/*
 * Decompiled with CFR 0.152.
 */
package brave.internal.zipkin.v2;

import brave.internal.zipkin.Util;
import brave.internal.zipkin.v2.AutoValue_Span;
import brave.internal.zipkin.v2.codec.Encoder;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import zipkin.Annotation;
import zipkin.Endpoint;

@AutoValue
@Immutable
public abstract class Span
implements Serializable {
    private static final long serialVersionUID = 0L;

    public abstract long traceIdHigh();

    public abstract long traceId();

    @Nullable
    public abstract Long parentId();

    public abstract long id();

    @Nullable
    public abstract Kind kind();

    @Nullable
    public abstract String name();

    @Nullable
    public abstract Long timestamp();

    @Nullable
    public abstract Long duration();

    @Nullable
    public abstract Endpoint localEndpoint();

    @Nullable
    public abstract Endpoint remoteEndpoint();

    public abstract List<Annotation> annotations();

    public abstract Map<String, String> tags();

    @Nullable
    public abstract Boolean debug();

    @Nullable
    public abstract Boolean shared();

    @Nullable
    public String localServiceName() {
        Endpoint localEndpoint = this.localEndpoint();
        return localEndpoint != null && !"".equals(localEndpoint.serviceName) ? localEndpoint.serviceName : null;
    }

    @Nullable
    public String remoteServiceName() {
        Endpoint remoteEndpoint = this.remoteEndpoint();
        return remoteEndpoint != null && !"".equals(remoteEndpoint.serviceName) ? remoteEndpoint.serviceName : null;
    }

    public String traceIdString() {
        if (this.traceIdHigh() != 0L) {
            char[] result2 = new char[32];
            Util.writeHexLong(result2, 0, this.traceIdHigh());
            Util.writeHexLong(result2, 16, this.traceId());
            return new String(result2);
        }
        char[] result3 = new char[16];
        Util.writeHexLong(result3, 0, this.traceId());
        return new String(result3);
    }

    public String idString() {
        int resultLength = 51;
        if (this.traceIdHigh() != 0L) {
            resultLength += 16;
        }
        char[] result2 = new char[resultLength];
        int pos = 0;
        if (this.traceIdHigh() != 0L) {
            Util.writeHexLong(result2, pos, this.traceIdHigh());
            pos += 16;
        }
        Util.writeHexLong(result2, pos, this.traceId());
        pos += 16;
        result2[pos++] = 46;
        Util.writeHexLong(result2, pos, this.id());
        pos += 16;
        result2[pos++] = 60;
        result2[pos++] = 58;
        Util.writeHexLong(result2, pos, this.parentId() != null ? this.parentId().longValue() : this.id());
        return new String(result2);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return new String(Encoder.JSON.encode((Object)this), Util.UTF_8);
    }

    public static final class Builder {
        Long traceId;
        long traceIdHigh;
        Long parentId;
        Long id;
        Kind kind;
        String name;
        Long timestamp;
        Long duration;
        Endpoint localEndpoint;
        Endpoint remoteEndpoint;
        ArrayList<Annotation> annotations;
        TreeMap<String, String> tags;
        Boolean debug;
        Boolean shared;

        public Builder clear() {
            this.traceIdHigh = 0L;
            this.traceId = null;
            this.parentId = null;
            this.id = null;
            this.kind = null;
            this.name = null;
            this.timestamp = null;
            this.duration = null;
            this.localEndpoint = null;
            this.remoteEndpoint = null;
            if (this.annotations != null) {
                this.annotations.clear();
            }
            if (this.tags != null) {
                this.tags.clear();
            }
            this.debug = null;
            this.shared = null;
            return this;
        }

        public Builder clone() {
            Builder result2 = new Builder();
            result2.traceIdHigh = this.traceIdHigh;
            result2.traceId = this.traceId;
            result2.parentId = this.parentId;
            result2.id = this.id;
            result2.kind = this.kind;
            result2.name = this.name;
            result2.timestamp = this.timestamp;
            result2.duration = this.duration;
            result2.localEndpoint = this.localEndpoint;
            result2.remoteEndpoint = this.remoteEndpoint;
            if (this.annotations != null) {
                result2.annotations = (ArrayList)this.annotations.clone();
            }
            if (this.tags != null) {
                result2.tags = (TreeMap)this.tags.clone();
            }
            result2.debug = this.debug;
            result2.shared = this.shared;
            return result2;
        }

        Builder(Span source) {
            this.traceId = source.traceId();
            this.parentId = source.parentId();
            this.id = source.id();
            this.kind = source.kind();
            this.name = source.name();
            this.timestamp = source.timestamp();
            this.duration = source.duration();
            this.localEndpoint = source.localEndpoint();
            this.remoteEndpoint = source.remoteEndpoint();
            if (!source.annotations().isEmpty()) {
                this.annotations = new ArrayList(source.annotations().size());
                this.annotations.addAll(source.annotations());
            }
            if (!source.tags().isEmpty()) {
                this.tags = new TreeMap();
                this.tags.putAll(source.tags());
            }
            this.debug = source.debug();
            this.shared = source.shared();
        }

        @Nullable
        public Kind kind() {
            return this.kind;
        }

        @Nullable
        public Endpoint localEndpoint() {
            return this.localEndpoint;
        }

        public Builder traceId(String traceId) {
            Util.checkNotNull(traceId, "traceId");
            if (traceId.length() == 32) {
                this.traceIdHigh(Util.lowerHexToUnsignedLong(traceId, 0));
            }
            return this.traceId(Util.lowerHexToUnsignedLong(traceId));
        }

        public Builder traceIdHigh(long traceIdHigh) {
            this.traceIdHigh = traceIdHigh;
            return this;
        }

        public Builder traceId(long traceId) {
            this.traceId = traceId;
            return this;
        }

        public Builder parentId(@Nullable String parentId) {
            this.parentId = parentId != null ? Long.valueOf(Util.lowerHexToUnsignedLong(parentId)) : null;
            return this;
        }

        public Builder parentId(@Nullable Long parentId) {
            this.parentId = parentId;
            return this;
        }

        public Builder id(String id2) {
            this.id = Util.lowerHexToUnsignedLong(id2);
            return this;
        }

        public Builder id(long id2) {
            this.id = id2;
            return this;
        }

        public Builder kind(@Nullable Kind kind) {
            this.kind = kind;
            return this;
        }

        public Builder name(@Nullable String name) {
            this.name = name == null || name.isEmpty() ? null : name.toLowerCase(Locale.ROOT);
            return this;
        }

        public Builder timestamp(@Nullable Long timestamp) {
            if (timestamp != null && timestamp == 0L) {
                timestamp = null;
            }
            this.timestamp = timestamp;
            return this;
        }

        public Builder duration(@Nullable Long duration) {
            if (duration != null && duration == 0L) {
                duration = null;
            }
            this.duration = duration;
            return this;
        }

        public Builder localEndpoint(@Nullable Endpoint localEndpoint) {
            this.localEndpoint = localEndpoint;
            return this;
        }

        public Builder remoteEndpoint(@Nullable Endpoint remoteEndpoint) {
            this.remoteEndpoint = remoteEndpoint;
            return this;
        }

        public Builder addAnnotation(long timestamp, String value) {
            if (this.annotations == null) {
                this.annotations = new ArrayList(2);
            }
            this.annotations.add(Annotation.create(timestamp, value, null));
            return this;
        }

        public Builder putTag(String key, String value) {
            if (this.tags == null) {
                this.tags = new TreeMap();
            }
            this.tags.put(Util.checkNotNull(key, "key"), Util.checkNotNull(value, "value"));
            return this;
        }

        public Builder debug(@Nullable Boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder shared(@Nullable Boolean shared) {
            this.shared = shared;
            return this;
        }

        public Span build() {
            return new AutoValue_Span(this.traceIdHigh, this.traceId, this.parentId, this.id, this.kind, this.name, this.timestamp, this.duration, this.localEndpoint, this.remoteEndpoint, Util.sortedList(this.annotations), this.tags == null ? Collections.emptyMap() : new LinkedHashMap<String, String>(this.tags), this.debug, this.shared);
        }

        Builder() {
        }
    }

    public static enum Kind {
        CLIENT,
        SERVER,
        PRODUCER,
        CONSUMER;

    }
}

