/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.infrastructure.participant;

import com.daml.ledger.api.testtool.infrastructure.LedgerServices;
import com.daml.ledger.api.testtool.infrastructure.ProtobufConverters$;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantSessionConfiguration;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext;
import com.digitalasset.ledger.api.v1.ledger_configuration_service.GetLedgerConfigurationRequest;
import com.digitalasset.ledger.api.v1.ledger_configuration_service.GetLedgerConfigurationRequest$;
import com.digitalasset.ledger.api.v1.ledger_configuration_service.GetLedgerConfigurationResponse;
import com.digitalasset.ledger.api.v1.ledger_configuration_service.LedgerConfiguration;
import com.digitalasset.ledger.api.v1.ledger_identity_service.GetLedgerIdentityRequest;
import com.digitalasset.ledger.api.v1.ledger_identity_service.GetLedgerIdentityRequest$;
import com.digitalasset.ledger.api.v1.ledger_identity_service.GetLedgerIdentityResponse;
import com.digitalasset.ledger.api.v1.ledger_offset.LedgerOffset;
import com.digitalasset.ledger.api.v1.transaction_service.GetLedgerEndRequest;
import com.digitalasset.ledger.api.v1.transaction_service.GetLedgerEndRequest$;
import com.digitalasset.ledger.api.v1.transaction_service.GetLedgerEndResponse;
import com.digitalasset.platform.testing.SingleItemObserver$;
import com.digitalasset.timer.RetryStrategy$;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import io.netty.channel.nio.NioEventLoopGroup;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ea!B\u0001\u0003\u0005\t\u0001\"A\u0005)beRL7-\u001b9b]R\u001cVm]:j_:T!a\u0001\u0003\u0002\u0017A\f'\u000f^5dSB\fg\u000e\u001e\u0006\u0003\u000b\u0019\ta\"\u001b8ge\u0006\u001cHO];diV\u0014XM\u0003\u0002\b\u0011\u0005AA/Z:ui>|GN\u0003\u0002\n\u0015\u0005\u0019\u0011\r]5\u000b\u0005-a\u0011A\u00027fI\u001e,'O\u0003\u0002\u000e\u001d\u0005!A-Y7m\u0015\u0005y\u0011aA2p[N\u0011\u0001!\u0005\t\u0003%Ui\u0011a\u0005\u0006\u0002)\u0005)1oY1mC&\u0011ac\u0005\u0002\u0007\u0003:L(+\u001a4\t\u0011a\u0001!Q1A\u0005\u0002i\taaY8oM&<7\u0001A\u000b\u00027A\u0011A$H\u0007\u0002\u0005%\u0011aD\u0001\u0002 !\u0006\u0014H/[2ja\u0006tGoU3tg&|gnQ8oM&<WO]1uS>t\u0007\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\u000f\r|gNZ5hA!A!\u0005\u0001B\u0001B\u0003%1%A\u0004dQ\u0006tg.\u001a7\u0011\u0005\u0011JS\"A\u0013\u000b\u0005\u0019:\u0013\u0001B4sa\u000eT\u0011\u0001K\u0001\u0003S>L!AK\u0013\u0003\u001d5\u000bg.Y4fI\u000eC\u0017M\u001c8fY\"AA\u0006\u0001B\u0001B\u0003%Q&\u0001\bfm\u0016tG\u000fT8pa\u001e\u0013x.\u001e9\u0011\u00059\"T\"A\u0018\u000b\u0005A\n\u0014a\u00018j_*\u0011!E\r\u0006\u0003g\u001d\nQA\\3uifL!!N\u0018\u0003#9Kw.\u0012<f]Rdun\u001c9He>,\b\u000f\u0003\u00058\u0001\t\u0015\r\u0011b\u00019\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH/F\u0001:!\tQT(D\u0001<\u0015\ta4#\u0001\u0006d_:\u001cWO\u001d:f]RL!AP\u001e\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\b\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\u0002#\u0015DXmY;uS>t7i\u001c8uKb$\b\u0005C\u0003C\u0001\u0011\u00051)\u0001\u0004=S:LGO\u0010\u000b\u0005\t\u001eC\u0015\n\u0006\u0002F\rB\u0011A\u0004\u0001\u0005\u0006o\u0005\u0003\u001d!\u000f\u0005\u00061\u0005\u0003\ra\u0007\u0005\u0006E\u0005\u0003\ra\t\u0005\u0006Y\u0005\u0003\r!\f\u0005\u0007\u0017\u0002\u0001\u000b\u0011\u0002'\u0002\r1|wmZ3s!\ti%+D\u0001O\u0015\ty\u0005+A\u0003tY\u001a$$NC\u0001R\u0003\ry'oZ\u0005\u0003':\u0013a\u0001T8hO\u0016\u0014\bBB+\u0001A\u0003%a+\u0001\u0005tKJ4\u0018nY3t!\t9\u0006,D\u0001\u0005\u0013\tIFA\u0001\bMK\u0012<WM]*feZL7-Z:\t\rm\u0003\u0001\u0015!\u0003]\u0003%aW\rZ4fe&#g\tE\u0002;;~K!AX\u001e\u0003\r\u0019+H/\u001e:f!\t\u0001\u0007N\u0004\u0002bM:\u0011!-Z\u0007\u0002G*\u0011A-G\u0001\u0007yI|w\u000e\u001e \n\u0003QI!aZ\n\u0002\rA\u0013X\rZ3g\u0013\tI'N\u0001\u0004TiJLgn\u001a\u0006\u0003ONAa\u0001\u001c\u0001!\u0002\u0013i\u0017\u0001\u0002;uY\u001a\u00032AO/o!\tyG/D\u0001q\u0015\t\t(/\u0001\u0003uS6,'\"A:\u0002\t)\fg/Y\u0005\u0003kB\u0014\u0001\u0002R;sCRLwN\u001c\u0005\u0007o\u0002!\tA\u0002=\u0002#\r\u0014X-\u0019;f)\u0016\u001cHoQ8oi\u0016DH\u000f\u0006\u0004z{\u0006\u0015\u0011\u0011\u0002\t\u0004uuS\bC\u0001\u000f|\u0013\ta(A\u0001\fQCJ$\u0018nY5qC:$H+Z:u\u0007>tG/\u001a=u\u0011\u0015qh\u000f1\u0001\u0000\u0003))g\u000e\u001a9pS:$\u0018\n\u001a\t\u0004\u0003\u0003AgbAA\u0002MB\u0011!m\u0005\u0005\u0007\u0003\u000f1\b\u0019A@\u0002\u001b\u0005\u0004\b\u000f\\5dCRLwN\\%e\u0011\u0019\tYA\u001ea\u0001\u007f\u0006\u0001\u0012\u000eZ3oi&4\u0017.\u001a:Tk\u001a4\u0017\u000e\u001f\u0005\t\u0003\u001f\u0001A\u0011\u0001\u0004\u0002\u0012\u0005)1\r\\8tKR\u0011\u00111\u0003\t\u0004%\u0005U\u0011bAA\f'\t!QK\\5u\u0001")
public final class ParticipantSession {
    private final ParticipantSessionConfiguration config;
    private final ManagedChannel channel;
    private final NioEventLoopGroup eventLoopGroup;
    private final ExecutionContext executionContext;
    private final Logger logger;
    private final LedgerServices services;
    private final Future<String> ledgerIdF;
    private final Future<java.time.Duration> ttlF;

    public ParticipantSessionConfiguration config() {
        return this.config;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    public Future<ParticipantTestContext> createTestContext(String endpointId, String applicationId, String identifierSuffix) {
        return this.ledgerIdF.flatMap((Function1<String, Future> & Serializable & scala.Serializable)ledgerId -> $this.ttlF.flatMap((Function1<java.time.Duration, Future> & Serializable & scala.Serializable)ttl -> $this.services.transaction().getLedgerEnd(new GetLedgerEndRequest((String)ledgerId, GetLedgerEndRequest$.MODULE$.$lessinit$greater$default$2())).map((Function1<GetLedgerEndResponse, LedgerOffset> & Serializable & scala.Serializable)x$4 -> x$4.getOffset(), this.executionContext()).map((Function1<LedgerOffset, ParticipantTestContext> & Serializable & scala.Serializable)end -> new ParticipantTestContext((String)ledgerId, endpointId, applicationId, identifierSuffix, (LedgerOffset)end, $this.services, (java.time.Duration)ttl, this.executionContext()), this.executionContext()), this.executionContext()), this.executionContext());
    }

    public void close() {
        this.logger.info(new StringBuilder(38).append("Disconnecting from participant at ").append(this.config().host()).append(":").append(this.config().port()).append("...").toString());
        this.channel.shutdownNow();
        if (!this.channel.awaitTermination(10L, TimeUnit.SECONDS)) {
            throw scala.sys.package$.MODULE$.error("Channel shutdown stuck. Unable to recover. Terminating.");
        }
        this.logger.info(new StringBuilder(41).append("Connection to participant at ").append(this.config().host()).append(":").append(this.config().port()).append(" shut down.").toString());
        if (!this.eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS).await(10L, TimeUnit.SECONDS)) {
            throw scala.sys.package$.MODULE$.error("Unable to shutdown event loop. Unable to recover. Terminating.");
        }
        this.logger.info(new StringBuilder(38).append("Connection to participant at ").append(this.config().host()).append(":").append(this.config().port()).append(" closed.").toString());
    }

    public static final /* synthetic */ Future $anonfun$ledgerIdF$1(ParticipantSession $this, int attempt2, Duration wait) {
        $this.logger.debug(new StringBuilder(64).append("Fetching ledgerId to create context (attempt #").append(attempt2).append(", next one in ").append(wait).append(")...").toString());
        return $this.services.identity().getLedgerIdentity(new GetLedgerIdentityRequest(GetLedgerIdentityRequest$.MODULE$.$lessinit$greater$default$1())).map((Function1<GetLedgerIdentityResponse, String> & Serializable & scala.Serializable)x$1 -> x$1.ledgerId(), $this.executionContext());
    }

    public static final /* synthetic */ void $anonfun$ttlF$2(ParticipantSession $this, String id$1, StreamObserver x$2) {
        $this.services.configuration().getLedgerConfiguration(new GetLedgerConfigurationRequest(id$1, GetLedgerConfigurationRequest$.MODULE$.$lessinit$greater$default$2()), x$2);
    }

    public ParticipantSession(ParticipantSessionConfiguration config, ManagedChannel channel, NioEventLoopGroup eventLoopGroup, ExecutionContext executionContext) {
        this.config = config;
        this.channel = channel;
        this.eventLoopGroup = eventLoopGroup;
        this.executionContext = executionContext;
        this.logger = LoggerFactory.getLogger(ParticipantSession.class);
        this.services = new LedgerServices(channel);
        this.ledgerIdF = RetryStrategy$.MODULE$.exponentialBackoff(10, new package.DurationInt(package$.MODULE$.DurationInt(10)).millis()).apply((Function2<Object, Duration, Future> & Serializable & scala.Serializable)(attempt2, wait) -> ParticipantSession.$anonfun$ledgerIdF$1(this, BoxesRunTime.unboxToInt(attempt2), wait), executionContext);
        this.ttlF = this.ledgerIdF.flatMap((Function1<String, Future> & Serializable & scala.Serializable)id2 -> SingleItemObserver$.MODULE$.first((Function1<StreamObserver, Object> & Serializable & scala.Serializable)x$2 -> {
            ParticipantSession.$anonfun$ttlF$2(this, id2, x$2);
            return BoxedUnit.UNIT;
        }).map((Function1<Option, LedgerConfiguration> & Serializable & scala.Serializable)x$3 -> ((GetLedgerConfigurationResponse)x$3.get()).getLedgerConfiguration(), this.executionContext()), executionContext).map((Function1<LedgerConfiguration, java.time.Duration> & Serializable & scala.Serializable)configuration -> {
            double factor = this.config().commandTtlFactor();
            Duration min = ProtobufConverters$.MODULE$.ProtobufDurationConverter(configuration.getMinTtl()).asScala();
            Duration max = ProtobufConverters$.MODULE$.ProtobufDurationConverter(configuration.getMaxTtl()).asScala();
            Duration ttl = max.$times(factor).min(max).max(min);
            $this.logger.info(new StringBuilder(40).append("Command TTL is ").append(ttl).append(" (min: ").append(min).append(", max: ").append(max).append(", factor: ").append(factor).append(")").toString());
            return java.time.Duration.ofNanos(ttl.toNanos());
        }, executionContext);
    }
}

