/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.infrastructure.participant;

import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantSession;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantSessionConfiguration;
import com.digitalasset.ledger.api.tls.TlsConfiguration;
import io.grpc.ManagedChannel;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea!B\u0001\u0003\u0005\u0011\u0001\"!\u0007)beRL7-\u001b9b]R\u001cVm]:j_:l\u0015M\\1hKJT!a\u0001\u0003\u0002\u0017A\f'\u000f^5dSB\fg\u000e\u001e\u0006\u0003\u000b\u0019\ta\"\u001b8ge\u0006\u001cHO];diV\u0014XM\u0003\u0002\b\u0011\u0005AA/Z:ui>|GN\u0003\u0002\n\u0015\u0005\u0019\u0011\r]5\u000b\u0005-a\u0011A\u00027fI\u001e,'O\u0003\u0002\u000e\u001d\u0005!A-Y7m\u0015\u0005y\u0011aA2p[N\u0011\u0001!\u0005\t\u0003%Ui\u0011a\u0005\u0006\u0002)\u0005)1oY1mC&\u0011ac\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000ba\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?\u0007\u0001!\u0012a\u0007\t\u00039\u0001i\u0011A\u0001\u0005\u0007=\u0001\u0001\u000b\u0011B\u0010\u0002\r1|wmZ3s!\t\u0001S%D\u0001\"\u0015\t\u00113%A\u0003tY\u001a$$NC\u0001%\u0003\ry'oZ\u0005\u0003M\u0005\u0012a\u0001T8hO\u0016\u0014\bB\u0002\u0015\u0001A\u0003%\u0011&\u0001\u0005dQ\u0006tg.\u001a7t!\u0011Qs&\r\u001b\u000e\u0003-R!\u0001L\u0017\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002/'\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005AZ#a\u0002+sS\u0016l\u0015\r\u001d\t\u00039IJ!a\r\u0002\u0003?A\u000b'\u000f^5dSB\fg\u000e^*fgNLwN\\\"p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002\u001dk%\u0011aG\u0001\u0002\u0013!\u0006\u0014H/[2ja\u0006tGoU3tg&|g\u000eC\u00039\u0001\u0011%\u0011(\u0001\u0004de\u0016\fG/\u001a\u000b\u0003u\t#\"\u0001N\u001e\t\u000bq:\u00049A\u001f\u0002\u0005\u0015\u001c\u0007C\u0001 A\u001b\u0005y$B\u0001\u0017\u0014\u0013\t\tuH\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\")1i\u000ea\u0001c\u000511m\u001c8gS\u001eD3aN#U!\r\u0011b\tS\u0005\u0003\u000fN\u0011a\u0001\u001e5s_^\u001c\bCA%R\u001d\tQuJ\u0004\u0002L\u001d6\tAJ\u0003\u0002N3\u00051AH]8pizJ\u0011\u0001F\u0005\u0003!N\tq\u0001]1dW\u0006<W-\u0003\u0002S'\n\u0001\"+\u001e8uS6,W\t_2faRLwN\u001c\u0006\u0003!N\tDAH+^gB\u0011aK\u0017\b\u0003/b\u0003\"aS\n\n\u0005e\u001b\u0012A\u0002)sK\u0012,g-\u0003\u0002\\9\n11\u000b\u001e:j]\u001eT!!W\n2\u000b\rr&M\\2\u0016\u0005}\u0003W#A+\u0005\u000b\u0005L\"\u0019\u00014\u0003\u0003QK!a\u00193\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\t)7#\u0001\u0004uQJ|wo]\t\u0003O*\u0004\"A\u00055\n\u0005%\u001c\"a\u0002(pi\"Lgn\u001a\t\u0003W2t!AE(\n\u00055\u001c&!\u0003+ie><\u0018M\u00197fc\u0015\u0019s\u000e]9f\u001d\t\u0011\u0002/\u0003\u0002f'E\"!EE\ns\u0005\u0015\u00198-\u00197bc\t1\u0003\nC\u0003v\u0001\u0011\u0005a/A\u0006hKR|%o\u0011:fCR,GCA<})\tA8\u0010E\u0002?sRJ!A_ \u0003\r\u0019+H/\u001e:f\u0011\u0015aD\u000fq\u0001>\u0011\u0015iH\u000f1\u00012\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]\"1q\u0010\u0001C\u0001\u0003\u0003\tQa\u00197pg\u0016$B!a\u0001\u0002\nA\u0019!#!\u0002\n\u0007\u0005\u001d1C\u0001\u0003V]&$\b\"B?\u007f\u0001\u0004\t\u0004bBA\u0007\u0001\u0011\u0005\u0011qB\u0001\tG2|7/Z!mYR\u0011\u00111\u0001")
public final class ParticipantSessionManager {
    private final Logger logger = LoggerFactory.getLogger(ParticipantSession.class);
    private final TrieMap<ParticipantSessionConfiguration, ParticipantSession> channels = TrieMap$.MODULE$.empty();

    private ParticipantSession create(ParticipantSessionConfiguration config, ExecutionContext ec) throws RuntimeException {
        this.logger.info(new StringBuilder(33).append("Connecting to participant at ").append(config.host()).append(":").append(config.port()).append("...").toString());
        String threadFactoryPoolName = new StringBuilder(17).append("grpc-event-loop-").append(config.host()).append("-").append(config.port()).toString();
        boolean daemonThreads = false;
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(threadFactoryPoolName, daemonThreads);
        this.logger.info(new StringBuilder(64).append("gRPC thread factory instantiated with pool '").append(threadFactoryPoolName).append("' (daemon threads: ").append(daemonThreads).append(")").toString());
        int threadCount = Runtime.getRuntime().availableProcessors();
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup(threadCount, threadFactory);
        this.logger.info(new StringBuilder(69).append("gRPC event loop thread group instantiated with ").append(threadCount).append(" threads using pool '").append(threadFactoryPoolName).append("'").toString());
        NettyChannelBuilder managedChannelBuilder = ((NettyChannelBuilder)NettyChannelBuilder.forAddress(config.host(), config.port()).eventLoopGroup(eventLoopGroup).channelType(NioSocketChannel.class).directExecutor()).usePlaintext();
        config.ssl().foreach((Function1<TlsConfiguration, Object> & Serializable & scala.Serializable)ssl -> {
            ParticipantSessionManager.$anonfun$create$1(this, managedChannelBuilder, ssl);
            return BoxedUnit.UNIT;
        });
        managedChannelBuilder.maxInboundMessageSize(10000000);
        ManagedChannel managedChannel = managedChannelBuilder.build();
        this.logger.info(new StringBuilder(30).append("Connection to participant at ").append(config.host()).append(":").append(config.port()).toString());
        return new ParticipantSession(config, managedChannel, eventLoopGroup, ec);
    }

    public Future<ParticipantSession> getOrCreate(ParticipantSessionConfiguration configuration, ExecutionContext ec) {
        return Future$.MODULE$.apply((Function0<ParticipantSession> & Serializable & scala.Serializable)() -> $this.channels.getOrElseUpdate(configuration, (Function0<ParticipantSession> & Serializable & scala.Serializable)() -> this.create(configuration, ec)), ec);
    }

    public void close(ParticipantSessionConfiguration configuration) {
        this.channels.get(configuration).foreach((Function1<ParticipantSession, Object> & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
    }

    public void closeAll() {
        this.channels.withFilter((Function1<Tuple2<ParticipantSessionConfiguration, ParticipantSession>, Object>)(Function1<Tuple2, Object> & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(ParticipantSessionManager.$anonfun$closeAll$1(check$ifrefutable$1))).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$2 -> {
            ParticipantSessionManager.$anonfun$closeAll$2(x$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$create$1(ParticipantSessionManager $this, NettyChannelBuilder managedChannelBuilder$1, TlsConfiguration ssl) {
        ssl.client().foreach((Function1<SslContext, NettyChannelBuilder> & Serializable & scala.Serializable)sslContext -> {
            $this.logger.info("Setting up managed communication channel with transport security");
            return managedChannelBuilder$1.useTransportSecurity().sslContext((SslContext)sslContext).negotiationType(NegotiationType.TLS);
        });
    }

    public static final /* synthetic */ boolean $anonfun$closeAll$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$closeAll$2(Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ParticipantSession session = (ParticipantSession)tuple2._2();
        session.close();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }
}

