/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.tests;

import com.daml.ledger.api.testtool.infrastructure.Allocation;
import com.daml.ledger.api.testtool.infrastructure.Allocation$;
import com.daml.ledger.api.testtool.infrastructure.Allocation$SingleParty$;
import com.daml.ledger.api.testtool.infrastructure.Allocation$TwoParties$;
import com.daml.ledger.api.testtool.infrastructure.Assertions$;
import com.daml.ledger.api.testtool.infrastructure.LedgerSession;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSuite;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext;
import com.digitalasset.ledger.api.v1.active_contracts_service.GetActiveContractsRequest;
import com.digitalasset.ledger.api.v1.active_contracts_service.GetActiveContractsRequest$;
import com.digitalasset.ledger.api.v1.event.CreatedEvent;
import com.digitalasset.ledger.api.v1.event.Event;
import com.digitalasset.ledger.api.v1.ledger_offset.LedgerOffset;
import com.digitalasset.ledger.api.v1.transaction.Transaction;
import com.digitalasset.ledger.api.v1.transaction.TransactionTree;
import com.digitalasset.ledger.api.v1.transaction_service.GetTransactionsRequest;
import com.digitalasset.ledger.api.v1.transaction_service.GetTransactionsRequest$;
import com.digitalasset.ledger.api.v1.value.Identifier;
import com.digitalasset.ledger.api.v1.value.Record;
import com.digitalasset.ledger.api.v1.value.RecordField;
import com.digitalasset.ledger.client.binding.DomainCommand;
import com.digitalasset.ledger.client.binding.encoding.ExerciseOn$;
import com.digitalasset.ledger.test_stable.Test.Dummy;
import com.digitalasset.ledger.test_stable.Test.Dummy$;
import com.digitalasset.ledger.test_stable.Test.Dummy$Dummy$u0020syntax$;
import com.digitalasset.ledger.test_stable.Test.DummyFactory;
import com.digitalasset.ledger.test_stable.Test.DummyFactory$;
import com.digitalasset.ledger.test_stable.Test.DummyWithParam;
import com.digitalasset.ledger.test_stable.Test.DummyWithParam$;
import io.grpc.Status;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.Future;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scalapb.lenses.Lens;
import scalaz.syntax.TagOps$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001B\u0001\u0003\u0001=\u0011a#Q2uSZ,7i\u001c8ue\u0006\u001cGo]*feZL7-\u001a\u0006\u0003\u0007\u0011\tQ\u0001^3tiNT!!\u0002\u0004\u0002\u0011Q,7\u000f\u001e;p_2T!a\u0002\u0005\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\n\u0015\u00051A.\u001a3hKJT!a\u0003\u0007\u0002\t\u0011\fW\u000e\u001c\u0006\u0002\u001b\u0005\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0003'\u0011\ta\"\u001b8ge\u0006\u001cHO];diV\u0014X-\u0003\u0002\u0016%\tyA*\u001a3hKJ$Vm\u001d;Tk&$X\rC\u0005\u0018\u0001\t\u0005\t\u0015!\u0003\u00197\u000591/Z:tS>t\u0007CA\t\u001a\u0013\tQ\"CA\u0007MK\u0012<WM]*fgNLwN\\\u0005\u0003/QAQ!\b\u0001\u0005\u0002y\ta\u0001P5oSRtDCA\u0010\"!\t\u0001\u0003!D\u0001\u0003\u0011\u00159B\u00041\u0001\u0019\u0011\u0015\u0019\u0003\u0001\"\u0003%\u0003Q\u0019'/Z1uK\u0012+X.\\=D_:$(/Y2ugR\u0019Q%\u00194\u0011\u0007\u0019ZS&D\u0001(\u0015\tA\u0013&\u0001\u0006d_:\u001cWO\u001d:f]RT\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y\u001d\u0012aAR;ukJ,\u0007#\u0002\u00180cekV\"A\u0015\n\u0005AJ#A\u0002+va2,7\u0007E\u00023\u001bFs!a\r&\u000f\u0005Q:eBA\u001bE\u001d\t1\u0014I\u0004\u00028\u007f9\u0011\u0001(\u0010\b\u0003sqj\u0011A\u000f\u0006\u0003w9\ta\u0001\u0010:p_Rt\u0014\"A\u0007\n\u0005yb\u0011\u0001\u00043jO&$\u0018\r\\1tg\u0016$\u0018BA\u0005A\u0015\tqD\"\u0003\u0002C\u0007\u000611\r\\5f]RT!!\u0003!\n\u0005\u00153\u0015a\u00022j]\u0012Lgn\u001a\u0006\u0003\u0005\u000eK!\u0001S%\u0002\u000fA\f7m[1hK*\u0011QIR\u0005\u0003\u00172\u000b\u0011\u0002\u0015:j[&$\u0018N^3\u000b\u0005!K\u0015B\u0001(P\u0005)\u0019uN\u001c;sC\u000e$\u0018\nZ\u0005\u0003!&\u0013\u0011\u0002\u0015:j[&$\u0018N^3\u0011\u0005I;V\"A*\u000b\u0005Q+\u0016\u0001\u0002+fgRT!AV\"\u0002\u0017Q,7\u000f^0ti\u0006\u0014G.Z\u0005\u00031N\u0013Q\u0001R;n[f\u00042AM'[!\t\u00116,\u0003\u0002]'\nqA)^7ns^KG\u000f\u001b)be\u0006l\u0007c\u0001\u001aN=B\u0011!kX\u0005\u0003AN\u0013A\u0002R;n[f4\u0015m\u0019;pefDQA\u0019\u0012A\u0002\r\fQ\u0001]1sif\u0004\"A\r3\n\u0005\u0015|%!\u0002)beRL\b\"B\u0005#\u0001\u00049\u0007C\u00015l\u001b\u0005I'B\u00016\u0013\u0003-\u0001\u0018M\u001d;jG&\u0004\u0018M\u001c;\n\u00051L'A\u0006)beRL7-\u001b9b]R$Vm\u001d;D_:$X\r\u001f;\t\u000b9\u0004A\u0011B8\u0002\u001f\u0005\u001c8/\u001a:u)\u0016l\u0007\u000f\\1uKN,2\u0001]A\u0013)\u001d\tH/`A\f\u0003o\u0001\"A\f:\n\u0005ML#\u0001B+oSRDQAY7A\u0002U\u00042A\u001e>d\u001d\t9\u0018P\u0004\u0002:q&\t!&\u0003\u0002IS%\u00111\u0010 \u0002\u0004'\u0016\f(B\u0001%*\u0011\u0015qX\u000e1\u0001\u0000\u0003\u0019)g/\u001a8ugB)a/!\u0001\u0002\u0006%\u0019\u00111\u0001?\u0003\rY+7\r^8s!\u0011\t9!a\u0005\u000e\u0005\u0005%!\u0002BA\u0006\u0003\u001b\tQ!\u001a<f]RTA!a\u0004\u0002\u0012\u0005\u0011a/\r\u0006\u0003\u000f\rKA!!\u0006\u0002\n\ta1I]3bi\u0016$WI^3oi\"9\u0011\u0011D7A\u0002\u0005m\u0011A\u0003;f[Bd\u0017\r^3JIB)!'!\b\u0002\"%\u0019\u0011qD(\u0003\u0015Q+W\u000e\u001d7bi\u0016LE\r\u0005\u0003\u0002$\u0005\u0015B\u0002\u0001\u0003\b\u0003Oi'\u0019AA\u0015\u0005\u0005\t\u0015\u0003BA\u0016\u0003c\u00012ALA\u0017\u0013\r\ty#\u000b\u0002\b\u001d>$\b.\u001b8h!\rq\u00131G\u0005\u0004\u0003kI#aA!os\"9\u0011\u0011H7A\u0002\u0005m\u0012!B2pk:$\bc\u0001\u0018\u0002>%\u0019\u0011qH\u0015\u0003\u0007%sG\u000f")
public class ActiveContractsService
extends LedgerTestSuite {
    private Future<Tuple3<Object, Object, Object>> createDummyContracts(Object party, ParticipantTestContext ledger) {
        return ledger.create(party, new Dummy(party)).flatMap((Function1<Object, Future> & Serializable & scala.Serializable)dummy -> ledger.create(party, new DummyWithParam(party)).flatMap((Function1<Object, Future> & Serializable & scala.Serializable)dummyWithParam -> ledger.create(party, new DummyFactory(party)).map((Function1<Object, Tuple3> & Serializable & scala.Serializable)dummyFactory -> new Tuple3<Object, Object, Object>(dummy, dummyWithParam, dummyFactory), this.ec()), this.ec()), this.ec());
    }

    private <A> void assertTemplates(Seq<Object> party, Vector<CreatedEvent> events, Object templateId, int count) {
        int templateEvents = events.count((Function1<CreatedEvent, Object> & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToBoolean(ActiveContractsService.$anonfun$assertTemplates$1(templateId, x$33)));
        Predef$.MODULE$.assert(templateEvents == count, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(34).append(party.mkString(" and ")).append(" expected ").append(count).append(" ").append(templateId).append(" events, but received ").append(templateEvents).append(".").toString());
    }

    public static final /* synthetic */ boolean $anonfun$new$8(Tuple3 check$ifrefutable$1) {
        Tuple3 tuple3 = check$ifrefutable$1;
        boolean bl = tuple3 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$new$13(Object dummy$1, CreatedEvent x$2) {
        String string2 = x$2.contractId();
        Object object = dummy$1;
        return !(string2 != null ? !string2.equals(object) : object != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$15(Object dummyWithParam$1, CreatedEvent x$3) {
        String string2 = x$3.contractId();
        Object object = dummyWithParam$1;
        return !(string2 != null ? !string2.equals(object) : object != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$17(Object dummyFactory$1, CreatedEvent x$4) {
        String string2 = x$4.contractId();
        Object object = dummyFactory$1;
        return !(string2 != null ? !string2.equals(object) : object != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$18(Object party$1, CreatedEvent x$5) {
        Seq<String> seq = x$5.signatories();
        Object CC = Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)TagOps$.MODULE$.unwrap$extension(scalaz.syntax.package$.MODULE$.tag().ToTagOps(party$1))}));
        return !(seq != null ? !seq.equals(CC) : CC != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$20(CreatedEvent x$6) {
        return x$6.observers().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$new$10(Object party$1, Object dummy$1, Object dummyWithParam$1, Object dummyFactory$1, Vector activeContracts) {
        Predef$.MODULE$.assert(activeContracts.size() == 3, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Expected 3 contracts, but received ").append(activeContracts.size()).append(".").toString());
        Predef$.MODULE$.assert(activeContracts.exists((Function1<CreatedEvent, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(ActiveContractsService.$anonfun$new$13(dummy$1, x$2))), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Didn't find Dummy contract with contractId ").append(dummy$1).append(".").toString());
        Predef$.MODULE$.assert(activeContracts.exists((Function1<CreatedEvent, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean(ActiveContractsService.$anonfun$new$15(dummyWithParam$1, x$3))), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Didn't find DummyWithParam contract with contractId ").append(dummy$1).append(".").toString());
        Predef$.MODULE$.assert(activeContracts.exists((Function1<CreatedEvent, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean(ActiveContractsService.$anonfun$new$17(dummyFactory$1, x$4))), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Didn't find DummyFactory contract with contractId ").append(dummy$1).append(".").toString());
        Vector invalidSignatories = (Vector)activeContracts.filterNot((Function1<CreatedEvent, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean(ActiveContractsService.$anonfun$new$18(party$1, x$5)));
        Predef$.MODULE$.assert(invalidSignatories.isEmpty(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Found contracts with signatories other than ").append(party$1).append(": ").append(invalidSignatories).toString());
        Vector invalidObservers = (Vector)activeContracts.filterNot((Function1<CreatedEvent, Object> & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean(ActiveContractsService.$anonfun$new$20(x$6)));
        Predef$.MODULE$.assert(invalidObservers.isEmpty(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Found contracts with non-empty observers: ").append(invalidObservers).toString());
    }

    public static final /* synthetic */ boolean $anonfun$new$23(Tuple3 check$ifrefutable$2) {
        Tuple3 tuple3 = check$ifrefutable$2;
        boolean bl = tuple3 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$new$25(Object dummy$2, Vector activeContracts) {
        Predef$.MODULE$.assert(activeContracts.size() == 1, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Expected 1 contract, but received ").append(activeContracts.size()).append(".").toString());
        Identifier identifier = ((CreatedEvent)activeContracts.head()).getTemplateId();
        Object a = TagOps$.MODULE$.unwrap$extension(scalaz.syntax.package$.MODULE$.tag().ToTagOps(Dummy$.MODULE$.id()));
        Predef$.MODULE$.assert(!(identifier != null ? !((Object)identifier).equals(a) : a != null), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Received contract is not of type Dummy, but ").append(((CreatedEvent)activeContracts.head()).templateId()).append(".").toString());
        String string2 = ((CreatedEvent)activeContracts.head()).contractId();
        Object object = dummy$2;
        Predef$.MODULE$.assert(!(string2 != null ? !string2.equals(object) : object != null), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Expected contract with contractId ").append(dummy$2).append(", but received ").append(((CreatedEvent)activeContracts.head()).contractId()).append(".").toString());
    }

    public static final /* synthetic */ boolean $anonfun$new$30(Tuple3 check$ifrefutable$3) {
        Tuple3 tuple3 = check$ifrefutable$3;
        boolean bl = tuple3 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$new$38(Object dummy$3, CreatedEvent x$9) {
        String string2 = x$9.contractId();
        Object object = dummy$3;
        return !(string2 != null ? !string2.equals(object) : object != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$42(Object dummy$3, CreatedEvent x$11) {
        String string2 = x$11.contractId();
        Object object = dummy$3;
        return !(string2 != null ? !string2.equals(object) : object != null);
    }

    public static final /* synthetic */ void $anonfun$new$35(Object dummy$3, Vector contractsBeforeExercise$1, Vector contractsAfterExercise) {
        Predef$.MODULE$.assert(contractsBeforeExercise$1.size() == 3, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Expected 3 contracts, but received ").append(contractsBeforeExercise$1.size()).append(".").toString());
        Predef$.MODULE$.assert(contractsBeforeExercise$1.exists((Function1<CreatedEvent, Object> & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean(ActiveContractsService.$anonfun$new$38(dummy$3, x$9))), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Expected to receive contract with contractId ").append(dummy$3).append(", but received ").append(((TraversableOnce)contractsBeforeExercise$1.map((Function1<CreatedEvent, String> & Serializable & scala.Serializable)x$10 -> x$10.contractId(), Vector$.MODULE$.canBuildFrom())).mkString(", ")).append(" instead.").toString());
        Predef$.MODULE$.assert(contractsAfterExercise.size() == 2, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Expected 2 contracts, but received ").append(contractsAfterExercise.size()).toString());
        Predef$.MODULE$.assert(!contractsAfterExercise.exists((Function1<CreatedEvent, Object> & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean(ActiveContractsService.$anonfun$new$42(dummy$3, x$11))), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Expected to not receive contract with contractId ").append(dummy$3).append(".").toString());
    }

    public static final /* synthetic */ boolean $anonfun$new$45(Tuple2 check$ifrefutable$4) {
        Option option2;
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null && (option2 = (Option)tuple2._1()) instanceof Some;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$new$52(Object dummy$4, CreatedEvent x$14) {
        String string2 = x$14.contractId();
        Object object = dummy$4;
        return !(string2 != null ? !string2.equals(object) : object != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$56(Object dummyWithParam$2, CreatedEvent x$15) {
        String string2 = x$15.contractId();
        Object object = dummyWithParam$2;
        return !(string2 != null ? !string2.equals(object) : object != null);
    }

    public static final /* synthetic */ void $anonfun$new$50(LedgerOffset offset$1, Vector onlyDummy$1, Object dummyWithParam$2, Object dummy$4, Vector transactions) {
        Predef$.MODULE$.assert(onlyDummy$1.size() == 1);
        Predef$.MODULE$.assert(onlyDummy$1.exists((Function1<CreatedEvent, Object> & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean(ActiveContractsService.$anonfun$new$52(dummy$4, x$14))), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Expected to receive ").append(dummy$4).append(" in active contracts, but didn't receive it.").toString());
        Predef$.MODULE$.assert(transactions.size() == 1, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Expected to receive only 1 transaction from offset ").append(offset$1).append(", but received ").append(transactions.size()).append(".").toString());
        Transaction transaction = (Transaction)transactions.head();
        Predef$.MODULE$.assert(transaction.events().size() == 1, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Expected only 1 event in the transaction, but received ").append(transaction.events().size()).append(".").toString());
        Seq createdEvent = transaction.events().collect(new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Event, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                Event.Event event;
                A1 A1 = x1;
                if (A1 != null && (event = A1.event()) instanceof Event.Event.Created) {
                    Event.Event.Created created = (Event.Event.Created)event;
                    CreatedEvent createdEvent = created.value();
                    object = createdEvent;
                } else {
                    object = function1.apply(x1);
                }
                return object;
            }

            public final boolean isDefinedAt(Event x1) {
                Event.Event event;
                Event event2 = x1;
                boolean bl = event2 != null && (event = event2.event()) instanceof Event.Event.Created;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.assert(createdEvent.exists((Function1<CreatedEvent, Object> & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean(ActiveContractsService.$anonfun$new$56(dummyWithParam$2, x$15))), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Expected a CreateEvent for ").append(dummyWithParam$2).append(", but received ").append(createdEvent).append(".").toString());
    }

    public static final /* synthetic */ boolean $anonfun$new$62(Tuple2 check$ifrefutable$5) {
        Tuple2 tuple2 = check$ifrefutable$5;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$new$64(Tuple2 check$ifrefutable$6) {
        Tuple2 tuple2 = check$ifrefutable$6;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$new$69(RecordField x$22) {
        return new StringOps(Predef$.MODULE$.augmentString(x$22.label())).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$new$73(RecordField x$25) {
        return x$25.label().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$new$65(Object party$6, Vector verboseEvents$1, Tuple2 x$27) {
        Tuple2 tuple2 = x$27;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Vector nonVerboseEvents = (Vector)tuple2._2();
        Vector verboseCreateArgs = ((TraversableLike)verboseEvents$1.map((Function1<CreatedEvent, Record> & Serializable & scala.Serializable)x$20 -> x$20.getCreateArguments(), Vector$.MODULE$.canBuildFrom())).flatMap((Function1<Record, Seq> & Serializable & scala.Serializable)x$21 -> x$21.fields(), Vector$.MODULE$.canBuildFrom());
        Predef$.MODULE$.assert(verboseEvents$1.nonEmpty() && verboseCreateArgs.forall((Function1<RecordField, Object> & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean(ActiveContractsService.$anonfun$new$69(x$22))), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(48).append(party$6).append(" expected a contract with labels, but received ").append(verboseEvents$1).append(".").toString());
        Vector nonVerboseCreateArgs = ((TraversableLike)nonVerboseEvents.map((Function1<CreatedEvent, Record> & Serializable & scala.Serializable)x$23 -> x$23.getCreateArguments(), Vector$.MODULE$.canBuildFrom())).flatMap((Function1<Record, Seq> & Serializable & scala.Serializable)x$24 -> x$24.fields(), Vector$.MODULE$.canBuildFrom());
        Predef$.MODULE$.assert(nonVerboseEvents.nonEmpty() && nonVerboseCreateArgs.forall((Function1<RecordField, Object> & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean(ActiveContractsService.$anonfun$new$73(x$25))), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(51).append(party$6).append(" expected a contract without labels, but received ").append(nonVerboseEvents).append(".").toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$81(ActiveContractsService $this, Object alice$1, Object bob$1, Vector allContractsForAlice$1, Vector allContractsForBob$1, Vector allContractsForAliceAndBob$1, Vector dummyContractsForAlice$1, Vector dummyContractsForAliceAndBob) {
        Predef$.MODULE$.assert(allContractsForAlice$1.size() == 3, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(34).append(alice$1).append(" expected 3 events, but received ").append(allContractsForAlice$1.size()).append(".").toString());
        $this.assertTemplates((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray(new Object[]{alice$1})), allContractsForAlice$1, Dummy$.MODULE$.id(), 1);
        $this.assertTemplates((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray(new Object[]{alice$1})), allContractsForAlice$1, DummyWithParam$.MODULE$.id(), 1);
        $this.assertTemplates((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray(new Object[]{alice$1})), allContractsForAlice$1, DummyFactory$.MODULE$.id(), 1);
        Predef$.MODULE$.assert(allContractsForBob$1.size() == 3, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(34).append(bob$1).append(" expected 3 events, but received ").append(allContractsForBob$1.size()).append(".").toString());
        $this.assertTemplates((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray(new Object[]{bob$1})), allContractsForBob$1, Dummy$.MODULE$.id(), 1);
        $this.assertTemplates((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray(new Object[]{bob$1})), allContractsForBob$1, DummyWithParam$.MODULE$.id(), 1);
        $this.assertTemplates((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray(new Object[]{bob$1})), allContractsForBob$1, DummyFactory$.MODULE$.id(), 1);
        Predef$.MODULE$.assert(allContractsForAliceAndBob$1.size() == 6, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(39).append(alice$1).append(" and ").append(bob$1).append(" expected 6 events, but received ").append(allContractsForAliceAndBob$1.size()).append(".").toString());
        $this.assertTemplates((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray(new Object[]{alice$1, bob$1})), allContractsForAliceAndBob$1, Dummy$.MODULE$.id(), 2);
        $this.assertTemplates((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray(new Object[]{alice$1, bob$1})), allContractsForAliceAndBob$1, DummyWithParam$.MODULE$.id(), 2);
        $this.assertTemplates((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray(new Object[]{alice$1, bob$1})), allContractsForAliceAndBob$1, DummyFactory$.MODULE$.id(), 2);
        Predef$.MODULE$.assert(dummyContractsForAlice$1.size() == 1, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(33).append(alice$1).append(" expected 1 event, but received ").append(dummyContractsForAlice$1.size()).append(".").toString());
        $this.assertTemplates((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray(new Object[]{alice$1})), dummyContractsForAlice$1, Dummy$.MODULE$.id(), 1);
        Predef$.MODULE$.assert(dummyContractsForAliceAndBob.size() == 2, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(39).append(alice$1).append(" and ").append(bob$1).append(" expected 2 events, but received ").append(dummyContractsForAliceAndBob.size()).append(".").toString());
        $this.assertTemplates((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray(new Object[]{alice$1, bob$1})), dummyContractsForAliceAndBob, Dummy$.MODULE$.id(), 2);
    }

    public static final /* synthetic */ void $anonfun$new$90(Object party$8, Object dummyCid$1, Object dummyWithParamCid$1, Vector contracts) {
        Predef$.MODULE$.assert(contracts.size() == 2, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(33).append(party$8).append(" expected 1 event, but received ").append(contracts.size()).append(".").toString());
        Vector dummyAgreementText = contracts.collect(new scala.Serializable(null, dummyCid$1){
            public static final long serialVersionUID = 0L;
            private final Object dummyCid$1;

            public final <A1 extends CreatedEvent, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                String string2 = A1.contractId();
                Object object = this.dummyCid$1;
                Option<String> option2 = !(string2 != null ? !string2.equals(object) : object != null) ? A1.agreementText() : function1.apply(x2);
                return (B1)option2;
            }

            public final boolean isDefinedAt(CreatedEvent x2) {
                CreatedEvent createdEvent = x2;
                String string2 = createdEvent.contractId();
                Object object = this.dummyCid$1;
                boolean bl = !(string2 != null ? !string2.equals(object) : object != null);
                return bl;
            }
            {
                this.dummyCid$1 = dummyCid$1;
            }
        }, Vector$.MODULE$.canBuildFrom());
        Vector dummyWithParamAgreementText = contracts.collect(new scala.Serializable(null, dummyWithParamCid$1){
            public static final long serialVersionUID = 0L;
            private final Object dummyWithParamCid$1;

            public final <A1 extends CreatedEvent, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                A1 A1 = x3;
                String string2 = A1.contractId();
                Object object = this.dummyWithParamCid$1;
                Option<String> option2 = !(string2 != null ? !string2.equals(object) : object != null) ? A1.agreementText() : function1.apply(x3);
                return (B1)option2;
            }

            public final boolean isDefinedAt(CreatedEvent x3) {
                CreatedEvent createdEvent = x3;
                String string2 = createdEvent.contractId();
                Object object = this.dummyWithParamCid$1;
                boolean bl = !(string2 != null ? !string2.equals(object) : object != null);
                return bl;
            }
            {
                this.dummyWithParamCid$1 = dummyWithParamCid$1;
            }
        }, Vector$.MODULE$.canBuildFrom());
        Predef$.MODULE$.assert(dummyAgreementText.exists((Function1<Option, Object> & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToBoolean(x$30.nonEmpty())), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(52).append(party$8).append(" expected a non-empty agreement text, but received ").append(dummyAgreementText).append(".").toString());
        Predef$.MODULE$.assert(dummyWithParamAgreementText.exists((Function1<Option, Object> & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToBoolean(x$31.nonEmpty())), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(49).append(party$8).append(" expected an empty agreement text, but received ").append(dummyWithParamAgreementText).append(".").toString());
    }

    public static final /* synthetic */ boolean $anonfun$new$98(Vector check$ifrefutable$7) {
        Vector vector2 = check$ifrefutable$7;
        Some<Vector> some = package$.MODULE$.Vector().unapplySeq(vector2);
        boolean bl = !some.isEmpty() && some.get() != null && some.get().lengthCompare(1) == 0;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$new$101(CreatedEvent dummyEvent$1, Transaction flatTransaction$1, TransactionTree transactionTree) {
        String string2 = flatTransaction$1.transactionId();
        String string3 = transactionTree.transactionId();
        Predef$.MODULE$.assert(!(string2 != null ? !string2.equals(string3) : string3 != null), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(81).append("EventId ").append(dummyEvent$1.eventId()).append(" did not resolve to the same flat transaction (").append(flatTransaction$1.transactionId()).append(") and transaction tree (").append(transactionTree.transactionId()).append(").").toString());
    }

    public static final /* synthetic */ boolean $anonfun$assertTemplates$1(Object templateId$1, CreatedEvent x$33) {
        Identifier identifier = x$33.getTemplateId();
        Object a = TagOps$.MODULE$.unwrap$extension(scalaz.syntax.package$.MODULE$.tag().ToTagOps(templateId$1));
        return !(identifier != null ? !((Object)identifier).equals(a) : a != null);
    }

    public ActiveContractsService(LedgerSession session) {
        super(session);
        this.test("ACSinvalidLedgerId", "The ActiveContractService should fail for requests with an invalid ledger identifier", Allocation$.MODULE$.allocate(Allocation$SingleParty$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$1 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$1;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Seq<Object> parties = participant.parties();
            String invalidLedgerId = "ACSinvalidLedgerId";
            GetActiveContractsRequest invalidRequest = (GetActiveContractsRequest)ledger.activeContractsRequest(parties, ledger.activeContractsRequest$default$2()).update(Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1<Lens, Function1> & Serializable & scala.Serializable)x$1 -> GetActiveContractsRequest$.MODULE$.GetActiveContractsRequestLens(x$1).ledgerId().$colon$eq(invalidLedgerId)}));
            Future future = ledger.activeContracts(invalidRequest).failed().map((Function1<Throwable, Object> & Serializable & scala.Serializable)failure -> {
                Assertions$.MODULE$.assertGrpcError(failure, Status.Code.NOT_FOUND, "not found. Actual Ledger ID");
                return BoxedUnit.UNIT;
            }, this.ec());
            return future;
        });
        this.test("ACSemptyResponse", "The ActiveContractService should succeed with an empty response if no contracts have been created for a party", Allocation$.MODULE$.allocate(Allocation$SingleParty$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$2 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$2;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(1) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Object party = participant.parties().apply(false);
            Future future = ledger.activeContracts(Predef$.MODULE$.wrapRefArray(new Object[]{party})).map((Function1<Vector, Object> & Serializable & scala.Serializable)activeContracts -> {
                Predef$.MODULE$.assert(activeContracts.isEmpty(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(50).append("There should be no active contracts, but received ").append(activeContracts).toString());
                return BoxedUnit.UNIT;
            }, this.ec());
            return future;
        });
        this.test("ACSallContracts", "The ActiveContractService should return all active contracts", Allocation$.MODULE$.allocate(Allocation$SingleParty$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$3 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$3;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(1) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Object party = participant.parties().apply(false);
            Future future = this.createDummyContracts(party, ledger).withFilter((Function1<Tuple3<Object, Object, Object>, Object>)(Function1<Tuple3, Object> & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(ActiveContractsService.$anonfun$new$8(check$ifrefutable$1)), this.ec()).flatMap((Function1<Tuple3, Future> & Serializable & scala.Serializable)x$7 -> {
                Tuple3 tuple3 = x$7;
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                Object dummy = tuple3._1();
                Object dummyWithParam = tuple3._2();
                Object dummyFactory = tuple3._3();
                Future future = ledger.activeContracts(Predef$.MODULE$.wrapRefArray(new Object[]{party})).map((Function1<Vector, Object> & Serializable & scala.Serializable)activeContracts -> {
                    ActiveContractsService.$anonfun$new$10(party, dummy, dummyWithParam, dummyFactory, activeContracts);
                    return BoxedUnit.UNIT;
                }, this.ec());
                return future;
            }, this.ec());
            return future;
        });
        this.test("ACSfilterContracts", "The ActiveContractService should return contracts filtered by templateId", Allocation$.MODULE$.allocate(Allocation$SingleParty$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$4 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$4;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(1) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Object party = participant.parties().apply(false);
            Future future = this.createDummyContracts(party, ledger).withFilter((Function1<Tuple3<Object, Object, Object>, Object>)(Function1<Tuple3, Object> & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean(ActiveContractsService.$anonfun$new$23(check$ifrefutable$2)), this.ec()).flatMap((Function1<Tuple3, Future> & Serializable & scala.Serializable)x$8 -> {
                Tuple3 tuple3 = x$8;
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                Object dummy = tuple3._1();
                Future future = ledger.activeContractsByTemplateId((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{(Identifier)TagOps$.MODULE$.unwrap$extension(scalaz.syntax.package$.MODULE$.tag().ToTagOps(Dummy$.MODULE$.id()))})), Predef$.MODULE$.wrapRefArray(new Object[]{party})).map((Function1<Vector, Object> & Serializable & scala.Serializable)activeContracts -> {
                    ActiveContractsService.$anonfun$new$25(dummy, activeContracts);
                    return BoxedUnit.UNIT;
                }, this.ec());
                return future;
            }, this.ec());
            return future;
        });
        this.test("ACSarchivedContracts", "The ActiveContractService does not return archived contracts", Allocation$.MODULE$.allocate(Allocation$SingleParty$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$5 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$5;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(1) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Object party = participant.parties().apply(false);
            Future future = this.createDummyContracts(party, ledger).withFilter((Function1<Tuple3<Object, Object, Object>, Object>)(Function1<Tuple3, Object> & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean(ActiveContractsService.$anonfun$new$30(check$ifrefutable$3)), this.ec()).flatMap((Function1<Tuple3, Future> & Serializable & scala.Serializable)x$12 -> {
                Tuple3 tuple3 = x$12;
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                Object dummy = tuple3._1();
                Future future = ledger.activeContracts(Predef$.MODULE$.wrapRefArray(new Object[]{party})).flatMap((Function1<Vector, Future> & Serializable & scala.Serializable)contractsBeforeExercise -> {
                    Object object = Dummy$.MODULE$.Dummy$u0020syntax(dummy);
                    return ledger.exercise(party, (Function1<Object, DomainCommand> & Serializable & scala.Serializable)actor -> Dummy$Dummy$u0020syntax$.MODULE$.exerciseDummyChoice1$extension1(object, actor, ExerciseOn$.MODULE$.OnId())).flatMap((Function1<TransactionTree, Future> & Serializable & scala.Serializable)_ -> ledger.activeContracts(Predef$.MODULE$.wrapRefArray(new Object[]{party})).map((Function1<Vector, Object> & Serializable & scala.Serializable)contractsAfterExercise -> {
                        ActiveContractsService.$anonfun$new$35(dummy, contractsBeforeExercise, contractsAfterExercise);
                        return BoxedUnit.UNIT;
                    }, this.ec()), this.ec());
                }, this.ec());
                return future;
            }, this.ec());
            return future;
        });
        this.test("ACSusableOffset", "The ActiveContractService should return a usable offset to resume streaming transactions", Allocation$.MODULE$.allocate(Allocation$SingleParty$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$6 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$6;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(1) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Object party = participant.parties().apply(false);
            Future future = ledger.create(party, new Dummy(party)).flatMap((Function1<Object, Future> & Serializable & scala.Serializable)dummy -> ledger.activeContracts(ledger.activeContractsRequest((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray(new Object[]{party})), ledger.activeContractsRequest$default$2())).withFilter((Function1<Tuple2<Option<LedgerOffset>, Vector<CreatedEvent>>, Object>)(Function1<Tuple2, Object> & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean(ActiveContractsService.$anonfun$new$45(check$ifrefutable$4)), this.ec()).flatMap((Function1<Tuple2, Future> & Serializable & scala.Serializable)x$17 -> {
                Vector onlyDummy;
                Option option2;
                block3: {
                    Tuple2 tuple2;
                    block2: {
                        tuple2 = x$17;
                        if (tuple2 == null) break block2;
                        option2 = (Option)tuple2._1();
                        onlyDummy = (Vector)tuple2._2();
                        if (option2 instanceof Some) break block3;
                    }
                    throw new MatchError(tuple2);
                }
                Some some = (Some)option2;
                LedgerOffset offset = (LedgerOffset)some.value();
                Future future = ledger.create(party, new DummyWithParam(party)).map((Function1<Object, Tuple3> & Serializable & scala.Serializable)dummyWithParam -> {
                    GetTransactionsRequest request = ledger.getTransactionsRequest((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray(new Object[]{party})), ledger.getTransactionsRequest$default$2());
                    GetTransactionsRequest fromOffset = (GetTransactionsRequest)request.update(Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1<Lens, Function1> & Serializable & scala.Serializable)x$13 -> GetTransactionsRequest$.MODULE$.GetTransactionsRequestLens(x$13).begin().$colon$eq(offset)}));
                    return new Tuple3<Object, GetTransactionsRequest, GetTransactionsRequest>(dummyWithParam, request, fromOffset);
                }, this.ec()).flatMap((Function1<Tuple3, Future> & Serializable & scala.Serializable)x$16 -> {
                    Tuple3 tuple3 = x$16;
                    if (tuple3 == null) {
                        throw new MatchError(tuple3);
                    }
                    Object dummyWithParam = tuple3._1();
                    GetTransactionsRequest fromOffset = (GetTransactionsRequest)tuple3._3();
                    Future future = ledger.flatTransactions(fromOffset).map((Function1<Vector, Object> & Serializable & scala.Serializable)transactions -> {
                        ActiveContractsService.$anonfun$new$50(offset, onlyDummy, dummyWithParam, dummy, transactions);
                        return BoxedUnit.UNIT;
                    }, this.ec());
                    return future;
                }, this.ec());
                return future;
            }, this.ec()), this.ec());
            return future;
        });
        this.test("ACSverbosity", "The ActiveContractService should emit field names only if the verbose flag is set to true", Allocation$.MODULE$.allocate(Allocation$SingleParty$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$7 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$7;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(1) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Object party = participant.parties().apply(false);
            Future future = ledger.create(party, new Dummy(party)).map((Function1<Object, Tuple3> & Serializable & scala.Serializable)x$26 -> {
                GetActiveContractsRequest verboseRequest = (GetActiveContractsRequest)ledger.activeContractsRequest((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray(new Object[]{party})), ledger.activeContractsRequest$default$2()).update(Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1<Lens, Function1> & Serializable & scala.Serializable)x$18 -> GetActiveContractsRequest$.MODULE$.GetActiveContractsRequestLens(x$18).verbose().$colon$eq(BoxesRunTime.boxToBoolean(true))}));
                GetActiveContractsRequest nonVerboseRequest = (GetActiveContractsRequest)verboseRequest.update(Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1<Lens, Function1> & Serializable & scala.Serializable)x$19 -> GetActiveContractsRequest$.MODULE$.GetActiveContractsRequestLens(x$19).verbose().$colon$eq(BoxesRunTime.boxToBoolean(false))}));
                return new Tuple3<Object, GetActiveContractsRequest, GetActiveContractsRequest>(x$26, verboseRequest, nonVerboseRequest);
            }, this.ec()).flatMap((Function1<Tuple3, Future> & Serializable & scala.Serializable)x$29 -> {
                Tuple3 tuple3 = x$29;
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                GetActiveContractsRequest verboseRequest = (GetActiveContractsRequest)tuple3._2();
                GetActiveContractsRequest nonVerboseRequest = (GetActiveContractsRequest)tuple3._3();
                Future future = ledger.activeContracts(verboseRequest).withFilter((Function1<Tuple2<Option<LedgerOffset>, Vector<CreatedEvent>>, Object>)(Function1<Tuple2, Object> & Serializable & scala.Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean(ActiveContractsService.$anonfun$new$62(check$ifrefutable$5)), this.ec()).flatMap((Function1<Tuple2, Future> & Serializable & scala.Serializable)x$28 -> {
                    Tuple2 tuple2 = x$28;
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    Vector verboseEvents = (Vector)tuple2._2();
                    Future future = ledger.activeContracts(nonVerboseRequest).withFilter((Function1<Tuple2<Option<LedgerOffset>, Vector<CreatedEvent>>, Object>)(Function1<Tuple2, Object> & Serializable & scala.Serializable)check$ifrefutable$6 -> BoxesRunTime.boxToBoolean(ActiveContractsService.$anonfun$new$64(check$ifrefutable$6)), this.ec()).map((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$27 -> {
                        ActiveContractsService.$anonfun$new$65(party, verboseEvents, x$27);
                        return BoxedUnit.UNIT;
                    }, this.ec());
                    return future;
                }, this.ec());
                return future;
            }, this.ec());
            return future;
        });
        this.test("ACSmultiParty", "The ActiveContractsService should return contracts for the requesting parties", Allocation$.MODULE$.allocate(Allocation$TwoParties$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$8 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$8;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(2) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Object alice = participant.parties().apply(false);
            Object bob = participant.parties().apply(true);
            Future future = this.createDummyContracts(alice, ledger).flatMap((Function1<Tuple3, Future> & Serializable & scala.Serializable)_2 -> this.createDummyContracts(bob, ledger).flatMap((Function1<Tuple3, Future> & Serializable & scala.Serializable)_ -> ledger.activeContracts(Predef$.MODULE$.wrapRefArray(new Object[]{alice})).flatMap((Function1<Vector, Future> & Serializable & scala.Serializable)allContractsForAlice -> ledger.activeContracts(Predef$.MODULE$.wrapRefArray(new Object[]{bob})).flatMap((Function1<Vector, Future> & Serializable & scala.Serializable)allContractsForBob -> ledger.activeContracts(Predef$.MODULE$.wrapRefArray(new Object[]{alice, bob})).flatMap((Function1<Vector, Future> & Serializable & scala.Serializable)allContractsForAliceAndBob -> ledger.activeContractsByTemplateId((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{(Identifier)TagOps$.MODULE$.unwrap$extension(scalaz.syntax.package$.MODULE$.tag().ToTagOps(Dummy$.MODULE$.id()))})), Predef$.MODULE$.wrapRefArray(new Object[]{alice})).flatMap((Function1<Vector, Future> & Serializable & scala.Serializable)dummyContractsForAlice -> ledger.activeContractsByTemplateId((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{(Identifier)TagOps$.MODULE$.unwrap$extension(scalaz.syntax.package$.MODULE$.tag().ToTagOps(Dummy$.MODULE$.id()))})), Predef$.MODULE$.wrapRefArray(new Object[]{alice, bob})).map((Function1<Vector, Object> & Serializable & scala.Serializable)dummyContractsForAliceAndBob -> {
                ActiveContractsService.$anonfun$new$81(this, alice, bob, allContractsForAlice, allContractsForBob, allContractsForAliceAndBob, dummyContractsForAlice, dummyContractsForAliceAndBob);
                return BoxedUnit.UNIT;
            }, this.ec()), this.ec()), this.ec()), this.ec()), this.ec()), this.ec()), this.ec());
            return future;
        });
        this.test("ACSagreementText", "The ActiveContractService should properly fill the agreementText field", Allocation$.MODULE$.allocate(Allocation$SingleParty$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$9 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$9;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(1) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Object party = participant.parties().apply(false);
            Future future = ledger.create(party, new Dummy(party)).flatMap((Function1<Object, Future> & Serializable & scala.Serializable)dummyCid -> ledger.create(party, new DummyWithParam(party)).flatMap((Function1<Object, Future> & Serializable & scala.Serializable)dummyWithParamCid -> ledger.activeContracts(Predef$.MODULE$.wrapRefArray(new Object[]{party})).map((Function1<Vector, Object> & Serializable & scala.Serializable)contracts -> {
                ActiveContractsService.$anonfun$new$90(party, dummyCid, dummyWithParamCid, contracts);
                return BoxedUnit.UNIT;
            }, this.ec()), this.ec()), this.ec());
            return future;
        });
        this.test("ACSeventId", "The ActiveContractService should properly fill the eventId field", Allocation$.MODULE$.allocate(Allocation$SingleParty$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$10 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$10;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(1) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Object party = participant.parties().apply(false);
            Future future = ledger.create(party, new Dummy(party)).flatMap((Function1<Object, Future> & Serializable & scala.Serializable)_ -> ledger.activeContracts(Predef$.MODULE$.wrapRefArray(new Object[]{party})).withFilter((Function1<Vector<CreatedEvent>, Object>)(Function1<Vector, Object> & Serializable & scala.Serializable)check$ifrefutable$7 -> BoxesRunTime.boxToBoolean(ActiveContractsService.$anonfun$new$98(check$ifrefutable$7)), this.ec()).flatMap((Function1<Vector, Future> & Serializable & scala.Serializable)x$32 -> {
                Vector vector2 = x$32;
                Some<Vector> some = package$.MODULE$.Vector().unapplySeq(vector2);
                if (some.isEmpty() || some.get() == null || some.get().lengthCompare(1) != 0) {
                    throw new MatchError(vector2);
                }
                CreatedEvent dummyEvent = (CreatedEvent)some.get().apply(0);
                Future future = ledger.flatTransactionByEventId(dummyEvent.eventId(), Predef$.MODULE$.wrapRefArray(new Object[]{party})).flatMap((Function1<Transaction, Future> & Serializable & scala.Serializable)flatTransaction -> ledger.transactionTreeByEventId(dummyEvent.eventId(), Predef$.MODULE$.wrapRefArray(new Object[]{party})).map((Function1<TransactionTree, Object> & Serializable & scala.Serializable)transactionTree -> {
                    ActiveContractsService.$anonfun$new$101(dummyEvent, flatTransaction, transactionTree);
                    return BoxedUnit.UNIT;
                }, this.ec()), this.ec());
                return future;
            }, this.ec()), this.ec());
            return future;
        });
    }
}

