/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.tests;

import com.daml.ledger.api.testtool.infrastructure.Allocation;
import com.daml.ledger.api.testtool.infrastructure.Allocation$;
import com.daml.ledger.api.testtool.infrastructure.Allocation$SingleParty$;
import com.daml.ledger.api.testtool.infrastructure.Allocation$TwoParties$;
import com.daml.ledger.api.testtool.infrastructure.Assertions$;
import com.daml.ledger.api.testtool.infrastructure.LedgerSession;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSuite;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext;
import com.digitalasset.ledger.api.v1.command_completion_service.CompletionStreamRequest;
import com.digitalasset.ledger.api.v1.command_completion_service.CompletionStreamRequest$;
import com.digitalasset.ledger.api.v1.command_submission_service.SubmitRequest;
import com.digitalasset.ledger.api.v1.command_submission_service.SubmitRequest$;
import com.digitalasset.ledger.api.v1.commands.Command;
import com.digitalasset.ledger.api.v1.commands.Command$;
import com.digitalasset.ledger.api.v1.commands.Commands$;
import com.digitalasset.ledger.api.v1.commands.ExerciseCommand$;
import com.digitalasset.ledger.api.v1.completion.Completion;
import com.digitalasset.ledger.client.binding.encoding.ExerciseOn$;
import com.digitalasset.ledger.test_stable.Test.Dummy;
import com.digitalasset.ledger.test_stable.Test.Dummy$;
import com.digitalasset.ledger.test_stable.Test.Dummy$Dummy$u0020syntax$;
import com.digitalasset.platform.testing.TimeoutException$;
import com.digitalasset.platform.testing.WithTimeout$;
import io.grpc.Status;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$DummyImplicit$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.Future;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scalapb.lenses.Lens;

@ScalaSignature(bytes="\u0006\u0001\t2A!\u0001\u0002\u0003\u001f\tY2i\\7nC:$7+\u001e2nSN\u001c\u0018n\u001c8D_6\u0004H.\u001a;j_:T!a\u0001\u0003\u0002\u000bQ,7\u000f^:\u000b\u0005\u00151\u0011\u0001\u0003;fgR$xn\u001c7\u000b\u0005\u001dA\u0011aA1qS*\u0011\u0011BC\u0001\u0007Y\u0016$w-\u001a:\u000b\u0005-a\u0011\u0001\u00023b[2T\u0011!D\u0001\u0004G>l7\u0001A\n\u0003\u0001A\u0001\"!\u0005\u000b\u000e\u0003IQ!a\u0005\u0003\u0002\u001d%tgM]1tiJ,8\r^;sK&\u0011QC\u0005\u0002\u0010\u0019\u0016$w-\u001a:UKN$8+^5uK\"Iq\u0003\u0001B\u0001B\u0003%\u0001dG\u0001\bg\u0016\u001c8/[8o!\t\t\u0012$\u0003\u0002\u001b%\tiA*\u001a3hKJ\u001cVm]:j_:L!a\u0006\u000b\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\ty\u0012\u0005\u0005\u0002!\u00015\t!\u0001C\u0003\u00189\u0001\u0007\u0001\u0004")
public final class CommandSubmissionCompletion
extends LedgerTestSuite {
    public static final /* synthetic */ void $anonfun$new$4(SubmitRequest request$1, Vector completions) {
        String commandId;
        String string2 = commandId = (String)Assertions$.MODULE$.assertSingleton("Expected only one completion", completions.map((Function1<Completion, String> & Serializable & scala.Serializable)x$1 -> x$1.commandId(), Vector$.MODULE$.canBuildFrom()));
        String string3 = request$1.commands().get().commandId();
        Predef$.MODULE$.assert(!(string2 != null ? !string2.equals(string3) : string3 != null), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Wrong command identifier on completion");
    }

    public static final /* synthetic */ void $anonfun$new$13(Throwable failed) {
        Throwable throwable2 = failed;
        TimeoutException$ timeoutException$ = TimeoutException$.MODULE$;
        Predef$.MODULE$.assert(!(throwable2 != null ? !throwable2.equals(timeoutException$) : timeoutException$ != null), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Timeout expected");
    }

    public static final /* synthetic */ void $anonfun$new$19(Throwable failed) {
        Throwable throwable2 = failed;
        TimeoutException$ timeoutException$ = TimeoutException$.MODULE$;
        Predef$.MODULE$.assert(!(throwable2 != null ? !throwable2.equals(timeoutException$) : timeoutException$ != null), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Timeout expected");
    }

    public CommandSubmissionCompletion(LedgerSession session) {
        super(session);
        this.test("CSCCompletions", "Read completions correctly with a correct application identifier and reading party", Allocation$.MODULE$.allocate(Allocation$SingleParty$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$1 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$1;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(1) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Object party = participant.parties().apply(false);
            Future future = ledger.submitRequest(party, Predef$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(Predef$DummyImplicit$.MODULE$.dummyImplicit()).command()})).flatMap((Function1<SubmitRequest, Future> & Serializable & scala.Serializable)request -> ledger.submit((SubmitRequest)request).flatMap((Function1<BoxedUnit, Future> & Serializable & scala.Serializable)_ -> ledger.firstCompletions(Predef$.MODULE$.wrapRefArray(new Object[]{party})).map((Function1<Vector, Object> & Serializable & scala.Serializable)completions -> {
                CommandSubmissionCompletion.$anonfun$new$4(request, completions);
                return BoxedUnit.UNIT;
            }, this.ec()), this.ec()), this.ec());
            return future;
        });
        this.test("CSCNoCompletionsWithoutRightAppId", "Read no completions without the correct application identifier", Allocation$.MODULE$.allocate(Allocation$SingleParty$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$2 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$2;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(1) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Object party = participant.parties().apply(false);
            Future future = ledger.submitRequest(party, Predef$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(Predef$DummyImplicit$.MODULE$.dummyImplicit()).command()})).flatMap((Function1<SubmitRequest, Future> & Serializable & scala.Serializable)request -> ledger.submit((SubmitRequest)request).map((Function1<BoxedUnit, Tuple2> & Serializable & scala.Serializable)x$3 -> {
                CompletionStreamRequest invalidRequest = (CompletionStreamRequest)ledger.completionStreamRequest(Predef$.MODULE$.wrapRefArray(new Object[]{party})).update(Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1<Lens, Function1> & Serializable & scala.Serializable)x$2 -> CompletionStreamRequest$.MODULE$.CompletionStreamRequestLens(x$2).applicationId().$colon$eq("invalid-application-id")}));
                return new Tuple2<BoxedUnit, CompletionStreamRequest>((BoxedUnit)x$3, invalidRequest);
            }, this.ec()).flatMap((Function1<Tuple2, Future> & Serializable & scala.Serializable)x$4 -> {
                Tuple2 tuple2 = x$4;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                CompletionStreamRequest invalidRequest = (CompletionStreamRequest)tuple2._2();
                Future future = WithTimeout$.MODULE$.apply(new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds(), (Function0<Future> & Serializable & scala.Serializable)() -> ledger.firstCompletions(invalidRequest)).failed().map((Function1<Throwable, Object> & Serializable & scala.Serializable)failed -> {
                    CommandSubmissionCompletion.$anonfun$new$13(failed);
                    return BoxedUnit.UNIT;
                }, this.ec());
                return future;
            }, this.ec()), this.ec());
            return future;
        });
        this.test("CSCNoCompletionsWithoutRightParty", "Read no completions without the correct party", Allocation$.MODULE$.allocate(Allocation$TwoParties$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$3 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$3;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(2) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Object party = participant.parties().apply(false);
            Object notTheSubmittingParty = participant.parties().apply(true);
            Future future = ledger.submitRequest(party, Predef$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(Predef$DummyImplicit$.MODULE$.dummyImplicit()).command()})).flatMap((Function1<SubmitRequest, Future> & Serializable & scala.Serializable)request -> ledger.submit((SubmitRequest)request).flatMap((Function1<BoxedUnit, Future> & Serializable & scala.Serializable)_ -> WithTimeout$.MODULE$.apply(new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds(), (Function0<Future> & Serializable & scala.Serializable)() -> ledger.firstCompletions(Predef$.MODULE$.wrapRefArray(new Object[]{notTheSubmittingParty}))).failed().map((Function1<Throwable, Object> & Serializable & scala.Serializable)failed -> {
                CommandSubmissionCompletion.$anonfun$new$19(failed);
                return BoxedUnit.UNIT;
            }, this.ec()), this.ec()), this.ec());
            return future;
        });
        this.test("CSCRefuseBadChoice", "The submission of an exercise of a choice that does not exist should yield INVALID_ARGUMENT", Allocation$.MODULE$.allocate(Allocation$SingleParty$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$4 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$4;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(1) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Object party = participant.parties().apply(false);
            String badChoice = "THIS_IS_NOT_A_VALID_CHOICE";
            Future future = ledger.create(party, new Dummy(party)).map((Function1<Object, Tuple3> & Serializable & scala.Serializable)dummy -> {
                Command exercise = Dummy$Dummy$u0020syntax$.MODULE$.exerciseDummyChoice1$extension1(Dummy$.MODULE$.Dummy$u0020syntax(dummy), party, ExerciseOn$.MODULE$.OnId()).command();
                Command wrongExercise = (Command)exercise.update(Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1<Lens, Function1> & Serializable & scala.Serializable)x$5 -> ExerciseCommand$.MODULE$.ExerciseCommandLens(Command$.MODULE$.CommandLens(x$5).exercise()).choice().$colon$eq(badChoice)}));
                return new Tuple3<Object, Command, Command>(dummy, exercise, wrongExercise);
            }, this.ec()).flatMap((Function1<Tuple3, Future> & Serializable & scala.Serializable)x$6 -> {
                Tuple3 tuple3 = x$6;
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                Command wrongExercise = (Command)tuple3._3();
                Future future = ledger.submitRequest(party, Predef$.MODULE$.wrapRefArray((Object[])new Command[]{wrongExercise})).flatMap((Function1<SubmitRequest, Future> & Serializable & scala.Serializable)wrongRequest -> ledger.submit((SubmitRequest)wrongRequest).failed().map((Function1<Throwable, Object> & Serializable & scala.Serializable)failure -> {
                    Assertions$.MODULE$.assertGrpcError(failure, Status.Code.INVALID_ARGUMENT, new StringBuilder(31).append("Couldn't find requested choice ").append(badChoice).toString());
                    return BoxedUnit.UNIT;
                }, this.ec()), this.ec());
                return future;
            }, this.ec());
            return future;
        });
        this.test("CSCSubmitWithInvalidLedgerId", "Submit should fail for an invalid ledger identifier", Allocation$.MODULE$.allocate(Allocation$SingleParty$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$5 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$5;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(1) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Object party = participant.parties().apply(false);
            String invalidLedgerId = "CSsubmitAndWaitInvalidLedgerId";
            Future future = ledger.submitRequest(party, Predef$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(Predef$DummyImplicit$.MODULE$.dummyImplicit()).command()})).map((Function1<SubmitRequest, Tuple2> & Serializable & scala.Serializable)request -> {
                SubmitRequest badLedgerId = (SubmitRequest)request.update(Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1<Lens, Function1> & Serializable & scala.Serializable)x$7 -> Commands$.MODULE$.CommandsLens(SubmitRequest$.MODULE$.SubmitRequestLens(x$7).commands()).ledgerId().$colon$eq(invalidLedgerId)}));
                return new Tuple2<SubmitRequest, SubmitRequest>((SubmitRequest)request, badLedgerId);
            }, this.ec()).flatMap((Function1<Tuple2, Future> & Serializable & scala.Serializable)x$8 -> {
                Tuple2 tuple2 = x$8;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                SubmitRequest badLedgerId = (SubmitRequest)tuple2._2();
                Future future = ledger.submit(badLedgerId).failed().map((Function1<Throwable, Object> & Serializable & scala.Serializable)failure -> {
                    Assertions$.MODULE$.assertGrpcError(failure, Status.Code.NOT_FOUND, new StringBuilder(23).append("Ledger ID '").append(invalidLedgerId).append("' not found.").toString());
                    return BoxedUnit.UNIT;
                }, this.ec());
                return future;
            }, this.ec());
            return future;
        });
        this.test("CSCDisallowEmptyTransactionsSubmission", "The submission of an empty command should be rejected with INVALID_ARGUMENT", Allocation$.MODULE$.allocate(Allocation$SingleParty$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$6 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$6;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(1) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Object party = participant.parties().apply(false);
            Future future = ledger.submitRequest(party, Predef$.MODULE$.wrapRefArray((Object[])new Command[0])).flatMap((Function1<SubmitRequest, Future> & Serializable & scala.Serializable)emptyRequest -> ledger.submit((SubmitRequest)emptyRequest).failed().map((Function1<Throwable, Object> & Serializable & scala.Serializable)failure -> {
                Assertions$.MODULE$.assertGrpcError(failure, Status.Code.INVALID_ARGUMENT, "Missing field: commands");
                return BoxedUnit.UNIT;
            }, this.ec()), this.ec());
            return future;
        });
    }
}

