/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.tests;

import com.daml.ledger.api.testtool.infrastructure.Allocation;
import com.daml.ledger.api.testtool.infrastructure.Allocation$;
import com.daml.ledger.api.testtool.infrastructure.Allocation$NoParties$;
import com.daml.ledger.api.testtool.infrastructure.Allocation$SingleParty$;
import com.daml.ledger.api.testtool.infrastructure.Assertions$;
import com.daml.ledger.api.testtool.infrastructure.LedgerSession;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSuite;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext;
import com.digitalasset.ledger.api.v1.admin.package_management_service.PackageDetails;
import com.digitalasset.ledger.api.v1.event.CreatedEvent;
import com.digitalasset.ledger.api.v1.transaction.TransactionTree;
import com.digitalasset.ledger.client.binding.DomainCommand;
import com.digitalasset.ledger.client.binding.encoding.ExerciseOn$;
import com.digitalasset.ledger.packagemanagementtest.PackageManagementTest.PackageManagementTestTemplate;
import com.digitalasset.ledger.packagemanagementtest.PackageManagementTest.PackageManagementTestTemplate$;
import com.digitalasset.ledger.packagemanagementtest.PackageManagementTest.PackageManagementTestTemplate$PackageManagementTestTemplate$u0020syntax$;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import java.io.InputStream;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u00153A!\u0001\u0002\u0003\u001f\t\t\u0002+Y2lC\u001e,W*\u00198bO\u0016lWM\u001c;\u000b\u0005\r!\u0011!\u0002;fgR\u001c(BA\u0003\u0007\u0003!!Xm\u001d;u_>d'BA\u0004\t\u0003\r\t\u0007/\u001b\u0006\u0003\u0013)\ta\u0001\\3eO\u0016\u0014(BA\u0006\r\u0003\u0011!\u0017-\u001c7\u000b\u00035\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E!R\"\u0001\n\u000b\u0005M!\u0011AD5oMJ\f7\u000f\u001e:vGR,(/Z\u0005\u0003+I\u0011q\u0002T3eO\u0016\u0014H+Z:u'VLG/\u001a\u0005\n/\u0001\u0011\t\u0011)A\u00051m\tqa]3tg&|g\u000e\u0005\u0002\u00123%\u0011!D\u0005\u0002\u000e\u0019\u0016$w-\u001a:TKN\u001c\u0018n\u001c8\n\u0005]!\u0002\"B\u000f\u0001\t\u0003q\u0012A\u0002\u001fj]&$h\b\u0006\u0002 CA\u0011\u0001\u0005A\u0007\u0002\u0005!)q\u0003\ba\u00011!11\u0005\u0001Q\u0001\n\u0011\nq\u0003^3tiB\u000b7m[1hKJ+7o\\;sG\u0016\u0004\u0016\r\u001e5\u0011\u0005\u0015RS\"\u0001\u0014\u000b\u0005\u001dB\u0013\u0001\u00027b]\u001eT\u0011!K\u0001\u0005U\u00064\u0018-\u0003\u0002,M\t11\u000b\u001e:j]\u001eDQ!\f\u0001\u0005\n9\nq\u0002\\8bIR+7\u000f\u001e)bG.\fw-\u001a\u000b\u0002_Q\u0011\u0001\u0007\u0011\t\u0004cYBT\"\u0001\u001a\u000b\u0005M\"\u0014AC2p]\u000e,(O]3oi*\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028e\t1a)\u001e;ve\u0016\u0004\"!\u000f \u000e\u0003iR!a\u000f\u001f\u0002\u0011A\u0014x\u000e^8ck\u001aT!!\u0010\u0007\u0002\r\u001d|wn\u001a7f\u0013\ty$H\u0001\u0006CsR,7\u000b\u001e:j]\u001eDQ!\u0011\u0017A\u0004\t\u000b!!Z2\u0011\u0005E\u001a\u0015B\u0001#3\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000f")
public final class PackageManagement
extends LedgerTestSuite {
    private final String testPackageResourcePath;

    /*
     * WARNING - void declaration
     */
    private Future<ByteString> loadTestPackage(ExecutionContext ec) {
        void var3_3;
        Future testPackage = Future$.MODULE$.apply((Function0<InputStream> & Serializable & scala.Serializable)() -> {
            void var1_1;
            InputStream in = this.getClass().getResourceAsStream($this.testPackageResourcePath);
            Predef$.MODULE$.assert(in != null, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Unable to load test package resource at '").append($this.testPackageResourcePath).append("'").toString());
            return var1_1;
        }, ec);
        Future bytes = testPackage.map((Function1<InputStream, ByteString> & Serializable & scala.Serializable)x$1 -> ByteString.readFrom(x$1), ec);
        bytes.onComplete((Function1<Try, Future> & Serializable & scala.Serializable)x$1 -> testPackage.map((Function1<InputStream, Object> & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        }, ec), ec);
        return var3_3;
    }

    public static final /* synthetic */ boolean $anonfun$new$15(Tuple2 x$5) {
        return x$5._2$mcI$sp() > 1;
    }

    public static final /* synthetic */ void $anonfun$new$12(Seq knownPackages$1, Vector acsBefore$1, Vector acsAfter) {
        Map duplicatePackageIds = (Map)knownPackages$1.groupBy((Function1<PackageDetails, String> & Serializable & scala.Serializable)x$3 -> x$3.packageId()).mapValues((Function1<Seq, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger(x$4.size())).filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean(PackageManagement.$anonfun$new$15(x$5)));
        Predef$.MODULE$.assert(duplicatePackageIds.isEmpty(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(41).append("There are duplicate package identifiers: ").append(((TraversableOnce)duplicatePackageIds.map((Function1<Tuple2, String> & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String name = (String)tuple2._1();
            int count = tuple2._2$mcI$sp();
            String string2 = new StringBuilder(3).append(name).append(" (").append(count).append(")").toString();
            return string2;
        }, Iterable$.MODULE$.canBuildFrom())).mkString(", ")).toString());
        Predef$.MODULE$.assert(acsBefore$1.size() == 1, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "After the contract has been created there should be one active contract but there's none");
        Predef$.MODULE$.assert(acsAfter.isEmpty(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(72).append("There should be no active package after the contract has been consumed: ").append(((TraversableOnce)acsAfter.map((Function1<CreatedEvent, String> & Serializable & scala.Serializable)x$6 -> x$6.contractId(), Vector$.MODULE$.canBuildFrom())).mkString(", ")).toString());
    }

    public PackageManagement(LedgerSession session) {
        super(session);
        this.testPackageResourcePath = "/ledger/ledger-api-test-tool/PackageManagementTest.dar";
        this.test("PackageManagementEmptyUpload", "An attempt at uploading an empty payload should fail", Allocation$.MODULE$.allocate(Allocation$NoParties$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$1 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$1;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(0) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Future future = ledger.uploadDarFile(ByteString.EMPTY).failed().map((Function1<Throwable, Object> & Serializable & scala.Serializable)failure -> {
                Assertions$.MODULE$.assertGrpcError(failure, Status.Code.INVALID_ARGUMENT, "Invalid argument: Invalid DAR: package-upload");
                return BoxedUnit.UNIT;
            }, this.ec());
            return future;
        });
        this.test("PackageManagementLoad", "Concurrent uploads of the same package should be idempotent and result in the package being available for use", Allocation$.MODULE$.allocate(Allocation$SingleParty$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$2 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$2;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(1) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Object party = participant.parties().apply(false);
            Future future = this.loadTestPackage(this.ec()).flatMap((Function1<ByteString, Future> & Serializable & scala.Serializable)testPackage -> Future$.MODULE$.sequence((TraversableOnce)package$.MODULE$.Vector().fill(8, (Function0<Future> & Serializable & scala.Serializable)() -> ledger.uploadDarFile((ByteString)testPackage)), Vector$.MODULE$.canBuildFrom(), this.ec()).flatMap((Function1<Vector, Future> & Serializable & scala.Serializable)_ -> ledger.listKnownPackages().flatMap((Function1<Seq, Future> & Serializable & scala.Serializable)knownPackages -> ledger.create(party, new PackageManagementTestTemplate(party)).flatMap((Function1<Object, Future> & Serializable & scala.Serializable)contract -> ledger.activeContracts(Predef$.MODULE$.wrapRefArray(new Object[]{party})).flatMap((Function1<Vector, Future> & Serializable & scala.Serializable)acsBefore -> {
                Object object = PackageManagementTestTemplate$.MODULE$.PackageManagementTestTemplate$u0020syntax(contract);
                return ledger.exercise(party, (Function1<Object, DomainCommand> & Serializable & scala.Serializable)actor -> PackageManagementTestTemplate$PackageManagementTestTemplate$u0020syntax$.MODULE$.exerciseTestChoice$extension1(object, actor, ExerciseOn$.MODULE$.OnId())).flatMap((Function1<TransactionTree, Future> & Serializable & scala.Serializable)_ -> ledger.activeContracts(Predef$.MODULE$.wrapRefArray(new Object[]{party})).map((Function1<Vector, Object> & Serializable & scala.Serializable)acsAfter -> {
                    PackageManagement.$anonfun$new$12(knownPackages, acsBefore, acsAfter);
                    return BoxedUnit.UNIT;
                }, this.ec()), this.ec());
            }, this.ec()), this.ec()), this.ec()), this.ec()), this.ec());
            return future;
        });
    }
}

