/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.tests;

import com.daml.ledger.api.testtool.infrastructure.Allocation;
import com.daml.ledger.api.testtool.infrastructure.Allocation$;
import com.daml.ledger.api.testtool.infrastructure.Allocation$SingleParty$;
import com.daml.ledger.api.testtool.infrastructure.Assertions$;
import com.daml.ledger.api.testtool.infrastructure.LedgerSession;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSuite;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext;
import com.daml.ledger.api.testtool.tests.TransactionScale$;
import com.digitalasset.ledger.api.v1.command_service.SubmitAndWaitRequest;
import com.digitalasset.ledger.api.v1.commands.Command;
import com.digitalasset.ledger.api.v1.transaction.Transaction;
import com.digitalasset.ledger.test_stable.Test.Dummy;
import com.digitalasset.ledger.test_stable.Test.TextContainer;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$DummyImplicit$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0$mcC$sp;

@ScalaSignature(bytes="\u0006\u0001q2A!\u0001\u0002\u0001\u001f\t\u0001BK]1og\u0006\u001cG/[8o'\u000e\fG.\u001a\u0006\u0003\u0007\u0011\tQ\u0001^3tiNT!!\u0002\u0004\u0002\u0011Q,7\u000f\u001e;p_2T!a\u0002\u0005\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\n\u0015\u00051A.\u001a3hKJT!a\u0003\u0007\u0002\t\u0011\fW\u000e\u001c\u0006\u0002\u001b\u0005\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0003'\u0011\ta\"\u001b8ge\u0006\u001cHO];diV\u0014X-\u0003\u0002\u0016%\tyA*\u001a3hKJ$Vm\u001d;Tk&$X\rC\u0005\u0018\u0001\t\u0005\t\u0015!\u0003\u00197\u000591/Z:tS>t\u0007CA\t\u001a\u0013\tQ\"CA\u0007MK\u0012<WM]*fgNLwN\\\u0005\u0003/QAQ!\b\u0001\u0005\u0002y\ta\u0001P5oSRtDCA\u0010\"!\t\u0001\u0003!D\u0001\u0003\u0011\u00159B\u00041\u0001\u0019\u0011\u0015\u0019\u0003\u0001\"\u0003%\u0003AqW/\u001c2fe>37i\\7nC:$7\u000f\u0006\u0002&WA\u0011a%K\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\t\u0019\u0011J\u001c;\t\u000b1\u0012\u0003\u0019A\u0013\u0002\u000bUt\u0017\u000e^:\b\u000b9\u0012\u0001\u0012A\u0018\u0002!Q\u0013\u0018M\\:bGRLwN\\*dC2,\u0007C\u0001\u00111\r\u0015\t!\u0001#\u00012'\t\u0001$\u0007\u0005\u0002'g%\u0011Ag\n\u0002\u0007\u0003:L(+\u001a4\t\u000bu\u0001D\u0011\u0001\u001c\u0015\u0003=Bq\u0001\u000f\u0019C\u0002\u0013%\u0011(\u0001\u000bok6\u0014WM](g\u0007>lW.\u00198egVs\u0017\u000e^\u000b\u0002K!11\b\rQ\u0001\n\u0015\nQC\\;nE\u0016\u0014xJZ\"p[6\fg\u000eZ:V]&$\b\u0005")
public class TransactionScale
extends LedgerTestSuite {
    private int numberOfCommands(int units) {
        return (int)((double)(units * TransactionScale$.MODULE$.com$daml$ledger$api$testtool$tests$TransactionScale$$numberOfCommandsUnit()) * super.session().config().loadScaleFactor());
    }

    public TransactionScale(LedgerSession session) {
        super(session);
        Predef$.MODULE$.require(this.numberOfCommands(1) > 0, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(39).append("The load scale factor must be at least ").append(1.0 / (double)TransactionScale$.MODULE$.com$daml$ledger$api$testtool$tests$TransactionScale$$numberOfCommandsUnit()).toString());
        this.test("TXLargeCommand", "Accept huge submissions with a large number of commands", Allocation$.MODULE$.allocate(Allocation$SingleParty$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$1 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$1;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(1) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Object party = participant.parties().apply(false);
            int targetNumberOfSubCommands = this.numberOfCommands(3);
            Future future = ledger.submitAndWaitRequest(party, (Seq)List$.MODULE$.fill(targetNumberOfSubCommands, (Function0<Command> & Serializable & scala.Serializable)() -> new Dummy(party).create(Predef$DummyImplicit$.MODULE$.dummyImplicit()).command())).flatMap((Function1<SubmitAndWaitRequest, Future> & Serializable & scala.Serializable)request -> ledger.submitAndWaitForTransaction((SubmitAndWaitRequest)request).map((Function1<Transaction, Object> & Serializable & scala.Serializable)result2 -> {
                seq = Assertions$.MODULE$.assertLength("LargeCommand", targetNumberOfSubCommands, result2.events());
                return BoxedUnit.UNIT;
            }, this.ec()), this.ec());
            return future;
        });
        this.test("TXManyCommands", "Accept many, large commands at once", Allocation$.MODULE$.allocate(Allocation$SingleParty$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$2 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$2;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(1) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Object party = participant.parties().apply(false);
            int targetNumberOfCommands = this.numberOfCommands(1);
            String oneKbOfText = new String((char[])Array$.MODULE$.fill(512, (JFunction0$mcC$sp & scala.Serializable)() -> 'a', ClassTag$.MODULE$.Char()));
            Future future = Future$.MODULE$.sequence((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), targetNumberOfCommands).map((Function1<Object, Future> & Serializable & scala.Serializable)x$1 -> ledger.create(party, new TextContainer(party, oneKbOfText)), IndexedSeq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom(), this.ec()).map((Function1<IndexedSeq, Object> & Serializable & scala.Serializable)contractIds -> {
                indexedSeq = Assertions$.MODULE$.assertLength("ManyCommands", targetNumberOfCommands, contractIds);
                return BoxedUnit.UNIT;
            }, this.ec());
            return future;
        });
    }
}

