/*
 * Decompiled with CFR 0.152.
 */
package com.digitalasset.daml.lf.engine;

import com.digitalasset.daml.lf.data.BackStack;
import com.digitalasset.daml.lf.data.BackStack$;
import com.digitalasset.daml.lf.data.FrontStack;
import com.digitalasset.daml.lf.data.FrontStack$;
import com.digitalasset.daml.lf.data.FrontStackCons$;
import com.digitalasset.daml.lf.data.ImmArray;
import com.digitalasset.daml.lf.data.Relation$Relation$;
import com.digitalasset.daml.lf.engine.AuthorizationError;
import com.digitalasset.daml.lf.transaction.BlindingInfo;
import com.digitalasset.daml.lf.transaction.GenTransaction;
import com.digitalasset.daml.lf.transaction.Node;
import com.digitalasset.daml.lf.types.Ledger;
import com.digitalasset.daml.lf.types.Ledger$;
import com.digitalasset.daml.lf.types.Ledger$DontAuthorize$;
import com.digitalasset.daml.lf.value.Value;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedMap;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Blinding$ {
    public static Blinding$ MODULE$;

    static {
        new Blinding$();
    }

    private Either<AuthorizationError, BlindingInfo> maybeAuthorizeAndBlind(GenTransaction<Value.NodeId, Value.ContractId, Value.VersionedValue<Value.ContractId>> tx, Ledger.Authorization authorization) {
        Ledger.EnrichedTransaction enrichedTx = Ledger$.MODULE$.enrichTransaction(authorization, tx);
        return enrichedTx.failedAuthorizations().isEmpty() ? package$.MODULE$.Right().apply(new BlindingInfo(enrichedTx.explicitDisclosure(), enrichedTx.localImplicitDisclosure(), enrichedTx.globalImplicitDisclosure())) : package$.MODULE$.Left().apply(new AuthorizationError(new StringBuilder(30).append("The following errors occured: ").append(Blinding$.authorizationErrors$1(enrichedTx.failedAuthorizations())).toString()));
    }

    public Either<AuthorizationError, BlindingInfo> checkAuthorizationAndBlind(GenTransaction<Value.NodeId, Value.ContractId, Value.VersionedValue<Value.ContractId>> tx, Set<String> initialAuthorizers) {
        return this.maybeAuthorizeAndBlind(tx, new Ledger.Authorize(initialAuthorizers));
    }

    public BlindingInfo blind(GenTransaction<Value.NodeId, Value.ContractId, Value.VersionedValue<Value.ContractId>> tx) {
        BlindingInfo x;
        Either<AuthorizationError, BlindingInfo> either2 = this.maybeAuthorizeAndBlind(tx, Ledger$DontAuthorize$.MODULE$);
        if (either2 instanceof Left) {
            Left left = (Left)either2;
            AuthorizationError err = (AuthorizationError)left.value();
            throw new RuntimeException(new StringBuilder(71).append("Impossible: got authorization exception even if we're not authorizing: ").append(err).toString());
        }
        if (!(either2 instanceof Right)) {
            throw new MatchError(either2);
        }
        Right right = (Right)either2;
        BlindingInfo blindingInfo = x = (BlindingInfo)right.value();
        return blindingInfo;
    }

    public <Nid, Cid, Val> GenTransaction<Nid, Cid, Val> divulgedTransaction(Map<Nid, Set<String>> divulgences, String party, GenTransaction<Nid, Cid, Val> tx, Ordering<Nid> evidence$1) {
        Set partyDivulgences = (Set)Relation$Relation$.MODULE$.invert(divulgences).apply(party);
        SortedMap<Nid, Node.GenNode<Nid, Cid, Val>> filteredNodes = tx.nodes().filterKeys((Function1<Nid, Object>)(Function1<Object, Object> & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean(partyDivulgences.contains(elem)));
        ImmArray x$2 = this.go$1(BackStack$.MODULE$.empty(), FrontStack$.MODULE$.apply(tx.roots()), tx, partyDivulgences);
        SortedMap<Nid, Node.GenNode<Nid, Cid, Val>> x$3 = filteredNodes;
        Option<Set<String>> x$4 = tx.optUsedPackages();
        return new GenTransaction<Nid, Cid, Val>(x$3, x$2, x$4, evidence$1);
    }

    private static final String authorizationErrors$1(Map failures) {
        return ((TraversableOnce)failures.map((Function1<Tuple2, String> & Serializable & scala.Serializable)x0$1 -> {
            String string2;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError(tuple2);
            Value.NodeId id2 = (Value.NodeId)tuple2._1();
            Ledger.FailedAuthorization failure = (Ledger.FailedAuthorization)tuple2._2();
            Ledger.FailedAuthorization failedAuthorization = failure;
            if (failedAuthorization instanceof Ledger.FANoControllers) {
                Ledger.FANoControllers fANoControllers = (Ledger.FANoControllers)failedAuthorization;
                string2 = new StringBuilder(27).append("node ").append(id2).append(" (").append(fANoControllers.templateId()).append(") has no controllers").toString();
                return string2;
            } else if (failedAuthorization instanceof Ledger.FAActorMismatch) {
                Ledger.FAActorMismatch fAActorMismatch = (Ledger.FAActorMismatch)failedAuthorization;
                string2 = new StringBuilder(53).append("node ").append(id2).append(" (").append(fAActorMismatch.templateId()).append(") requires controllers: ").append(fAActorMismatch.controllers().mkString(",")).append(", but only ").append(fAActorMismatch.givenActors().mkString(",")).append(" were given").toString();
                return string2;
            } else if (failedAuthorization instanceof Ledger.FACreateMissingAuthorization) {
                Ledger.FACreateMissingAuthorization fACreateMissingAuthorization = (Ledger.FACreateMissingAuthorization)failedAuthorization;
                string2 = new StringBuilder(52).append("node ").append(id2).append(" (").append(fACreateMissingAuthorization.templateId()).append(") requires authorizers ").append(fACreateMissingAuthorization.requiredParties().mkString(",")).append(", but only ").append(fACreateMissingAuthorization.authorizingParties().mkString(",")).append(" were given").toString();
                return string2;
            } else if (failedAuthorization instanceof Ledger.FAFetchMissingAuthorization) {
                Ledger.FAFetchMissingAuthorization fAFetchMissingAuthorization = (Ledger.FAFetchMissingAuthorization)failedAuthorization;
                string2 = new StringBuilder(106).append("node ").append(id2).append(" requires one of the stakeholders ").append(fAFetchMissingAuthorization.stakeholders()).append(" of the fetched contract to be an authorizer, but authorizers were ").append(fAFetchMissingAuthorization.authorizingParties()).toString();
                return string2;
            } else if (failedAuthorization instanceof Ledger.FAExerciseMissingAuthorization) {
                Ledger.FAExerciseMissingAuthorization fAExerciseMissingAuthorization = (Ledger.FAExerciseMissingAuthorization)failedAuthorization;
                string2 = new StringBuilder(52).append("node ").append(id2).append(" (").append(fAExerciseMissingAuthorization.templateId()).append(") requires authorizers ").append(fAExerciseMissingAuthorization.requiredParties().mkString(",")).append(", but only ").append(fAExerciseMissingAuthorization.authorizingParties().mkString(",")).append(" were given").toString();
                return string2;
            } else if (failedAuthorization instanceof Ledger.FANoSignatories) {
                Ledger.FANoSignatories fANoSignatories = (Ledger.FANoSignatories)failedAuthorization;
                string2 = new StringBuilder(27).append("node ").append(id2).append(" (").append(fANoSignatories.templateId()).append(") has no signatories").toString();
                return string2;
            } else if (failedAuthorization instanceof Ledger.FALookupByKeyMissingAuthorization) {
                Ledger.FALookupByKeyMissingAuthorization fALookupByKeyMissingAuthorization = (Ledger.FALookupByKeyMissingAuthorization)failedAuthorization;
                string2 = new StringBuilder(66).append("node ").append(id2).append(" (").append(fALookupByKeyMissingAuthorization.templateId()).append(") requires authorizers ").append(fALookupByKeyMissingAuthorization.maintainers()).append(" for lookup by key, but it only has ").append(fALookupByKeyMissingAuthorization.authorizingParties()).toString();
                return string2;
            } else {
                if (!(failedAuthorization instanceof Ledger.FAMaintainersNotSubsetOfSignatories)) throw new MatchError(failedAuthorization);
                Ledger.FAMaintainersNotSubsetOfSignatories fAMaintainersNotSubsetOfSignatories = (Ledger.FAMaintainersNotSubsetOfSignatories)failedAuthorization;
                string2 = new StringBuilder(68).append("node ").append(id2).append(" (").append(fAMaintainersNotSubsetOfSignatories.templateId()).append(") has maintainers ").append(fAMaintainersNotSubsetOfSignatories.maintainers()).append(" which are not a subset of the signatories ").append(fAMaintainersNotSubsetOfSignatories.signatories()).toString();
            }
            return string2;
        }, Iterable$.MODULE$.canBuildFrom())).mkString(";");
    }

    private final ImmArray go$1(BackStack filteredRoots, FrontStack remainingRoots, GenTransaction tx$1, Set partyDivulgences$1) {
        block3: {
            FrontStack frontStack;
            block4: {
                Node.GenNode genNode;
                while (true) {
                    if (FrontStack$.MODULE$.unapply(frontStack = remainingRoots)) break block3;
                    Option option2 = FrontStackCons$.MODULE$.unapply(frontStack);
                    if (option2.isEmpty()) break block4;
                    Object root = option2.get()._1();
                    FrontStack remainingRoots2 = option2.get()._2();
                    if (partyDivulgences$1.contains(root)) {
                        remainingRoots = remainingRoots2;
                        filteredRoots = filteredRoots.$colon$plus(root);
                        continue;
                    }
                    genNode = (Node.GenNode)tx$1.nodes().apply(root);
                    boolean bl = genNode instanceof Node.NodeFetch ? true : (genNode instanceof Node.NodeCreate ? true : genNode instanceof Node.NodeLookupByKey);
                    if (bl) {
                        remainingRoots = remainingRoots2;
                        continue;
                    }
                    if (!(genNode instanceof Node.NodeExercises)) break;
                    Node.NodeExercises nodeExercises = (Node.NodeExercises)genNode;
                    ImmArray immArray = nodeExercises.children();
                    remainingRoots = remainingRoots2.$plus$plus$colon(immArray);
                }
                throw new MatchError(genNode);
            }
            throw new MatchError(frontStack);
        }
        ImmArray immArray = filteredRoots.toImmArray();
        return immArray;
    }

    private Blinding$() {
        MODULE$ = this;
    }
}

