/*
 * Decompiled with CFR 0.152.
 */
package com.digitalasset.daml.lf.engine;

import com.digitalasset.daml.lf.data.ImmArray;
import com.digitalasset.daml.lf.data.Ref;
import com.digitalasset.daml.lf.engine.Error;
import com.digitalasset.daml.lf.engine.Error$;
import com.digitalasset.daml.lf.language.Ast;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class PackageLookup$ {
    public static PackageLookup$ MODULE$;

    static {
        new PackageLookup$();
    }

    public Either<Error, Ast.Definition> lookupDefinition(Ast.Package pkg, Ref.QualifiedName identifier) {
        return (Either)pkg.lookupIdentifier(identifier).fold((Function1<String, Left> & Serializable & scala.Serializable)err -> package$.MODULE$.Left().apply(Error$.MODULE$.apply((String)err)), (Function1<Ast.Definition, Right> & Serializable & scala.Serializable)x$1 -> package$.MODULE$.Right().apply(x$1));
    }

    public Either<Error, Ast.DDataType> lookupDataType(Ast.Package pkg, Ref.QualifiedName identifier) {
        return this.lookupDefinition(pkg, identifier).flatMap((Function1<Ast.Definition, Either> & Serializable & scala.Serializable)defn -> {
            Either either2;
            Ast.Definition definition = defn;
            if (definition instanceof Ast.DValue) {
                either2 = package$.MODULE$.Left().apply(Error$.MODULE$.apply(new StringBuilder(57).append("Got value definition instead of datatype when looking up ").append(identifier).toString()));
            } else if (definition instanceof Ast.DDataType) {
                Ast.DDataType dDataType = (Ast.DDataType)definition;
                either2 = package$.MODULE$.Right().apply(dDataType);
            } else {
                throw new MatchError(definition);
            }
            return either2.map((Function1<Ast.DDataType, Ast.DDataType> & Serializable & scala.Serializable)dataTyp -> dataTyp);
        });
    }

    public Either<Error, Tuple2<ImmArray<Tuple2<String, Ast.Kind>>, Ast.DataRecord>> lookupRecord(Ast.Package pkg, Ref.QualifiedName identifier) {
        return this.lookupDataType(pkg, identifier).flatMap((Function1<Ast.DDataType, Either> & Serializable & scala.Serializable)dataTyp -> {
            Either either2;
            Ast.DataCons dataCons = dataTyp.cons();
            if (dataCons instanceof Ast.DataRecord) {
                Ast.DataRecord dataRecord = (Ast.DataRecord)dataCons;
                either2 = package$.MODULE$.Right().apply(new Tuple2<ImmArray<Tuple2<String, Ast.Kind>>, Ast.DataRecord>(dataTyp.params(), dataRecord));
            } else if (dataCons instanceof Ast.DataVariant) {
                either2 = package$.MODULE$.Left().apply(Error$.MODULE$.apply(new StringBuilder(45).append("Expecting record for identifier ").append(identifier).append(", got variant").toString()));
            } else if (dataCons instanceof Ast.DataEnum) {
                either2 = package$.MODULE$.Left().apply(Error$.MODULE$.apply(new StringBuilder(42).append("Expecting record for identifier ").append(identifier).append(", got enum").toString()));
            } else {
                throw new MatchError(dataCons);
            }
            return either2;
        });
    }

    public Either<Error, Tuple2<ImmArray<Tuple2<String, Ast.Kind>>, Ast.DataVariant>> lookupVariant(Ast.Package pkg, Ref.QualifiedName identifier) {
        return this.lookupDataType(pkg, identifier).flatMap((Function1<Ast.DDataType, Either> & Serializable & scala.Serializable)dataTyp -> {
            Either either2;
            Ast.DataCons dataCons = dataTyp.cons();
            if (dataCons instanceof Ast.DataVariant) {
                Ast.DataVariant dataVariant = (Ast.DataVariant)dataCons;
                either2 = package$.MODULE$.Right().apply(new Tuple2<ImmArray<Tuple2<String, Ast.Kind>>, Ast.DataVariant>(dataTyp.params(), dataVariant));
            } else if (dataCons instanceof Ast.DataRecord) {
                either2 = package$.MODULE$.Left().apply(Error$.MODULE$.apply(new StringBuilder(45).append("Expecting variant for identifier ").append(identifier).append(", got record").toString()));
            } else if (dataCons instanceof Ast.DataEnum) {
                either2 = package$.MODULE$.Left().apply(Error$.MODULE$.apply(new StringBuilder(43).append("Expecting variant for identifier ").append(identifier).append(", got enum").toString()));
            } else {
                throw new MatchError(dataCons);
            }
            return either2;
        });
    }

    public Either<Error, Ast.DataEnum> lookupEnum(Ast.Package pkg, Ref.QualifiedName identifier) {
        return this.lookupDataType(pkg, identifier).flatMap((Function1<Ast.DDataType, Either> & Serializable & scala.Serializable)dataTyp -> {
            Either either2;
            Ast.DataCons dataCons = dataTyp.cons();
            if (dataCons instanceof Ast.DataEnum) {
                Ast.DataEnum dataEnum = (Ast.DataEnum)dataCons;
                either2 = package$.MODULE$.Right().apply(dataEnum);
            } else if (dataCons instanceof Ast.DataVariant) {
                either2 = package$.MODULE$.Left().apply(Error$.MODULE$.apply(new StringBuilder(43).append("Expecting enum for identifier ").append(identifier).append(", got variant").toString()));
            } else if (dataCons instanceof Ast.DataRecord) {
                either2 = package$.MODULE$.Left().apply(Error$.MODULE$.apply(new StringBuilder(42).append("Expecting enum for identifier ").append(identifier).append(", got record").toString()));
            } else {
                throw new MatchError(dataCons);
            }
            return either2;
        });
    }

    public Either<Error, Ast.Template> lookupTemplate(Ast.Package pkg, Ref.QualifiedName identifier) {
        return this.lookupDataType(pkg, identifier).flatMap((Function1<Ast.DDataType, Either> & Serializable & scala.Serializable)dataTyp -> {
            Option<Ast.Template> option2;
            void var2_12;
            boolean bl = false;
            Ast.DataRecord dataRecord = null;
            Ast.DataCons dataCons = dataTyp.cons();
            if (dataCons instanceof Ast.DataRecord) {
                bl = true;
                dataRecord = (Ast.DataRecord)dataCons;
                Option<Ast.Template> option3 = dataRecord.optTemplate();
                if (option3 instanceof Some) {
                    Some some = (Some)option3;
                    Ast.Template template = (Ast.Template)some.value();
                    Right right = package$.MODULE$.Right().apply(template);
                    return var2_12.map((Function1<Ast.Template, Ast.Template> & Serializable & scala.Serializable)tpl -> tpl);
                }
            }
            if (bl && None$.MODULE$.equals(option2 = dataRecord.optTemplate())) {
                Left left = package$.MODULE$.Left().apply(Error$.MODULE$.apply(new StringBuilder(44).append("Got record with no template when looking up ").append(identifier).toString()));
                return var2_12.map((Function1<Ast.Template, Ast.Template> & Serializable & scala.Serializable)tpl -> tpl);
            }
            if (dataCons instanceof Ast.DataVariant) {
                Left left = package$.MODULE$.Left().apply(Error$.MODULE$.apply(new StringBuilder(47).append("Expecting template for identifier ").append(identifier).append(", got variant").toString()));
                return var2_12.map((Function1<Ast.Template, Ast.Template> & Serializable & scala.Serializable)tpl -> tpl);
            }
            if (!(dataCons instanceof Ast.DataEnum)) throw new MatchError(dataCons);
            Left left = package$.MODULE$.Left().apply(Error$.MODULE$.apply(new StringBuilder(44).append("Expecting template for identifier ").append(identifier).append(", got enum").toString()));
            return var2_12.map((Function1<Ast.Template, Ast.Template> & Serializable & scala.Serializable)tpl -> tpl);
        });
    }

    private PackageLookup$() {
        MODULE$ = this;
    }
}

