/*
 * Decompiled with CFR 0.152.
 */
package com.digitalasset.daml.lf.speedy;

import com.digitalasset.daml.lf.data.FrontStack;
import com.digitalasset.daml.lf.data.Ref;
import com.digitalasset.daml.lf.data.package$;
import com.digitalasset.daml.lf.speedy.SError;
import com.digitalasset.daml.lf.speedy.SError$;
import com.digitalasset.daml.lf.speedy.SValue;
import com.digitalasset.daml.lf.speedy.SValue$SGenMap$Key$;
import com.digitalasset.daml.lf.speedy.SValue$SToken$;
import com.digitalasset.daml.lf.speedy.Speedy;
import com.digitalasset.daml.lf.transaction.Transaction;
import com.digitalasset.daml.lf.transaction.Transaction$EndExerciseInRootContext$;
import com.digitalasset.daml.lf.value.Value;
import java.io.Serializable;
import java.math.BigDecimal;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class SBuiltin$ {
    public static SBuiltin$ MODULE$;

    static {
        new SBuiltin$();
    }

    public long com$digitalasset$daml$lf$speedy$SBuiltin$$add(long x, long y) {
        long l;
        try {
            l = Math.addExact(x, y);
        }
        catch (ArithmeticException arithmeticException) {
            throw new SError.DamlEArithmeticError(new StringBuilder(32).append("Int64 overflow when adding ").append(y).append(" to ").append(x).append(".").toString());
        }
        return l;
    }

    public long com$digitalasset$daml$lf$speedy$SBuiltin$$div(long x, long y) {
        if (y == 0L) {
            throw new SError.DamlEArithmeticError(new StringBuilder(24).append("Attempt to divide ").append(x).append(" by 0.").toString());
        }
        if (x == Long.MIN_VALUE && y == -1L) {
            throw new SError.DamlEArithmeticError(new StringBuilder(34).append("Int64 overflow when dividing ").append(x).append(" by ").append(y).append(".").toString());
        }
        return x / y;
    }

    public long com$digitalasset$daml$lf$speedy$SBuiltin$$mult(long x, long y) {
        long l;
        try {
            l = Math.multiplyExact(x, y);
        }
        catch (ArithmeticException arithmeticException) {
            throw new SError.DamlEArithmeticError(new StringBuilder(37).append("Int64 overflow when multiplying ").append(x).append(" by ").append(y).append(".").toString());
        }
        return l;
    }

    public long com$digitalasset$daml$lf$speedy$SBuiltin$$sub(long x, long y) {
        long l;
        try {
            l = Math.subtractExact(x, y);
        }
        catch (ArithmeticException arithmeticException) {
            throw new SError.DamlEArithmeticError(new StringBuilder(39).append("Int64 overflow when subtracting ").append(y).append(" from ").append(x).append(".").toString());
        }
        return l;
    }

    public long com$digitalasset$daml$lf$speedy$SBuiltin$$mod(long x, long y) {
        if (y == 0L) {
            throw new SError.DamlEArithmeticError(new StringBuilder(29).append("Attempt to compute ").append(x).append(" modulo 0.").toString());
        }
        return x % y;
    }

    public long com$digitalasset$daml$lf$speedy$SBuiltin$$exp(long base, long exponent) {
        long l;
        if (exponent < 0L) {
            throw new SError.DamlEArithmeticError(new StringBuilder(44).append("Attempt to raise ").append(base).append(" to the negative exponent ").append(exponent).append(".").toString());
        }
        if (exponent == 0L) {
            l = 1L;
        } else {
            try {
                long x = base;
                long y = 1L;
                for (long n = exponent; n > 1L; n >>= 1) {
                    if (n % 2L == 1L) {
                        y = Math.multiplyExact(y, x);
                    }
                    x = Math.multiplyExact(x, x);
                }
                l = Math.multiplyExact(x, y);
            }
            catch (ArithmeticException arithmeticException) {
                throw new SError.DamlEArithmeticError(new StringBuilder(46).append("Int64 overflow when raising ").append(base).append(" to the exponent ").append(exponent).append(".").toString());
            }
        }
        return l;
    }

    public BigDecimal com$digitalasset$daml$lf$speedy$SBuiltin$$add(BigDecimal x, BigDecimal y) {
        return this.com$digitalasset$daml$lf$speedy$SBuiltin$$rightOrArithmeticError(new StringBuilder(37).append("(Numeric ").append(x.scale()).append(") overflow when adding ").append(package$.MODULE$.Numeric().toString(y)).append(" to ").append(package$.MODULE$.Numeric().toString(x)).append(".").toString(), package$.MODULE$.Numeric().add(x, y));
    }

    public BigDecimal com$digitalasset$daml$lf$speedy$SBuiltin$$subtract(BigDecimal x, BigDecimal y) {
        return this.com$digitalasset$daml$lf$speedy$SBuiltin$$rightOrArithmeticError(new StringBuilder(44).append("(Numeric ").append(x.scale()).append(") overflow when subtracting ").append(package$.MODULE$.Numeric().toString(y)).append(" from ").append(package$.MODULE$.Numeric().toString(x)).append(".").toString(), package$.MODULE$.Numeric().subtract(x, y));
    }

    public BigDecimal com$digitalasset$daml$lf$speedy$SBuiltin$$multiply(int scale, BigDecimal x, BigDecimal y) {
        return this.com$digitalasset$daml$lf$speedy$SBuiltin$$rightOrArithmeticError(new StringBuilder(42).append("(Numeric ").append(scale).append(") overflow when multiplying ").append(package$.MODULE$.Numeric().toString(x)).append(" by ").append(package$.MODULE$.Numeric().toString(y)).append(".").toString(), package$.MODULE$.Numeric().multiply(scale, x, y));
    }

    public BigDecimal com$digitalasset$daml$lf$speedy$SBuiltin$$divide(int scale, BigDecimal x, BigDecimal y) {
        if (y.signum() == 0) {
            throw new SError.DamlEArithmeticError(new StringBuilder(23).append("Attempt to divide ").append(package$.MODULE$.Numeric().toString(x)).append(" by ").append(package$.MODULE$.Numeric().toString(y)).append(".").toString());
        }
        return this.com$digitalasset$daml$lf$speedy$SBuiltin$$rightOrArithmeticError(new StringBuilder(39).append("(Numeric ").append(scale).append(") overflow when dividing ").append(package$.MODULE$.Numeric().toString(x)).append(" by ").append(package$.MODULE$.Numeric().toString(y)).append(".").toString(), package$.MODULE$.Numeric().divide(scale, x, y));
    }

    public SValue.SGenMap.Key com$digitalasset$daml$lf$speedy$SBuiltin$$buildKey(SValue v) throws SError.SErrorCrash {
        SValue.SGenMap.Key key;
        Either<String, SValue.SGenMap.Key> either2 = SValue$SGenMap$Key$.MODULE$.fromSValue(v);
        if (either2 instanceof Left) {
            Left left = (Left)either2;
            String msg = (String)left.value();
            throw new SError.SErrorCrash(msg);
        }
        if (!(either2 instanceof Right)) {
            throw new MatchError(either2);
        }
        Right right = (Right)either2;
        SValue.SGenMap.Key key2 = key = (SValue.SGenMap.Key)right.value();
        return key2;
    }

    public void com$digitalasset$daml$lf$speedy$SBuiltin$$checkAborted(Transaction.PartialTransaction ptx) {
        Transaction.TransactionError transactionError;
        boolean bl = false;
        Some some = null;
        Option<Transaction.TransactionError> option2 = ptx.aborted();
        if (option2 instanceof Some) {
            bl = true;
            some = (Some)option2;
            Transaction.TransactionError transactionError2 = (Transaction.TransactionError)some.value();
            if (transactionError2 instanceof Transaction.ContractNotActive) {
                Transaction.ContractNotActive contractNotActive = (Transaction.ContractNotActive)transactionError2;
                Value.ContractId coid = contractNotActive.coid();
                Ref.Identifier tid = contractNotActive.templateId();
                Value.NodeId consumedBy = contractNotActive.consumedBy();
                throw new SError.DamlELocalContractNotActive(coid, tid, consumedBy);
            }
        }
        if (bl && Transaction$EndExerciseInRootContext$.MODULE$.equals(transactionError = (Transaction.TransactionError)some.value())) {
            BoxedUnit boxedUnit = (BoxedUnit)SError$.MODULE$.crash("internal error: end exercise in root context");
        } else if (None$.MODULE$.equals(option2)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option2);
        }
    }

    public void com$digitalasset$daml$lf$speedy$SBuiltin$$checkToken(SValue v) {
        SValue sValue = v;
        if (SValue$SToken$.MODULE$.equals(sValue)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = (BoxedUnit)SError$.MODULE$.crash(new StringBuilder(19).append("value not a token: ").append(v).toString());
        }
    }

    public Set<String> com$digitalasset$daml$lf$speedy$SBuiltin$$extractParties(SValue v) {
        Set set2;
        SValue sValue = v;
        if (sValue instanceof SValue.SList) {
            SValue.SList sList = (SValue.SList)sValue;
            FrontStack<SValue> vs = sList.list();
            set2 = vs.iterator().collect(new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends SValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    String string2;
                    A1 A1 = x1;
                    if (A1 instanceof SValue.SParty) {
                        String p;
                        SValue.SParty sParty = (SValue.SParty)A1;
                        string2 = p = sParty.value();
                    } else {
                        string2 = SError$.MODULE$.crash(new StringBuilder(25).append("non-party value in list: ").append(A1).toString());
                    }
                    return (B1)string2;
                }

                public final boolean isDefinedAt(SValue x1) {
                    SValue sValue = x1;
                    boolean bl = sValue instanceof SValue.SParty ? true : true;
                    return bl;
                }
            }).toSet();
        } else if (sValue instanceof SValue.SParty) {
            SValue.SParty sParty = (SValue.SParty)sValue;
            String p = sParty.value();
            set2 = (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{p}));
        } else {
            set2 = (Set)SError$.MODULE$.crash(new StringBuilder(38).append("value not a list of parties or party: ").append(v).toString());
        }
        return set2;
    }

    public void com$digitalasset$daml$lf$speedy$SBuiltin$$checkLookupMaintainers(Ref.Identifier templateId, Speedy.Machine machine, Set<String> maintainers) {
        if (!machine.validating()) {
            String submitter;
            String string2 = submitter = machine.committers().size() != 1 ? (String)SError$.MODULE$.crash(new StringBuilder(68).append("expecting exactly one committer since we're not validating, but got ").append(machine.committers()).toString()) : (String)machine.committers().toSeq().head();
            if (machine.checkSubmitterInMaintainers() && !maintainers.contains(submitter)) {
                throw new SError.DamlESubmitterNotInMaintainers(templateId, submitter, maintainers);
            }
        }
    }

    public <A> A com$digitalasset$daml$lf$speedy$SBuiltin$$rightOrArithmeticError(String message, Either<String, A> mb) {
        return (A)mb.fold((Function1<String, Nothing$> & Serializable & scala.Serializable)x$21 -> {
            throw new SError.DamlEArithmeticError(String.valueOf(message));
        }, (Function1<Object, Object> & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x));
    }

    private SBuiltin$() {
        MODULE$ = this;
    }
}

