/*
 * Decompiled with CFR 0.152.
 */
package com.digitalasset.daml.lf.transaction;

import com.digitalasset.daml.lf.blinding.Blindinginfo;
import com.digitalasset.daml.lf.data.Ref$;
import com.digitalasset.daml.lf.transaction.BlindingInfo;
import com.digitalasset.daml.lf.transaction.package$;
import com.digitalasset.daml.lf.value.Value;
import com.digitalasset.daml.lf.value.ValueCoder;
import com.google.protobuf.ByteString;
import com.google.protobuf.ProtocolStringList;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BlindingCoder$ {
    public static BlindingCoder$ MODULE$;

    static {
        new BlindingCoder$();
    }

    public Either<ValueCoder.DecodeError, BlindingInfo> decode(Blindinginfo.BlindingInfo p, Function1<String, Either<ValueCoder.DecodeError, Value.NodeId>> nodeIdReader) {
        Buffer explicitDisclosure = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getExplicitDisclosureList()).asScala()).map((Function1<Blindinginfo.NodeParties, Either> & Serializable & scala.Serializable)n -> ((Either)nodeIdReader.apply(n.getNodeId())).flatMap((Function1<Value.NodeId, Either> & Serializable & scala.Serializable)ni -> MODULE$.toPartySet(n.getPartiesList()).map((Function1<Set, Tuple2> & Serializable & scala.Serializable)parties -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ni), parties))), Buffer$.MODULE$.canBuildFrom());
        Buffer implicitLocal = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getLocalImplicitDisclosureList()).asScala()).map((Function1<Blindinginfo.NodeParties, Either> & Serializable & scala.Serializable)n -> ((Either)nodeIdReader.apply(n.getNodeId())).flatMap((Function1<Value.NodeId, Either> & Serializable & scala.Serializable)ni -> MODULE$.toPartySet(n.getPartiesList()).map((Function1<Set, Tuple2> & Serializable & scala.Serializable)parties -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ni), parties))), Buffer$.MODULE$.canBuildFrom());
        Buffer globalDisclosure = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getGlobalImplicitDisclosureList()).asScala()).map((Function1<Blindinginfo.ContractParties, Either> & Serializable & scala.Serializable)n -> MODULE$.toPartySet(n.getPartiesList()).flatMap((Function1<Set, Either> & Serializable & scala.Serializable)parties -> MODULE$.toContractId(n.getContractId()).map((Function1<String, Tuple2> & Serializable & scala.Serializable)coid -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new Value.AbsoluteContractId((String)coid)), parties))), Buffer$.MODULE$.canBuildFrom());
        return package$.MODULE$.sequence(explicitDisclosure, Buffer$.MODULE$.canBuildFrom()).flatMap((Function1<Buffer, Either> & Serializable & scala.Serializable)explicit -> package$.MODULE$.sequence(implicitLocal, Buffer$.MODULE$.canBuildFrom()).flatMap((Function1<Buffer, Either> & Serializable & scala.Serializable)local -> package$.MODULE$.sequence(globalDisclosure, Buffer$.MODULE$.canBuildFrom()).map((Function1<Buffer, BlindingInfo> & Serializable & scala.Serializable)global -> new BlindingInfo(explicit.toMap(Predef$.MODULE$.$conforms()), local.toMap(Predef$.MODULE$.$conforms()), global.toMap(Predef$.MODULE$.$conforms())))));
    }

    public Blindinginfo.BlindingInfo encode(BlindingInfo blindingInfo, Function1<Value.NodeId, String> nodeIdWriter) {
        Blindinginfo.BlindingInfo.Builder builder = Blindinginfo.BlindingInfo.newBuilder();
        Iterable localImplicit = blindingInfo.localDivulgence().map((Function1<Tuple2, Blindinginfo.NodeParties> & Serializable & scala.Serializable)nodeParties -> {
            Blindinginfo.NodeParties.Builder b1 = Blindinginfo.NodeParties.newBuilder();
            b1.setNodeId((String)nodeIdWriter.apply((Value.NodeId)nodeParties._1()));
            b1.addAllParties(JavaConverters$.MODULE$.setAsJavaSetConverter(((Set)nodeParties._2()).toSet()).asJava());
            return b1.build();
        }, Iterable$.MODULE$.canBuildFrom());
        Iterable explicit = blindingInfo.disclosure().map((Function1<Tuple2, Blindinginfo.NodeParties> & Serializable & scala.Serializable)nodeParties -> {
            Blindinginfo.NodeParties.Builder b1 = Blindinginfo.NodeParties.newBuilder();
            b1.setNodeId((String)nodeIdWriter.apply((Value.NodeId)nodeParties._1()));
            b1.addAllParties(JavaConverters$.MODULE$.setAsJavaSetConverter(((Set)nodeParties._2()).toSet()).asJava());
            return b1.build();
        }, Iterable$.MODULE$.canBuildFrom());
        Iterable global = blindingInfo.globalDivulgence().map((Function1<Tuple2, Blindinginfo.ContractParties> & Serializable & scala.Serializable)contractParties -> {
            Blindinginfo.ContractParties.Builder b1 = Blindinginfo.ContractParties.newBuilder();
            b1.setContractId(((Value.AbsoluteContractId)contractParties._1()).coid());
            b1.addAllParties(JavaConverters$.MODULE$.setAsJavaSetConverter(((Set)contractParties._2()).toSet()).asJava());
            return b1.build();
        }, Iterable$.MODULE$.canBuildFrom());
        builder.addAllExplicitDisclosure(JavaConverters$.MODULE$.asJavaIterableConverter(explicit).asJava());
        builder.addAllGlobalImplicitDisclosure(JavaConverters$.MODULE$.asJavaIterableConverter(global).asJava());
        builder.addAllLocalImplicitDisclosure(JavaConverters$.MODULE$.asJavaIterableConverter(localImplicit).asJava());
        return builder.build();
    }

    private Either<ValueCoder.DecodeError, Set<String>> toPartySet(ProtocolStringList strList) {
        Either either2;
        Buffer parties = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(strList.asByteStringList()).asScala()).map((Function1<ByteString, Either> & Serializable & scala.Serializable)bs -> Ref$.MODULE$.Party().fromString(bs.toStringUtf8()), Buffer$.MODULE$.canBuildFrom());
        Either either3 = package$.MODULE$.sequence(parties, Buffer$.MODULE$.canBuildFrom());
        if (either3 instanceof Left) {
            Left left = (Left)either3;
            String err = (String)left.value();
            either2 = scala.package$.MODULE$.Left().apply(new ValueCoder.DecodeError(new StringBuilder(21).append("Cannot decode party: ").append(err).toString()));
        } else if (either3 instanceof Right) {
            Right right = (Right)either3;
            Buffer l = (Buffer)right.value();
            either2 = scala.package$.MODULE$.Right().apply(l.toSet());
        } else {
            throw new MatchError(either3);
        }
        return either2;
    }

    private Either<ValueCoder.DecodeError, String> toContractId(String s) {
        return Ref$.MODULE$.ContractIdString().fromString(s).left().map((Function1<String, ValueCoder.DecodeError> & Serializable & scala.Serializable)err -> new ValueCoder.DecodeError(new StringBuilder(26).append("Cannot decode contractId: ").append((String)err).toString()));
    }

    private BlindingCoder$() {
        MODULE$ = this;
    }
}

