/*
 * Decompiled with CFR 0.152.
 */
package com.digitalasset.daml.lf.types;

import com.digitalasset.daml.lf.data.FrontStack;
import com.digitalasset.daml.lf.data.ImmArray;
import com.digitalasset.daml.lf.data.Ref;
import com.digitalasset.daml.lf.data.Ref$;
import com.digitalasset.daml.lf.data.Relation$Relation$;
import com.digitalasset.daml.lf.data.SortedLookupList;
import com.digitalasset.daml.lf.data.Time;
import com.digitalasset.daml.lf.transaction.GenTransaction;
import com.digitalasset.daml.lf.transaction.Node;
import com.digitalasset.daml.lf.types.Ledger;
import com.digitalasset.daml.lf.types.Ledger$EnrichState$;
import com.digitalasset.daml.lf.types.Ledger$LedgerData$;
import com.digitalasset.daml.lf.types.Ledger$ScenarioNodeId$;
import com.digitalasset.daml.lf.value.Value;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.IntMap;
import scala.collection.immutable.IntMap$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.SortedMap$;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Ledger$ {
    public static Ledger$ MODULE$;
    private final String com$digitalasset$daml$lf$types$Ledger$$$colon;

    static {
        new Ledger$();
    }

    public Value.AbsoluteContractId txNodeIdToAbsoluteContractId(String commitPrefix, Value.NodeId txnid) {
        return new Value.AbsoluteContractId(Ref$.MODULE$.ContractIdString().concat(commitPrefix, Predef$.MODULE$.wrapRefArray((Object[])new String[]{txnid.name()})));
    }

    public Value.AbsoluteContractId relativeToAbsoluteContractId(String commitPrefix, Value.RelativeContractId i) {
        return this.txNodeIdToAbsoluteContractId(commitPrefix, i.txnid());
    }

    public Value.AbsoluteContractId contractIdToAbsoluteContractId(String commitPrefix, Value.ContractId cid) {
        Value.AbsoluteContractId absoluteContractId;
        Value.ContractId contractId = cid;
        if (contractId instanceof Value.AbsoluteContractId) {
            Value.AbsoluteContractId absoluteContractId2;
            absoluteContractId = absoluteContractId2 = (Value.AbsoluteContractId)contractId;
        } else if (contractId instanceof Value.RelativeContractId) {
            Value.RelativeContractId relativeContractId = (Value.RelativeContractId)contractId;
            absoluteContractId = this.relativeToAbsoluteContractId(commitPrefix, relativeContractId);
        } else {
            throw new MatchError(contractId);
        }
        return absoluteContractId;
    }

    public Value.AbsoluteContractId assertAbsoluteContractId(Value.ContractId cid) {
        Value.AbsoluteContractId absoluteContractId;
        Value.ContractId contractId = cid;
        if (!(contractId instanceof Value.AbsoluteContractId)) {
            if (contractId instanceof Value.RelativeContractId) {
                throw this.crash("Unexpected relative contract id '$cid'");
            }
            throw new MatchError(contractId);
        }
        Value.AbsoluteContractId absoluteContractId2 = absoluteContractId = (Value.AbsoluteContractId)contractId;
        return absoluteContractId2;
    }

    public String com$digitalasset$daml$lf$types$Ledger$$$colon() {
        return this.com$digitalasset$daml$lf$types$Ledger$$$colon;
    }

    public Nothing$ crash(String reason) {
        return this.throwLedgerError(new Ledger.ErrorLedgerCrash(reason));
    }

    public Nothing$ throwLedgerError(Ledger.Error err) {
        throw new Ledger.LedgerException(err);
    }

    public Ledger.RichTransaction enrichedTransactionToRichTransaction(String commitPrefix, String committer, Time.Timestamp effectiveAt, Ledger.EnrichedTransaction enrichedTx) {
        return new Ledger.RichTransaction(committer, effectiveAt, enrichedTx.roots().map((Function1<Value.NodeId, String> & Serializable & scala.Serializable)x$1 -> Ledger$ScenarioNodeId$.MODULE$.apply(commitPrefix, (Value.NodeId)x$1)), enrichedTx.nodes().map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Value.NodeId nodeId = (Value.NodeId)tuple2._1();
            Node.GenNode node = (Node.GenNode)tuple2._2();
            Tuple2<String, Node.GenNode<String, Value.AbsoluteContractId, Value.VersionedValue<Value.AbsoluteContractId>>> tuple22 = new Tuple2<String, Node.GenNode<String, Value.AbsoluteContractId, Value.VersionedValue<Value.AbsoluteContractId>>>(Ledger$ScenarioNodeId$.MODULE$.apply(commitPrefix, nodeId), MODULE$.translateNode(commitPrefix, node));
            return tuple22;
        }, scala.collection.package$.MODULE$.breakOut(SortedMap$.MODULE$.canBuildFrom(Ref$.MODULE$.LedgerString().ordering()))), enrichedTx.explicitDisclosure().map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Value.NodeId nodeId = (Value.NodeId)tuple2._1();
            Set ps = (Set)tuple2._2();
            Tuple2<String, Set> tuple22 = new Tuple2<String, Set>(Ledger$ScenarioNodeId$.MODULE$.apply(commitPrefix, nodeId), ps);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom()), enrichedTx.localImplicitDisclosure().map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Value.NodeId nodeId = (Value.NodeId)tuple2._1();
            Set ps = (Set)tuple2._2();
            Tuple2<String, Set> tuple22 = new Tuple2<String, Set>(Ledger$ScenarioNodeId$.MODULE$.apply(commitPrefix, nodeId), ps);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom()), enrichedTx.globalImplicitDisclosure(), enrichedTx.failedAuthorizations());
    }

    public Node.GenNode<String, Value.AbsoluteContractId, Value.VersionedValue<Value.AbsoluteContractId>> translateNode(String commitPrefix, Node.GenNode<Value.NodeId, Value.ContractId, Value.VersionedValue<Value.ContractId>> node) {
        Node.GenNode<Nothing$, Object, Object> genNode;
        Node.GenNode<Value.NodeId, Value.ContractId, Value.VersionedValue<Value.ContractId>> genNode2 = node;
        if (genNode2 instanceof Node.NodeCreate) {
            Node.NodeCreate nodeCreate = (Node.NodeCreate)genNode2;
            Value.VersionedValue<Value.AbsoluteContractId> x$16 = this.makeAbsolute(commitPrefix, (Value.VersionedValue)nodeCreate.coinst().arg());
            Ref.Identifier x$17 = nodeCreate.coinst().copy$default$1();
            String x$18 = nodeCreate.coinst().copy$default$3();
            genNode = new Node.NodeCreate<Value.AbsoluteContractId, Value.VersionedValue<Value.AbsoluteContractId>>(this.contractIdToAbsoluteContractId(commitPrefix, (Value.ContractId)nodeCreate.coid()), nodeCreate.coinst().copy(x$17, x$16, x$18), nodeCreate.optLocation(), nodeCreate.signatories(), nodeCreate.stakeholders(), nodeCreate.key().map((Function1<Node.KeyWithMaintainers, Node.KeyWithMaintainers> & Serializable & scala.Serializable)x$2 -> x$2.mapValue((Function1<Value.VersionedValue, Value.VersionedValue> & Serializable & scala.Serializable)x$3 -> MODULE$.makeAbsolute(commitPrefix, (Value.VersionedValue<Value.ContractId>)x$3))));
        } else if (genNode2 instanceof Node.NodeFetch) {
            Node.NodeFetch nodeFetch = (Node.NodeFetch)genNode2;
            Value.AbsoluteContractId x$19 = this.contractIdToAbsoluteContractId(commitPrefix, (Value.ContractId)nodeFetch.coid());
            Option<Ref.Location> x$20 = nodeFetch.optLocation();
            Ref.Identifier x$21 = nodeFetch.templateId();
            Option<Set<String>> x$22 = nodeFetch.actingParties();
            Set<String> x$23 = nodeFetch.signatories();
            Set<String> x$24 = nodeFetch.stakeholders();
            genNode = new Node.NodeFetch<Value.AbsoluteContractId>(x$19, x$21, x$20, x$22, x$23, x$24);
        } else if (genNode2 instanceof Node.NodeExercises) {
            Node.NodeExercises nodeExercises = (Node.NodeExercises)genNode2;
            genNode = new Node.NodeExercises(this.contractIdToAbsoluteContractId(commitPrefix, (Value.ContractId)nodeExercises.targetCoid()), nodeExercises.templateId(), nodeExercises.choiceId(), nodeExercises.optLocation(), nodeExercises.consuming(), nodeExercises.actingParties(), this.makeAbsolute(commitPrefix, (Value.VersionedValue)nodeExercises.chosenValue()), nodeExercises.stakeholders(), nodeExercises.signatories(), nodeExercises.controllers(), nodeExercises.children().map((Function1<Value.NodeId, String> & Serializable & scala.Serializable)x$4 -> Ledger$ScenarioNodeId$.MODULE$.apply(commitPrefix, (Value.NodeId)x$4)), nodeExercises.exerciseResult().map((Function1<Value.VersionedValue, Value.VersionedValue> & Serializable & scala.Serializable)x$5 -> MODULE$.makeAbsolute(commitPrefix, (Value.VersionedValue<Value.ContractId>)x$5)), nodeExercises.key().map((Function1<Value.VersionedValue, Value.VersionedValue> & Serializable & scala.Serializable)x$6 -> x$6.mapContractId((Function1<Value.ContractId, Value.AbsoluteContractId> & Serializable & scala.Serializable)cid -> MODULE$.assertAbsoluteContractId((Value.ContractId)cid))));
        } else if (genNode2 instanceof Node.NodeLookupByKey) {
            Node.NodeLookupByKey nodeLookupByKey = (Node.NodeLookupByKey)genNode2;
            genNode = new Node.NodeLookupByKey<Value.AbsoluteContractId, Value.VersionedValue<Value.AbsoluteContractId>>(nodeLookupByKey.templateId(), nodeLookupByKey.optLocation(), nodeLookupByKey.key().mapValue((Function1<Value.VersionedValue, Value.VersionedValue> & Serializable & scala.Serializable)x$7 -> MODULE$.makeAbsolute(commitPrefix, (Value.VersionedValue<Value.ContractId>)x$7)), nodeLookupByKey.result().map((Function1<Value.ContractId, Value.AbsoluteContractId> & Serializable & scala.Serializable)x$8 -> MODULE$.contractIdToAbsoluteContractId(commitPrefix, (Value.ContractId)x$8)));
        } else {
            throw new MatchError(genNode2);
        }
        return genNode;
    }

    public Either<Ledger.CommitError, Ledger.CommitResult> commitTransaction(String committer, Time.Timestamp effectiveAt, Option<Ref.Location> optLocation, GenTransaction<Value.NodeId, Value.ContractId, Value.VersionedValue<Value.ContractId>> tr, Ledger.Ledger l) {
        Left<Ledger.CommitError, Ledger.CommitResult> left;
        Ledger.ScenarioTransactionId i = l.scenarioStepId();
        String commitPrefix = i.makeCommitPrefix();
        Ledger.RichTransaction richTr = this.enrichedTransactionToRichTransaction(commitPrefix, committer, effectiveAt, this.enrichTransaction(new Ledger.Authorize((Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{committer}))), tr));
        if (richTr.failedAuthorizations().nonEmpty()) {
            left = package$.MODULE$.Left().apply(new Ledger.CommitError.FailedAuthorizations(richTr.failedAuthorizations()));
        } else {
            Either either2;
            Either<Ledger.UniqueKeyViolation, Ledger.LedgerData> either3 = this.processTransaction(i, richTr, l.ledgerData());
            if (either3 instanceof Left) {
                Left left2 = (Left)either3;
                Ledger.UniqueKeyViolation err = (Ledger.UniqueKeyViolation)left2.value();
                either2 = package$.MODULE$.Left().apply(new Ledger.CommitError.UniqueKeyViolation(err));
            } else if (either3 instanceof Right) {
                Right right = (Right)either3;
                Ledger.LedgerData updatedCache = (Ledger.LedgerData)right.value();
                GenMap x$40 = l.scenarioSteps().$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(i.index())), new Ledger.Commit(i, richTr, optLocation)));
                Ledger.ScenarioTransactionId x$41 = l.scenarioStepId().next();
                Ledger.LedgerData x$42 = updatedCache;
                Time.Timestamp x$43 = l.copy$default$1();
                either2 = package$.MODULE$.Right().apply(new Ledger.CommitResult(l.copy(x$43, x$41, (IntMap<Ledger.ScenarioStep>)x$40, x$42), i, richTr));
            } else {
                throw new MatchError(either3);
            }
            left = either2;
        }
        return left;
    }

    public Ledger.Ledger initialLedger(Time.Timestamp t0) {
        return new Ledger.Ledger(t0, new Ledger.ScenarioTransactionId(0), IntMap$.MODULE$.empty(), Ledger$LedgerData$.MODULE$.empty());
    }

    public Ledger.EnrichedTransaction enrichTransaction(Ledger.Authorization authorization, GenTransaction<Value.NodeId, Value.ContractId, Value.VersionedValue<Value.ContractId>> tr) {
        Set initialParentExerciseWitnesses = (Set)Predef$.MODULE$.Set().apply(Nil$.MODULE$);
        Ledger.EnrichState finalState = tr.roots().foldLeft(Ledger$EnrichState$.MODULE$.empty(), (Function2<Ledger.EnrichState, Value.NodeId, Ledger.EnrichState> & Serializable & scala.Serializable)(s2, nodeId) -> Ledger$.enrichNode$1(s2, initialParentExerciseWitnesses, authorization, nodeId, tr));
        return new Ledger.EnrichedTransaction(tr.roots(), tr.nodes(), finalState.disclosures(), finalState.localDivulgences(), finalState.globalDivulgences(), finalState.failedAuthorizations());
    }

    public Set<Value.ContractId> collectCoids(Value.VersionedValue<Value.ContractId> value) {
        return this.collectCoids(value.value());
    }

    public Set<Value.ContractId> collectCoids(Value<Value.ContractId> value) {
        Builder coids = Predef$.MODULE$.implicitly(Set$.MODULE$.canBuildFrom()).apply();
        this.collect$1(value, coids);
        return coids.result();
    }

    public Value.VersionedValue<Value.AbsoluteContractId> makeAbsolute(String commitPrefix, Value.VersionedValue<Value.ContractId> value) {
        return new Value.VersionedValue<Value.AbsoluteContractId>(value.version(), this.makeAbsolute(commitPrefix, value.value()));
    }

    public Value<Value.AbsoluteContractId> makeAbsolute(String commitPrefix, Value<Value.ContractId> value) {
        return this.rewrite$1(value, commitPrefix);
    }

    private Either<Ledger.UniqueKeyViolation, Ledger.LedgerData> processTransaction(Ledger.ScenarioTransactionId trId, Ledger.RichTransaction richTr, Ledger.LedgerData ledgerData) {
        Either mbCacheAfterProcess = this.processNodes$1(package$.MODULE$.Right().apply(ledgerData), (List)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(None$.MODULE$), richTr.roots().toList())})), trId, richTr);
        return mbCacheAfterProcess.map((Function1<Ledger.LedgerData, Ledger.LedgerData> & Serializable & scala.Serializable)cacheAfterProcess -> {
            Map globalImplicitDisclosure = richTr.globalImplicitDisclosure().map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$11 -> {
                Tuple2 tuple2 = x0$11;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Value.AbsoluteContractId cid = (Value.AbsoluteContractId)tuple2._1();
                Set parties = (Set)tuple2._2();
                Tuple2 tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ledgerData.coidToNodeId().apply(cid)), parties);
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            return Relation$Relation$.MODULE$.union(Relation$Relation$.MODULE$.union(richTr.localImplicitDisclosure(), richTr.explicitDisclosure()), globalImplicitDisclosure).foldLeft(cacheAfterProcess, (Function2<Ledger.LedgerData, Tuple2, Ledger.LedgerData> & Serializable & scala.Serializable)(x0$12, x1$2) -> {
                Tuple2 tuple2;
                Ledger.LedgerData cacheP;
                block3: {
                    Tuple2<Ledger.LedgerData, Tuple2> tuple22;
                    block2: {
                        tuple22 = new Tuple2<Ledger.LedgerData, Tuple2>((Ledger.LedgerData)x0$12, (Tuple2)x1$2);
                        if (tuple22 == null) break block2;
                        cacheP = tuple22._1();
                        tuple2 = tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError(tuple22);
                }
                String nodeId = (String)tuple2._1();
                Set witnesses = (Set)tuple2._2();
                Ledger.LedgerData ledgerData = cacheP.updateNodeInfo(nodeId, (Function1<Ledger.NodeInfo, Ledger.NodeInfo> & Serializable & scala.Serializable)x$14 -> x$14.addObservers(((TraversableOnce)witnesses.map((Function1<String, Tuple2> & Serializable & scala.Serializable)x$15 -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$15), trId), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())));
                return ledgerData;
            });
        });
    }

    private static final Ledger.EnrichState enrichNode$1(Ledger.EnrichState state, Set parentExerciseWitnesses, Ledger.Authorization authorization, Value.NodeId nodeId, GenTransaction tr$1) {
        Ledger.EnrichState enrichState;
        Node.GenNode node = (Node.GenNode)tr$1.nodes().getOrElse(nodeId, (Function0<Nothing$> & Serializable & scala.Serializable)() -> MODULE$.crash(new StringBuilder(53).append("enrichNode - precondition violated: node ").append(nodeId).append(" not present").toString()));
        Node.GenNode genNode = node;
        if (genNode instanceof Node.NodeCreate) {
            Ledger.EnrichState state1;
            Node.NodeCreate nodeCreate = (Node.NodeCreate)genNode;
            Set witnesses = (Set)nodeCreate.stakeholders().union(parentExerciseWitnesses);
            enrichState = state1 = state.authorizeCreate(nodeId, nodeCreate, nodeCreate.signatories(), authorization, nodeCreate.key().map((Function1<Node.KeyWithMaintainers, Set> & Serializable & scala.Serializable)x$9 -> x$9.maintainers())).discloseTo(witnesses, nodeId);
        } else if (genNode instanceof Node.NodeFetch) {
            Node.NodeFetch nodeFetch = (Node.NodeFetch)genNode;
            Ledger.EnrichState state1 = state.divulgeCoidTo((Set)parentExerciseWitnesses.$minus$minus(nodeFetch.stakeholders()), (Value.ContractId)nodeFetch.coid()).discloseTo(parentExerciseWitnesses, nodeId);
            enrichState = state1.authorizeFetch(nodeId, nodeFetch, nodeFetch.stakeholders(), authorization);
        } else if (genNode instanceof Node.NodeExercises) {
            Node.NodeExercises nodeExercises = (Node.NodeExercises)genNode;
            Ledger.EnrichState state0 = state.authorizeExercise(nodeId, nodeExercises, nodeExercises.actingParties(), authorization, nodeExercises.controllers());
            Set witnesses = nodeExercises.consuming() ? (Set)nodeExercises.stakeholders().union(parentExerciseWitnesses) : (Set)nodeExercises.actingParties().union(nodeExercises.signatories()).union(parentExerciseWitnesses);
            Ledger.EnrichState state1 = state0.discloseTo(witnesses, nodeId);
            Ledger.EnrichState state2 = state1.divulgeCoidTo((Set)parentExerciseWitnesses.$minus$minus(nodeExercises.stakeholders()), (Value.ContractId)nodeExercises.targetCoid());
            enrichState = nodeExercises.children().foldLeft(state2, (Function2<Ledger.EnrichState, Value.NodeId, Ledger.EnrichState> & Serializable & scala.Serializable)(s2, childNodeId) -> Ledger$.enrichNode$1(s2, witnesses, authorization.map((Function1<Set<String>, Set<String>>)(Function1<Set, Set> & Serializable & scala.Serializable)x$10 -> (Set)nodeExercises.controllers().union(nodeExercises.signatories())), childNodeId, tr$1));
        } else if (genNode instanceof Node.NodeLookupByKey) {
            Node.NodeLookupByKey nodeLookupByKey = (Node.NodeLookupByKey)genNode;
            enrichState = state.authorizeLookupByKey(nodeId, nodeLookupByKey, authorization).discloseTo(parentExerciseWitnesses, nodeId);
        } else {
            throw new MatchError(genNode);
        }
        return enrichState;
    }

    public static final /* synthetic */ void $anonfun$collectCoids$1(Ledger$ $this, Builder coids$1, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Value v = (Value)tuple2._2();
        $this.collect$1(v, coids$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$collectCoids$2(Ledger$ $this, Builder coids$1, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Value v = (Value)tuple2._2();
        $this.collect$1(v, coids$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$collectCoids$6(Ledger$ $this, Builder coids$1, Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Value k = (Value)tuple2._1();
        Value v = (Value)tuple2._2();
        $this.collect$1(k, coids$1);
        $this.collect$1(v, coids$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void collect$1(Value v2, Builder coids$1) {
        block17: {
            Value value;
            while (true) {
                Value arg;
                if ((value = v2) instanceof Value.ValueRecord) {
                    Value.ValueRecord valueRecord = (Value.ValueRecord)value;
                    ImmArray fs = valueRecord.fields();
                    fs.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$5 -> {
                        Ledger$.$anonfun$collectCoids$1(this, coids$1, x0$5);
                        return BoxedUnit.UNIT;
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block17;
                }
                if (value instanceof Value.ValueStruct) {
                    Value.ValueStruct valueStruct = (Value.ValueStruct)value;
                    ImmArray fs = valueStruct.fields();
                    fs.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$6 -> {
                        Ledger$.$anonfun$collectCoids$2(this, coids$1, x0$6);
                        return BoxedUnit.UNIT;
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block17;
                }
                if (!(value instanceof Value.ValueVariant)) break;
                Value.ValueVariant valueVariant = (Value.ValueVariant)value;
                v2 = arg = valueVariant.value();
            }
            if (value instanceof Value.ValueEnum) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (value instanceof Value.ValueList) {
                Value.ValueList valueList = (Value.ValueList)value;
                FrontStack vs = valueList.values();
                vs.foreach((Function1<Value, Object> & Serializable & scala.Serializable)v -> {
                    this.collect$1(v, coids$1);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (value instanceof Value.ValueContractId) {
                Value.ValueContractId valueContractId = (Value.ValueContractId)value;
                Value.ContractId coid = (Value.ContractId)valueContractId.value();
                coids$1.$plus$eq(coid);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (value instanceof Value.ValueCidlessLeaf) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (value instanceof Value.ValueOptional) {
                Value.ValueOptional valueOptional = (Value.ValueOptional)value;
                Option mbV = valueOptional.value();
                mbV.foreach((Function1<Value, Object> & Serializable & scala.Serializable)v -> {
                    this.collect$1(v, coids$1);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (value instanceof Value.ValueTextMap) {
                Value.ValueTextMap valueTextMap = (Value.ValueTextMap)value;
                SortedLookupList map2 = valueTextMap.value();
                map2.values().foreach((Function1<Value, Object> & Serializable & scala.Serializable)v -> {
                    this.collect$1(v, coids$1);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (value instanceof Value.ValueGenMap) {
                Value.ValueGenMap valueGenMap = (Value.ValueGenMap)value;
                ImmArray entries = valueGenMap.entries();
                entries.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$7 -> {
                    Ledger$.$anonfun$collectCoids$6(this, coids$1, x0$7);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(value);
            }
        }
    }

    private final Value rewrite$1(Value v2, String commitPrefix$3) {
        Value value;
        Value value2 = v2;
        if (value2 instanceof Value.ValueRecord) {
            Value.ValueRecord valueRecord = (Value.ValueRecord)value2;
            Option<Ref.Identifier> tycon = valueRecord.tycon();
            ImmArray fs = valueRecord.fields();
            value = new Value.ValueRecord(tycon, fs.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$8 -> {
                Tuple2 tuple2 = x0$8;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Option k = (Option)tuple2._1();
                Value v = (Value)tuple2._2();
                Tuple2<Option, Value> tuple22 = new Tuple2<Option, Value>(k, this.rewrite$1(v, commitPrefix$3));
                return tuple22;
            }));
        } else if (value2 instanceof Value.ValueStruct) {
            Value.ValueStruct valueStruct = (Value.ValueStruct)value2;
            ImmArray fs = valueStruct.fields();
            value = new Value.ValueStruct(fs.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$9 -> {
                Tuple2 tuple2 = x0$9;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String k = (String)tuple2._1();
                Value v = (Value)tuple2._2();
                Tuple2<String, Value> tuple22 = new Tuple2<String, Value>(k, this.rewrite$1(v, commitPrefix$3));
                return tuple22;
            }));
        } else if (value2 instanceof Value.ValueVariant) {
            Value.ValueVariant valueVariant = (Value.ValueVariant)value2;
            Option<Ref.Identifier> tycon = valueVariant.tycon();
            String variant = valueVariant.variant();
            Value value3 = valueVariant.value();
            value = new Value.ValueVariant(tycon, variant, this.rewrite$1(value3, commitPrefix$3));
        } else if (value2 instanceof Value.ValueList) {
            Value.ValueList valueList = (Value.ValueList)value2;
            FrontStack vs = valueList.values();
            value = new Value.ValueList(vs.map((Function1<Value, Value> & Serializable & scala.Serializable)v -> this.rewrite$1((Value)v, commitPrefix$3)));
        } else if (value2 instanceof Value.ValueContractId) {
            Value.ValueContractId valueContractId = (Value.ValueContractId)value2;
            Value.ContractId coid = (Value.ContractId)valueContractId.value();
            Value.AbsoluteContractId acoid = this.contractIdToAbsoluteContractId(commitPrefix$3, coid);
            value = new Value.ValueContractId<Value.AbsoluteContractId>(acoid);
        } else if (value2 instanceof Value.ValueCidlessLeaf) {
            Value.ValueCidlessLeaf valueCidlessLeaf = (Value.ValueCidlessLeaf)value2;
            value = valueCidlessLeaf;
        } else if (value2 instanceof Value.ValueOptional) {
            Value.ValueOptional valueOptional = (Value.ValueOptional)value2;
            Option mbV = valueOptional.value();
            value = new Value.ValueOptional(mbV.map((Function1<Value, Value> & Serializable & scala.Serializable)v -> this.rewrite$1((Value)v, commitPrefix$3)));
        } else if (value2 instanceof Value.ValueTextMap) {
            Value.ValueTextMap valueTextMap = (Value.ValueTextMap)value2;
            SortedLookupList map2 = valueTextMap.value();
            value = new Value.ValueTextMap(map2.mapValue((Function1<Value, Value> & Serializable & scala.Serializable)v -> this.rewrite$1((Value)v, commitPrefix$3)));
        } else if (value2 instanceof Value.ValueGenMap) {
            Value.ValueGenMap valueGenMap = (Value.ValueGenMap)value2;
            ImmArray entries = valueGenMap.entries();
            value = new Value.ValueGenMap(entries.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$10 -> {
                Tuple2 tuple2 = x0$10;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Value k = (Value)tuple2._1();
                Value v = (Value)tuple2._2();
                Tuple2<Value, Value> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.rewrite$1(k, commitPrefix$3)), this.rewrite$1(v, commitPrefix$3));
                return tuple22;
            }));
        } else {
            throw new MatchError(value2);
        }
        return value;
    }

    private final Either processNodes$1(Either mbCache0, List enps, Ledger.ScenarioTransactionId trId$1, Ledger.RichTransaction richTr$1) {
        Either either2;
        block23: {
            Right right;
            block24: {
                Ledger.LedgerData cache0;
                block25: {
                    List list2;
                    block26: {
                        Option option2;
                        block27: {
                            Node.GenNode genNode;
                            block28: {
                                Option option3;
                                while (true) {
                                    if ((right = mbCache0) instanceof Left) {
                                        Left left = (Left)((Object)right);
                                        Ledger.UniqueKeyViolation err = (Ledger.UniqueKeyViolation)left.value();
                                        either2 = package$.MODULE$.Left().apply(err);
                                        break block23;
                                    }
                                    if (!(right instanceof Right)) break block24;
                                    Right right2 = right;
                                    cache0 = (Ledger.LedgerData)right2.value();
                                    boolean bl = false;
                                    $colon$colon $colon$colon = null;
                                    list2 = enps;
                                    if (((Object)Nil$.MODULE$).equals(list2)) break block25;
                                    if (list2 instanceof $colon$colon) {
                                        List list3;
                                        bl = true;
                                        $colon$colon = ($colon$colon)list2;
                                        Tuple2 tuple2 = (Tuple2)$colon$colon.head();
                                        List restENPs = $colon$colon.tl$access$1();
                                        if (tuple2 != null && ((Object)Nil$.MODULE$).equals(list3 = (List)tuple2._2())) {
                                            enps = restENPs;
                                            mbCache0 = package$.MODULE$.Right().apply(cache0);
                                            continue;
                                        }
                                    }
                                    if (!bl) break block26;
                                    Tuple2 tuple2 = (Tuple2)$colon$colon.head();
                                    List restENPs = $colon$colon.tl$access$1();
                                    if (tuple2 == null) break block26;
                                    Option mbParentId = (Option)tuple2._1();
                                    List list4 = (List)tuple2._2();
                                    if (!(list4 instanceof $colon$colon)) break block26;
                                    $colon$colon $colon$colon2 = ($colon$colon)list4;
                                    String nodeId = (String)$colon$colon2.head();
                                    List restOfNodeIds = $colon$colon2.tl$access$1();
                                    option2 = richTr$1.nodes().get(nodeId);
                                    if (None$.MODULE$.equals(option2)) {
                                        throw this.crash(new StringBuilder(41).append("processTransaction: non-existent node '").append(nodeId).append("'.").toString());
                                    }
                                    if (!(option2 instanceof Some)) break block27;
                                    Some some = (Some)option2;
                                    Node.GenNode node = (Node.GenNode)some.value();
                                    Ledger.NodeInfo newNodeInfo = new Ledger.NodeInfo(node, trId$1, richTr$1.effectiveAt(), (Map<String, Ledger.ScenarioTransactionId>)Predef$.MODULE$.Map().empty(), (Set<String>)Predef$.MODULE$.Set().empty(), None$.MODULE$, mbParentId);
                                    Map<String, Ledger.NodeInfo> x$80 = cache0.nodeInfos().$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(nodeId), newNodeInfo));
                                    Set<Value.AbsoluteContractId> x$81 = cache0.copy$default$1();
                                    Map<Node.GlobalKey, Value.AbsoluteContractId> x$82 = cache0.copy$default$3();
                                    Map<Value.AbsoluteContractId, String> x$83 = cache0.copy$default$4();
                                    Ledger.LedgerData newCache = cache0.copy(x$81, x$80, x$82, x$83);
                                    Tuple2 tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(mbParentId), restOfNodeIds);
                                    List idsToProcess = restENPs.$colon$colon(tuple22);
                                    genNode = node;
                                    if (genNode instanceof Node.NodeCreate) {
                                        Right right3;
                                        Node.NodeCreate nodeCreate = (Node.NodeCreate)genNode;
                                        Ledger.LedgerData newCache1 = newCache.markAsActive((Value.AbsoluteContractId)nodeCreate.coid()).createdIn((Value.AbsoluteContractId)nodeCreate.coid(), nodeId);
                                        Option option4 = nodeCreate.key();
                                        if (None$.MODULE$.equals(option4)) {
                                            right3 = package$.MODULE$.Right().apply(newCache1);
                                        } else if (option4 instanceof Some) {
                                            Either either3;
                                            Some some2 = (Some)option4;
                                            Node.KeyWithMaintainers keyWithMaintainers = (Node.KeyWithMaintainers)some2.value();
                                            Node.GlobalKey gk = new Node.GlobalKey(nodeCreate.coinst().template(), (Value.VersionedValue)keyWithMaintainers.key());
                                            Option option5 = newCache1.activeKeys().get(gk);
                                            if (None$.MODULE$.equals(option5)) {
                                                either3 = package$.MODULE$.Right().apply(newCache1.addKey(gk, (Value.AbsoluteContractId)nodeCreate.coid()));
                                            } else if (option5 instanceof Some) {
                                                either3 = package$.MODULE$.Left().apply(new Ledger.UniqueKeyViolation(gk));
                                            } else {
                                                throw new MatchError(option5);
                                            }
                                            right3 = either3;
                                        } else {
                                            throw new MatchError(option4);
                                        }
                                        Right mbNewCache2 = right3;
                                        enps = idsToProcess;
                                        mbCache0 = mbNewCache2;
                                        continue;
                                    }
                                    if (genNode instanceof Node.NodeFetch) {
                                        Node.NodeFetch nodeFetch = (Node.NodeFetch)genNode;
                                        Value.AbsoluteContractId referencedCoid = (Value.AbsoluteContractId)nodeFetch.coid();
                                        Ledger.LedgerData newCacheP = newCache.updateNodeInfo(referencedCoid, (Function1<Ledger.NodeInfo, Ledger.NodeInfo> & Serializable & scala.Serializable)info -> {
                                            Set x$84 = (Set)info.referencedBy().$plus(nodeId);
                                            Node.GenNode<String, Value.AbsoluteContractId, Value.VersionedValue<Value.AbsoluteContractId>> x$85 = info.copy$default$1();
                                            Ledger.ScenarioTransactionId x$86 = info.copy$default$2();
                                            Time.Timestamp x$87 = info.copy$default$3();
                                            Map<String, Ledger.ScenarioTransactionId> x$88 = info.copy$default$4();
                                            Option<String> x$89 = info.copy$default$6();
                                            Option<String> x$90 = info.copy$default$7();
                                            return info.copy(x$85, x$86, x$87, x$88, x$84, x$89, x$90);
                                        });
                                        enps = idsToProcess;
                                        mbCache0 = package$.MODULE$.Right().apply(newCacheP);
                                        continue;
                                    }
                                    if (genNode instanceof Node.NodeExercises) {
                                        Ledger.LedgerData ledgerData;
                                        Node.NodeExercises nodeExercises = (Node.NodeExercises)genNode;
                                        Ledger.LedgerData newCache0 = newCache.updateNodeInfo((Value.AbsoluteContractId)nodeExercises.targetCoid(), (Function1<Ledger.NodeInfo, Ledger.NodeInfo> & Serializable & scala.Serializable)info -> {
                                            Set x$91 = (Set)info.referencedBy().$plus(nodeId);
                                            Option x$92 = nodeExercises.consuming() ? new Some<String>(nodeId) : info.consumedBy();
                                            Node.GenNode<String, Value.AbsoluteContractId, Value.VersionedValue<Value.AbsoluteContractId>> x$93 = info.copy$default$1();
                                            Ledger.ScenarioTransactionId x$94 = info.copy$default$2();
                                            Time.Timestamp x$95 = info.copy$default$3();
                                            Map<String, Ledger.ScenarioTransactionId> x$96 = info.copy$default$4();
                                            Option<String> x$97 = info.copy$default$7();
                                            return info.copy(x$93, x$94, x$95, x$96, x$91, x$92, x$97);
                                        });
                                        if (nodeExercises.consuming()) {
                                            Ledger.LedgerData ledgerData2;
                                            Ledger.LedgerData newCache0_1 = newCache0.markAsInactive((Value.AbsoluteContractId)nodeExercises.targetCoid());
                                            Node.NodeCreate nc = (Node.NodeCreate)newCache0_1.nodeInfoByCoid((Value.AbsoluteContractId)nodeExercises.targetCoid()).node();
                                            Option option6 = nc.key();
                                            if (None$.MODULE$.equals(option6)) {
                                                ledgerData2 = newCache0_1;
                                            } else if (option6 instanceof Some) {
                                                Some some3 = (Some)option6;
                                                Node.KeyWithMaintainers key = (Node.KeyWithMaintainers)some3.value();
                                                ledgerData2 = newCache0_1.removeKey(new Node.GlobalKey(nodeExercises.templateId(), (Value.VersionedValue)key.key()));
                                            } else {
                                                throw new MatchError(option6);
                                            }
                                            ledgerData = ledgerData2;
                                        } else {
                                            ledgerData = newCache0;
                                        }
                                        Ledger.LedgerData newCache1 = ledgerData;
                                        Tuple2 tuple23 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new Some<String>(nodeId)), nodeExercises.children().toList());
                                        enps = idsToProcess.$colon$colon(tuple23);
                                        mbCache0 = package$.MODULE$.Right().apply(newCache1);
                                        continue;
                                    }
                                    if (!(genNode instanceof Node.NodeLookupByKey)) break block28;
                                    Node.NodeLookupByKey nodeLookupByKey = (Node.NodeLookupByKey)genNode;
                                    option3 = nodeLookupByKey.result();
                                    if (None$.MODULE$.equals(option3)) {
                                        enps = idsToProcess;
                                        mbCache0 = package$.MODULE$.Right().apply(newCache);
                                        continue;
                                    }
                                    if (!(option3 instanceof Some)) break;
                                    Some some4 = (Some)option3;
                                    Value.AbsoluteContractId referencedCoid = (Value.AbsoluteContractId)some4.value();
                                    Ledger.LedgerData newCacheP = newCache.updateNodeInfo(referencedCoid, (Function1<Ledger.NodeInfo, Ledger.NodeInfo> & Serializable & scala.Serializable)info -> {
                                        Set x$98 = (Set)info.referencedBy().$plus(nodeId);
                                        Node.GenNode<String, Value.AbsoluteContractId, Value.VersionedValue<Value.AbsoluteContractId>> x$99 = info.copy$default$1();
                                        Ledger.ScenarioTransactionId x$100 = info.copy$default$2();
                                        Time.Timestamp x$101 = info.copy$default$3();
                                        Map<String, Ledger.ScenarioTransactionId> x$102 = info.copy$default$4();
                                        Option<String> x$103 = info.copy$default$6();
                                        Option<String> x$104 = info.copy$default$7();
                                        return info.copy(x$99, x$100, x$101, x$102, x$98, x$103, x$104);
                                    });
                                    enps = idsToProcess;
                                    mbCache0 = package$.MODULE$.Right().apply(newCacheP);
                                }
                                throw new MatchError(option3);
                            }
                            throw new MatchError(genNode);
                        }
                        throw new MatchError(option2);
                    }
                    throw new MatchError(list2);
                }
                Right right4 = package$.MODULE$.Right().apply(cache0);
                either2 = right4;
                break block23;
            }
            throw new MatchError(right);
        }
        return either2;
    }

    private Ledger$() {
        MODULE$ = this;
        this.com$digitalasset$daml$lf$types$Ledger$$$colon = Ref$.MODULE$.LedgerString().assertFromString(":");
    }
}

