/*
 * Decompiled with CFR 0.152.
 */
package com.digitalasset.daml.lf.validation;

import com.digitalasset.daml.lf.data.ImmArray;
import com.digitalasset.daml.lf.data.Ref;
import com.digitalasset.daml.lf.data.Ref$;
import com.digitalasset.daml.lf.language.Ast;
import com.digitalasset.daml.lf.language.Ast$TStruct$;
import com.digitalasset.daml.lf.validation.Util$;
import com.digitalasset.daml.lf.validation.Util$TupleImmArrayOps$;
import com.digitalasset.daml.lf.validation.traversable.TypeTraversable$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream$;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class TypeSubst$ {
    public static TypeSubst$ MODULE$;

    static {
        new TypeSubst$();
    }

    public Ast.Type substitute(Map<String, Ast.Type> subst, Ast.Type typ) {
        return this.go(this.freeVars(subst), subst, typ);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Ast.Type go(Set<String> fv0, Map<String, Ast.Type> subst0, Ast.Type typ0) {
        Ast.Type type = typ0;
        if (type instanceof Ast.TVar) {
            Ast.TVar tVar = (Ast.TVar)type;
            String name = tVar.name();
            return (Ast.Type)subst0.getOrElse(name, (Function0<Ast.Type> & Serializable & scala.Serializable)() -> typ0);
        }
        boolean bl = type instanceof Ast.TTyCon ? true : (type instanceof Ast.TBuiltin ? true : type instanceof Ast.TNat);
        if (bl) {
            return typ0;
        }
        if (type instanceof Ast.TApp) {
            Ast.TApp tApp = (Ast.TApp)type;
            Ast.Type t1 = tApp.tyfun();
            Ast.Type t2 = tApp.arg();
            return new Ast.TApp(this.go(fv0, subst0, t1), this.go(fv0, subst0, t2));
        }
        if (type instanceof Ast.TForall) {
            Ast.TForall tForall = (Ast.TForall)type;
            Tuple2<String, Ast.Kind> tuple2 = tForall.binder();
            Ast.Type t = tForall.body();
            if (tuple2 != null) {
                Ast.TForall tForall2;
                String v0 = tuple2._1();
                Ast.Kind k = tuple2._2();
                if (fv0.contains(v0)) {
                    String v1 = this.freshTypeVarName(fv0);
                    Set fv1 = (Set)fv0.$plus(v1);
                    Map<String, Ast.Type> subst1 = subst0.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(v0), new Ast.TVar(v1)));
                    tForall2 = new Ast.TForall(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(v1), k), this.go(fv1, subst1, t));
                    return tForall2;
                } else {
                    tForall2 = new Ast.TForall(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(v0), k), this.go((Set)fv0.$plus(v0), (Map)subst0.$minus(v0), t));
                }
                return tForall2;
            }
        }
        if (!(type instanceof Ast.TStruct)) throw new MatchError(type);
        Ast.TStruct tStruct = (Ast.TStruct)type;
        ImmArray ts = tStruct.sortedFields();
        return Ast$TStruct$.MODULE$.apply(Util$TupleImmArrayOps$.MODULE$.transform$extension(Util$.MODULE$.TupleImmArrayOps(ts), (Function2<String, Ast.Type, Ast.Type> & Serializable & scala.Serializable)(x$1, x) -> MODULE$.go(fv0, subst0, (Ast.Type)x)));
    }

    private String freshTypeVarName(Set<String> fv) {
        return (String)((LinearSeqOptimized)((TraversableLike)package$.MODULE$.Stream().from(0).map((Function1<Object, String> & Serializable & scala.Serializable)i -> TypeSubst$.$anonfun$freshTypeVarName$1(BoxesRunTime.unboxToInt(i)), Stream$.MODULE$.canBuildFrom())).filterNot((Function1<String, Object> & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean(fv.contains(elem)))).apply(0);
    }

    public Ast.DataCons substitute(Map<String, Ast.Type> subst, Ast.DataCons dataCons) {
        Ast.DataCons dataCons2;
        Ast.DataCons dataCons3 = dataCons;
        if (dataCons3 instanceof Ast.DataRecord) {
            Ast.DataRecord dataRecord = (Ast.DataRecord)dataCons3;
            ImmArray fields = dataRecord.fields();
            dataCons2 = new Ast.DataRecord(Util$TupleImmArrayOps$.MODULE$.transform$extension(Util$.MODULE$.TupleImmArrayOps(fields), (Function2<String, Ast.Type, Ast.Type> & Serializable & scala.Serializable)(x$2, x) -> MODULE$.substitute(subst, (Ast.Type)x)), None$.MODULE$);
        } else if (dataCons3 instanceof Ast.DataVariant) {
            Ast.DataVariant dataVariant = (Ast.DataVariant)dataCons3;
            ImmArray variants = dataVariant.variants();
            dataCons2 = new Ast.DataVariant(Util$TupleImmArrayOps$.MODULE$.transform$extension(Util$.MODULE$.TupleImmArrayOps(variants), (Function2<String, Ast.Type, Ast.Type> & Serializable & scala.Serializable)(x$3, x) -> MODULE$.substitute(subst, (Ast.Type)x)));
        } else if (dataCons3 instanceof Ast.DataEnum) {
            Ast.DataEnum dataEnum;
            dataCons2 = dataEnum = (Ast.DataEnum)dataCons3;
        } else {
            throw new MatchError(dataCons3);
        }
        return dataCons2;
    }

    public Ast.TypeConApp substitute(Map<String, Ast.Type> subst, Ast.TypeConApp app) {
        Ast.TypeConApp typeConApp = app;
        if (typeConApp == null) {
            throw new MatchError(typeConApp);
        }
        Ref.Identifier tycon = typeConApp.tycon();
        ImmArray<Ast.Type> args = typeConApp.args();
        Set<String> fv = this.freeVars(subst);
        Ast.TypeConApp typeConApp2 = new Ast.TypeConApp(tycon, args.map((Function1<Ast.Type, Ast.Type> & Serializable & scala.Serializable)x$4 -> MODULE$.go(fv, subst, (Ast.Type)x$4)));
        return typeConApp2;
    }

    public Set<String> freeVars(Ast.Type typ) {
        return this.freeVars((Set<String>)Predef$.MODULE$.Set().empty(), typ);
    }

    private Set<String> freeVars(Set<String> acc2, Ast.Type typ2) {
        Set<String> set2;
        Ast.Type type = typ2;
        if (type instanceof Ast.TVar) {
            Ast.TVar tVar = (Ast.TVar)type;
            String name = tVar.name();
            set2 = (Set<String>)acc2.$plus(name);
        } else {
            Set<String> set3 = acc2;
            set2 = TypeTraversable$.MODULE$.apply(typ2).$div$colon(set3, (Function2<Set, Ast.Type, Set> & Serializable & scala.Serializable)(acc, typ) -> MODULE$.freeVars((Set<String>)acc, (Ast.Type)typ));
        }
        return set2;
    }

    private Set<String> freeVars(Map<String, Ast.Type> subst) {
        return (Set)subst.values().foldLeft(Predef$.MODULE$.Set().empty(), (Function2<Set, Ast.Type, Set> & Serializable & scala.Serializable)(acc, typ) -> MODULE$.freeVars((Set<String>)acc, (Ast.Type)typ));
    }

    public static final /* synthetic */ String $anonfun$freshTypeVarName$1(int i) {
        return Ref$.MODULE$.Name().assertFromString(new StringBuilder(9).append("$freshVar").append(((Object)BoxesRunTime.boxToInteger(i)).toString()).toString());
    }

    private TypeSubst$() {
        MODULE$ = this;
    }
}

