/*
 * Decompiled with CFR 0.152.
 */
package com.digitalasset.daml.lf.validation.traversable;

import com.digitalasset.daml.lf.data.ImmArray;
import com.digitalasset.daml.lf.language.Ast;
import com.digitalasset.daml.lf.language.Ast$ScenarioGetTime$;
import com.digitalasset.daml.lf.language.Ast$UpdateGetTime$;
import com.digitalasset.daml.lf.validation.Util$;
import com.digitalasset.daml.lf.validation.Util$TupleImmArrayOps$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Parallel;
import scala.collection.Parallelizable;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.TraversableView;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.FilterMonadic;
import scala.collection.generic.GenericCompanion;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.Combiner;
import scala.collection.parallel.ParIterable;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

public final class ExprTraversable$ {
    public static ExprTraversable$ MODULE$;

    static {
        new ExprTraversable$();
    }

    public <U> void foreach(Ast.Expr x, Function1<Ast.Expr, U> f) {
        BoxedUnit boxedUnit;
        Ast.Expr expr = x;
        boolean bl = expr instanceof Ast.EVar ? true : (expr instanceof Ast.EBuiltin ? true : (expr instanceof Ast.EPrimCon ? true : (expr instanceof Ast.EPrimLit ? true : (expr instanceof Ast.EVal ? true : (expr instanceof Ast.EContractId ? true : (expr instanceof Ast.EEnumCon ? true : expr instanceof Ast.ETypeRep))))));
        if (bl) {
            boxedUnit = BoxedUnit.UNIT;
        } else if (expr instanceof Ast.ELocation) {
            Ast.ELocation eLocation = (Ast.ELocation)expr;
            Ast.Expr expr2 = eLocation.expr();
            boxedUnit = f.apply(expr2);
        } else if (expr instanceof Ast.ERecCon) {
            Ast.ERecCon eRecCon = (Ast.ERecCon)expr;
            ImmArray fields = eRecCon.fields();
            Util$TupleImmArrayOps$.MODULE$.values$extension(Util$.MODULE$.TupleImmArrayOps(fields)).foreach(f);
            boxedUnit = BoxedUnit.UNIT;
        } else if (expr instanceof Ast.ERecProj) {
            Ast.ERecProj eRecProj = (Ast.ERecProj)expr;
            Ast.Expr record2 = eRecProj.record();
            boxedUnit = f.apply(record2);
        } else if (expr instanceof Ast.ERecUpd) {
            Ast.ERecUpd eRecUpd = (Ast.ERecUpd)expr;
            Ast.Expr record3 = eRecUpd.record();
            Ast.Expr update = eRecUpd.update();
            f.apply(record3);
            boxedUnit = f.apply(update);
        } else if (expr instanceof Ast.EVariantCon) {
            Ast.EVariantCon eVariantCon = (Ast.EVariantCon)expr;
            Ast.Expr arg = eVariantCon.arg();
            boxedUnit = f.apply(arg);
        } else if (expr instanceof Ast.EStructCon) {
            Ast.EStructCon eStructCon = (Ast.EStructCon)expr;
            ImmArray fields = eStructCon.fields();
            Util$TupleImmArrayOps$.MODULE$.values$extension(Util$.MODULE$.TupleImmArrayOps(fields)).foreach(f);
            boxedUnit = BoxedUnit.UNIT;
        } else if (expr instanceof Ast.EStructProj) {
            Ast.EStructProj eStructProj = (Ast.EStructProj)expr;
            Ast.Expr struct = eStructProj.struct();
            boxedUnit = f.apply(struct);
        } else if (expr instanceof Ast.EStructUpd) {
            Ast.EStructUpd eStructUpd = (Ast.EStructUpd)expr;
            Ast.Expr struct = eStructUpd.struct();
            Ast.Expr update = eStructUpd.update();
            f.apply(struct);
            boxedUnit = f.apply(update);
        } else if (expr instanceof Ast.EApp) {
            Ast.EApp eApp = (Ast.EApp)expr;
            Ast.Expr fun = eApp.fun();
            Ast.Expr arg = eApp.arg();
            f.apply(fun);
            boxedUnit = f.apply(arg);
        } else if (expr instanceof Ast.ETyApp) {
            Ast.ETyApp eTyApp = (Ast.ETyApp)expr;
            Ast.Expr expr3 = eTyApp.expr();
            boxedUnit = f.apply(expr3);
        } else if (expr instanceof Ast.EAbs) {
            Ast.EAbs eAbs = (Ast.EAbs)expr;
            Ast.Expr body = eAbs.body();
            boxedUnit = f.apply(body);
        } else if (expr instanceof Ast.ETyAbs) {
            Ast.ETyAbs eTyAbs = (Ast.ETyAbs)expr;
            Ast.Expr body = eTyAbs.body();
            boxedUnit = f.apply(body);
        } else if (expr instanceof Ast.ECase) {
            Ast.ECase eCase = (Ast.ECase)expr;
            Ast.Expr scrut = eCase.scrut();
            ImmArray<Ast.CaseAlt> alts = eCase.alts();
            f.apply(scrut);
            alts.iterator().foreach((Function1<Ast.CaseAlt, Object> & Serializable & scala.Serializable)a -> f.apply(a.expr()));
            boxedUnit = BoxedUnit.UNIT;
        } else if (expr instanceof Ast.ELet) {
            Ast.ELet eLet = (Ast.ELet)expr;
            Ast.Binding binding = eLet.binding();
            Ast.Expr body = eLet.body();
            f.apply(binding.bound());
            boxedUnit = f.apply(body);
        } else if (expr instanceof Ast.ENil) {
            boxedUnit = BoxedUnit.UNIT;
        } else if (expr instanceof Ast.ECons) {
            Ast.ECons eCons = (Ast.ECons)expr;
            ImmArray<Ast.Expr> front = eCons.front();
            Ast.Expr tail = eCons.tail();
            front.iterator().foreach(f);
            boxedUnit = f.apply(tail);
        } else if (expr instanceof Ast.EUpdate) {
            Ast.EUpdate eUpdate = (Ast.EUpdate)expr;
            Ast.Update update = eUpdate.update();
            this.foreach(update, f);
            boxedUnit = BoxedUnit.UNIT;
        } else if (expr instanceof Ast.EScenario) {
            Ast.EScenario eScenario = (Ast.EScenario)expr;
            Ast.Scenario scenario = eScenario.scenario();
            this.foreach(scenario, f);
            boxedUnit = BoxedUnit.UNIT;
        } else if (expr instanceof Ast.ENone) {
            boxedUnit = BoxedUnit.UNIT;
        } else if (expr instanceof Ast.ESome) {
            Ast.ESome eSome = (Ast.ESome)expr;
            Ast.Expr body = eSome.body();
            boxedUnit = f.apply(body);
        } else if (expr instanceof Ast.EToAny) {
            Ast.EToAny eToAny = (Ast.EToAny)expr;
            Ast.Expr body = eToAny.body();
            boxedUnit = f.apply(body);
        } else if (expr instanceof Ast.EFromAny) {
            Ast.EFromAny eFromAny = (Ast.EFromAny)expr;
            Ast.Expr body = eFromAny.body();
            boxedUnit = f.apply(body);
        } else {
            throw new MatchError(expr);
        }
    }

    public <U> void foreach(Ast.Update x, Function1<Ast.Expr, U> f) {
        Object object;
        Ast.Update update = x;
        if (update instanceof Ast.UpdatePure) {
            Ast.UpdatePure updatePure = (Ast.UpdatePure)update;
            Ast.Expr expr = updatePure.expr();
            object = f.apply(expr);
        } else if (update instanceof Ast.UpdateBlock) {
            Ast.UpdateBlock updateBlock = (Ast.UpdateBlock)update;
            ImmArray<Ast.Binding> bindings = updateBlock.bindings();
            Ast.Expr body = updateBlock.body();
            bindings.iterator().foreach((Function1<Ast.Binding, Object> & Serializable & scala.Serializable)b -> f.apply(b.bound()));
            object = f.apply(body);
        } else if (update instanceof Ast.UpdateCreate) {
            Ast.UpdateCreate updateCreate = (Ast.UpdateCreate)update;
            Ast.Expr arg = updateCreate.arg();
            object = f.apply(arg);
        } else if (update instanceof Ast.UpdateFetch) {
            Ast.UpdateFetch updateFetch = (Ast.UpdateFetch)update;
            Ast.Expr contractId = updateFetch.contractId();
            object = f.apply(contractId);
        } else if (update instanceof Ast.UpdateExercise) {
            Ast.UpdateExercise updateExercise = (Ast.UpdateExercise)update;
            Ast.Expr cid = updateExercise.cidE();
            Option<Ast.Expr> actors = updateExercise.actorsE();
            Ast.Expr arg = updateExercise.argE();
            f.apply(cid);
            actors.foreach(f);
            object = f.apply(arg);
        } else if (Ast$UpdateGetTime$.MODULE$.equals(update)) {
            object = BoxedUnit.UNIT;
        } else if (update instanceof Ast.UpdateFetchByKey) {
            Ast.UpdateFetchByKey updateFetchByKey = (Ast.UpdateFetchByKey)update;
            Ast.RetrieveByKey rbk = updateFetchByKey.rbk();
            object = f.apply(rbk.key());
        } else if (update instanceof Ast.UpdateLookupByKey) {
            Ast.UpdateLookupByKey updateLookupByKey = (Ast.UpdateLookupByKey)update;
            Ast.RetrieveByKey rbk = updateLookupByKey.rbk();
            object = f.apply(rbk.key());
        } else if (update instanceof Ast.UpdateEmbedExpr) {
            Ast.UpdateEmbedExpr updateEmbedExpr = (Ast.UpdateEmbedExpr)update;
            Ast.Expr body = updateEmbedExpr.body();
            object = f.apply(body);
        } else {
            throw new MatchError(update);
        }
    }

    public <U> void foreach(Ast.Scenario x, Function1<Ast.Expr, U> f) {
        Object object;
        Ast.Scenario scenario = x;
        if (scenario instanceof Ast.ScenarioPure) {
            Ast.ScenarioPure scenarioPure = (Ast.ScenarioPure)scenario;
            Ast.Expr expr = scenarioPure.expr();
            object = f.apply(expr);
        } else if (scenario instanceof Ast.ScenarioBlock) {
            Ast.ScenarioBlock scenarioBlock = (Ast.ScenarioBlock)scenario;
            ImmArray<Ast.Binding> bindings = scenarioBlock.bindings();
            Ast.Expr body = scenarioBlock.body();
            bindings.iterator().foreach((Function1<Ast.Binding, Object> & Serializable & scala.Serializable)b -> f.apply(b.bound()));
            object = f.apply(body);
        } else if (scenario instanceof Ast.ScenarioCommit) {
            Ast.ScenarioCommit scenarioCommit = (Ast.ScenarioCommit)scenario;
            Ast.Expr party = scenarioCommit.partyE();
            Ast.Expr update = scenarioCommit.updateE();
            f.apply(party);
            object = f.apply(update);
        } else if (scenario instanceof Ast.ScenarioMustFailAt) {
            Ast.ScenarioMustFailAt scenarioMustFailAt = (Ast.ScenarioMustFailAt)scenario;
            Ast.Expr party = scenarioMustFailAt.partyE();
            Ast.Expr update = scenarioMustFailAt.updateE();
            f.apply(party);
            object = f.apply(update);
        } else if (scenario instanceof Ast.ScenarioPass) {
            Ast.ScenarioPass scenarioPass = (Ast.ScenarioPass)scenario;
            Ast.Expr relTime = scenarioPass.relTimeE();
            object = f.apply(relTime);
        } else if (Ast$ScenarioGetTime$.MODULE$.equals(scenario)) {
            object = BoxedUnit.UNIT;
        } else if (scenario instanceof Ast.ScenarioGetParty) {
            Ast.ScenarioGetParty scenarioGetParty = (Ast.ScenarioGetParty)scenario;
            Ast.Expr name = scenarioGetParty.nameE();
            object = f.apply(name);
        } else if (scenario instanceof Ast.ScenarioEmbedExpr) {
            Ast.ScenarioEmbedExpr scenarioEmbedExpr = (Ast.ScenarioEmbedExpr)scenario;
            Ast.Expr body = scenarioEmbedExpr.body();
            object = f.apply(body);
        } else {
            throw new MatchError(scenario);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public <U> void foreach(Ast.Definition x, Function1<Ast.Expr, U> f) {
        Ast.DataCons dataCons;
        Ast.DataCons dataCons2;
        boolean bl = false;
        Ast.DDataType dDataType = null;
        Ast.Definition definition = x;
        if (definition instanceof Ast.DDataType) {
            bl = true;
            dDataType = (Ast.DDataType)definition;
            Ast.DataCons dataCons3 = dDataType.cons();
            if (dataCons3 instanceof Ast.DataRecord) {
                Ast.DataRecord dataRecord = (Ast.DataRecord)dataCons3;
                Option<Ast.Template> template = dataRecord.optTemplate();
                template.foreach((Function1<Ast.Template, Object> & Serializable & scala.Serializable)x$1 -> {
                    ExprTraversable$.MODULE$.foreach(x$1, f);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl && (dataCons2 = dDataType.cons()) instanceof Ast.DataVariant) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (bl && (dataCons = dDataType.cons()) instanceof Ast.DataEnum) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (!(definition instanceof Ast.DValue)) throw new MatchError(definition);
        Ast.DValue dValue = (Ast.DValue)definition;
        Ast.Expr body = dValue.body();
        f.apply(body);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public <U> void foreach(Ast.Template x, Function1<Ast.Expr, U> f) {
        Ast.Template template = x;
        if (template == null) {
            throw new MatchError(template);
        }
        Ast.Expr precond = template.precond();
        Ast.Expr signatories = template.signatories();
        Ast.Expr agreementText = template.agreementText();
        Map<String, Ast.TemplateChoice> choices = template.choices();
        Ast.Expr observers = template.observers();
        Option<Ast.TemplateKey> key = template.key();
        f.apply(precond);
        f.apply(signatories);
        f.apply(agreementText);
        choices.values().foreach((Function1<Ast.TemplateChoice, Object> & Serializable & scala.Serializable)x$2 -> {
            ExprTraversable$.MODULE$.foreach(x$2, f);
            return BoxedUnit.UNIT;
        });
        f.apply(observers);
        key.foreach((Function1<Ast.TemplateKey, Object> & Serializable & scala.Serializable)x$3 -> {
            ExprTraversable$.MODULE$.foreach(x$3, f);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public <U> void foreach(Ast.TemplateChoice x, Function1<Ast.Expr, U> f) {
        Ast.TemplateChoice templateChoice = x;
        if (templateChoice == null) {
            throw new MatchError(templateChoice);
        }
        Ast.Expr controllers = templateChoice.controllers();
        Ast.Expr update = templateChoice.update();
        f.apply(controllers);
        f.apply(update);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public <U> void foreach(Ast.TemplateKey x, Function1<Ast.Expr, U> f) {
        Ast.TemplateKey templateKey = x;
        if (templateKey == null) {
            throw new MatchError(templateKey);
        }
        Ast.Expr body = templateKey.body();
        Ast.Expr maintainers = templateKey.maintainers();
        f.apply(body);
        f.apply(maintainers);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Traversable<Ast.Expr> apply(Ast.Expr expr) {
        return new Traversable<Ast.Expr>(expr){
            private final Ast.Expr expr$1;

            public GenericCompanion<Traversable> companion() {
                return Traversable.companion$(this);
            }

            public Traversable<Ast.Expr> seq() {
                return Traversable.seq$(this);
            }

            public Builder<Ast.Expr, Traversable<Ast.Expr>> newBuilder() {
                return GenericTraversableTemplate.newBuilder$(this);
            }

            public <B> Builder<B, Traversable<B>> genericBuilder() {
                return GenericTraversableTemplate.genericBuilder$(this);
            }

            public <A1, A2> Tuple2<Traversable<A1>, Traversable<A2>> unzip(Function1<Ast.Expr, Tuple2<A1, A2>> asPair) {
                return GenericTraversableTemplate.unzip$(this, asPair);
            }

            public <A1, A2, A3> Tuple3<Traversable<A1>, Traversable<A2>, Traversable<A3>> unzip3(Function1<Ast.Expr, Tuple3<A1, A2, A3>> asTriple) {
                return GenericTraversableTemplate.unzip3$(this, asTriple);
            }

            public GenTraversable flatten(Function1 asTraversable) {
                return GenericTraversableTemplate.flatten$(this, asTraversable);
            }

            public GenTraversable transpose(Function1 asTraversable) {
                return GenericTraversableTemplate.transpose$(this, asTraversable);
            }

            public Object repr() {
                return TraversableLike.repr$(this);
            }

            public final boolean isTraversableAgain() {
                return TraversableLike.isTraversableAgain$(this);
            }

            public Traversable<Ast.Expr> thisCollection() {
                return TraversableLike.thisCollection$(this);
            }

            public Traversable toCollection(Object repr) {
                return TraversableLike.toCollection$(this, repr);
            }

            public Combiner<Ast.Expr, ParIterable<Ast.Expr>> parCombiner() {
                return TraversableLike.parCombiner$(this);
            }

            public boolean isEmpty() {
                return TraversableLike.isEmpty$(this);
            }

            public boolean hasDefiniteSize() {
                return TraversableLike.hasDefiniteSize$(this);
            }

            public <B, That> That $plus$plus(GenTraversableOnce<B> that, CanBuildFrom<Traversable<Ast.Expr>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$(this, that, bf);
            }

            public <B, That> That $plus$plus$colon(TraversableOnce<B> that, CanBuildFrom<Traversable<Ast.Expr>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
            }

            public <B, That> That $plus$plus$colon(Traversable<B> that, CanBuildFrom<Traversable<Ast.Expr>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
            }

            public <B, That> That map(Function1<Ast.Expr, B> f, CanBuildFrom<Traversable<Ast.Expr>, B, That> bf) {
                return (That)TraversableLike.map$(this, f, bf);
            }

            public <B, That> That flatMap(Function1<Ast.Expr, GenTraversableOnce<B>> f, CanBuildFrom<Traversable<Ast.Expr>, B, That> bf) {
                return (That)TraversableLike.flatMap$(this, f, bf);
            }

            public Object filterImpl(Function1 p, boolean isFlipped) {
                return TraversableLike.filterImpl$(this, p, isFlipped);
            }

            public Object filter(Function1 p) {
                return TraversableLike.filter$(this, p);
            }

            public Object filterNot(Function1 p) {
                return TraversableLike.filterNot$(this, p);
            }

            public <B, That> That collect(PartialFunction<Ast.Expr, B> pf, CanBuildFrom<Traversable<Ast.Expr>, B, That> bf) {
                return (That)TraversableLike.collect$(this, pf, bf);
            }

            public Tuple2<Traversable<Ast.Expr>, Traversable<Ast.Expr>> partition(Function1<Ast.Expr, Object> p) {
                return TraversableLike.partition$(this, p);
            }

            public <K> Map<K, Traversable<Ast.Expr>> groupBy(Function1<Ast.Expr, K> f) {
                return TraversableLike.groupBy$(this, f);
            }

            public boolean forall(Function1<Ast.Expr, Object> p) {
                return TraversableLike.forall$(this, p);
            }

            public boolean exists(Function1<Ast.Expr, Object> p) {
                return TraversableLike.exists$(this, p);
            }

            public Option<Ast.Expr> find(Function1<Ast.Expr, Object> p) {
                return TraversableLike.find$(this, p);
            }

            public <B, That> That scan(B z, Function2<B, B, B> op, CanBuildFrom<Traversable<Ast.Expr>, B, That> cbf) {
                return (That)TraversableLike.scan$(this, z, op, cbf);
            }

            public <B, That> That scanLeft(B z, Function2<B, Ast.Expr, B> op, CanBuildFrom<Traversable<Ast.Expr>, B, That> bf) {
                return (That)TraversableLike.scanLeft$(this, z, op, bf);
            }

            public <B, That> That scanRight(B z, Function2<Ast.Expr, B, B> op, CanBuildFrom<Traversable<Ast.Expr>, B, That> bf) {
                return (That)TraversableLike.scanRight$(this, z, op, bf);
            }

            public Object head() {
                return TraversableLike.head$(this);
            }

            public Option<Ast.Expr> headOption() {
                return TraversableLike.headOption$(this);
            }

            public Object tail() {
                return TraversableLike.tail$(this);
            }

            public Object last() {
                return TraversableLike.last$(this);
            }

            public Option<Ast.Expr> lastOption() {
                return TraversableLike.lastOption$(this);
            }

            public Object init() {
                return TraversableLike.init$(this);
            }

            public Object take(int n) {
                return TraversableLike.take$(this, n);
            }

            public Object drop(int n) {
                return TraversableLike.drop$(this, n);
            }

            public Object slice(int from, int until) {
                return TraversableLike.slice$(this, from, until);
            }

            public Object sliceWithKnownDelta(int from, int until, int delta) {
                return TraversableLike.sliceWithKnownDelta$(this, from, until, delta);
            }

            public Object sliceWithKnownBound(int from, int until) {
                return TraversableLike.sliceWithKnownBound$(this, from, until);
            }

            public Object takeWhile(Function1 p) {
                return TraversableLike.takeWhile$(this, p);
            }

            public Object dropWhile(Function1 p) {
                return TraversableLike.dropWhile$(this, p);
            }

            public Tuple2<Traversable<Ast.Expr>, Traversable<Ast.Expr>> span(Function1<Ast.Expr, Object> p) {
                return TraversableLike.span$(this, p);
            }

            public Tuple2<Traversable<Ast.Expr>, Traversable<Ast.Expr>> splitAt(int n) {
                return TraversableLike.splitAt$(this, n);
            }

            public Iterator<Traversable<Ast.Expr>> tails() {
                return TraversableLike.tails$(this);
            }

            public Iterator<Traversable<Ast.Expr>> inits() {
                return TraversableLike.inits$(this);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                TraversableLike.copyToArray$(this, xs, start, len);
            }

            public Traversable<Ast.Expr> toTraversable() {
                return TraversableLike.toTraversable$(this);
            }

            public Iterator<Ast.Expr> toIterator() {
                return TraversableLike.toIterator$(this);
            }

            public Stream<Ast.Expr> toStream() {
                return TraversableLike.toStream$(this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Ast.Expr, Col> cbf) {
                return (Col)TraversableLike.to$(this, cbf);
            }

            public String toString() {
                return TraversableLike.toString$(this);
            }

            public String stringPrefix() {
                return TraversableLike.stringPrefix$(this);
            }

            public TraversableView<Ast.Expr, Traversable<Ast.Expr>> view() {
                return TraversableLike.view$(this);
            }

            public TraversableView<Ast.Expr, Traversable<Ast.Expr>> view(int from, int until) {
                return TraversableLike.view$(this, from, until);
            }

            public FilterMonadic<Ast.Expr, Traversable<Ast.Expr>> withFilter(Function1<Ast.Expr, Object> p) {
                return TraversableLike.withFilter$(this, p);
            }

            public Parallel par() {
                return Parallelizable.par$(this);
            }

            public List<Ast.Expr> reversed() {
                return TraversableOnce.reversed$(this);
            }

            public int size() {
                return TraversableOnce.size$(this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$(this);
            }

            public int count(Function1<Ast.Expr, Object> p) {
                return TraversableOnce.count$(this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Ast.Expr, B> pf) {
                return TraversableOnce.collectFirst$(this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Ast.Expr, B> op) {
                return (B)TraversableOnce.$div$colon$(this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Ast.Expr, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$(this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Ast.Expr, B> op) {
                return (B)TraversableOnce.foldLeft$(this, z, op);
            }

            public <B> B foldRight(B z, Function2<Ast.Expr, B, B> op) {
                return (B)TraversableOnce.foldRight$(this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Ast.Expr, B> op) {
                return (B)TraversableOnce.reduceLeft$(this, op);
            }

            public <B> B reduceRight(Function2<Ast.Expr, B, B> op) {
                return (B)TraversableOnce.reduceRight$(this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Ast.Expr, B> op) {
                return TraversableOnce.reduceLeftOption$(this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Ast.Expr, B, B> op) {
                return TraversableOnce.reduceRightOption$(this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$(this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$(this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$(this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Ast.Expr, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$(this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$(this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$(this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$(this, cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$(this, cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$(this, f, cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$(this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$(this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$(this, xs, start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$(this, xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$(this, evidence$1);
            }

            public List<Ast.Expr> toList() {
                return TraversableOnce.toList$(this);
            }

            public Iterable<Ast.Expr> toIterable() {
                return TraversableOnce.toIterable$(this);
            }

            public Seq<Ast.Expr> toSeq() {
                return TraversableOnce.toSeq$(this);
            }

            public IndexedSeq<Ast.Expr> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$(this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$(this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$(this);
            }

            public Vector<Ast.Expr> toVector() {
                return TraversableOnce.toVector$(this);
            }

            public <T, U> Map<T, U> toMap(Predef$.less.colon.less<Ast.Expr, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$(this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$(this, start, sep, end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$(this, sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$(this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$(this, b, start, sep, end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$(this, b, sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$(this, b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$(this);
            }

            public <U> void foreach(Function1<Ast.Expr, U> f) {
                ExprTraversable$.MODULE$.foreach(this.expr$1, f);
            }
            {
                this.expr$1 = expr$1;
                GenTraversableOnce.$init$(this);
                TraversableOnce.$init$(this);
                Parallelizable.$init$(this);
                TraversableLike.$init$(this);
                GenericTraversableTemplate.$init$(this);
                GenTraversable.$init$(this);
                Traversable.$init$(this);
            }
        };
    }

    public Traversable<Ast.Expr> apply(Ast.Template template) {
        return new Traversable<Ast.Expr>(template){
            private final Ast.Template template$1;

            public GenericCompanion<Traversable> companion() {
                return Traversable.companion$(this);
            }

            public Traversable<Ast.Expr> seq() {
                return Traversable.seq$(this);
            }

            public Builder<Ast.Expr, Traversable<Ast.Expr>> newBuilder() {
                return GenericTraversableTemplate.newBuilder$(this);
            }

            public <B> Builder<B, Traversable<B>> genericBuilder() {
                return GenericTraversableTemplate.genericBuilder$(this);
            }

            public <A1, A2> Tuple2<Traversable<A1>, Traversable<A2>> unzip(Function1<Ast.Expr, Tuple2<A1, A2>> asPair) {
                return GenericTraversableTemplate.unzip$(this, asPair);
            }

            public <A1, A2, A3> Tuple3<Traversable<A1>, Traversable<A2>, Traversable<A3>> unzip3(Function1<Ast.Expr, Tuple3<A1, A2, A3>> asTriple) {
                return GenericTraversableTemplate.unzip3$(this, asTriple);
            }

            public GenTraversable flatten(Function1 asTraversable) {
                return GenericTraversableTemplate.flatten$(this, asTraversable);
            }

            public GenTraversable transpose(Function1 asTraversable) {
                return GenericTraversableTemplate.transpose$(this, asTraversable);
            }

            public Object repr() {
                return TraversableLike.repr$(this);
            }

            public final boolean isTraversableAgain() {
                return TraversableLike.isTraversableAgain$(this);
            }

            public Traversable<Ast.Expr> thisCollection() {
                return TraversableLike.thisCollection$(this);
            }

            public Traversable toCollection(Object repr) {
                return TraversableLike.toCollection$(this, repr);
            }

            public Combiner<Ast.Expr, ParIterable<Ast.Expr>> parCombiner() {
                return TraversableLike.parCombiner$(this);
            }

            public boolean isEmpty() {
                return TraversableLike.isEmpty$(this);
            }

            public boolean hasDefiniteSize() {
                return TraversableLike.hasDefiniteSize$(this);
            }

            public <B, That> That $plus$plus(GenTraversableOnce<B> that, CanBuildFrom<Traversable<Ast.Expr>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$(this, that, bf);
            }

            public <B, That> That $plus$plus$colon(TraversableOnce<B> that, CanBuildFrom<Traversable<Ast.Expr>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
            }

            public <B, That> That $plus$plus$colon(Traversable<B> that, CanBuildFrom<Traversable<Ast.Expr>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
            }

            public <B, That> That map(Function1<Ast.Expr, B> f, CanBuildFrom<Traversable<Ast.Expr>, B, That> bf) {
                return (That)TraversableLike.map$(this, f, bf);
            }

            public <B, That> That flatMap(Function1<Ast.Expr, GenTraversableOnce<B>> f, CanBuildFrom<Traversable<Ast.Expr>, B, That> bf) {
                return (That)TraversableLike.flatMap$(this, f, bf);
            }

            public Object filterImpl(Function1 p, boolean isFlipped) {
                return TraversableLike.filterImpl$(this, p, isFlipped);
            }

            public Object filter(Function1 p) {
                return TraversableLike.filter$(this, p);
            }

            public Object filterNot(Function1 p) {
                return TraversableLike.filterNot$(this, p);
            }

            public <B, That> That collect(PartialFunction<Ast.Expr, B> pf, CanBuildFrom<Traversable<Ast.Expr>, B, That> bf) {
                return (That)TraversableLike.collect$(this, pf, bf);
            }

            public Tuple2<Traversable<Ast.Expr>, Traversable<Ast.Expr>> partition(Function1<Ast.Expr, Object> p) {
                return TraversableLike.partition$(this, p);
            }

            public <K> Map<K, Traversable<Ast.Expr>> groupBy(Function1<Ast.Expr, K> f) {
                return TraversableLike.groupBy$(this, f);
            }

            public boolean forall(Function1<Ast.Expr, Object> p) {
                return TraversableLike.forall$(this, p);
            }

            public boolean exists(Function1<Ast.Expr, Object> p) {
                return TraversableLike.exists$(this, p);
            }

            public Option<Ast.Expr> find(Function1<Ast.Expr, Object> p) {
                return TraversableLike.find$(this, p);
            }

            public <B, That> That scan(B z, Function2<B, B, B> op, CanBuildFrom<Traversable<Ast.Expr>, B, That> cbf) {
                return (That)TraversableLike.scan$(this, z, op, cbf);
            }

            public <B, That> That scanLeft(B z, Function2<B, Ast.Expr, B> op, CanBuildFrom<Traversable<Ast.Expr>, B, That> bf) {
                return (That)TraversableLike.scanLeft$(this, z, op, bf);
            }

            public <B, That> That scanRight(B z, Function2<Ast.Expr, B, B> op, CanBuildFrom<Traversable<Ast.Expr>, B, That> bf) {
                return (That)TraversableLike.scanRight$(this, z, op, bf);
            }

            public Object head() {
                return TraversableLike.head$(this);
            }

            public Option<Ast.Expr> headOption() {
                return TraversableLike.headOption$(this);
            }

            public Object tail() {
                return TraversableLike.tail$(this);
            }

            public Object last() {
                return TraversableLike.last$(this);
            }

            public Option<Ast.Expr> lastOption() {
                return TraversableLike.lastOption$(this);
            }

            public Object init() {
                return TraversableLike.init$(this);
            }

            public Object take(int n) {
                return TraversableLike.take$(this, n);
            }

            public Object drop(int n) {
                return TraversableLike.drop$(this, n);
            }

            public Object slice(int from, int until) {
                return TraversableLike.slice$(this, from, until);
            }

            public Object sliceWithKnownDelta(int from, int until, int delta) {
                return TraversableLike.sliceWithKnownDelta$(this, from, until, delta);
            }

            public Object sliceWithKnownBound(int from, int until) {
                return TraversableLike.sliceWithKnownBound$(this, from, until);
            }

            public Object takeWhile(Function1 p) {
                return TraversableLike.takeWhile$(this, p);
            }

            public Object dropWhile(Function1 p) {
                return TraversableLike.dropWhile$(this, p);
            }

            public Tuple2<Traversable<Ast.Expr>, Traversable<Ast.Expr>> span(Function1<Ast.Expr, Object> p) {
                return TraversableLike.span$(this, p);
            }

            public Tuple2<Traversable<Ast.Expr>, Traversable<Ast.Expr>> splitAt(int n) {
                return TraversableLike.splitAt$(this, n);
            }

            public Iterator<Traversable<Ast.Expr>> tails() {
                return TraversableLike.tails$(this);
            }

            public Iterator<Traversable<Ast.Expr>> inits() {
                return TraversableLike.inits$(this);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                TraversableLike.copyToArray$(this, xs, start, len);
            }

            public Traversable<Ast.Expr> toTraversable() {
                return TraversableLike.toTraversable$(this);
            }

            public Iterator<Ast.Expr> toIterator() {
                return TraversableLike.toIterator$(this);
            }

            public Stream<Ast.Expr> toStream() {
                return TraversableLike.toStream$(this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Ast.Expr, Col> cbf) {
                return (Col)TraversableLike.to$(this, cbf);
            }

            public String toString() {
                return TraversableLike.toString$(this);
            }

            public String stringPrefix() {
                return TraversableLike.stringPrefix$(this);
            }

            public TraversableView<Ast.Expr, Traversable<Ast.Expr>> view() {
                return TraversableLike.view$(this);
            }

            public TraversableView<Ast.Expr, Traversable<Ast.Expr>> view(int from, int until) {
                return TraversableLike.view$(this, from, until);
            }

            public FilterMonadic<Ast.Expr, Traversable<Ast.Expr>> withFilter(Function1<Ast.Expr, Object> p) {
                return TraversableLike.withFilter$(this, p);
            }

            public Parallel par() {
                return Parallelizable.par$(this);
            }

            public List<Ast.Expr> reversed() {
                return TraversableOnce.reversed$(this);
            }

            public int size() {
                return TraversableOnce.size$(this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$(this);
            }

            public int count(Function1<Ast.Expr, Object> p) {
                return TraversableOnce.count$(this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Ast.Expr, B> pf) {
                return TraversableOnce.collectFirst$(this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Ast.Expr, B> op) {
                return (B)TraversableOnce.$div$colon$(this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Ast.Expr, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$(this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Ast.Expr, B> op) {
                return (B)TraversableOnce.foldLeft$(this, z, op);
            }

            public <B> B foldRight(B z, Function2<Ast.Expr, B, B> op) {
                return (B)TraversableOnce.foldRight$(this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Ast.Expr, B> op) {
                return (B)TraversableOnce.reduceLeft$(this, op);
            }

            public <B> B reduceRight(Function2<Ast.Expr, B, B> op) {
                return (B)TraversableOnce.reduceRight$(this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Ast.Expr, B> op) {
                return TraversableOnce.reduceLeftOption$(this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Ast.Expr, B, B> op) {
                return TraversableOnce.reduceRightOption$(this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$(this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$(this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$(this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Ast.Expr, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$(this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$(this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$(this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$(this, cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$(this, cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$(this, f, cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$(this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$(this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$(this, xs, start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$(this, xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$(this, evidence$1);
            }

            public List<Ast.Expr> toList() {
                return TraversableOnce.toList$(this);
            }

            public Iterable<Ast.Expr> toIterable() {
                return TraversableOnce.toIterable$(this);
            }

            public Seq<Ast.Expr> toSeq() {
                return TraversableOnce.toSeq$(this);
            }

            public IndexedSeq<Ast.Expr> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$(this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$(this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$(this);
            }

            public Vector<Ast.Expr> toVector() {
                return TraversableOnce.toVector$(this);
            }

            public <T, U> Map<T, U> toMap(Predef$.less.colon.less<Ast.Expr, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$(this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$(this, start, sep, end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$(this, sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$(this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$(this, b, start, sep, end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$(this, b, sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$(this, b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$(this);
            }

            public <U> void foreach(Function1<Ast.Expr, U> f) {
                ExprTraversable$.MODULE$.foreach(this.template$1, f);
            }
            {
                this.template$1 = template$1;
                GenTraversableOnce.$init$(this);
                TraversableOnce.$init$(this);
                Parallelizable.$init$(this);
                TraversableLike.$init$(this);
                GenericTraversableTemplate.$init$(this);
                GenTraversable.$init$(this);
                Traversable.$init$(this);
            }
        };
    }

    public Traversable<Ast.Expr> apply(Ast.Definition definition) {
        return new Traversable<Ast.Expr>(definition){
            private final Ast.Definition definition$1;

            public GenericCompanion<Traversable> companion() {
                return Traversable.companion$(this);
            }

            public Traversable<Ast.Expr> seq() {
                return Traversable.seq$(this);
            }

            public Builder<Ast.Expr, Traversable<Ast.Expr>> newBuilder() {
                return GenericTraversableTemplate.newBuilder$(this);
            }

            public <B> Builder<B, Traversable<B>> genericBuilder() {
                return GenericTraversableTemplate.genericBuilder$(this);
            }

            public <A1, A2> Tuple2<Traversable<A1>, Traversable<A2>> unzip(Function1<Ast.Expr, Tuple2<A1, A2>> asPair) {
                return GenericTraversableTemplate.unzip$(this, asPair);
            }

            public <A1, A2, A3> Tuple3<Traversable<A1>, Traversable<A2>, Traversable<A3>> unzip3(Function1<Ast.Expr, Tuple3<A1, A2, A3>> asTriple) {
                return GenericTraversableTemplate.unzip3$(this, asTriple);
            }

            public GenTraversable flatten(Function1 asTraversable) {
                return GenericTraversableTemplate.flatten$(this, asTraversable);
            }

            public GenTraversable transpose(Function1 asTraversable) {
                return GenericTraversableTemplate.transpose$(this, asTraversable);
            }

            public Object repr() {
                return TraversableLike.repr$(this);
            }

            public final boolean isTraversableAgain() {
                return TraversableLike.isTraversableAgain$(this);
            }

            public Traversable<Ast.Expr> thisCollection() {
                return TraversableLike.thisCollection$(this);
            }

            public Traversable toCollection(Object repr) {
                return TraversableLike.toCollection$(this, repr);
            }

            public Combiner<Ast.Expr, ParIterable<Ast.Expr>> parCombiner() {
                return TraversableLike.parCombiner$(this);
            }

            public boolean isEmpty() {
                return TraversableLike.isEmpty$(this);
            }

            public boolean hasDefiniteSize() {
                return TraversableLike.hasDefiniteSize$(this);
            }

            public <B, That> That $plus$plus(GenTraversableOnce<B> that, CanBuildFrom<Traversable<Ast.Expr>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$(this, that, bf);
            }

            public <B, That> That $plus$plus$colon(TraversableOnce<B> that, CanBuildFrom<Traversable<Ast.Expr>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
            }

            public <B, That> That $plus$plus$colon(Traversable<B> that, CanBuildFrom<Traversable<Ast.Expr>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
            }

            public <B, That> That map(Function1<Ast.Expr, B> f, CanBuildFrom<Traversable<Ast.Expr>, B, That> bf) {
                return (That)TraversableLike.map$(this, f, bf);
            }

            public <B, That> That flatMap(Function1<Ast.Expr, GenTraversableOnce<B>> f, CanBuildFrom<Traversable<Ast.Expr>, B, That> bf) {
                return (That)TraversableLike.flatMap$(this, f, bf);
            }

            public Object filterImpl(Function1 p, boolean isFlipped) {
                return TraversableLike.filterImpl$(this, p, isFlipped);
            }

            public Object filter(Function1 p) {
                return TraversableLike.filter$(this, p);
            }

            public Object filterNot(Function1 p) {
                return TraversableLike.filterNot$(this, p);
            }

            public <B, That> That collect(PartialFunction<Ast.Expr, B> pf, CanBuildFrom<Traversable<Ast.Expr>, B, That> bf) {
                return (That)TraversableLike.collect$(this, pf, bf);
            }

            public Tuple2<Traversable<Ast.Expr>, Traversable<Ast.Expr>> partition(Function1<Ast.Expr, Object> p) {
                return TraversableLike.partition$(this, p);
            }

            public <K> Map<K, Traversable<Ast.Expr>> groupBy(Function1<Ast.Expr, K> f) {
                return TraversableLike.groupBy$(this, f);
            }

            public boolean forall(Function1<Ast.Expr, Object> p) {
                return TraversableLike.forall$(this, p);
            }

            public boolean exists(Function1<Ast.Expr, Object> p) {
                return TraversableLike.exists$(this, p);
            }

            public Option<Ast.Expr> find(Function1<Ast.Expr, Object> p) {
                return TraversableLike.find$(this, p);
            }

            public <B, That> That scan(B z, Function2<B, B, B> op, CanBuildFrom<Traversable<Ast.Expr>, B, That> cbf) {
                return (That)TraversableLike.scan$(this, z, op, cbf);
            }

            public <B, That> That scanLeft(B z, Function2<B, Ast.Expr, B> op, CanBuildFrom<Traversable<Ast.Expr>, B, That> bf) {
                return (That)TraversableLike.scanLeft$(this, z, op, bf);
            }

            public <B, That> That scanRight(B z, Function2<Ast.Expr, B, B> op, CanBuildFrom<Traversable<Ast.Expr>, B, That> bf) {
                return (That)TraversableLike.scanRight$(this, z, op, bf);
            }

            public Object head() {
                return TraversableLike.head$(this);
            }

            public Option<Ast.Expr> headOption() {
                return TraversableLike.headOption$(this);
            }

            public Object tail() {
                return TraversableLike.tail$(this);
            }

            public Object last() {
                return TraversableLike.last$(this);
            }

            public Option<Ast.Expr> lastOption() {
                return TraversableLike.lastOption$(this);
            }

            public Object init() {
                return TraversableLike.init$(this);
            }

            public Object take(int n) {
                return TraversableLike.take$(this, n);
            }

            public Object drop(int n) {
                return TraversableLike.drop$(this, n);
            }

            public Object slice(int from, int until) {
                return TraversableLike.slice$(this, from, until);
            }

            public Object sliceWithKnownDelta(int from, int until, int delta) {
                return TraversableLike.sliceWithKnownDelta$(this, from, until, delta);
            }

            public Object sliceWithKnownBound(int from, int until) {
                return TraversableLike.sliceWithKnownBound$(this, from, until);
            }

            public Object takeWhile(Function1 p) {
                return TraversableLike.takeWhile$(this, p);
            }

            public Object dropWhile(Function1 p) {
                return TraversableLike.dropWhile$(this, p);
            }

            public Tuple2<Traversable<Ast.Expr>, Traversable<Ast.Expr>> span(Function1<Ast.Expr, Object> p) {
                return TraversableLike.span$(this, p);
            }

            public Tuple2<Traversable<Ast.Expr>, Traversable<Ast.Expr>> splitAt(int n) {
                return TraversableLike.splitAt$(this, n);
            }

            public Iterator<Traversable<Ast.Expr>> tails() {
                return TraversableLike.tails$(this);
            }

            public Iterator<Traversable<Ast.Expr>> inits() {
                return TraversableLike.inits$(this);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                TraversableLike.copyToArray$(this, xs, start, len);
            }

            public Traversable<Ast.Expr> toTraversable() {
                return TraversableLike.toTraversable$(this);
            }

            public Iterator<Ast.Expr> toIterator() {
                return TraversableLike.toIterator$(this);
            }

            public Stream<Ast.Expr> toStream() {
                return TraversableLike.toStream$(this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Ast.Expr, Col> cbf) {
                return (Col)TraversableLike.to$(this, cbf);
            }

            public String toString() {
                return TraversableLike.toString$(this);
            }

            public String stringPrefix() {
                return TraversableLike.stringPrefix$(this);
            }

            public TraversableView<Ast.Expr, Traversable<Ast.Expr>> view() {
                return TraversableLike.view$(this);
            }

            public TraversableView<Ast.Expr, Traversable<Ast.Expr>> view(int from, int until) {
                return TraversableLike.view$(this, from, until);
            }

            public FilterMonadic<Ast.Expr, Traversable<Ast.Expr>> withFilter(Function1<Ast.Expr, Object> p) {
                return TraversableLike.withFilter$(this, p);
            }

            public Parallel par() {
                return Parallelizable.par$(this);
            }

            public List<Ast.Expr> reversed() {
                return TraversableOnce.reversed$(this);
            }

            public int size() {
                return TraversableOnce.size$(this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$(this);
            }

            public int count(Function1<Ast.Expr, Object> p) {
                return TraversableOnce.count$(this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Ast.Expr, B> pf) {
                return TraversableOnce.collectFirst$(this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Ast.Expr, B> op) {
                return (B)TraversableOnce.$div$colon$(this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Ast.Expr, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$(this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Ast.Expr, B> op) {
                return (B)TraversableOnce.foldLeft$(this, z, op);
            }

            public <B> B foldRight(B z, Function2<Ast.Expr, B, B> op) {
                return (B)TraversableOnce.foldRight$(this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Ast.Expr, B> op) {
                return (B)TraversableOnce.reduceLeft$(this, op);
            }

            public <B> B reduceRight(Function2<Ast.Expr, B, B> op) {
                return (B)TraversableOnce.reduceRight$(this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Ast.Expr, B> op) {
                return TraversableOnce.reduceLeftOption$(this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Ast.Expr, B, B> op) {
                return TraversableOnce.reduceRightOption$(this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$(this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$(this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$(this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Ast.Expr, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$(this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$(this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$(this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$(this, cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$(this, cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$(this, f, cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$(this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$(this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$(this, xs, start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$(this, xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$(this, evidence$1);
            }

            public List<Ast.Expr> toList() {
                return TraversableOnce.toList$(this);
            }

            public Iterable<Ast.Expr> toIterable() {
                return TraversableOnce.toIterable$(this);
            }

            public Seq<Ast.Expr> toSeq() {
                return TraversableOnce.toSeq$(this);
            }

            public IndexedSeq<Ast.Expr> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$(this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$(this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$(this);
            }

            public Vector<Ast.Expr> toVector() {
                return TraversableOnce.toVector$(this);
            }

            public <T, U> Map<T, U> toMap(Predef$.less.colon.less<Ast.Expr, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$(this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$(this, start, sep, end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$(this, sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$(this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$(this, b, start, sep, end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$(this, b, sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$(this, b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$(this);
            }

            public <U> void foreach(Function1<Ast.Expr, U> f) {
                ExprTraversable$.MODULE$.foreach(this.definition$1, f);
            }
            {
                this.definition$1 = definition$1;
                GenTraversableOnce.$init$(this);
                TraversableOnce.$init$(this);
                Parallelizable.$init$(this);
                TraversableLike.$init$(this);
                GenericTraversableTemplate.$init$(this);
                GenTraversable.$init$(this);
                Traversable.$init$(this);
            }
        };
    }

    private ExprTraversable$() {
        MODULE$ = this;
    }
}

