/*
 * Decompiled with CFR 0.152.
 */
package com.digitalasset.daml.lf.validation.traversable;

import com.digitalasset.daml.lf.data.ImmArray;
import com.digitalasset.daml.lf.data.Ref;
import com.digitalasset.daml.lf.language.Ast;
import com.digitalasset.daml.lf.language.Ast$ScenarioGetTime$;
import com.digitalasset.daml.lf.language.Ast$TApp$;
import com.digitalasset.daml.lf.language.Ast$UpdateGetTime$;
import com.digitalasset.daml.lf.validation.Util$;
import com.digitalasset.daml.lf.validation.Util$TupleImmArrayOps$;
import com.digitalasset.daml.lf.validation.traversable.ExprTraversable$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Parallel;
import scala.collection.Parallelizable;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.TraversableView;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.FilterMonadic;
import scala.collection.generic.GenericCompanion;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.Combiner;
import scala.collection.parallel.ParIterable;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

public final class TypeTraversable$ {
    public static TypeTraversable$ MODULE$;

    static {
        new TypeTraversable$();
    }

    private Ast.Type toType(Ast.TypeConApp tyCon) {
        Ast.TTyCon tTyCon = new Ast.TTyCon(tyCon.tycon());
        return tyCon.args().iterator().$div$colon(tTyCon, Ast$TApp$.MODULE$);
    }

    public <U> void foreach(Ast.Type typ, Function1<Ast.Type, U> f) {
        Ast.Type type = typ;
        boolean bl = type instanceof Ast.TVar ? true : (type instanceof Ast.TTyCon ? true : (type instanceof Ast.TBuiltin ? true : type instanceof Ast.TNat));
        if (bl) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (type instanceof Ast.TApp) {
            Ast.TApp tApp = (Ast.TApp)type;
            Ast.Type tyfun = tApp.tyfun();
            Ast.Type arg = tApp.arg();
            f.apply(tyfun);
            f.apply(arg);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (type instanceof Ast.TForall) {
            Ast.TForall tForall = (Ast.TForall)type;
            Ast.Type body = tForall.body();
            f.apply(body);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (type instanceof Ast.TStruct) {
            Ast.TStruct tStruct = (Ast.TStruct)type;
            ImmArray fields = tStruct.sortedFields();
            Util$TupleImmArrayOps$.MODULE$.values$extension(Util$.MODULE$.TupleImmArrayOps(fields)).foreach(f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(type);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public <U> void foreach(Ast.Expr expr0, Function1<Ast.Type, U> f) {
        Ast.Expr expr = expr0;
        if (expr instanceof Ast.EContractId) {
            Ast.EContractId eContractId = (Ast.EContractId)expr;
            Ref.Identifier typeConName = eContractId.tmplId();
            U u = f.apply(new Ast.TTyCon(typeConName));
            return;
        }
        if (expr instanceof Ast.ERecCon) {
            Ast.ERecCon eRecCon = (Ast.ERecCon)expr;
            Ast.TypeConApp tycon = eRecCon.tycon();
            ImmArray fields = eRecCon.fields();
            f.apply(this.toType(tycon));
            Util$TupleImmArrayOps$.MODULE$.values$extension(Util$.MODULE$.TupleImmArrayOps(fields)).foreach((Function1<Ast.Expr, Object> & Serializable & scala.Serializable)x$2 -> {
                TypeTraversable$.MODULE$.foreach(x$2, f);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (expr instanceof Ast.ERecProj) {
            Ast.ERecProj eRecProj = (Ast.ERecProj)expr;
            Ast.TypeConApp tycon = eRecProj.tycon();
            Ast.Expr record2 = eRecProj.record();
            f.apply(this.toType(tycon));
            this.foreach(record2, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (expr instanceof Ast.ERecUpd) {
            Ast.ERecUpd eRecUpd = (Ast.ERecUpd)expr;
            Ast.TypeConApp tycon = eRecUpd.tycon();
            Ast.Expr record3 = eRecUpd.record();
            Ast.Expr update = eRecUpd.update();
            f.apply(this.toType(tycon));
            this.foreach(record3, f);
            this.foreach(update, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (expr instanceof Ast.EVariantCon) {
            Ast.EVariantCon eVariantCon = (Ast.EVariantCon)expr;
            Ast.TypeConApp tycon = eVariantCon.tycon();
            Ast.Expr arg = eVariantCon.arg();
            f.apply(this.toType(tycon));
            this.foreach(arg, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (expr instanceof Ast.ETyApp) {
            Ast.ETyApp eTyApp = (Ast.ETyApp)expr;
            Ast.Expr expr2 = eTyApp.expr();
            Ast.Type typ = eTyApp.typ();
            this.foreach(expr2, f);
            U u = f.apply(typ);
            return;
        }
        if (expr instanceof Ast.EAbs) {
            Ast.EAbs eAbs = (Ast.EAbs)expr;
            Tuple2<String, Ast.Type> tuple2 = eAbs.binder();
            Ast.Expr body = eAbs.body();
            if (tuple2 != null) {
                Ast.Type boundVarType = tuple2._2();
                f.apply(boundVarType);
                this.foreach(body, f);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (expr instanceof Ast.ELet) {
            Ast.ELet eLet = (Ast.ELet)expr;
            Ast.Binding binding = eLet.binding();
            Ast.Expr body = eLet.body();
            this.foreach(binding, f);
            this.foreach(body, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (expr instanceof Ast.EEnumCon) {
            Ast.EEnumCon eEnumCon = (Ast.EEnumCon)expr;
            Ref.Identifier tyConName = eEnumCon.tyConName();
            U u = f.apply(new Ast.TTyCon(tyConName));
            return;
        }
        if (expr instanceof Ast.EToAny) {
            Ast.EToAny eToAny = (Ast.EToAny)expr;
            Ast.Type typ = eToAny.ty();
            Ast.Expr expr3 = eToAny.body();
            f.apply(typ);
            this.foreach(expr3, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (expr instanceof Ast.EFromAny) {
            Ast.EFromAny eFromAny = (Ast.EFromAny)expr;
            Ast.Type typ = eFromAny.ty();
            Ast.Expr expr4 = eFromAny.body();
            f.apply(typ);
            this.foreach(expr4, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (expr instanceof Ast.ETypeRep) {
            Ast.ETypeRep eTypeRep = (Ast.ETypeRep)expr;
            Ast.Type tyCon = eTypeRep.typ();
            U u = f.apply(tyCon);
            return;
        }
        if (expr instanceof Ast.ENil) {
            Ast.ENil eNil = (Ast.ENil)expr;
            Ast.Type typ = eNil.typ();
            U u = f.apply(typ);
            return;
        }
        if (expr instanceof Ast.ECons) {
            Ast.ECons eCons = (Ast.ECons)expr;
            Ast.Type typ = eCons.typ();
            ImmArray<Ast.Expr> front = eCons.front();
            Ast.Expr tail = eCons.tail();
            f.apply(typ);
            front.iterator().foreach((Function1<Ast.Expr, Object> & Serializable & scala.Serializable)x$3 -> {
                TypeTraversable$.MODULE$.foreach(x$3, f);
                return BoxedUnit.UNIT;
            });
            this.foreach(tail, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (expr instanceof Ast.ENone) {
            Ast.ENone eNone = (Ast.ENone)expr;
            Ast.Type typ = eNone.typ();
            U u = f.apply(typ);
            return;
        }
        if (expr instanceof Ast.ESome) {
            Ast.ESome eSome = (Ast.ESome)expr;
            Ast.Type typ = eSome.typ();
            Ast.Expr body = eSome.body();
            f.apply(typ);
            this.foreach(body, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (expr instanceof Ast.EUpdate) {
            Ast.EUpdate eUpdate = (Ast.EUpdate)expr;
            Ast.Update u = eUpdate.update();
            this.foreach(u, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (expr instanceof Ast.EScenario) {
            Ast.EScenario eScenario = (Ast.EScenario)expr;
            Ast.Scenario s2 = eScenario.scenario();
            this.foreach(s2, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        boolean bl = expr instanceof Ast.EVar ? true : (expr instanceof Ast.EVal ? true : (expr instanceof Ast.EBuiltin ? true : (expr instanceof Ast.EPrimCon ? true : (expr instanceof Ast.EPrimLit ? true : (expr instanceof Ast.EApp ? true : (expr instanceof Ast.ECase ? true : (expr instanceof Ast.ELocation ? true : (expr instanceof Ast.EStructCon ? true : (expr instanceof Ast.EStructProj ? true : (expr instanceof Ast.EStructUpd ? true : expr instanceof Ast.ETyAbs))))))))));
        if (!bl) throw new MatchError(expr);
        ExprTraversable$.MODULE$.foreach(expr0, (Function1<Ast.Expr, Object> & Serializable & scala.Serializable)(Ast.Expr x$4) -> {
            TypeTraversable$.MODULE$.foreach(x$4, f);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public <U> void foreach(Ast.Update update, Function1<Ast.Type, U> f) {
        Ast.Update update2 = update;
        if (update2 instanceof Ast.UpdatePure) {
            Ast.UpdatePure updatePure = (Ast.UpdatePure)update2;
            Ast.Type typ = updatePure.t();
            Ast.Expr expr = updatePure.expr();
            f.apply(typ);
            this.foreach(expr, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (update2 instanceof Ast.UpdateBlock) {
            Ast.UpdateBlock updateBlock = (Ast.UpdateBlock)update2;
            ImmArray<Ast.Binding> bindings = updateBlock.bindings();
            Ast.Expr body = updateBlock.body();
            bindings.iterator().foreach((Function1<Ast.Binding, Object> & Serializable & scala.Serializable)x$5 -> {
                TypeTraversable$.MODULE$.foreach(x$5, f);
                return BoxedUnit.UNIT;
            });
            this.foreach(body, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (update2 instanceof Ast.UpdateCreate) {
            Ast.UpdateCreate updateCreate = (Ast.UpdateCreate)update2;
            Ref.Identifier templateId = updateCreate.templateId();
            Ast.Expr arg = updateCreate.arg();
            f.apply(new Ast.TTyCon(templateId));
            this.foreach(arg, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (update2 instanceof Ast.UpdateFetch) {
            Ast.UpdateFetch updateFetch = (Ast.UpdateFetch)update2;
            Ref.Identifier templateId = updateFetch.templateId();
            Ast.Expr contractId = updateFetch.contractId();
            f.apply(new Ast.TTyCon(templateId));
            this.foreach(contractId, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (update2 instanceof Ast.UpdateExercise) {
            Ast.UpdateExercise updateExercise = (Ast.UpdateExercise)update2;
            Ref.Identifier templateId = updateExercise.templateId();
            Ast.Expr cid = updateExercise.cidE();
            Option<Ast.Expr> actors = updateExercise.actorsE();
            Ast.Expr arg = updateExercise.argE();
            f.apply(new Ast.TTyCon(templateId));
            this.foreach(cid, f);
            actors.foreach((Function1<Ast.Expr, Object> & Serializable & scala.Serializable)x$6 -> {
                TypeTraversable$.MODULE$.foreach(x$6, f);
                return BoxedUnit.UNIT;
            });
            this.foreach(arg, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (update2 instanceof Ast.UpdateEmbedExpr) {
            Ast.UpdateEmbedExpr updateEmbedExpr = (Ast.UpdateEmbedExpr)update2;
            Ast.Type typ = updateEmbedExpr.typ();
            Ast.Expr body = updateEmbedExpr.body();
            f.apply(typ);
            this.foreach(body, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl = Ast$UpdateGetTime$.MODULE$.equals(update2) ? true : (update2 instanceof Ast.UpdateFetchByKey ? true : update2 instanceof Ast.UpdateLookupByKey);
            if (bl) {
                ExprTraversable$.MODULE$.foreach(update, (Function1<Ast.Expr, Object> & Serializable & scala.Serializable)(Ast.Expr x$7) -> {
                    TypeTraversable$.MODULE$.foreach(x$7, f);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(update2);
            }
        }
    }

    public <U> void foreach(Ast.Binding binding, Function1<Ast.Type, U> f) {
        Ast.Binding binding2 = binding;
        if (binding2 == null) {
            throw new MatchError(binding2);
        }
        Ast.Type typ = binding2.typ();
        Ast.Expr bound2 = binding2.bound();
        f.apply(typ);
        this.foreach(bound2, f);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public <U> void foreach(Ast.Scenario scenario, Function1<Ast.Type, U> f) {
        Ast.Scenario scenario2 = scenario;
        if (scenario2 instanceof Ast.ScenarioPure) {
            Ast.ScenarioPure scenarioPure = (Ast.ScenarioPure)scenario2;
            Ast.Type typ = scenarioPure.t();
            Ast.Expr expr = scenarioPure.expr();
            f.apply(typ);
            this.foreach(expr, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (scenario2 instanceof Ast.ScenarioBlock) {
            Ast.ScenarioBlock scenarioBlock = (Ast.ScenarioBlock)scenario2;
            ImmArray<Ast.Binding> bindings = scenarioBlock.bindings();
            Ast.Expr body = scenarioBlock.body();
            bindings.foreach((Function1<Ast.Binding, BoxedUnit>)(Function1<Ast.Binding, Object> & Serializable & scala.Serializable)x$8 -> {
                TypeTraversable$.MODULE$.foreach(x$8, f);
                return BoxedUnit.UNIT;
            });
            this.foreach(body, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (scenario2 instanceof Ast.ScenarioCommit) {
            Ast.ScenarioCommit scenarioCommit = (Ast.ScenarioCommit)scenario2;
            Ast.Expr party = scenarioCommit.partyE();
            Ast.Expr update = scenarioCommit.updateE();
            Ast.Type retType = scenarioCommit.retType();
            this.foreach(party, f);
            this.foreach(update, f);
            f.apply(retType);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (scenario2 instanceof Ast.ScenarioMustFailAt) {
            Ast.ScenarioMustFailAt scenarioMustFailAt = (Ast.ScenarioMustFailAt)scenario2;
            Ast.Expr party = scenarioMustFailAt.partyE();
            Ast.Expr update = scenarioMustFailAt.updateE();
            Ast.Type retType = scenarioMustFailAt.retType();
            this.foreach(party, f);
            this.foreach(update, f);
            f.apply(retType);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (scenario2 instanceof Ast.ScenarioEmbedExpr) {
            Ast.ScenarioEmbedExpr scenarioEmbedExpr = (Ast.ScenarioEmbedExpr)scenario2;
            Ast.Type typ = scenarioEmbedExpr.typ();
            Ast.Expr body = scenarioEmbedExpr.body();
            f.apply(typ);
            this.foreach(body, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl = Ast$ScenarioGetTime$.MODULE$.equals(scenario2) ? true : (scenario2 instanceof Ast.ScenarioPass ? true : scenario2 instanceof Ast.ScenarioGetParty);
            if (bl) {
                ExprTraversable$.MODULE$.foreach(scenario, (Function1<Ast.Expr, Object> & Serializable & scala.Serializable)(Ast.Expr x$9) -> {
                    TypeTraversable$.MODULE$.foreach(x$9, f);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(scenario2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public <U> void foreach(Ast.Definition defn, Function1<Ast.Type, U> f) {
        Ast.DataCons dataCons;
        Ast.DataCons dataCons2;
        boolean bl = false;
        Ast.DDataType dDataType = null;
        Ast.Definition definition = defn;
        if (definition instanceof Ast.DDataType) {
            bl = true;
            dDataType = (Ast.DDataType)definition;
            Ast.DataCons dataCons3 = dDataType.cons();
            if (dataCons3 instanceof Ast.DataRecord) {
                Ast.DataRecord dataRecord = (Ast.DataRecord)dataCons3;
                ImmArray fields = dataRecord.fields();
                Option<Ast.Template> template = dataRecord.optTemplate();
                Util$TupleImmArrayOps$.MODULE$.values$extension(Util$.MODULE$.TupleImmArrayOps(fields)).foreach(f);
                template.foreach((Function1<Ast.Template, Object> & Serializable & scala.Serializable)x$10 -> {
                    TypeTraversable$.MODULE$.foreach(x$10, f);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl && (dataCons2 = dDataType.cons()) instanceof Ast.DataVariant) {
            Ast.DataVariant dataVariant = (Ast.DataVariant)dataCons2;
            ImmArray variants = dataVariant.variants();
            Util$TupleImmArrayOps$.MODULE$.values$extension(Util$.MODULE$.TupleImmArrayOps(variants)).foreach(f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (bl && (dataCons = dDataType.cons()) instanceof Ast.DataEnum) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (!(definition instanceof Ast.DValue)) throw new MatchError(definition);
        Ast.DValue dValue = (Ast.DValue)definition;
        Ast.Type typ = dValue.typ();
        Ast.Expr body = dValue.body();
        f.apply(typ);
        this.foreach(body, f);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public <U> void foreach(Ast.Template x, Function1<Ast.Type, U> f) {
        Ast.Template template = x;
        if (template == null) {
            throw new MatchError(template);
        }
        Ast.Expr precond = template.precond();
        Ast.Expr signatories = template.signatories();
        Ast.Expr agreementText = template.agreementText();
        Map<String, Ast.TemplateChoice> choices = template.choices();
        Ast.Expr observers = template.observers();
        Option<Ast.TemplateKey> key = template.key();
        this.foreach(precond, f);
        this.foreach(signatories, f);
        this.foreach(agreementText, f);
        choices.values().foreach((Function1<Ast.TemplateChoice, Object> & Serializable & scala.Serializable)x$11 -> {
            TypeTraversable$.MODULE$.foreach(x$11, f);
            return BoxedUnit.UNIT;
        });
        this.foreach(observers, f);
        key.foreach((Function1<Ast.TemplateKey, Object> & Serializable & scala.Serializable)x$12 -> {
            TypeTraversable$.MODULE$.foreach(x$12, f);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public <U> void foreach(Ast.TemplateChoice choice2, Function1<Ast.Type, U> f) {
        Ast.Expr update;
        Ast.Type retType;
        Tuple2<Option<String>, Ast.Type> tuple2;
        Ast.Expr controllers;
        block3: {
            Ast.TemplateChoice templateChoice;
            block2: {
                templateChoice = choice2;
                if (templateChoice == null) break block2;
                controllers = templateChoice.controllers();
                tuple2 = templateChoice.argBinder();
                retType = templateChoice.returnType();
                update = templateChoice.update();
                if (tuple2 != null) break block3;
            }
            throw new MatchError(templateChoice);
        }
        Ast.Type boundedVarType = tuple2._2();
        this.foreach(controllers, f);
        this.foreach(update, f);
        f.apply(boundedVarType);
        f.apply(retType);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public <U> void foreach(Ast.TemplateKey key, Function1<Ast.Type, U> f) {
        Ast.TemplateKey templateKey = key;
        if (templateKey == null) {
            throw new MatchError(templateKey);
        }
        Ast.Type typ = templateKey.typ();
        Ast.Expr body = templateKey.body();
        Ast.Expr maintainers = templateKey.maintainers();
        f.apply(typ);
        this.foreach(body, f);
        this.foreach(maintainers, f);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Traversable<Ast.Type> apply(Ast.Type typ) {
        return new Traversable<Ast.Type>(typ){
            private final Ast.Type typ$1;

            public GenericCompanion<Traversable> companion() {
                return Traversable.companion$(this);
            }

            public Traversable<Ast.Type> seq() {
                return Traversable.seq$(this);
            }

            public Builder<Ast.Type, Traversable<Ast.Type>> newBuilder() {
                return GenericTraversableTemplate.newBuilder$(this);
            }

            public <B> Builder<B, Traversable<B>> genericBuilder() {
                return GenericTraversableTemplate.genericBuilder$(this);
            }

            public <A1, A2> Tuple2<Traversable<A1>, Traversable<A2>> unzip(Function1<Ast.Type, Tuple2<A1, A2>> asPair) {
                return GenericTraversableTemplate.unzip$(this, asPair);
            }

            public <A1, A2, A3> Tuple3<Traversable<A1>, Traversable<A2>, Traversable<A3>> unzip3(Function1<Ast.Type, Tuple3<A1, A2, A3>> asTriple) {
                return GenericTraversableTemplate.unzip3$(this, asTriple);
            }

            public GenTraversable flatten(Function1 asTraversable) {
                return GenericTraversableTemplate.flatten$(this, asTraversable);
            }

            public GenTraversable transpose(Function1 asTraversable) {
                return GenericTraversableTemplate.transpose$(this, asTraversable);
            }

            public Object repr() {
                return TraversableLike.repr$(this);
            }

            public final boolean isTraversableAgain() {
                return TraversableLike.isTraversableAgain$(this);
            }

            public Traversable<Ast.Type> thisCollection() {
                return TraversableLike.thisCollection$(this);
            }

            public Traversable toCollection(Object repr) {
                return TraversableLike.toCollection$(this, repr);
            }

            public Combiner<Ast.Type, ParIterable<Ast.Type>> parCombiner() {
                return TraversableLike.parCombiner$(this);
            }

            public boolean isEmpty() {
                return TraversableLike.isEmpty$(this);
            }

            public boolean hasDefiniteSize() {
                return TraversableLike.hasDefiniteSize$(this);
            }

            public <B, That> That $plus$plus(GenTraversableOnce<B> that, CanBuildFrom<Traversable<Ast.Type>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$(this, that, bf);
            }

            public <B, That> That $plus$plus$colon(TraversableOnce<B> that, CanBuildFrom<Traversable<Ast.Type>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
            }

            public <B, That> That $plus$plus$colon(Traversable<B> that, CanBuildFrom<Traversable<Ast.Type>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
            }

            public <B, That> That map(Function1<Ast.Type, B> f, CanBuildFrom<Traversable<Ast.Type>, B, That> bf) {
                return (That)TraversableLike.map$(this, f, bf);
            }

            public <B, That> That flatMap(Function1<Ast.Type, GenTraversableOnce<B>> f, CanBuildFrom<Traversable<Ast.Type>, B, That> bf) {
                return (That)TraversableLike.flatMap$(this, f, bf);
            }

            public Object filterImpl(Function1 p, boolean isFlipped) {
                return TraversableLike.filterImpl$(this, p, isFlipped);
            }

            public Object filter(Function1 p) {
                return TraversableLike.filter$(this, p);
            }

            public Object filterNot(Function1 p) {
                return TraversableLike.filterNot$(this, p);
            }

            public <B, That> That collect(PartialFunction<Ast.Type, B> pf, CanBuildFrom<Traversable<Ast.Type>, B, That> bf) {
                return (That)TraversableLike.collect$(this, pf, bf);
            }

            public Tuple2<Traversable<Ast.Type>, Traversable<Ast.Type>> partition(Function1<Ast.Type, Object> p) {
                return TraversableLike.partition$(this, p);
            }

            public <K> Map<K, Traversable<Ast.Type>> groupBy(Function1<Ast.Type, K> f) {
                return TraversableLike.groupBy$(this, f);
            }

            public boolean forall(Function1<Ast.Type, Object> p) {
                return TraversableLike.forall$(this, p);
            }

            public boolean exists(Function1<Ast.Type, Object> p) {
                return TraversableLike.exists$(this, p);
            }

            public Option<Ast.Type> find(Function1<Ast.Type, Object> p) {
                return TraversableLike.find$(this, p);
            }

            public <B, That> That scan(B z, Function2<B, B, B> op, CanBuildFrom<Traversable<Ast.Type>, B, That> cbf) {
                return (That)TraversableLike.scan$(this, z, op, cbf);
            }

            public <B, That> That scanLeft(B z, Function2<B, Ast.Type, B> op, CanBuildFrom<Traversable<Ast.Type>, B, That> bf) {
                return (That)TraversableLike.scanLeft$(this, z, op, bf);
            }

            public <B, That> That scanRight(B z, Function2<Ast.Type, B, B> op, CanBuildFrom<Traversable<Ast.Type>, B, That> bf) {
                return (That)TraversableLike.scanRight$(this, z, op, bf);
            }

            public Object head() {
                return TraversableLike.head$(this);
            }

            public Option<Ast.Type> headOption() {
                return TraversableLike.headOption$(this);
            }

            public Object tail() {
                return TraversableLike.tail$(this);
            }

            public Object last() {
                return TraversableLike.last$(this);
            }

            public Option<Ast.Type> lastOption() {
                return TraversableLike.lastOption$(this);
            }

            public Object init() {
                return TraversableLike.init$(this);
            }

            public Object take(int n) {
                return TraversableLike.take$(this, n);
            }

            public Object drop(int n) {
                return TraversableLike.drop$(this, n);
            }

            public Object slice(int from, int until) {
                return TraversableLike.slice$(this, from, until);
            }

            public Object sliceWithKnownDelta(int from, int until, int delta) {
                return TraversableLike.sliceWithKnownDelta$(this, from, until, delta);
            }

            public Object sliceWithKnownBound(int from, int until) {
                return TraversableLike.sliceWithKnownBound$(this, from, until);
            }

            public Object takeWhile(Function1 p) {
                return TraversableLike.takeWhile$(this, p);
            }

            public Object dropWhile(Function1 p) {
                return TraversableLike.dropWhile$(this, p);
            }

            public Tuple2<Traversable<Ast.Type>, Traversable<Ast.Type>> span(Function1<Ast.Type, Object> p) {
                return TraversableLike.span$(this, p);
            }

            public Tuple2<Traversable<Ast.Type>, Traversable<Ast.Type>> splitAt(int n) {
                return TraversableLike.splitAt$(this, n);
            }

            public Iterator<Traversable<Ast.Type>> tails() {
                return TraversableLike.tails$(this);
            }

            public Iterator<Traversable<Ast.Type>> inits() {
                return TraversableLike.inits$(this);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                TraversableLike.copyToArray$(this, xs, start, len);
            }

            public Traversable<Ast.Type> toTraversable() {
                return TraversableLike.toTraversable$(this);
            }

            public Iterator<Ast.Type> toIterator() {
                return TraversableLike.toIterator$(this);
            }

            public Stream<Ast.Type> toStream() {
                return TraversableLike.toStream$(this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Ast.Type, Col> cbf) {
                return (Col)TraversableLike.to$(this, cbf);
            }

            public String toString() {
                return TraversableLike.toString$(this);
            }

            public String stringPrefix() {
                return TraversableLike.stringPrefix$(this);
            }

            public TraversableView<Ast.Type, Traversable<Ast.Type>> view() {
                return TraversableLike.view$(this);
            }

            public TraversableView<Ast.Type, Traversable<Ast.Type>> view(int from, int until) {
                return TraversableLike.view$(this, from, until);
            }

            public FilterMonadic<Ast.Type, Traversable<Ast.Type>> withFilter(Function1<Ast.Type, Object> p) {
                return TraversableLike.withFilter$(this, p);
            }

            public Parallel par() {
                return Parallelizable.par$(this);
            }

            public List<Ast.Type> reversed() {
                return TraversableOnce.reversed$(this);
            }

            public int size() {
                return TraversableOnce.size$(this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$(this);
            }

            public int count(Function1<Ast.Type, Object> p) {
                return TraversableOnce.count$(this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Ast.Type, B> pf) {
                return TraversableOnce.collectFirst$(this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Ast.Type, B> op) {
                return (B)TraversableOnce.$div$colon$(this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Ast.Type, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$(this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Ast.Type, B> op) {
                return (B)TraversableOnce.foldLeft$(this, z, op);
            }

            public <B> B foldRight(B z, Function2<Ast.Type, B, B> op) {
                return (B)TraversableOnce.foldRight$(this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Ast.Type, B> op) {
                return (B)TraversableOnce.reduceLeft$(this, op);
            }

            public <B> B reduceRight(Function2<Ast.Type, B, B> op) {
                return (B)TraversableOnce.reduceRight$(this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Ast.Type, B> op) {
                return TraversableOnce.reduceLeftOption$(this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Ast.Type, B, B> op) {
                return TraversableOnce.reduceRightOption$(this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$(this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$(this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$(this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Ast.Type, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$(this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$(this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$(this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$(this, cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$(this, cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$(this, f, cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$(this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$(this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$(this, xs, start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$(this, xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$(this, evidence$1);
            }

            public List<Ast.Type> toList() {
                return TraversableOnce.toList$(this);
            }

            public Iterable<Ast.Type> toIterable() {
                return TraversableOnce.toIterable$(this);
            }

            public Seq<Ast.Type> toSeq() {
                return TraversableOnce.toSeq$(this);
            }

            public IndexedSeq<Ast.Type> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$(this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$(this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$(this);
            }

            public Vector<Ast.Type> toVector() {
                return TraversableOnce.toVector$(this);
            }

            public <T, U> Map<T, U> toMap(Predef$.less.colon.less<Ast.Type, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$(this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$(this, start, sep, end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$(this, sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$(this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$(this, b, start, sep, end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$(this, b, sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$(this, b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$(this);
            }

            public <U> void foreach(Function1<Ast.Type, U> f) {
                TypeTraversable$.MODULE$.foreach(this.typ$1, f);
            }
            {
                this.typ$1 = typ$1;
                GenTraversableOnce.$init$(this);
                TraversableOnce.$init$(this);
                Parallelizable.$init$(this);
                TraversableLike.$init$(this);
                GenericTraversableTemplate.$init$(this);
                GenTraversable.$init$(this);
                Traversable.$init$(this);
            }
        };
    }

    public Traversable<Ast.Type> apply(Ast.Expr expr) {
        return new Traversable<Ast.Type>(expr){
            private final Ast.Expr expr$1;

            public GenericCompanion<Traversable> companion() {
                return Traversable.companion$(this);
            }

            public Traversable<Ast.Type> seq() {
                return Traversable.seq$(this);
            }

            public Builder<Ast.Type, Traversable<Ast.Type>> newBuilder() {
                return GenericTraversableTemplate.newBuilder$(this);
            }

            public <B> Builder<B, Traversable<B>> genericBuilder() {
                return GenericTraversableTemplate.genericBuilder$(this);
            }

            public <A1, A2> Tuple2<Traversable<A1>, Traversable<A2>> unzip(Function1<Ast.Type, Tuple2<A1, A2>> asPair) {
                return GenericTraversableTemplate.unzip$(this, asPair);
            }

            public <A1, A2, A3> Tuple3<Traversable<A1>, Traversable<A2>, Traversable<A3>> unzip3(Function1<Ast.Type, Tuple3<A1, A2, A3>> asTriple) {
                return GenericTraversableTemplate.unzip3$(this, asTriple);
            }

            public GenTraversable flatten(Function1 asTraversable) {
                return GenericTraversableTemplate.flatten$(this, asTraversable);
            }

            public GenTraversable transpose(Function1 asTraversable) {
                return GenericTraversableTemplate.transpose$(this, asTraversable);
            }

            public Object repr() {
                return TraversableLike.repr$(this);
            }

            public final boolean isTraversableAgain() {
                return TraversableLike.isTraversableAgain$(this);
            }

            public Traversable<Ast.Type> thisCollection() {
                return TraversableLike.thisCollection$(this);
            }

            public Traversable toCollection(Object repr) {
                return TraversableLike.toCollection$(this, repr);
            }

            public Combiner<Ast.Type, ParIterable<Ast.Type>> parCombiner() {
                return TraversableLike.parCombiner$(this);
            }

            public boolean isEmpty() {
                return TraversableLike.isEmpty$(this);
            }

            public boolean hasDefiniteSize() {
                return TraversableLike.hasDefiniteSize$(this);
            }

            public <B, That> That $plus$plus(GenTraversableOnce<B> that, CanBuildFrom<Traversable<Ast.Type>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$(this, that, bf);
            }

            public <B, That> That $plus$plus$colon(TraversableOnce<B> that, CanBuildFrom<Traversable<Ast.Type>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
            }

            public <B, That> That $plus$plus$colon(Traversable<B> that, CanBuildFrom<Traversable<Ast.Type>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
            }

            public <B, That> That map(Function1<Ast.Type, B> f, CanBuildFrom<Traversable<Ast.Type>, B, That> bf) {
                return (That)TraversableLike.map$(this, f, bf);
            }

            public <B, That> That flatMap(Function1<Ast.Type, GenTraversableOnce<B>> f, CanBuildFrom<Traversable<Ast.Type>, B, That> bf) {
                return (That)TraversableLike.flatMap$(this, f, bf);
            }

            public Object filterImpl(Function1 p, boolean isFlipped) {
                return TraversableLike.filterImpl$(this, p, isFlipped);
            }

            public Object filter(Function1 p) {
                return TraversableLike.filter$(this, p);
            }

            public Object filterNot(Function1 p) {
                return TraversableLike.filterNot$(this, p);
            }

            public <B, That> That collect(PartialFunction<Ast.Type, B> pf, CanBuildFrom<Traversable<Ast.Type>, B, That> bf) {
                return (That)TraversableLike.collect$(this, pf, bf);
            }

            public Tuple2<Traversable<Ast.Type>, Traversable<Ast.Type>> partition(Function1<Ast.Type, Object> p) {
                return TraversableLike.partition$(this, p);
            }

            public <K> Map<K, Traversable<Ast.Type>> groupBy(Function1<Ast.Type, K> f) {
                return TraversableLike.groupBy$(this, f);
            }

            public boolean forall(Function1<Ast.Type, Object> p) {
                return TraversableLike.forall$(this, p);
            }

            public boolean exists(Function1<Ast.Type, Object> p) {
                return TraversableLike.exists$(this, p);
            }

            public Option<Ast.Type> find(Function1<Ast.Type, Object> p) {
                return TraversableLike.find$(this, p);
            }

            public <B, That> That scan(B z, Function2<B, B, B> op, CanBuildFrom<Traversable<Ast.Type>, B, That> cbf) {
                return (That)TraversableLike.scan$(this, z, op, cbf);
            }

            public <B, That> That scanLeft(B z, Function2<B, Ast.Type, B> op, CanBuildFrom<Traversable<Ast.Type>, B, That> bf) {
                return (That)TraversableLike.scanLeft$(this, z, op, bf);
            }

            public <B, That> That scanRight(B z, Function2<Ast.Type, B, B> op, CanBuildFrom<Traversable<Ast.Type>, B, That> bf) {
                return (That)TraversableLike.scanRight$(this, z, op, bf);
            }

            public Object head() {
                return TraversableLike.head$(this);
            }

            public Option<Ast.Type> headOption() {
                return TraversableLike.headOption$(this);
            }

            public Object tail() {
                return TraversableLike.tail$(this);
            }

            public Object last() {
                return TraversableLike.last$(this);
            }

            public Option<Ast.Type> lastOption() {
                return TraversableLike.lastOption$(this);
            }

            public Object init() {
                return TraversableLike.init$(this);
            }

            public Object take(int n) {
                return TraversableLike.take$(this, n);
            }

            public Object drop(int n) {
                return TraversableLike.drop$(this, n);
            }

            public Object slice(int from, int until) {
                return TraversableLike.slice$(this, from, until);
            }

            public Object sliceWithKnownDelta(int from, int until, int delta) {
                return TraversableLike.sliceWithKnownDelta$(this, from, until, delta);
            }

            public Object sliceWithKnownBound(int from, int until) {
                return TraversableLike.sliceWithKnownBound$(this, from, until);
            }

            public Object takeWhile(Function1 p) {
                return TraversableLike.takeWhile$(this, p);
            }

            public Object dropWhile(Function1 p) {
                return TraversableLike.dropWhile$(this, p);
            }

            public Tuple2<Traversable<Ast.Type>, Traversable<Ast.Type>> span(Function1<Ast.Type, Object> p) {
                return TraversableLike.span$(this, p);
            }

            public Tuple2<Traversable<Ast.Type>, Traversable<Ast.Type>> splitAt(int n) {
                return TraversableLike.splitAt$(this, n);
            }

            public Iterator<Traversable<Ast.Type>> tails() {
                return TraversableLike.tails$(this);
            }

            public Iterator<Traversable<Ast.Type>> inits() {
                return TraversableLike.inits$(this);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                TraversableLike.copyToArray$(this, xs, start, len);
            }

            public Traversable<Ast.Type> toTraversable() {
                return TraversableLike.toTraversable$(this);
            }

            public Iterator<Ast.Type> toIterator() {
                return TraversableLike.toIterator$(this);
            }

            public Stream<Ast.Type> toStream() {
                return TraversableLike.toStream$(this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Ast.Type, Col> cbf) {
                return (Col)TraversableLike.to$(this, cbf);
            }

            public String toString() {
                return TraversableLike.toString$(this);
            }

            public String stringPrefix() {
                return TraversableLike.stringPrefix$(this);
            }

            public TraversableView<Ast.Type, Traversable<Ast.Type>> view() {
                return TraversableLike.view$(this);
            }

            public TraversableView<Ast.Type, Traversable<Ast.Type>> view(int from, int until) {
                return TraversableLike.view$(this, from, until);
            }

            public FilterMonadic<Ast.Type, Traversable<Ast.Type>> withFilter(Function1<Ast.Type, Object> p) {
                return TraversableLike.withFilter$(this, p);
            }

            public Parallel par() {
                return Parallelizable.par$(this);
            }

            public List<Ast.Type> reversed() {
                return TraversableOnce.reversed$(this);
            }

            public int size() {
                return TraversableOnce.size$(this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$(this);
            }

            public int count(Function1<Ast.Type, Object> p) {
                return TraversableOnce.count$(this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Ast.Type, B> pf) {
                return TraversableOnce.collectFirst$(this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Ast.Type, B> op) {
                return (B)TraversableOnce.$div$colon$(this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Ast.Type, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$(this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Ast.Type, B> op) {
                return (B)TraversableOnce.foldLeft$(this, z, op);
            }

            public <B> B foldRight(B z, Function2<Ast.Type, B, B> op) {
                return (B)TraversableOnce.foldRight$(this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Ast.Type, B> op) {
                return (B)TraversableOnce.reduceLeft$(this, op);
            }

            public <B> B reduceRight(Function2<Ast.Type, B, B> op) {
                return (B)TraversableOnce.reduceRight$(this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Ast.Type, B> op) {
                return TraversableOnce.reduceLeftOption$(this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Ast.Type, B, B> op) {
                return TraversableOnce.reduceRightOption$(this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$(this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$(this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$(this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Ast.Type, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$(this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$(this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$(this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$(this, cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$(this, cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$(this, f, cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$(this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$(this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$(this, xs, start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$(this, xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$(this, evidence$1);
            }

            public List<Ast.Type> toList() {
                return TraversableOnce.toList$(this);
            }

            public Iterable<Ast.Type> toIterable() {
                return TraversableOnce.toIterable$(this);
            }

            public Seq<Ast.Type> toSeq() {
                return TraversableOnce.toSeq$(this);
            }

            public IndexedSeq<Ast.Type> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$(this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$(this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$(this);
            }

            public Vector<Ast.Type> toVector() {
                return TraversableOnce.toVector$(this);
            }

            public <T, U> Map<T, U> toMap(Predef$.less.colon.less<Ast.Type, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$(this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$(this, start, sep, end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$(this, sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$(this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$(this, b, start, sep, end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$(this, b, sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$(this, b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$(this);
            }

            public <U> void foreach(Function1<Ast.Type, U> f) {
                TypeTraversable$.MODULE$.foreach(this.expr$1, f);
            }
            {
                this.expr$1 = expr$1;
                GenTraversableOnce.$init$(this);
                TraversableOnce.$init$(this);
                Parallelizable.$init$(this);
                TraversableLike.$init$(this);
                GenericTraversableTemplate.$init$(this);
                GenTraversable.$init$(this);
                Traversable.$init$(this);
            }
        };
    }

    public Traversable<Ast.Type> apply(Ast.Definition definition) {
        return new Traversable<Ast.Type>(definition){
            private final Ast.Definition definition$1;

            public GenericCompanion<Traversable> companion() {
                return Traversable.companion$(this);
            }

            public Traversable<Ast.Type> seq() {
                return Traversable.seq$(this);
            }

            public Builder<Ast.Type, Traversable<Ast.Type>> newBuilder() {
                return GenericTraversableTemplate.newBuilder$(this);
            }

            public <B> Builder<B, Traversable<B>> genericBuilder() {
                return GenericTraversableTemplate.genericBuilder$(this);
            }

            public <A1, A2> Tuple2<Traversable<A1>, Traversable<A2>> unzip(Function1<Ast.Type, Tuple2<A1, A2>> asPair) {
                return GenericTraversableTemplate.unzip$(this, asPair);
            }

            public <A1, A2, A3> Tuple3<Traversable<A1>, Traversable<A2>, Traversable<A3>> unzip3(Function1<Ast.Type, Tuple3<A1, A2, A3>> asTriple) {
                return GenericTraversableTemplate.unzip3$(this, asTriple);
            }

            public GenTraversable flatten(Function1 asTraversable) {
                return GenericTraversableTemplate.flatten$(this, asTraversable);
            }

            public GenTraversable transpose(Function1 asTraversable) {
                return GenericTraversableTemplate.transpose$(this, asTraversable);
            }

            public Object repr() {
                return TraversableLike.repr$(this);
            }

            public final boolean isTraversableAgain() {
                return TraversableLike.isTraversableAgain$(this);
            }

            public Traversable<Ast.Type> thisCollection() {
                return TraversableLike.thisCollection$(this);
            }

            public Traversable toCollection(Object repr) {
                return TraversableLike.toCollection$(this, repr);
            }

            public Combiner<Ast.Type, ParIterable<Ast.Type>> parCombiner() {
                return TraversableLike.parCombiner$(this);
            }

            public boolean isEmpty() {
                return TraversableLike.isEmpty$(this);
            }

            public boolean hasDefiniteSize() {
                return TraversableLike.hasDefiniteSize$(this);
            }

            public <B, That> That $plus$plus(GenTraversableOnce<B> that, CanBuildFrom<Traversable<Ast.Type>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$(this, that, bf);
            }

            public <B, That> That $plus$plus$colon(TraversableOnce<B> that, CanBuildFrom<Traversable<Ast.Type>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
            }

            public <B, That> That $plus$plus$colon(Traversable<B> that, CanBuildFrom<Traversable<Ast.Type>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
            }

            public <B, That> That map(Function1<Ast.Type, B> f, CanBuildFrom<Traversable<Ast.Type>, B, That> bf) {
                return (That)TraversableLike.map$(this, f, bf);
            }

            public <B, That> That flatMap(Function1<Ast.Type, GenTraversableOnce<B>> f, CanBuildFrom<Traversable<Ast.Type>, B, That> bf) {
                return (That)TraversableLike.flatMap$(this, f, bf);
            }

            public Object filterImpl(Function1 p, boolean isFlipped) {
                return TraversableLike.filterImpl$(this, p, isFlipped);
            }

            public Object filter(Function1 p) {
                return TraversableLike.filter$(this, p);
            }

            public Object filterNot(Function1 p) {
                return TraversableLike.filterNot$(this, p);
            }

            public <B, That> That collect(PartialFunction<Ast.Type, B> pf, CanBuildFrom<Traversable<Ast.Type>, B, That> bf) {
                return (That)TraversableLike.collect$(this, pf, bf);
            }

            public Tuple2<Traversable<Ast.Type>, Traversable<Ast.Type>> partition(Function1<Ast.Type, Object> p) {
                return TraversableLike.partition$(this, p);
            }

            public <K> Map<K, Traversable<Ast.Type>> groupBy(Function1<Ast.Type, K> f) {
                return TraversableLike.groupBy$(this, f);
            }

            public boolean forall(Function1<Ast.Type, Object> p) {
                return TraversableLike.forall$(this, p);
            }

            public boolean exists(Function1<Ast.Type, Object> p) {
                return TraversableLike.exists$(this, p);
            }

            public Option<Ast.Type> find(Function1<Ast.Type, Object> p) {
                return TraversableLike.find$(this, p);
            }

            public <B, That> That scan(B z, Function2<B, B, B> op, CanBuildFrom<Traversable<Ast.Type>, B, That> cbf) {
                return (That)TraversableLike.scan$(this, z, op, cbf);
            }

            public <B, That> That scanLeft(B z, Function2<B, Ast.Type, B> op, CanBuildFrom<Traversable<Ast.Type>, B, That> bf) {
                return (That)TraversableLike.scanLeft$(this, z, op, bf);
            }

            public <B, That> That scanRight(B z, Function2<Ast.Type, B, B> op, CanBuildFrom<Traversable<Ast.Type>, B, That> bf) {
                return (That)TraversableLike.scanRight$(this, z, op, bf);
            }

            public Object head() {
                return TraversableLike.head$(this);
            }

            public Option<Ast.Type> headOption() {
                return TraversableLike.headOption$(this);
            }

            public Object tail() {
                return TraversableLike.tail$(this);
            }

            public Object last() {
                return TraversableLike.last$(this);
            }

            public Option<Ast.Type> lastOption() {
                return TraversableLike.lastOption$(this);
            }

            public Object init() {
                return TraversableLike.init$(this);
            }

            public Object take(int n) {
                return TraversableLike.take$(this, n);
            }

            public Object drop(int n) {
                return TraversableLike.drop$(this, n);
            }

            public Object slice(int from, int until) {
                return TraversableLike.slice$(this, from, until);
            }

            public Object sliceWithKnownDelta(int from, int until, int delta) {
                return TraversableLike.sliceWithKnownDelta$(this, from, until, delta);
            }

            public Object sliceWithKnownBound(int from, int until) {
                return TraversableLike.sliceWithKnownBound$(this, from, until);
            }

            public Object takeWhile(Function1 p) {
                return TraversableLike.takeWhile$(this, p);
            }

            public Object dropWhile(Function1 p) {
                return TraversableLike.dropWhile$(this, p);
            }

            public Tuple2<Traversable<Ast.Type>, Traversable<Ast.Type>> span(Function1<Ast.Type, Object> p) {
                return TraversableLike.span$(this, p);
            }

            public Tuple2<Traversable<Ast.Type>, Traversable<Ast.Type>> splitAt(int n) {
                return TraversableLike.splitAt$(this, n);
            }

            public Iterator<Traversable<Ast.Type>> tails() {
                return TraversableLike.tails$(this);
            }

            public Iterator<Traversable<Ast.Type>> inits() {
                return TraversableLike.inits$(this);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                TraversableLike.copyToArray$(this, xs, start, len);
            }

            public Traversable<Ast.Type> toTraversable() {
                return TraversableLike.toTraversable$(this);
            }

            public Iterator<Ast.Type> toIterator() {
                return TraversableLike.toIterator$(this);
            }

            public Stream<Ast.Type> toStream() {
                return TraversableLike.toStream$(this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Ast.Type, Col> cbf) {
                return (Col)TraversableLike.to$(this, cbf);
            }

            public String toString() {
                return TraversableLike.toString$(this);
            }

            public String stringPrefix() {
                return TraversableLike.stringPrefix$(this);
            }

            public TraversableView<Ast.Type, Traversable<Ast.Type>> view() {
                return TraversableLike.view$(this);
            }

            public TraversableView<Ast.Type, Traversable<Ast.Type>> view(int from, int until) {
                return TraversableLike.view$(this, from, until);
            }

            public FilterMonadic<Ast.Type, Traversable<Ast.Type>> withFilter(Function1<Ast.Type, Object> p) {
                return TraversableLike.withFilter$(this, p);
            }

            public Parallel par() {
                return Parallelizable.par$(this);
            }

            public List<Ast.Type> reversed() {
                return TraversableOnce.reversed$(this);
            }

            public int size() {
                return TraversableOnce.size$(this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$(this);
            }

            public int count(Function1<Ast.Type, Object> p) {
                return TraversableOnce.count$(this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Ast.Type, B> pf) {
                return TraversableOnce.collectFirst$(this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Ast.Type, B> op) {
                return (B)TraversableOnce.$div$colon$(this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Ast.Type, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$(this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Ast.Type, B> op) {
                return (B)TraversableOnce.foldLeft$(this, z, op);
            }

            public <B> B foldRight(B z, Function2<Ast.Type, B, B> op) {
                return (B)TraversableOnce.foldRight$(this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Ast.Type, B> op) {
                return (B)TraversableOnce.reduceLeft$(this, op);
            }

            public <B> B reduceRight(Function2<Ast.Type, B, B> op) {
                return (B)TraversableOnce.reduceRight$(this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Ast.Type, B> op) {
                return TraversableOnce.reduceLeftOption$(this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Ast.Type, B, B> op) {
                return TraversableOnce.reduceRightOption$(this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$(this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$(this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$(this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Ast.Type, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$(this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$(this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$(this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$(this, cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$(this, cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$(this, f, cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$(this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$(this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$(this, xs, start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$(this, xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$(this, evidence$1);
            }

            public List<Ast.Type> toList() {
                return TraversableOnce.toList$(this);
            }

            public Iterable<Ast.Type> toIterable() {
                return TraversableOnce.toIterable$(this);
            }

            public Seq<Ast.Type> toSeq() {
                return TraversableOnce.toSeq$(this);
            }

            public IndexedSeq<Ast.Type> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$(this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$(this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$(this);
            }

            public Vector<Ast.Type> toVector() {
                return TraversableOnce.toVector$(this);
            }

            public <T, U> Map<T, U> toMap(Predef$.less.colon.less<Ast.Type, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$(this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$(this, start, sep, end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$(this, sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$(this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$(this, b, start, sep, end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$(this, b, sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$(this, b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$(this);
            }

            public <U> void foreach(Function1<Ast.Type, U> f) {
                TypeTraversable$.MODULE$.foreach(this.definition$1, f);
            }
            {
                this.definition$1 = definition$1;
                GenTraversableOnce.$init$(this);
                TraversableOnce.$init$(this);
                Parallelizable.$init$(this);
                TraversableLike.$init$(this);
                GenericTraversableTemplate.$init$(this);
                GenTraversable.$init$(this);
                Traversable.$init$(this);
            }
        };
    }

    private TypeTraversable$() {
        MODULE$ = this;
    }
}

