/*
 * Decompiled with CFR 0.152.
 */
package com.digitalasset.grpc.adapter;

import com.digitalasset.grpc.adapter.ExecutionSequencer;
import com.digitalasset.grpc.adapter.ExecutionSequencerFactory;
import com.digitalasset.grpc.adapter.SingleThreadExecutionSequencer;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;

public class SingleThreadExecutionSequencerPool
implements ExecutionSequencerFactory {
    private final int instanceCount;
    @Nonnull
    private final SingleThreadExecutionSequencer[] sequencers;
    private final AtomicInteger counter = new AtomicInteger(0);

    public SingleThreadExecutionSequencerPool(@Nonnull String poolName) {
        this.instanceCount = Runtime.getRuntime().availableProcessors();
        this.sequencers = new SingleThreadExecutionSequencer[this.instanceCount];
        this.initPool(poolName);
    }

    public SingleThreadExecutionSequencerPool(@Nonnull String poolName, int instanceCount) {
        this.instanceCount = instanceCount;
        this.sequencers = new SingleThreadExecutionSequencer[instanceCount];
        this.initPool(poolName);
    }

    private void initPool(@Nonnull String poolName) {
        for (int i = 0; i < this.instanceCount; ++i) {
            this.sequencers[i] = new SingleThreadExecutionSequencer(String.format("%s-%d", poolName, i));
        }
    }

    @Override
    public ExecutionSequencer getExecutionSequencer() {
        return this.sequencers[this.counter.getAndIncrement() % this.instanceCount];
    }

    @Override
    public void close() throws Exception {
        for (int i = 0; i < this.instanceCount; ++i) {
            if (this.sequencers[i] != null) {
                this.sequencers[i].close();
            }
            this.sequencers[i] = null;
        }
    }
}

