/*
 * Decompiled with CFR 0.152.
 */
package com.digitalasset.platform.server.services.command;

import akka.NotUsed;
import akka.stream.Materializer;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.SourceQueueWithComplete;
import com.digitalasset.ledger.api.v1.command_service.SubmitAndWaitRequest;
import com.digitalasset.ledger.api.v1.command_submission_service.SubmitRequest;
import com.digitalasset.ledger.api.v1.completion.Completion;
import com.digitalasset.ledger.client.services.commands.CommandTrackerFlow;
import com.digitalasset.platform.server.services.command.HandleOfferResult$;
import com.digitalasset.platform.server.services.command.SizeCappedMap;
import com.digitalasset.platform.server.services.command.Tracker;
import com.digitalasset.platform.server.services.command.TrackerImpl$;
import com.digitalasset.util.Ctx;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Predef$;
import scala.Tuple2;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001B\u0001\u0003\u0001=\u00111\u0002\u0016:bG.,'/S7qY*\u00111\u0001B\u0001\bG>lW.\u00198e\u0015\t)a!\u0001\u0005tKJ4\u0018nY3t\u0015\t9\u0001\"\u0001\u0004tKJ4XM\u001d\u0006\u0003\u0013)\t\u0001\u0002\u001d7bi\u001a|'/\u001c\u0006\u0003\u00171\tA\u0002Z5hSR\fG.Y:tKRT\u0011!D\u0001\u0004G>l7\u0001A\n\u0004\u0001AA\u0002CA\t\u0017\u001b\u0005\u0011\"BA\n\u0015\u0003\u0011a\u0017M\\4\u000b\u0003U\tAA[1wC&\u0011qC\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005eQR\"\u0001\u0002\n\u0005m\u0011!a\u0002+sC\u000e\\WM\u001d\u0005\t;\u0001\u0011\t\u0011)A\u0005=\u0005)\u0011/^3vKB\u0019qD\n\u0015\u000e\u0003\u0001R!!\t\u0012\u0002\u0011M\u001c\u0017\r\\1eg2T!a\t\u0013\u0002\rM$(/Z1n\u0015\u0005)\u0013\u0001B1lW\u0006L!a\n\u0011\u0003/M{WO]2f#V,W/Z,ji\"\u001cu.\u001c9mKR,\u0007cA\u0015\u000269\u0011\u0011DK\u0004\u0006W\tA\t\u0001L\u0001\f)J\f7m[3s\u00136\u0004H\u000e\u0005\u0002\u001a[\u0019)\u0011A\u0001E\u0001]M\u0011Qf\f\t\u0003aMj\u0011!\r\u0006\u0002e\u0005)1oY1mC&\u0011A'\r\u0002\u0007\u0003:L(+\u001a4\t\u000bYjC\u0011A\u001c\u0002\rqJg.\u001b;?)\u0005a\u0003bB\u001d.\u0005\u0004%IAO\u0001\u0007Y><w-\u001a:\u0016\u0003m\u0002\"\u0001P!\u000e\u0003uR!AP \u0002\u000bMdg\r\u000e6\u000b\u0003\u0001\u000b1a\u001c:h\u0013\t\u0011UH\u0001\u0004M_\u001e<WM\u001d\u0005\u0007\t6\u0002\u000b\u0011B\u001e\u0002\u000f1|wmZ3sA!)a)\fC\u0001\u000f\u0006)\u0011\r\u001d9msR1\u0001\nUA\u0014\u0003c!\"!\u0013&\u0011\u0005e\u0001\u0001\"B&F\u0001\ba\u0015\u0001D7bi\u0016\u0014\u0018.\u00197ju\u0016\u0014\bCA'O\u001b\u0005\u0011\u0013BA(#\u00051i\u0015\r^3sS\u0006d\u0017N_3s\u0011\u0015\tV\t1\u0001S\u0003\u001d!(/Y2lKJ\u0004RaH*VgRL!\u0001\u0016\u0011\u0003\t\u0019cwn\u001e\t\u0005-f[V.D\u0001X\u0015\tA&\"\u0001\u0003vi&d\u0017B\u0001.X\u0005\r\u0019E\u000f\u001f\t\u00049~\u000bW\"A/\u000b\u0005y\u000b\u0014AC2p]\u000e,(O]3oi&\u0011\u0001-\u0018\u0002\b!J|W.[:f!\t\u00117.D\u0001d\u0015\t!W-\u0001\u0006d_6\u0004H.\u001a;j_:T!AZ4\u0002\u0005Y\f$B\u00015j\u0003\r\t\u0007/\u001b\u0006\u0003U*\ta\u0001\\3eO\u0016\u0014\u0018B\u00017d\u0005)\u0019u.\u001c9mKRLwN\u001c\t\u0003]Fl\u0011a\u001c\u0006\u0003a\u0016\f!dY8n[\u0006tGmX:vE6L7o]5p]~\u001bXM\u001d<jG\u0016L!A]8\u0003\u001bM+(-\\5u%\u0016\fX/Z:u!\u00111\u0016lW1\u0011\rU\fI\"a\b\\\u001d\r1\u00181\u0003\b\u0004o\u00065ab\u0001=\u0002\n9\u0019\u00110!\u0002\u000f\u0007i\f\u0019AD\u0002|\u0003\u0003q!\u0001`@\u000e\u0003uT!A \b\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0011BA\u0006\r\u0013\tQ'\"C\u0002\u0002\b%\faa\u00197jK:$\u0018bA\u0003\u0002\f)\u0019\u0011qA5\n\t\u0005=\u0011\u0011C\u0001\tG>lW.\u00198eg*\u0019Q!a\u0003\n\t\u0005U\u0011qC\u0001\u0013\u0007>lW.\u00198e)J\f7m[3s\r2|wO\u0003\u0003\u0002\u0010\u0005E\u0011\u0002BA\u000e\u0003;\u0011A\"T1uKJL\u0017\r\\5{K\u0012TA!!\u0006\u0002\u0018A!\u0011\u0011EA\u0012\u001b\u0005!\u0013bAA\u0013I\t9aj\u001c;Vg\u0016$\u0007bBA\u0015\u000b\u0002\u0007\u00111F\u0001\u0010S:\u0004X\u000f\u001e\"vM\u001a,'oU5{KB\u0019\u0001'!\f\n\u0007\u0005=\u0012GA\u0002J]RDq!a\rF\u0001\u0004\tY#A\u0006iSN$xN]=TSj,W!BA\u001c[\u0001)&AC)vKV,\u0017J\u001c9vi\"Q\u00111\u0007\u0001\u0003\u0002\u0003\u0006I!a\u000b\t\rY\u0002A\u0011AA\u001f)\u0015I\u0015qHA!\u0011\u0019i\u00121\ba\u0001=!A\u00111GA\u001e\u0001\u0004\tY\u0003C\u0004:\u0001\t\u0007I\u0011\u0002\u001e\t\r\u0011\u0003\u0001\u0015!\u0003<\u0011%\tI\u0005\u0001b\u0001\n\u0013\tY%\u0001\u0007l]><hNU3tk2$8/\u0006\u0002\u0002NAA\u0011qJA*\u0003/\ni'\u0004\u0002\u0002R)\u0011\u0001\fF\u0005\u0005\u0003+\n\tFA\u0002NCB\u0004r\u0001MA-\u0003;\ni&C\u0002\u0002\\E\u0012a\u0001V;qY\u0016\u0014\u0004\u0003BA0\u0003OrA!!\u0019\u0002dA\u0011A0M\u0005\u0004\u0003K\n\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002j\u0005-$AB*ue&twMC\u0002\u0002fE\u0002B\u0001XA8C&\u0019\u0011\u0011O/\u0003\r\u0019+H/\u001e:f\u0011!\t)\b\u0001Q\u0001\n\u00055\u0013!D6o_^t'+Z:vYR\u001c\b\u0005C\u0004\u0002z\u0001!\t%a\u001f\u0002\u000bQ\u0014\u0018mY6\u0015\t\u0005u\u0014\u0011\u0012\u000b\u0005\u0003[\ny\b\u0003\u0005\u0002\u0002\u0006]\u00049AAB\u0003\t)7\rE\u0002]\u0003\u000bK1!a\"^\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000f\u0003\u0005\u0002\f\u0006]\u0004\u0019AAG\u0003\u001d\u0011X-];fgR\u0004B!a$\u0002\u00166\u0011\u0011\u0011\u0013\u0006\u0004\u0003'+\u0017aD2p[6\fg\u000eZ0tKJ4\u0018nY3\n\t\u0005]\u0015\u0011\u0013\u0002\u0015'V\u0014W.\u001b;B]\u0012<\u0016-\u001b;SKF,Xm\u001d;\t\u000f\u0005m\u0005\u0001\"\u0003\u0002\u001e\u0006\u00012/\u001e2nSRtUm\u001e*fcV,7\u000f\u001e\u000b\u0007\u0003?\u000b\u0019+!*\u0015\t\u00055\u0014\u0011\u0015\u0005\t\u0003\u0003\u000bI\nq\u0001\u0002\u0004\"A\u00111RAM\u0001\u0004\ti\tC\u0004\u0002(\u0006e\u0005\u0019A.\u0002\u000fA\u0014x.\\5tK\"9\u00111\u0016\u0001\u0005B\u00055\u0016!B2m_N,GCAAX!\r\u0001\u0014\u0011W\u0005\u0004\u0003g\u000b$\u0001B+oSR\u0004")
public class TrackerImpl
implements Tracker {
    private final SourceQueueWithComplete<Ctx<Promise<Completion>, SubmitRequest>> queue;
    private final Logger logger;
    private final Map<Tuple2<String, String>, Future<Completion>> knownResults;

    public static TrackerImpl apply(Flow<Ctx<Promise<Completion>, SubmitRequest>, Ctx<Promise<Completion>, Completion>, CommandTrackerFlow.Materialized<NotUsed, Promise<Completion>>> flow, int n, int n2, Materializer materializer) {
        return TrackerImpl$.MODULE$.apply(flow, n, n2, materializer);
    }

    private Logger logger() {
        return this.logger;
    }

    private Map<Tuple2<String, String>, Future<Completion>> knownResults() {
        return this.knownResults;
    }

    @Override
    public Future<Completion> track(SubmitAndWaitRequest request, ExecutionContext ec) {
        this.logger().trace(new StringBuilder(41).append("tracking command for party: ").append(request.getCommands().party()).append(", commandId: ").append(request.getCommands().commandId()).toString());
        Promise<Completion> promise = Promise$.MODULE$.apply();
        Future<Completion> storedResult = this.knownResults().putIfAbsent(new Tuple2<String, String>(request.getCommands().commandId(), request.getCommands().applicationId()), promise.future());
        return storedResult == null ? this.submitNewRequest(request, promise, ec) : storedResult;
    }

    private Future<Completion> submitNewRequest(SubmitAndWaitRequest request, Promise<Completion> promise, ExecutionContext ec) {
        this.queue.offer(new Ctx<Promise<Completion>, SubmitRequest>(promise, new SubmitRequest(request.commands(), request.traceContext()))).andThen(HandleOfferResult$.MODULE$.completePromise(promise), ec);
        return promise.future();
    }

    @Override
    public void close() {
        this.logger().debug("Shutting down tracking component.");
        this.queue.complete();
        Await$.MODULE$.result(this.queue.watchCompletion(), new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds());
    }

    public TrackerImpl(SourceQueueWithComplete<Ctx<Promise<Completion>, SubmitRequest>> queue, int historySize) {
        this.queue = queue;
        this.logger = LoggerFactory.getLogger(this.getClass());
        Predef$.MODULE$.require(historySize > 0, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> " History size must be a positive integer.");
        this.knownResults = Collections.synchronizedMap(new SizeCappedMap(historySize / 2, historySize));
    }
}

