/*
 * Decompiled with CFR 0.152.
 */
package com.github.blemale.scaffeine;

import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.compat.java8.FutureConverters;
import scala.concurrent.Future;

class AsyncCacheLoaderAdapter<K, V>
implements AsyncCacheLoader<K, V> {
    private final Function1<K, Future<V>> loader;
    private final Option<Function2<K, V, Future<V>>> reloadLoader;

    AsyncCacheLoaderAdapter(Function1<K, Future<V>> function1, Option<Function2<K, V, Future<V>>> option2) {
        this.loader = function1;
        this.reloadLoader = option2;
    }

    @Override
    @Nonnull
    public CompletableFuture<V> asyncLoad(@Nonnull K k, @Nonnull Executor executor) {
        return FutureConverters.toJava(this.loader.apply(k)).toCompletableFuture();
    }

    @Override
    @Nonnull
    public CompletableFuture<V> asyncReload(@Nonnull K k, @Nonnull V v, @Nonnull Executor executor) {
        if (this.reloadLoader.isEmpty()) {
            return AsyncCacheLoader.super.asyncReload(k, v, executor);
        }
        return FutureConverters.toJava(this.reloadLoader.get().apply(k, v)).toCompletableFuture();
    }
}

