/*
 * Decompiled with CFR 0.152.
 */
package com.github.blemale.scaffeine;

import com.github.benmanes.caffeine.cache.CacheLoader;
import javax.annotation.Nonnull;
import scala.Function1;
import scala.Function2;
import scala.Option;

class CacheLoaderAdapter<K, V>
implements CacheLoader<K, V> {
    private final Function1<K, V> loader;
    private final Option<Function2<K, V, V>> reloadLoader;

    CacheLoaderAdapter(Function1<K, V> function1, Option<Function2<K, V, V>> option2) {
        this.loader = function1;
        this.reloadLoader = option2;
    }

    @Override
    public V load(@Nonnull K k) throws Exception {
        return this.loader.apply(k);
    }

    @Override
    public V reload(@Nonnull K k, @Nonnull V v) throws Exception {
        if (this.reloadLoader.isEmpty()) {
            return CacheLoader.super.reload(k, v);
        }
        return this.reloadLoader.get().apply(k, v);
    }
}

