/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ChannelLogger;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ClientStreamTracer;
import io.grpc.CompressorRegistry;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.Context;
import io.grpc.DecompressorRegistry;
import io.grpc.EquivalentAddressGroup;
import io.grpc.InternalChannelz;
import io.grpc.InternalInstrumented;
import io.grpc.InternalLogId;
import io.grpc.InternalWithLogId;
import io.grpc.LoadBalancer;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.NameResolver;
import io.grpc.NameResolverRegistry;
import io.grpc.ProxyDetector;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.AbstractManagedChannelImplBuilder;
import io.grpc.internal.AbstractSubchannel;
import io.grpc.internal.AutoConfiguredLoadBalancerFactory;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.CallCredentialsApplyingTransportFactory;
import io.grpc.internal.CallTracer;
import io.grpc.internal.ChannelLoggerImpl;
import io.grpc.internal.ChannelTracer;
import io.grpc.internal.ClientCallImpl;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.ConnectivityStateManager;
import io.grpc.internal.DelayedClientTransport;
import io.grpc.internal.GrpcAttributes;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.InUseStateAggregator;
import io.grpc.internal.InternalSubchannel;
import io.grpc.internal.LogExceptionRunnable;
import io.grpc.internal.ManagedChannelServiceConfig;
import io.grpc.internal.ManagedClientTransport;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.OobChannel;
import io.grpc.internal.PickSubchannelArgsImpl;
import io.grpc.internal.Rescheduler;
import io.grpc.internal.RetriableStream;
import io.grpc.internal.ServiceConfigInterceptor;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.internal.SubchannelChannel;
import io.grpc.internal.TimeProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class ManagedChannelImpl
extends ManagedChannel
implements InternalInstrumented<InternalChannelz.ChannelStats> {
    static final Logger logger = Logger.getLogger(ManagedChannelImpl.class.getName());
    @VisibleForTesting
    static final Pattern URI_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9+.-]*:/.*");
    static final long IDLE_TIMEOUT_MILLIS_DISABLE = -1L;
    @VisibleForTesting
    static final long SUBCHANNEL_SHUTDOWN_DELAY_SECONDS = 5L;
    @VisibleForTesting
    static final Status SHUTDOWN_NOW_STATUS = Status.UNAVAILABLE.withDescription("Channel shutdownNow invoked");
    @VisibleForTesting
    static final Status SHUTDOWN_STATUS = Status.UNAVAILABLE.withDescription("Channel shutdown invoked");
    @VisibleForTesting
    static final Status SUBCHANNEL_SHUTDOWN_STATUS = Status.UNAVAILABLE.withDescription("Subchannel shutdown invoked");
    private final InternalLogId logId;
    private final String target;
    private final NameResolverRegistry nameResolverRegistry;
    private final NameResolver.Factory nameResolverFactory;
    private final NameResolver.Args nameResolverArgs;
    private final AutoConfiguredLoadBalancerFactory loadBalancerFactory;
    private final ClientTransportFactory transportFactory;
    private final ScheduledExecutorForBalancer scheduledExecutorForBalancer;
    private final Executor executor;
    private final ObjectPool<? extends Executor> executorPool;
    private final ObjectPool<? extends Executor> balancerRpcExecutorPool;
    private final ExecutorHolder balancerRpcExecutorHolder;
    private final TimeProvider timeProvider;
    private final int maxTraceEvents;
    @VisibleForTesting
    final SynchronizationContext syncContext = new SynchronizationContext(new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            logger.log(Level.SEVERE, "[" + ManagedChannelImpl.this.getLogId() + "] Uncaught exception in the SynchronizationContext. Panic!", e);
            ManagedChannelImpl.this.panic(e);
        }
    });
    private boolean fullStreamDecompression;
    private final DecompressorRegistry decompressorRegistry;
    private final CompressorRegistry compressorRegistry;
    private final Supplier<Stopwatch> stopwatchSupplier;
    private final long idleTimeoutMillis;
    private final ConnectivityStateManager channelStateManager = new ConnectivityStateManager();
    private final ServiceConfigInterceptor serviceConfigInterceptor;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Channel interceptorChannel;
    @Nullable
    private final String userAgent;
    private NameResolver nameResolver;
    private boolean nameResolverStarted;
    @Nullable
    private LbHelperImpl lbHelper;
    @Nullable
    private volatile LoadBalancer.SubchannelPicker subchannelPicker;
    private boolean panicMode;
    private final Set<InternalSubchannel> subchannels = new HashSet<InternalSubchannel>(16, 0.75f);
    private final Set<OobChannel> oobChannels = new HashSet<OobChannel>(1, 0.75f);
    private final DelayedClientTransport delayedTransport;
    private final UncommittedRetriableStreamsRegistry uncommittedRetriableStreamsRegistry = new UncommittedRetriableStreamsRegistry();
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private boolean shutdownNowed;
    private volatile boolean terminating;
    private volatile boolean terminated;
    private final CountDownLatch terminatedLatch = new CountDownLatch(1);
    private final CallTracer.Factory callTracerFactory;
    private final CallTracer channelCallTracer;
    private final ChannelTracer channelTracer;
    private final ChannelLogger channelLogger;
    private final InternalChannelz channelz;
    @CheckForNull
    private Boolean haveBackends;
    @Nullable
    private Map<String, ?> lastServiceConfig;
    @Nullable
    private final Map<String, ?> defaultServiceConfig;
    private boolean waitingForServiceConfig = true;
    private final boolean lookUpServiceConfig;
    private final RetriableStream.ChannelBufferMeter channelBufferUsed = new RetriableStream.ChannelBufferMeter();
    @Nullable
    private RetriableStream.Throttle throttle;
    private final long perRpcBufferLimit;
    private final long channelBufferLimit;
    private final boolean retryEnabled;
    private final ManagedClientTransport.Listener delayedTransportListener = new DelayedTransportListener();
    @VisibleForTesting
    final InUseStateAggregator<Object> inUseStateAggregator = new IdleModeStateAggregator();
    @Nullable
    private SynchronizationContext.ScheduledHandle scheduledNameResolverRefresh;
    @Nullable
    private BackoffPolicy nameResolverBackoffPolicy;
    private final ClientCallImpl.ClientTransportProvider transportProvider = new ChannelTransportProvider();
    private final Rescheduler idleTimer;

    private void maybeShutdownNowSubchannels() {
        if (this.shutdownNowed) {
            for (InternalSubchannel subchannel : this.subchannels) {
                subchannel.shutdownNow(SHUTDOWN_NOW_STATUS);
            }
            for (OobChannel oobChannel : this.oobChannels) {
                oobChannel.getInternalSubchannel().shutdownNow(SHUTDOWN_NOW_STATUS);
            }
        }
    }

    @Override
    public ListenableFuture<InternalChannelz.ChannelStats> getStats() {
        final SettableFuture<InternalChannelz.ChannelStats> ret = SettableFuture.create();
        final class StatsFetcher
        implements Runnable {
            StatsFetcher() {
            }

            @Override
            public void run() {
                InternalChannelz.ChannelStats.Builder builder = new InternalChannelz.ChannelStats.Builder();
                ManagedChannelImpl.this.channelCallTracer.updateBuilder(builder);
                ManagedChannelImpl.this.channelTracer.updateBuilder(builder);
                builder.setTarget(ManagedChannelImpl.this.target).setState(ManagedChannelImpl.this.channelStateManager.getState());
                ArrayList<InternalWithLogId> children = new ArrayList<InternalWithLogId>();
                children.addAll(ManagedChannelImpl.this.subchannels);
                children.addAll(ManagedChannelImpl.this.oobChannels);
                builder.setSubchannels(children);
                ret.set(builder.build());
            }
        }
        this.syncContext.execute(new StatsFetcher());
        return ret;
    }

    @Override
    public InternalLogId getLogId() {
        return this.logId;
    }

    private void shutdownNameResolverAndLoadBalancer(boolean channelIsActive) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (channelIsActive) {
            Preconditions.checkState(this.nameResolverStarted, "nameResolver is not started");
            Preconditions.checkState(this.lbHelper != null, "lbHelper is null");
        }
        if (this.nameResolver != null) {
            this.cancelNameResolverBackoff();
            this.nameResolver.shutdown();
            this.nameResolverStarted = false;
            this.nameResolver = channelIsActive ? ManagedChannelImpl.getNameResolver(this.target, this.nameResolverFactory, this.nameResolverArgs) : null;
        }
        if (this.lbHelper != null) {
            this.lbHelper.lb.shutdown();
            this.lbHelper = null;
        }
        this.subchannelPicker = null;
    }

    @VisibleForTesting
    void exitIdleMode() {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (this.shutdown.get() || this.panicMode) {
            return;
        }
        if (this.inUseStateAggregator.isInUse()) {
            this.cancelIdleTimer(false);
        } else {
            this.rescheduleIdleTimer();
        }
        if (this.lbHelper != null) {
            return;
        }
        this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Exiting idle mode");
        LbHelperImpl lbHelper = new LbHelperImpl();
        lbHelper.lb = this.loadBalancerFactory.newLoadBalancer(lbHelper);
        this.lbHelper = lbHelper;
        NameResolverListener listener = new NameResolverListener(lbHelper, this.nameResolver);
        this.nameResolver.start(listener);
        this.nameResolverStarted = true;
    }

    private void enterIdleMode() {
        this.shutdownNameResolverAndLoadBalancer(true);
        this.delayedTransport.reprocess(null);
        this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Entering IDLE state");
        this.channelStateManager.gotoState(ConnectivityState.IDLE);
        if (this.inUseStateAggregator.isInUse()) {
            this.exitIdleMode();
        }
    }

    private void cancelIdleTimer(boolean permanent) {
        this.idleTimer.cancel(permanent);
    }

    private void rescheduleIdleTimer() {
        if (this.idleTimeoutMillis == -1L) {
            return;
        }
        this.idleTimer.reschedule(this.idleTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    private void cancelNameResolverBackoff() {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (this.scheduledNameResolverRefresh != null) {
            this.scheduledNameResolverRefresh.cancel();
            this.scheduledNameResolverRefresh = null;
            this.nameResolverBackoffPolicy = null;
        }
    }

    private void refreshAndResetNameResolution() {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        this.cancelNameResolverBackoff();
        this.refreshNameResolution();
    }

    private void refreshNameResolution() {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (this.nameResolverStarted) {
            this.nameResolver.refresh();
        }
    }

    ManagedChannelImpl(AbstractManagedChannelImplBuilder<?> builder, ClientTransportFactory clientTransportFactory, BackoffPolicy.Provider backoffPolicyProvider, ObjectPool<? extends Executor> balancerRpcExecutorPool, Supplier<Stopwatch> stopwatchSupplier, List<ClientInterceptor> interceptors, final TimeProvider timeProvider) {
        this.target = Preconditions.checkNotNull(builder.target, "target");
        this.logId = InternalLogId.allocate("Channel", this.target);
        this.nameResolverFactory = builder.getNameResolverFactory();
        ProxyDetector proxyDetector = builder.proxyDetector != null ? builder.proxyDetector : GrpcUtil.getDefaultProxyDetector();
        this.retryEnabled = builder.retryEnabled && !builder.temporarilyDisableRetry;
        this.loadBalancerFactory = new AutoConfiguredLoadBalancerFactory(builder.defaultLbPolicy);
        this.nameResolverRegistry = builder.nameResolverRegistry;
        this.nameResolverArgs = NameResolver.Args.newBuilder().setDefaultPort(builder.getDefaultPort()).setProxyDetector(proxyDetector).setSynchronizationContext(this.syncContext).setServiceConfigParser(new ScParser(this.retryEnabled, builder.maxRetryAttempts, builder.maxHedgedAttempts, this.loadBalancerFactory)).build();
        this.nameResolver = ManagedChannelImpl.getNameResolver(this.target, this.nameResolverFactory, this.nameResolverArgs);
        this.timeProvider = Preconditions.checkNotNull(timeProvider, "timeProvider");
        this.maxTraceEvents = builder.maxTraceEvents;
        this.channelTracer = new ChannelTracer(this.logId, builder.maxTraceEvents, timeProvider.currentTimeNanos(), "Channel for '" + this.target + "'");
        this.channelLogger = new ChannelLoggerImpl(this.channelTracer, timeProvider);
        this.executorPool = Preconditions.checkNotNull(builder.executorPool, "executorPool");
        this.balancerRpcExecutorPool = Preconditions.checkNotNull(balancerRpcExecutorPool, "balancerRpcExecutorPool");
        this.balancerRpcExecutorHolder = new ExecutorHolder(balancerRpcExecutorPool);
        this.executor = Preconditions.checkNotNull(this.executorPool.getObject(), "executor");
        this.delayedTransport = new DelayedClientTransport(this.executor, this.syncContext);
        this.delayedTransport.start(this.delayedTransportListener);
        this.backoffPolicyProvider = backoffPolicyProvider;
        this.transportFactory = new CallCredentialsApplyingTransportFactory(clientTransportFactory, this.executor);
        this.scheduledExecutorForBalancer = new ScheduledExecutorForBalancer(this.transportFactory.getScheduledExecutorService());
        this.serviceConfigInterceptor = new ServiceConfigInterceptor(this.retryEnabled, builder.maxRetryAttempts, builder.maxHedgedAttempts);
        this.defaultServiceConfig = builder.defaultServiceConfig;
        this.lastServiceConfig = this.defaultServiceConfig;
        this.lookUpServiceConfig = builder.lookUpServiceConfig;
        Channel channel = new RealChannel(this.nameResolver.getServiceAuthority());
        channel = ClientInterceptors.intercept(channel, this.serviceConfigInterceptor);
        if (builder.binlog != null) {
            channel = builder.binlog.wrapChannel(channel);
        }
        this.interceptorChannel = ClientInterceptors.intercept(channel, interceptors);
        this.stopwatchSupplier = Preconditions.checkNotNull(stopwatchSupplier, "stopwatchSupplier");
        if (builder.idleTimeoutMillis == -1L) {
            this.idleTimeoutMillis = builder.idleTimeoutMillis;
        } else {
            Preconditions.checkArgument(builder.idleTimeoutMillis >= AbstractManagedChannelImplBuilder.IDLE_MODE_MIN_TIMEOUT_MILLIS, "invalid idleTimeoutMillis %s", builder.idleTimeoutMillis);
            this.idleTimeoutMillis = builder.idleTimeoutMillis;
        }
        this.idleTimer = new Rescheduler(new IdleModeTimer(), this.syncContext, this.transportFactory.getScheduledExecutorService(), stopwatchSupplier.get());
        this.fullStreamDecompression = builder.fullStreamDecompression;
        this.decompressorRegistry = Preconditions.checkNotNull(builder.decompressorRegistry, "decompressorRegistry");
        this.compressorRegistry = Preconditions.checkNotNull(builder.compressorRegistry, "compressorRegistry");
        this.userAgent = builder.userAgent;
        this.channelBufferLimit = builder.retryBufferSize;
        this.perRpcBufferLimit = builder.perRpcBufferLimit;
        final class ChannelCallTracerFactory
        implements CallTracer.Factory {
            ChannelCallTracerFactory() {
            }

            @Override
            public CallTracer create() {
                return new CallTracer(timeProvider);
            }
        }
        this.callTracerFactory = new ChannelCallTracerFactory();
        this.channelCallTracer = this.callTracerFactory.create();
        this.channelz = Preconditions.checkNotNull(builder.channelz);
        this.channelz.addRootChannel(this);
        if (!this.lookUpServiceConfig) {
            if (this.defaultServiceConfig != null) {
                this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Service config look-up disabled, using default service config");
            }
            this.handleServiceConfigUpdate();
        }
    }

    private void handleServiceConfigUpdate() {
        this.waitingForServiceConfig = false;
        this.serviceConfigInterceptor.handleUpdate(this.lastServiceConfig);
        if (this.retryEnabled) {
            this.throttle = ServiceConfigUtil.getThrottlePolicy(this.lastServiceConfig);
        }
    }

    @VisibleForTesting
    static NameResolver getNameResolver(String target, NameResolver.Factory nameResolverFactory, NameResolver.Args nameResolverArgs) {
        NameResolver resolver;
        URI targetUri = null;
        StringBuilder uriSyntaxErrors = new StringBuilder();
        try {
            targetUri = new URI(target);
        }
        catch (URISyntaxException e) {
            uriSyntaxErrors.append(e.getMessage());
        }
        if (targetUri != null && (resolver = nameResolverFactory.newNameResolver(targetUri, nameResolverArgs)) != null) {
            return resolver;
        }
        if (!URI_PATTERN.matcher(target).matches()) {
            try {
                targetUri = new URI(nameResolverFactory.getDefaultScheme(), "", "/" + target, null);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            resolver = nameResolverFactory.newNameResolver(targetUri, nameResolverArgs);
            if (resolver != null) {
                return resolver;
            }
        }
        throw new IllegalArgumentException(String.format("cannot find a NameResolver for %s%s", target, uriSyntaxErrors.length() > 0 ? " (" + uriSyntaxErrors + ")" : ""));
    }

    @Override
    public ManagedChannelImpl shutdown() {
        this.channelLogger.log(ChannelLogger.ChannelLogLevel.DEBUG, "shutdown() called");
        if (!this.shutdown.compareAndSet(false, true)) {
            return this;
        }
        final class Shutdown
        implements Runnable {
            Shutdown() {
            }

            @Override
            public void run() {
                ManagedChannelImpl.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Entering SHUTDOWN state");
                ManagedChannelImpl.this.channelStateManager.gotoState(ConnectivityState.SHUTDOWN);
            }
        }
        this.syncContext.executeLater(new Shutdown());
        this.uncommittedRetriableStreamsRegistry.onShutdown(SHUTDOWN_STATUS);
        final class CancelIdleTimer
        implements Runnable {
            CancelIdleTimer() {
            }

            @Override
            public void run() {
                ManagedChannelImpl.this.cancelIdleTimer(true);
            }
        }
        this.syncContext.execute(new CancelIdleTimer());
        return this;
    }

    @Override
    public ManagedChannelImpl shutdownNow() {
        this.channelLogger.log(ChannelLogger.ChannelLogLevel.DEBUG, "shutdownNow() called");
        this.shutdown();
        this.uncommittedRetriableStreamsRegistry.onShutdownNow(SHUTDOWN_NOW_STATUS);
        final class ShutdownNow
        implements Runnable {
            ShutdownNow() {
            }

            @Override
            public void run() {
                if (ManagedChannelImpl.this.shutdownNowed) {
                    return;
                }
                ManagedChannelImpl.this.shutdownNowed = true;
                ManagedChannelImpl.this.maybeShutdownNowSubchannels();
            }
        }
        this.syncContext.execute(new ShutdownNow());
        return this;
    }

    @VisibleForTesting
    void panic(final Throwable t) {
        if (this.panicMode) {
            return;
        }
        this.panicMode = true;
        this.cancelIdleTimer(true);
        this.shutdownNameResolverAndLoadBalancer(false);
        final class PanicSubchannelPicker
        extends LoadBalancer.SubchannelPicker {
            private final LoadBalancer.PickResult panicPickResult;

            PanicSubchannelPicker() {
                this.panicPickResult = LoadBalancer.PickResult.withDrop(Status.INTERNAL.withDescription("Panic! This is a bug!").withCause(t));
            }

            @Override
            public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
                return this.panicPickResult;
            }
        }
        this.updateSubchannelPicker(new PanicSubchannelPicker());
        this.channelLogger.log(ChannelLogger.ChannelLogLevel.ERROR, "PANIC! Entering TRANSIENT_FAILURE");
        this.channelStateManager.gotoState(ConnectivityState.TRANSIENT_FAILURE);
    }

    @VisibleForTesting
    boolean isInPanicMode() {
        return this.panicMode;
    }

    private void updateSubchannelPicker(LoadBalancer.SubchannelPicker newPicker) {
        this.subchannelPicker = newPicker;
        this.delayedTransport.reprocess(newPicker);
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.terminatedLatch.await(timeout, unit);
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions) {
        return this.interceptorChannel.newCall(method, callOptions);
    }

    @Override
    public String authority() {
        return this.interceptorChannel.authority();
    }

    private Executor getCallExecutor(CallOptions callOptions) {
        Executor executor = callOptions.getExecutor();
        if (executor == null) {
            executor = this.executor;
        }
        return executor;
    }

    private void maybeTerminateChannel() {
        if (this.terminated) {
            return;
        }
        if (this.shutdown.get() && this.subchannels.isEmpty() && this.oobChannels.isEmpty()) {
            this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Terminated");
            this.channelz.removeRootChannel(this);
            this.terminated = true;
            this.terminatedLatch.countDown();
            this.executorPool.returnObject(this.executor);
            this.balancerRpcExecutorHolder.release();
            this.transportFactory.close();
        }
    }

    private void handleInternalSubchannelState(ConnectivityStateInfo newState) {
        if (newState.getState() == ConnectivityState.TRANSIENT_FAILURE || newState.getState() == ConnectivityState.IDLE) {
            this.refreshAndResetNameResolution();
        }
    }

    @Override
    public ConnectivityState getState(boolean requestConnection) {
        ConnectivityState savedChannelState = this.channelStateManager.getState();
        if (requestConnection && savedChannelState == ConnectivityState.IDLE) {
            final class RequestConnection
            implements Runnable {
                RequestConnection() {
                }

                @Override
                public void run() {
                    ManagedChannelImpl.this.exitIdleMode();
                    if (ManagedChannelImpl.this.subchannelPicker != null) {
                        ManagedChannelImpl.this.subchannelPicker.requestConnection();
                    }
                    if (ManagedChannelImpl.this.lbHelper != null) {
                        ((ManagedChannelImpl)ManagedChannelImpl.this).lbHelper.lb.requestConnection();
                    }
                }
            }
            this.syncContext.execute(new RequestConnection());
        }
        return savedChannelState;
    }

    @Override
    public void notifyWhenStateChanged(final ConnectivityState source, final Runnable callback) {
        final class NotifyStateChanged
        implements Runnable {
            NotifyStateChanged() {
            }

            @Override
            public void run() {
                ManagedChannelImpl.this.channelStateManager.notifyWhenStateChanged(callback, ManagedChannelImpl.this.executor, source);
            }
        }
        this.syncContext.execute(new NotifyStateChanged());
    }

    @Override
    public void resetConnectBackoff() {
        final class ResetConnectBackoff
        implements Runnable {
            ResetConnectBackoff() {
            }

            @Override
            public void run() {
                if (ManagedChannelImpl.this.shutdown.get()) {
                    return;
                }
                if (ManagedChannelImpl.this.scheduledNameResolverRefresh != null && ManagedChannelImpl.this.scheduledNameResolverRefresh.isPending()) {
                    Preconditions.checkState(ManagedChannelImpl.this.nameResolverStarted, "name resolver must be started");
                    ManagedChannelImpl.this.refreshAndResetNameResolution();
                }
                for (InternalSubchannel subchannel : ManagedChannelImpl.this.subchannels) {
                    subchannel.resetConnectBackoff();
                }
                for (OobChannel oobChannel : ManagedChannelImpl.this.oobChannels) {
                    oobChannel.resetConnectBackoff();
                }
            }
        }
        this.syncContext.execute(new ResetConnectBackoff());
    }

    @Override
    public void enterIdle() {
        final class PrepareToLoseNetworkRunnable
        implements Runnable {
            PrepareToLoseNetworkRunnable() {
            }

            @Override
            public void run() {
                if (ManagedChannelImpl.this.shutdown.get() || ManagedChannelImpl.this.lbHelper == null) {
                    return;
                }
                ManagedChannelImpl.this.cancelIdleTimer(false);
                ManagedChannelImpl.this.enterIdleMode();
            }
        }
        this.syncContext.execute(new PrepareToLoseNetworkRunnable());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("logId", this.logId.getId()).add("target", this.target).toString();
    }

    private void logWarningIfNotInSyncContext(String method) {
        try {
            this.syncContext.throwIfNotInThisSynchronizationContext();
        }
        catch (IllegalStateException e) {
            logger.log(Level.WARNING, method + " should be called from SynchronizationContext. This warning will become an exception in a future release. See https://github.com/grpc/grpc-java/issues/5015 for more details", e);
        }
    }

    @VisibleForTesting
    static final class ScParser
    extends NameResolver.ServiceConfigParser {
        private final boolean retryEnabled;
        private final int maxRetryAttemptsLimit;
        private final int maxHedgedAttemptsLimit;
        private final AutoConfiguredLoadBalancerFactory autoLoadBalancerFactory;

        ScParser(boolean retryEnabled, int maxRetryAttemptsLimit, int maxHedgedAttemptsLimit, AutoConfiguredLoadBalancerFactory autoLoadBalancerFactory) {
            this.retryEnabled = retryEnabled;
            this.maxRetryAttemptsLimit = maxRetryAttemptsLimit;
            this.maxHedgedAttemptsLimit = maxHedgedAttemptsLimit;
            this.autoLoadBalancerFactory = Preconditions.checkNotNull(autoLoadBalancerFactory, "autoLoadBalancerFactory");
        }

        @Override
        public NameResolver.ConfigOrError parseServiceConfig(Map<String, ?> rawServiceConfig) {
            try {
                Object loadBalancingPolicySelection;
                NameResolver.ConfigOrError choiceFromLoadBalancer = this.autoLoadBalancerFactory.selectLoadBalancerPolicy(rawServiceConfig);
                if (choiceFromLoadBalancer == null) {
                    loadBalancingPolicySelection = null;
                } else {
                    if (choiceFromLoadBalancer.getError() != null) {
                        return NameResolver.ConfigOrError.fromError(choiceFromLoadBalancer.getError());
                    }
                    loadBalancingPolicySelection = choiceFromLoadBalancer.getConfig();
                }
                return NameResolver.ConfigOrError.fromConfig(ManagedChannelServiceConfig.fromServiceConfig(rawServiceConfig, this.retryEnabled, this.maxRetryAttemptsLimit, this.maxHedgedAttemptsLimit, loadBalancingPolicySelection));
            }
            catch (RuntimeException e) {
                return NameResolver.ConfigOrError.fromError(Status.UNKNOWN.withDescription("failed to parse service config").withCause(e));
            }
        }
    }

    private static final class ScheduledExecutorForBalancer
    implements ScheduledExecutorService {
        final ScheduledExecutorService delegate;

        private ScheduledExecutorForBalancer(ScheduledExecutorService delegate) {
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable2, long delay, TimeUnit unit) {
            return this.delegate.schedule(callable2, delay, unit);
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable cmd, long delay, TimeUnit unit) {
            return this.delegate.schedule(cmd, delay, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return this.delegate.scheduleAtFixedRate(command, initialDelay, period, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this.delegate.scheduleWithFixedDelay(command, initialDelay, delay, unit);
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.awaitTermination(timeout, unit);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return this.delegate.invokeAll(tasks);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.invokeAll(tasks, timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return this.delegate.invokeAny(tasks);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.delegate.invokeAny(tasks, timeout, unit);
        }

        @Override
        public boolean isShutdown() {
            return this.delegate.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.delegate.isTerminated();
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException("Restricted: shutdown() is not allowed");
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException("Restricted: shutdownNow() is not allowed");
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return this.delegate.submit(task);
        }

        @Override
        public Future<?> submit(Runnable task) {
            return this.delegate.submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result2) {
            return this.delegate.submit(task, result2);
        }

        @Override
        public void execute(Runnable command) {
            this.delegate.execute(command);
        }
    }

    private static final class ExecutorHolder {
        private final ObjectPool<? extends Executor> pool;
        private Executor executor;

        ExecutorHolder(ObjectPool<? extends Executor> executorPool) {
            this.pool = Preconditions.checkNotNull(executorPool, "executorPool");
        }

        synchronized Executor getExecutor() {
            if (this.executor == null) {
                this.executor = Preconditions.checkNotNull(this.pool.getObject(), "%s.getObject()", (Object)this.executor);
            }
            return this.executor;
        }

        synchronized void release() {
            if (this.executor != null) {
                this.executor = this.pool.returnObject(this.executor);
            }
        }
    }

    private final class IdleModeStateAggregator
    extends InUseStateAggregator<Object> {
        private IdleModeStateAggregator() {
        }

        @Override
        protected void handleInUse() {
            ManagedChannelImpl.this.exitIdleMode();
        }

        @Override
        protected void handleNotInUse() {
            if (ManagedChannelImpl.this.shutdown.get()) {
                return;
            }
            ManagedChannelImpl.this.rescheduleIdleTimer();
        }
    }

    private final class DelayedTransportListener
    implements ManagedClientTransport.Listener {
        private DelayedTransportListener() {
        }

        @Override
        public void transportShutdown(Status s) {
            Preconditions.checkState(ManagedChannelImpl.this.shutdown.get(), "Channel must have been shut down");
        }

        @Override
        public void transportReady() {
        }

        @Override
        public void transportInUse(boolean inUse) {
            ManagedChannelImpl.this.inUseStateAggregator.updateObjectInUse(ManagedChannelImpl.this.delayedTransport, inUse);
        }

        @Override
        public void transportTerminated() {
            Preconditions.checkState(ManagedChannelImpl.this.shutdown.get(), "Channel must have been shut down");
            ManagedChannelImpl.this.terminating = true;
            ManagedChannelImpl.this.shutdownNameResolverAndLoadBalancer(false);
            ManagedChannelImpl.this.maybeShutdownNowSubchannels();
            ManagedChannelImpl.this.maybeTerminateChannel();
        }
    }

    private final class SubchannelImpl
    extends AbstractSubchannel {
        final LoadBalancer.CreateSubchannelArgs args;
        final LbHelperImpl helper;
        final InternalLogId subchannelLogId;
        final ChannelLoggerImpl subchannelLogger;
        final ChannelTracer subchannelTracer;
        LoadBalancer.SubchannelStateListener listener;
        InternalSubchannel subchannel;
        boolean started;
        boolean shutdown;
        SynchronizationContext.ScheduledHandle delayedShutdownTask;

        SubchannelImpl(LoadBalancer.CreateSubchannelArgs args, LbHelperImpl helper) {
            this.args = Preconditions.checkNotNull(args, "args");
            this.helper = Preconditions.checkNotNull(helper, "helper");
            this.subchannelLogId = InternalLogId.allocate("Subchannel", ManagedChannelImpl.this.authority());
            this.subchannelTracer = new ChannelTracer(this.subchannelLogId, ManagedChannelImpl.this.maxTraceEvents, ManagedChannelImpl.this.timeProvider.currentTimeNanos(), "Subchannel for " + args.getAddresses());
            this.subchannelLogger = new ChannelLoggerImpl(this.subchannelTracer, ManagedChannelImpl.this.timeProvider);
        }

        private void internalStart(final LoadBalancer.SubchannelStateListener listener) {
            Preconditions.checkState(!this.started, "already started");
            Preconditions.checkState(!this.shutdown, "already shutdown");
            this.started = true;
            this.listener = listener;
            if (ManagedChannelImpl.this.terminating) {
                ManagedChannelImpl.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.onSubchannelState(ConnectivityStateInfo.forNonError(ConnectivityState.SHUTDOWN));
                    }
                });
                return;
            }
            final class ManagedInternalSubchannelCallback
            extends InternalSubchannel.Callback {
                ManagedInternalSubchannelCallback() {
                }

                @Override
                void onTerminated(InternalSubchannel is) {
                    ManagedChannelImpl.this.subchannels.remove(is);
                    ManagedChannelImpl.this.channelz.removeSubchannel(is);
                    ManagedChannelImpl.this.maybeTerminateChannel();
                }

                @Override
                void onStateChange(InternalSubchannel is, ConnectivityStateInfo newState) {
                    ManagedChannelImpl.this.handleInternalSubchannelState(newState);
                    Preconditions.checkState(listener != null, "listener is null");
                    listener.onSubchannelState(newState);
                }

                @Override
                void onInUse(InternalSubchannel is) {
                    ManagedChannelImpl.this.inUseStateAggregator.updateObjectInUse(is, true);
                }

                @Override
                void onNotInUse(InternalSubchannel is) {
                    ManagedChannelImpl.this.inUseStateAggregator.updateObjectInUse(is, false);
                }
            }
            final InternalSubchannel internalSubchannel = new InternalSubchannel(this.args.getAddresses(), ManagedChannelImpl.this.authority(), ManagedChannelImpl.this.userAgent, ManagedChannelImpl.this.backoffPolicyProvider, ManagedChannelImpl.this.transportFactory, ManagedChannelImpl.this.transportFactory.getScheduledExecutorService(), ManagedChannelImpl.this.stopwatchSupplier, ManagedChannelImpl.this.syncContext, new ManagedInternalSubchannelCallback(), ManagedChannelImpl.this.channelz, ManagedChannelImpl.this.callTracerFactory.create(), this.subchannelTracer, this.subchannelLogId, this.subchannelLogger);
            ManagedChannelImpl.this.channelTracer.reportEvent(new InternalChannelz.ChannelTrace.Event.Builder().setDescription("Child Subchannel started").setSeverity(InternalChannelz.ChannelTrace.Event.Severity.CT_INFO).setTimestampNanos(ManagedChannelImpl.this.timeProvider.currentTimeNanos()).setSubchannelRef(internalSubchannel).build());
            this.subchannel = internalSubchannel;
            ManagedChannelImpl.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    ManagedChannelImpl.this.channelz.addSubchannel(internalSubchannel);
                    ManagedChannelImpl.this.subchannels.add(internalSubchannel);
                }
            });
        }

        @Override
        public void start(LoadBalancer.SubchannelStateListener listener) {
            ManagedChannelImpl.this.syncContext.throwIfNotInThisSynchronizationContext();
            this.internalStart(listener);
        }

        @Override
        InternalInstrumented<InternalChannelz.ChannelStats> getInstrumentedInternalSubchannel() {
            Preconditions.checkState(this.started, "not started");
            return this.subchannel;
        }

        @Override
        public void shutdown() {
            ManagedChannelImpl.this.logWarningIfNotInSyncContext("Subchannel.shutdown()");
            ManagedChannelImpl.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    SubchannelImpl.this.internalShutdown();
                }
            });
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void internalShutdown() {
            ManagedChannelImpl.this.syncContext.throwIfNotInThisSynchronizationContext();
            if (this.subchannel == null) {
                this.shutdown = true;
                return;
            }
            if (this.shutdown) {
                if (!ManagedChannelImpl.this.terminating || this.delayedShutdownTask == null) return;
                this.delayedShutdownTask.cancel();
                this.delayedShutdownTask = null;
            } else {
                this.shutdown = true;
            }
            if (!ManagedChannelImpl.this.terminating) {
                final class ShutdownSubchannel
                implements Runnable {
                    ShutdownSubchannel() {
                    }

                    @Override
                    public void run() {
                        SubchannelImpl.this.subchannel.shutdown(SUBCHANNEL_SHUTDOWN_STATUS);
                    }
                }
                this.delayedShutdownTask = ManagedChannelImpl.this.syncContext.schedule(new LogExceptionRunnable(new ShutdownSubchannel()), 5L, TimeUnit.SECONDS, ManagedChannelImpl.this.transportFactory.getScheduledExecutorService());
                return;
            }
            this.subchannel.shutdown(SHUTDOWN_STATUS);
        }

        @Override
        public void requestConnection() {
            ManagedChannelImpl.this.logWarningIfNotInSyncContext("Subchannel.requestConnection()");
            Preconditions.checkState(this.started, "not started");
            this.subchannel.obtainActiveTransport();
        }

        @Override
        public List<EquivalentAddressGroup> getAllAddresses() {
            ManagedChannelImpl.this.logWarningIfNotInSyncContext("Subchannel.getAllAddresses()");
            Preconditions.checkState(this.started, "not started");
            return this.subchannel.getAddressGroups();
        }

        @Override
        public Attributes getAttributes() {
            return this.args.getAttributes();
        }

        public String toString() {
            return this.subchannelLogId.toString();
        }

        @Override
        public Channel asChannel() {
            Preconditions.checkState(this.started, "not started");
            return new SubchannelChannel(this.subchannel, ManagedChannelImpl.this.balancerRpcExecutorHolder.getExecutor(), ManagedChannelImpl.this.transportFactory.getScheduledExecutorService(), ManagedChannelImpl.this.callTracerFactory.create());
        }

        @Override
        public Object getInternalSubchannel() {
            Preconditions.checkState(this.started, "Subchannel is not started");
            return this.subchannel;
        }

        @Override
        public ChannelLogger getChannelLogger() {
            return this.subchannelLogger;
        }

        @Override
        public void updateAddresses(List<EquivalentAddressGroup> addrs) {
            ManagedChannelImpl.this.syncContext.throwIfNotInThisSynchronizationContext();
            this.subchannel.updateAddresses(addrs);
        }
    }

    private final class NameResolverListener
    extends NameResolver.Listener2 {
        final LbHelperImpl helper;
        final NameResolver resolver;

        NameResolverListener(LbHelperImpl helperImpl, NameResolver resolver) {
            this.helper = Preconditions.checkNotNull(helperImpl, "helperImpl");
            this.resolver = Preconditions.checkNotNull(resolver, "resolver");
        }

        @Override
        public void onResult(final NameResolver.ResolutionResult resolutionResult) {
            final class NamesResolved
            implements Runnable {
                NamesResolved() {
                }

                @Override
                public void run() {
                    Map effectiveServiceConfig;
                    List<EquivalentAddressGroup> servers = resolutionResult.getAddresses();
                    Attributes attrs = resolutionResult.getAttributes();
                    ManagedChannelImpl.this.channelLogger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Resolved address: {0}, config={1}", servers, attrs);
                    if (ManagedChannelImpl.this.haveBackends == null || !ManagedChannelImpl.this.haveBackends.booleanValue()) {
                        ManagedChannelImpl.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Address resolved: {0}", servers);
                        ManagedChannelImpl.this.haveBackends = true;
                    }
                    ManagedChannelImpl.this.nameResolverBackoffPolicy = null;
                    Map serviceConfig = attrs.get(GrpcAttributes.NAME_RESOLVER_SERVICE_CONFIG);
                    if (!ManagedChannelImpl.this.lookUpServiceConfig) {
                        if (serviceConfig != null) {
                            ManagedChannelImpl.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Service config from name resolver discarded by channel settings");
                        }
                        effectiveServiceConfig = ManagedChannelImpl.this.defaultServiceConfig;
                    } else {
                        if (serviceConfig != null) {
                            effectiveServiceConfig = serviceConfig;
                        } else {
                            effectiveServiceConfig = ManagedChannelImpl.this.defaultServiceConfig;
                            if (ManagedChannelImpl.this.defaultServiceConfig != null) {
                                ManagedChannelImpl.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Received no service config, using default service config");
                            }
                        }
                        if (effectiveServiceConfig != ManagedChannelImpl.this.lastServiceConfig) {
                            ManagedChannelImpl.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Service config changed{0}", effectiveServiceConfig == null ? " to null" : "");
                            ManagedChannelImpl.this.lastServiceConfig = effectiveServiceConfig;
                        }
                        try {
                            ManagedChannelImpl.this.handleServiceConfigUpdate();
                        }
                        catch (RuntimeException re) {
                            logger.log(Level.WARNING, "[" + ManagedChannelImpl.this.getLogId() + "] Unexpected exception from parsing service config", re);
                        }
                    }
                    if (NameResolverListener.this.helper == ManagedChannelImpl.this.lbHelper) {
                        Status handleResult;
                        Attributes effectiveAttrs = attrs;
                        if (effectiveServiceConfig != serviceConfig) {
                            effectiveAttrs = attrs.toBuilder().set(GrpcAttributes.NAME_RESOLVER_SERVICE_CONFIG, effectiveServiceConfig).build();
                        }
                        if (!(handleResult = NameResolverListener.this.helper.lb.tryHandleResolvedAddresses(LoadBalancer.ResolvedAddresses.newBuilder().setAddresses(servers).setAttributes(effectiveAttrs).build())).isOk()) {
                            NameResolverListener.this.handleErrorInSyncContext(handleResult.augmentDescription(NameResolverListener.this.resolver + " was used"));
                        }
                    }
                }
            }
            ManagedChannelImpl.this.syncContext.execute(new NamesResolved());
        }

        @Override
        public void onError(final Status error) {
            Preconditions.checkArgument(!error.isOk(), "the error status must not be OK");
            final class NameResolverErrorHandler
            implements Runnable {
                NameResolverErrorHandler() {
                }

                @Override
                public void run() {
                    NameResolverListener.this.handleErrorInSyncContext(error);
                }
            }
            ManagedChannelImpl.this.syncContext.execute(new NameResolverErrorHandler());
        }

        private void handleErrorInSyncContext(Status error) {
            logger.log(Level.WARNING, "[{0}] Failed to resolve name. status={1}", new Object[]{ManagedChannelImpl.this.getLogId(), error});
            if (ManagedChannelImpl.this.haveBackends == null || ManagedChannelImpl.this.haveBackends.booleanValue()) {
                ManagedChannelImpl.this.channelLogger.log(ChannelLogger.ChannelLogLevel.WARNING, "Failed to resolve name: {0}", error);
                ManagedChannelImpl.this.haveBackends = false;
            }
            if (this.helper != ManagedChannelImpl.this.lbHelper) {
                return;
            }
            this.helper.lb.handleNameResolutionError(error);
            if (ManagedChannelImpl.this.scheduledNameResolverRefresh != null && ManagedChannelImpl.this.scheduledNameResolverRefresh.isPending()) {
                return;
            }
            if (ManagedChannelImpl.this.nameResolverBackoffPolicy == null) {
                ManagedChannelImpl.this.nameResolverBackoffPolicy = ManagedChannelImpl.this.backoffPolicyProvider.get();
            }
            long delayNanos = ManagedChannelImpl.this.nameResolverBackoffPolicy.nextBackoffNanos();
            ManagedChannelImpl.this.channelLogger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Scheduling DNS resolution backoff for {0} ns", delayNanos);
            ManagedChannelImpl.this.scheduledNameResolverRefresh = ManagedChannelImpl.this.syncContext.schedule(new DelayedNameResolverRefresh(), delayNanos, TimeUnit.NANOSECONDS, ManagedChannelImpl.this.transportFactory.getScheduledExecutorService());
        }
    }

    private class LbHelperImpl
    extends LoadBalancer.Helper {
        AutoConfiguredLoadBalancerFactory.AutoConfiguredLoadBalancer lb;

        private LbHelperImpl() {
        }

        @Override
        @Deprecated
        public AbstractSubchannel createSubchannel(List<EquivalentAddressGroup> addressGroups, Attributes attrs) {
            ManagedChannelImpl.this.logWarningIfNotInSyncContext("createSubchannel()");
            Preconditions.checkNotNull(addressGroups, "addressGroups");
            Preconditions.checkNotNull(attrs, "attrs");
            final SubchannelImpl subchannel = this.createSubchannelInternal(LoadBalancer.CreateSubchannelArgs.newBuilder().setAddresses(addressGroups).setAttributes(attrs).build());
            LoadBalancer.SubchannelStateListener listener = new LoadBalancer.SubchannelStateListener(){

                @Override
                public void onSubchannelState(ConnectivityStateInfo newState) {
                    if (LbHelperImpl.this != ManagedChannelImpl.this.lbHelper) {
                        return;
                    }
                    LbHelperImpl.this.lb.handleSubchannelState(subchannel, newState);
                }
            };
            subchannel.internalStart(listener);
            return subchannel;
        }

        @Override
        public AbstractSubchannel createSubchannel(LoadBalancer.CreateSubchannelArgs args) {
            ManagedChannelImpl.this.syncContext.throwIfNotInThisSynchronizationContext();
            return this.createSubchannelInternal(args);
        }

        private SubchannelImpl createSubchannelInternal(LoadBalancer.CreateSubchannelArgs args) {
            Preconditions.checkState(!ManagedChannelImpl.this.terminated, "Channel is terminated");
            return new SubchannelImpl(args, this);
        }

        @Override
        public void updateBalancingState(final ConnectivityState newState, final LoadBalancer.SubchannelPicker newPicker) {
            Preconditions.checkNotNull(newState, "newState");
            Preconditions.checkNotNull(newPicker, "newPicker");
            ManagedChannelImpl.this.logWarningIfNotInSyncContext("updateBalancingState()");
            final class UpdateBalancingState
            implements Runnable {
                UpdateBalancingState() {
                }

                @Override
                public void run() {
                    if (LbHelperImpl.this != ManagedChannelImpl.this.lbHelper) {
                        return;
                    }
                    ManagedChannelImpl.this.updateSubchannelPicker(newPicker);
                    if (newState != ConnectivityState.SHUTDOWN) {
                        ManagedChannelImpl.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Entering {0} state", new Object[]{newState});
                        ManagedChannelImpl.this.channelStateManager.gotoState(newState);
                    }
                }
            }
            ManagedChannelImpl.this.syncContext.execute(new UpdateBalancingState());
        }

        @Override
        public void refreshNameResolution() {
            ManagedChannelImpl.this.logWarningIfNotInSyncContext("refreshNameResolution()");
            final class LoadBalancerRefreshNameResolution
            implements Runnable {
                LoadBalancerRefreshNameResolution() {
                }

                @Override
                public void run() {
                    ManagedChannelImpl.this.refreshAndResetNameResolution();
                }
            }
            ManagedChannelImpl.this.syncContext.execute(new LoadBalancerRefreshNameResolution());
        }

        @Override
        @Deprecated
        public void updateSubchannelAddresses(LoadBalancer.Subchannel subchannel, List<EquivalentAddressGroup> addrs) {
            Preconditions.checkArgument(subchannel instanceof SubchannelImpl, "subchannel must have been returned from createSubchannel");
            ManagedChannelImpl.this.logWarningIfNotInSyncContext("updateSubchannelAddresses()");
            ((InternalSubchannel)subchannel.getInternalSubchannel()).updateAddresses(addrs);
        }

        @Override
        public ManagedChannel createOobChannel(EquivalentAddressGroup addressGroup, String authority) {
            Preconditions.checkState(!ManagedChannelImpl.this.terminated, "Channel is terminated");
            long oobChannelCreationTime = ManagedChannelImpl.this.timeProvider.currentTimeNanos();
            InternalLogId oobLogId = InternalLogId.allocate("OobChannel", null);
            InternalLogId subchannelLogId = InternalLogId.allocate("Subchannel-OOB", authority);
            ChannelTracer oobChannelTracer = new ChannelTracer(oobLogId, ManagedChannelImpl.this.maxTraceEvents, oobChannelCreationTime, "OobChannel for " + addressGroup);
            final OobChannel oobChannel = new OobChannel(authority, ManagedChannelImpl.this.balancerRpcExecutorPool, ManagedChannelImpl.this.transportFactory.getScheduledExecutorService(), ManagedChannelImpl.this.syncContext, ManagedChannelImpl.this.callTracerFactory.create(), oobChannelTracer, ManagedChannelImpl.this.channelz, ManagedChannelImpl.this.timeProvider);
            ManagedChannelImpl.this.channelTracer.reportEvent(new InternalChannelz.ChannelTrace.Event.Builder().setDescription("Child OobChannel created").setSeverity(InternalChannelz.ChannelTrace.Event.Severity.CT_INFO).setTimestampNanos(oobChannelCreationTime).setChannelRef(oobChannel).build());
            ChannelTracer subchannelTracer = new ChannelTracer(subchannelLogId, ManagedChannelImpl.this.maxTraceEvents, oobChannelCreationTime, "Subchannel for " + addressGroup);
            ChannelLoggerImpl subchannelLogger = new ChannelLoggerImpl(subchannelTracer, ManagedChannelImpl.this.timeProvider);
            final class ManagedOobChannelCallback
            extends InternalSubchannel.Callback {
                ManagedOobChannelCallback() {
                }

                @Override
                void onTerminated(InternalSubchannel is) {
                    ManagedChannelImpl.this.oobChannels.remove(oobChannel);
                    ManagedChannelImpl.this.channelz.removeSubchannel(is);
                    oobChannel.handleSubchannelTerminated();
                    ManagedChannelImpl.this.maybeTerminateChannel();
                }

                @Override
                void onStateChange(InternalSubchannel is, ConnectivityStateInfo newState) {
                    ManagedChannelImpl.this.handleInternalSubchannelState(newState);
                    oobChannel.handleSubchannelStateChange(newState);
                }
            }
            InternalSubchannel internalSubchannel = new InternalSubchannel(Collections.singletonList(addressGroup), authority, ManagedChannelImpl.this.userAgent, ManagedChannelImpl.this.backoffPolicyProvider, ManagedChannelImpl.this.transportFactory, ManagedChannelImpl.this.transportFactory.getScheduledExecutorService(), ManagedChannelImpl.this.stopwatchSupplier, ManagedChannelImpl.this.syncContext, new ManagedOobChannelCallback(), ManagedChannelImpl.this.channelz, ManagedChannelImpl.this.callTracerFactory.create(), subchannelTracer, subchannelLogId, subchannelLogger);
            oobChannelTracer.reportEvent(new InternalChannelz.ChannelTrace.Event.Builder().setDescription("Child Subchannel created").setSeverity(InternalChannelz.ChannelTrace.Event.Severity.CT_INFO).setTimestampNanos(oobChannelCreationTime).setSubchannelRef(internalSubchannel).build());
            ManagedChannelImpl.this.channelz.addSubchannel(oobChannel);
            ManagedChannelImpl.this.channelz.addSubchannel(internalSubchannel);
            oobChannel.setSubchannel(internalSubchannel);
            final class AddOobChannel
            implements Runnable {
                AddOobChannel() {
                }

                @Override
                public void run() {
                    if (ManagedChannelImpl.this.terminating) {
                        oobChannel.shutdown();
                    }
                    if (!ManagedChannelImpl.this.terminated) {
                        ManagedChannelImpl.this.oobChannels.add(oobChannel);
                    }
                }
            }
            ManagedChannelImpl.this.syncContext.execute(new AddOobChannel());
            return oobChannel;
        }

        @Override
        public void updateOobChannelAddresses(ManagedChannel channel, EquivalentAddressGroup eag) {
            Preconditions.checkArgument(channel instanceof OobChannel, "channel must have been returned from createOobChannel");
            ((OobChannel)channel).updateAddresses(eag);
        }

        @Override
        public String getAuthority() {
            return ManagedChannelImpl.this.authority();
        }

        @Override
        @Deprecated
        public NameResolver.Factory getNameResolverFactory() {
            return ManagedChannelImpl.this.nameResolverFactory;
        }

        @Override
        public SynchronizationContext getSynchronizationContext() {
            return ManagedChannelImpl.this.syncContext;
        }

        @Override
        public ScheduledExecutorService getScheduledExecutorService() {
            return ManagedChannelImpl.this.scheduledExecutorForBalancer;
        }

        @Override
        public ChannelLogger getChannelLogger() {
            return ManagedChannelImpl.this.channelLogger;
        }

        @Override
        public NameResolver.Args getNameResolverArgs() {
            return ManagedChannelImpl.this.nameResolverArgs;
        }

        @Override
        public NameResolverRegistry getNameResolverRegistry() {
            return ManagedChannelImpl.this.nameResolverRegistry;
        }
    }

    private final class UncommittedRetriableStreamsRegistry {
        final Object lock = new Object();
        @GuardedBy(value="lock")
        Collection<ClientStream> uncommittedRetriableStreams = new HashSet<ClientStream>();
        @GuardedBy(value="lock")
        Status shutdownStatus;

        private UncommittedRetriableStreamsRegistry() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onShutdown(Status reason) {
            boolean shouldShutdownDelayedTransport = false;
            Object object = this.lock;
            synchronized (object) {
                if (this.shutdownStatus != null) {
                    return;
                }
                this.shutdownStatus = reason;
                if (this.uncommittedRetriableStreams.isEmpty()) {
                    shouldShutdownDelayedTransport = true;
                }
            }
            if (shouldShutdownDelayedTransport) {
                ManagedChannelImpl.this.delayedTransport.shutdown(reason);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onShutdownNow(Status reason) {
            ArrayList<ClientStream> streams;
            this.onShutdown(reason);
            Iterator iterator = this.lock;
            synchronized (iterator) {
                streams = new ArrayList<ClientStream>(this.uncommittedRetriableStreams);
            }
            for (ClientStream stream2 : streams) {
                stream2.cancel(reason);
            }
            ManagedChannelImpl.this.delayedTransport.shutdownNow(reason);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        Status add(RetriableStream<?> retriableStream) {
            Object object = this.lock;
            synchronized (object) {
                if (this.shutdownStatus != null) {
                    return this.shutdownStatus;
                }
                this.uncommittedRetriableStreams.add(retriableStream);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(RetriableStream<?> retriableStream) {
            Status shutdownStatusCopy = null;
            Object object = this.lock;
            synchronized (object) {
                this.uncommittedRetriableStreams.remove(retriableStream);
                if (this.uncommittedRetriableStreams.isEmpty()) {
                    shutdownStatusCopy = this.shutdownStatus;
                    this.uncommittedRetriableStreams = new HashSet<ClientStream>();
                }
            }
            if (shutdownStatusCopy != null) {
                ManagedChannelImpl.this.delayedTransport.shutdown(shutdownStatusCopy);
            }
        }
    }

    private class RealChannel
    extends Channel {
        private final String authority;

        private RealChannel(String authority) {
            this.authority = Preconditions.checkNotNull(authority, "authority");
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions) {
            return new ClientCallImpl<ReqT, RespT>(method, ManagedChannelImpl.this.getCallExecutor(callOptions), callOptions, ManagedChannelImpl.this.transportProvider, ManagedChannelImpl.this.terminated ? null : ManagedChannelImpl.this.transportFactory.getScheduledExecutorService(), ManagedChannelImpl.this.channelCallTracer, ManagedChannelImpl.this.retryEnabled).setFullStreamDecompression(ManagedChannelImpl.this.fullStreamDecompression).setDecompressorRegistry(ManagedChannelImpl.this.decompressorRegistry).setCompressorRegistry(ManagedChannelImpl.this.compressorRegistry);
        }

        @Override
        public String authority() {
            return this.authority;
        }
    }

    private final class ChannelTransportProvider
    implements ClientCallImpl.ClientTransportProvider {
        private ChannelTransportProvider() {
        }

        @Override
        public ClientTransport get(LoadBalancer.PickSubchannelArgs args) {
            LoadBalancer.SubchannelPicker pickerCopy = ManagedChannelImpl.this.subchannelPicker;
            if (ManagedChannelImpl.this.shutdown.get()) {
                return ManagedChannelImpl.this.delayedTransport;
            }
            if (pickerCopy == null) {
                final class ExitIdleModeForTransport
                implements Runnable {
                    ExitIdleModeForTransport() {
                    }

                    @Override
                    public void run() {
                        ManagedChannelImpl.this.exitIdleMode();
                    }
                }
                ManagedChannelImpl.this.syncContext.execute(new ExitIdleModeForTransport());
                return ManagedChannelImpl.this.delayedTransport;
            }
            LoadBalancer.PickResult pickResult = pickerCopy.pickSubchannel(args);
            ClientTransport transport = GrpcUtil.getTransportFromPickResult(pickResult, args.getCallOptions().isWaitForReady());
            if (transport != null) {
                return transport;
            }
            return ManagedChannelImpl.this.delayedTransport;
        }

        @Override
        public <ReqT> ClientStream newRetriableStream(final MethodDescriptor<ReqT, ?> method, final CallOptions callOptions, final Metadata headers, final Context context) {
            Preconditions.checkState(ManagedChannelImpl.this.retryEnabled, "retry should be enabled");
            final class RetryStream
            extends RetriableStream<ReqT> {
                RetryStream() {
                    super(methodDescriptor, metadata, ManagedChannelImpl.this.channelBufferUsed, ManagedChannelImpl.this.perRpcBufferLimit, ManagedChannelImpl.this.channelBufferLimit, ManagedChannelImpl.this.getCallExecutor(callOptions2), ManagedChannelImpl.this.transportFactory.getScheduledExecutorService(), callOptions2.getOption(ServiceConfigInterceptor.RETRY_POLICY_KEY), callOptions2.getOption(ServiceConfigInterceptor.HEDGING_POLICY_KEY), ManagedChannelImpl.this.throttle);
                }

                @Override
                Status prestart() {
                    return ManagedChannelImpl.this.uncommittedRetriableStreamsRegistry.add(this);
                }

                @Override
                void postCommit() {
                    ManagedChannelImpl.this.uncommittedRetriableStreamsRegistry.remove(this);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                ClientStream newSubstream(ClientStreamTracer.Factory tracerFactory, Metadata newHeaders) {
                    CallOptions newOptions = callOptions.withStreamTracerFactory(tracerFactory);
                    ClientTransport transport = ChannelTransportProvider.this.get(new PickSubchannelArgsImpl(method, newHeaders, newOptions));
                    Context origContext = context.attach();
                    try {
                        ClientStream clientStream = transport.newStream(method, newHeaders, newOptions);
                        return clientStream;
                    }
                    finally {
                        context.detach(origContext);
                    }
                }
            }
            return new RetryStream();
        }
    }

    @VisibleForTesting
    class DelayedNameResolverRefresh
    implements Runnable {
        DelayedNameResolverRefresh() {
        }

        @Override
        public void run() {
            ManagedChannelImpl.this.scheduledNameResolverRefresh = null;
            ManagedChannelImpl.this.refreshNameResolution();
        }
    }

    private class IdleModeTimer
    implements Runnable {
        private IdleModeTimer() {
        }

        @Override
        public void run() {
            ManagedChannelImpl.this.enterIdleMode();
        }
    }
}

