/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.services;

import com.google.common.base.Preconditions;
import io.grpc.CallOptions;
import io.grpc.ClientInterceptor;
import io.grpc.ServerInterceptor;
import io.grpc.services.BinaryLogProvider;
import io.grpc.services.BinaryLogSink;
import io.grpc.services.BinlogHelper;
import io.grpc.services.TempFileSink;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

class BinaryLogProviderImpl
extends BinaryLogProvider {
    private static final AtomicLong counter = new AtomicLong(1L);
    private final BinlogHelper.Factory factory;
    private final BinaryLogSink sink;

    public BinaryLogProviderImpl() throws IOException {
        this(new TempFileSink(), System.getenv("GRPC_BINARY_LOG_CONFIG"));
    }

    @Deprecated
    public BinaryLogProviderImpl(BinaryLogSink sink) throws IOException {
        this(sink, System.getenv("GRPC_BINARY_LOG_CONFIG"));
    }

    public BinaryLogProviderImpl(BinaryLogSink sink, String configStr) throws IOException {
        this.sink = Preconditions.checkNotNull(sink);
        try {
            this.factory = new BinlogHelper.FactoryImpl(sink, configStr);
        }
        catch (RuntimeException e) {
            sink.close();
            throw new IOException("Can not initialize. The env variable GRPC_BINARY_LOG_CONFIG must be valid.", e);
        }
    }

    @Override
    @Nullable
    public ServerInterceptor getServerInterceptor(String fullMethodName) {
        BinlogHelper helperForMethod = this.factory.getLog(fullMethodName);
        if (helperForMethod == null) {
            return null;
        }
        return helperForMethod.getServerInterceptor(counter.getAndIncrement());
    }

    @Override
    @Nullable
    public ClientInterceptor getClientInterceptor(String fullMethodName, CallOptions callOptions) {
        BinlogHelper helperForMethod = this.factory.getLog(fullMethodName);
        if (helperForMethod == null) {
            return null;
        }
        return helperForMethod.getClientInterceptor(counter.getAndIncrement());
    }

    @Override
    public void close() throws IOException {
        this.sink.close();
    }
}

