/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark;

import com.google.errorprone.annotations.CompileTimeConstant;
import io.perfmark.Impl;
import io.perfmark.Link;
import io.perfmark.Tag;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PerfMark {
    private static final Tag NO_TAG = new Tag("", Long.MIN_VALUE);
    private static final Link NO_LINK = new Link(Long.MIN_VALUE);
    private static final Impl impl;

    public static void setEnabled(boolean value) {
        impl.setEnabled(value);
    }

    public static void startTask(@CompileTimeConstant String taskName, Tag tag2) {
        impl.startTask(taskName, tag2.tagName, tag2.tagId);
    }

    public static void startTask(@CompileTimeConstant String taskName) {
        impl.startTask(taskName);
    }

    public static void event(@CompileTimeConstant String eventName, Tag tag2) {
        impl.event(eventName, tag2.tagName, tag2.tagId);
    }

    public static void event(@CompileTimeConstant String eventName) {
        impl.event(eventName);
    }

    public static void stopTask(@CompileTimeConstant String taskName, Tag tag2) {
        impl.stopTask(taskName, tag2.tagName, tag2.tagId);
    }

    public static void stopTask(@CompileTimeConstant String taskName) {
        impl.stopTask(taskName);
    }

    public static Tag createTag() {
        return NO_TAG;
    }

    public static Tag createTag(long id2) {
        if (!impl.shouldCreateTag()) {
            return NO_TAG;
        }
        return new Tag("", id2);
    }

    public static Tag createTag(String name) {
        if (!impl.shouldCreateTag()) {
            return NO_TAG;
        }
        return new Tag(name, Long.MIN_VALUE);
    }

    public static Tag createTag(String name, long id2) {
        if (!impl.shouldCreateTag()) {
            return NO_TAG;
        }
        return new Tag(name, id2);
    }

    public static Link link() {
        long linkId = impl.linkAndGetId();
        if (linkId == Long.MIN_VALUE) {
            return NO_LINK;
        }
        return new Link(linkId);
    }

    static void link(long linkId) {
        impl.link(linkId);
    }

    private PerfMark() {
    }

    static {
        Impl instance = null;
        Level level = Level.WARNING;
        Throwable err = null;
        Class<?> clz = null;
        try {
            clz = Class.forName("io.perfmark.impl.SecretPerfMarkImpl$PerfMarkImpl");
        }
        catch (ClassNotFoundException e) {
            level = Level.FINE;
            err = e;
        }
        catch (Throwable t) {
            err = t;
        }
        if (clz != null) {
            try {
                instance = clz.asSubclass(Impl.class).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                err = t;
            }
        }
        impl = instance != null ? instance : new Impl();
        if (err != null) {
            Logger.getLogger(PerfMark.class.getName()).log(level, "Error during PerfMark.<clinit>", err);
        }
    }
}

