/*
 * Decompiled with CFR 0.152.
 */
package zipkin;

import java.util.Arrays;
import javax.annotation.Nullable;
import zipkin.Endpoint;
import zipkin.internal.JsonCodec;
import zipkin.internal.Util;

public final class BinaryAnnotation
implements Comparable<BinaryAnnotation> {
    public final String key;
    public final byte[] value;
    public final Type type;
    @Nullable
    public final Endpoint endpoint;

    public static BinaryAnnotation address(String key, Endpoint endpoint) {
        return new BinaryAnnotation(key, new byte[]{1}, Type.BOOL, Util.checkNotNull(endpoint, "endpoint"));
    }

    public static BinaryAnnotation create(String key, String value, @Nullable Endpoint endpoint) {
        Util.checkNotNull(key, "key");
        if (value == null) {
            throw new NullPointerException("value of " + key);
        }
        return new BinaryAnnotation(key, value.getBytes(Util.UTF_8), Type.STRING, endpoint);
    }

    public static BinaryAnnotation create(String key, byte[] value, Type type, @Nullable Endpoint endpoint) {
        return new BinaryAnnotation(key, value, type, endpoint);
    }

    BinaryAnnotation(String key, byte[] value, Type type, @Nullable Endpoint endpoint) {
        Util.checkNotNull(key, "key");
        if (value == null) {
            throw new NullPointerException("value of " + key);
        }
        if (type == null) {
            throw new NullPointerException("type of " + key);
        }
        this.key = key;
        this.value = value;
        this.type = type;
        this.endpoint = endpoint;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BinaryAnnotation) {
            BinaryAnnotation that = (BinaryAnnotation)o;
            return this.key.equals(that.key) && Arrays.equals(this.value, that.value) && this.type.equals((Object)that.type) && Util.equal(this.endpoint, that.endpoint);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= this.key.hashCode();
        h2 *= 1000003;
        h2 ^= Arrays.hashCode(this.value);
        h2 *= 1000003;
        h2 ^= this.type.hashCode();
        h2 *= 1000003;
        return h2 ^= this.endpoint == null ? 0 : this.endpoint.hashCode();
    }

    @Override
    public int compareTo(BinaryAnnotation that) {
        if (this == that) {
            return 0;
        }
        return this.key.compareTo(that.key);
    }

    public String toString() {
        return new String(JsonCodec.writeBinaryAnnotation(this), Util.UTF_8);
    }

    public static final class Builder {
        private String key;
        private byte[] value;
        private Type type;
        private Endpoint endpoint;

        Builder() {
        }

        Builder(BinaryAnnotation source) {
            this.key = source.key;
            this.value = source.value;
            this.type = source.type;
            this.endpoint = source.endpoint;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder value(byte[] value) {
            this.value = (byte[])value.clone();
            return this;
        }

        public Builder value(String value) {
            this.value = value.getBytes(Util.UTF_8);
            this.type = Type.STRING;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder endpoint(@Nullable Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public BinaryAnnotation build() {
            return new BinaryAnnotation(this.key, this.value, this.type, this.endpoint);
        }
    }

    public static enum Type {
        BOOL(0),
        BYTES(1),
        I16(2),
        I32(3),
        I64(4),
        DOUBLE(5),
        STRING(6);

        public final int value;

        private Type(int value) {
            this.value = value;
        }

        public static Type fromValue(int value) {
            switch (value) {
                case 0: {
                    return BOOL;
                }
                case 1: {
                    return BYTES;
                }
                case 2: {
                    return I16;
                }
                case 3: {
                    return I32;
                }
                case 4: {
                    return I64;
                }
                case 5: {
                    return DOUBLE;
                }
                case 6: {
                    return STRING;
                }
            }
            return BYTES;
        }
    }
}

