/*
 * Decompiled with CFR 0.152.
 */
package zipkin;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Locale;
import zipkin.Codec;
import zipkin.internal.Util;

public final class DependencyLink
implements Serializable {
    private static final long serialVersionUID = 0L;
    public final String parent;
    public final String child;
    public final long callCount;
    public final long errorCount;

    public static DependencyLink create(String parent, String child, long callCount) {
        return DependencyLink.builder().parent(parent).child(child).callCount(callCount).build();
    }

    DependencyLink(Builder builder) {
        this.parent = Util.checkNotNull(builder.parent, "parent").toLowerCase(Locale.ROOT);
        this.child = Util.checkNotNull(builder.child, "child").toLowerCase(Locale.ROOT);
        this.callCount = builder.callCount;
        this.errorCount = builder.errorCount;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return new String(Codec.JSON.writeDependencyLink(this), Util.UTF_8);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DependencyLink) {
            DependencyLink that = (DependencyLink)o;
            return this.parent.equals(that.parent) && this.child.equals(that.child) && this.callCount == that.callCount && this.errorCount == that.errorCount;
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= this.parent.hashCode();
        h2 *= 1000003;
        h2 ^= this.child.hashCode();
        h2 *= 1000003;
        h2 ^= (int)((long)h2 ^ (this.callCount >>> 32 ^ this.callCount));
        h2 *= 1000003;
        h2 ^= (int)((long)h2 ^ (this.errorCount >>> 32 ^ this.errorCount));
        return h2;
    }

    final Object writeReplace() throws ObjectStreamException {
        return new SerializedForm(Codec.THRIFT.writeDependencyLink(this));
    }

    static final class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final byte[] bytes;

        SerializedForm(byte[] bytes) {
            this.bytes = bytes;
        }

        Object readResolve() throws ObjectStreamException {
            try {
                return Codec.THRIFT.readDependencyLink(this.bytes);
            }
            catch (IllegalArgumentException e) {
                throw new StreamCorruptedException(e.getMessage());
            }
        }
    }

    public static final class Builder {
        private String parent;
        private String child;
        private long callCount;
        private long errorCount;

        Builder() {
        }

        Builder(DependencyLink source) {
            this.parent = source.parent;
            this.child = source.child;
            this.callCount = source.callCount;
            this.errorCount = source.errorCount;
        }

        public Builder parent(String parent) {
            this.parent = parent;
            return this;
        }

        public Builder child(String child) {
            this.child = child;
            return this;
        }

        public Builder callCount(long callCount) {
            this.callCount = callCount;
            return this;
        }

        public Builder errorCount(long errorCount) {
            this.errorCount = errorCount;
            return this;
        }

        public DependencyLink build() {
            return new DependencyLink(this);
        }
    }
}

