/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import zipkin.storage.Callback;

public final class CallbackCaptor<V>
implements Callback<V> {
    final CountDownLatch countDown = new CountDownLatch(1);
    final AtomicReference<Object> ref = new AtomicReference();

    @Nullable
    public V get() {
        boolean interrupted = false;
        while (true) {
            try {
                this.countDown.await();
                Object result2 = this.ref.get();
                if (result2 instanceof Throwable) {
                    if (result2 instanceof Error) {
                        throw (Error)result2;
                    }
                    if (result2 instanceof RuntimeException) {
                        throw (RuntimeException)result2;
                    }
                    throw new RuntimeException((Exception)result2);
                }
                Object object = result2;
                return (V)object;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void onSuccess(@Nullable V value) {
        this.ref.set(value);
        this.countDown.countDown();
    }

    @Override
    public void onError(Throwable t) {
        this.ref.set(t);
        this.countDown.countDown();
    }
}

