/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import zipkin.Component;
import zipkin.internal.LenientDoubleCallbackAsyncSpanStore;
import zipkin.internal.V2SpanConsumerAdapter;
import zipkin.internal.V2SpanStoreAdapter;
import zipkin.internal.v2.CheckResult;
import zipkin.internal.v2.storage.StorageComponent;
import zipkin.storage.AsyncSpanConsumer;
import zipkin.storage.AsyncSpanStore;
import zipkin.storage.SpanStore;
import zipkin.storage.StorageAdapters;

public abstract class V2StorageComponent
implements zipkin.storage.StorageComponent {
    public static V2StorageComponent create(final StorageComponent delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        final LegacySpanStoreProvider legacyProvider = delegate instanceof LegacySpanStoreProvider ? (LegacySpanStoreProvider)((Object)delegate) : null;
        return new V2StorageComponent(){

            @Override
            protected LegacySpanStoreProvider legacyProvider() {
                return legacyProvider;
            }

            @Override
            public StorageComponent internalDelegate() {
                return delegate;
            }
        };
    }

    protected abstract LegacySpanStoreProvider legacyProvider();

    public abstract StorageComponent internalDelegate();

    @Override
    public SpanStore spanStore() {
        AsyncSpanStore legacy;
        AsyncSpanStore asyncSpanStore = legacy = this.legacyProvider() != null ? this.legacyProvider().legacyAsyncSpanStore() : null;
        if (legacy != null) {
            return StorageAdapters.asyncToBlocking(this.asyncSpanStore());
        }
        return new V2SpanStoreAdapter(this.internalDelegate().spanStore());
    }

    @Override
    public AsyncSpanStore asyncSpanStore() {
        AsyncSpanStore legacy;
        V2SpanStoreAdapter v2 = new V2SpanStoreAdapter(this.internalDelegate().spanStore());
        AsyncSpanStore asyncSpanStore = legacy = this.legacyProvider() != null ? this.legacyProvider().legacyAsyncSpanStore() : null;
        if (legacy == null) {
            return v2;
        }
        return new LenientDoubleCallbackAsyncSpanStore(v2, legacy);
    }

    @Override
    public final AsyncSpanConsumer asyncSpanConsumer() {
        return new V2SpanConsumerAdapter(this.internalDelegate().spanConsumer());
    }

    @Override
    public Component.CheckResult check() {
        CheckResult result2 = this.internalDelegate().check();
        return result2.ok() ? Component.CheckResult.OK : Component.CheckResult.failed(result2.error() instanceof Exception ? (Exception)result2.error() : new ExecutionException(result2.error()));
    }

    @Override
    public void close() throws IOException {
        this.internalDelegate().close();
    }

    public String toString() {
        return this.internalDelegate().toString();
    }

    public static interface LegacySpanStoreProvider {
        @Nullable
        public AsyncSpanStore legacyAsyncSpanStore();
    }
}

