/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal.v2;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import zipkin.internal.v2.AutoValue_Endpoint;

@AutoValue
@Immutable
public abstract class Endpoint
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final ThreadLocal<char[]> IPV6_TO_STRING = new ThreadLocal<char[]>(){

        @Override
        protected char[] initialValue() {
            return new char[39];
        }
    };
    static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int IPV6_PART_COUNT = 8;

    @Nullable
    public abstract String serviceName();

    @Nullable
    public abstract String ipv4();

    @Nullable
    public abstract String ipv6();

    @Nullable
    public abstract Integer port();

    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        return new AutoValue_Endpoint.Builder();
    }

    @Nullable
    static String parseEmbeddedIPv4(byte[] ipv6) {
        for (int i = 0; i < 10; ++i) {
            if (ipv6[i] == 0) continue;
            return null;
        }
        int flag = (ipv6[10] & 0xFF) << 8 | ipv6[11] & 0xFF;
        if (flag != 0 && flag != -1) {
            return null;
        }
        int o1 = ipv6[12] & 0xFF;
        int o2 = ipv6[13] & 0xFF;
        int o3 = ipv6[14] & 0xFF;
        int o4 = ipv6[15] & 0xFF;
        if (flag == 0 && o1 == 0 && o2 == 0 && o3 == 0 && o4 == 1) {
            return null;
        }
        return String.valueOf(o1) + '.' + o2 + '.' + o3 + '.' + o4;
    }

    static IpFamily detectFamily(String ipString) {
        char c;
        boolean hasColon = false;
        boolean hasDot = false;
        int length = ipString.length();
        for (int i = 0; i < length; ++i) {
            c = ipString.charAt(i);
            if (c == '.') {
                hasDot = true;
                continue;
            }
            if (c == ':') {
                if (hasDot) {
                    return IpFamily.Unknown;
                }
                hasColon = true;
                continue;
            }
            if (!Endpoint.notHex(c)) continue;
            return IpFamily.Unknown;
        }
        if (hasColon) {
            if (hasDot) {
                int lastColon = ipString.lastIndexOf(58);
                if (!Endpoint.isValidIpV4Address(ipString, lastColon + 1, ipString.length())) {
                    return IpFamily.Unknown;
                }
                if (lastColon == 1 && ipString.charAt(0) == ':') {
                    return IpFamily.IPv4Embedded;
                }
                if (lastColon != 6 || ipString.charAt(0) != ':' || ipString.charAt(1) != ':') {
                    return IpFamily.Unknown;
                }
                for (int i = 2; i < 6; ++i) {
                    c = ipString.charAt(i);
                    if (c == 'f' || c == 'F' || c == '0') continue;
                    return IpFamily.Unknown;
                }
                return IpFamily.IPv4Embedded;
            }
            return IpFamily.IPv6;
        }
        if (hasDot && Endpoint.isValidIpV4Address(ipString, 0, ipString.length())) {
            return IpFamily.IPv4;
        }
        return IpFamily.Unknown;
    }

    private static boolean notHex(char c) {
        return !(c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F');
    }

    static String writeIpV6(byte[] ipv6) {
        int i;
        int pos = 0;
        char[] buf = IPV6_TO_STRING.get();
        int zeroCompressionIndex = -1;
        int zeroCompressionLength = -1;
        int zeroIndex = -1;
        boolean allZeros = true;
        for (i = 0; i < ipv6.length; i += 2) {
            if (ipv6[i] == 0 && ipv6[i + 1] == 0) {
                if (zeroIndex >= 0) continue;
                zeroIndex = i;
                continue;
            }
            allZeros = false;
            if (zeroIndex < 0) continue;
            int zeroLength = i - zeroIndex;
            if (zeroLength > zeroCompressionLength) {
                zeroCompressionIndex = zeroIndex;
                zeroCompressionLength = zeroLength;
            }
            zeroIndex = -1;
        }
        if (allZeros) {
            return "::";
        }
        if (zeroCompressionIndex == -1 && zeroIndex != -1) {
            zeroCompressionIndex = zeroIndex;
            zeroCompressionLength = 16 - zeroIndex;
        }
        i = 0;
        while (i < ipv6.length) {
            if (i == zeroCompressionIndex) {
                buf[pos++] = 58;
                if ((i += zeroCompressionLength) != ipv6.length) continue;
                buf[pos++] = 58;
                continue;
            }
            if (i != 0) {
                buf[pos++] = 58;
            }
            byte high = ipv6[i++];
            byte low = ipv6[i++];
            char val = HEX_DIGITS[high >> 4 & 0xF];
            boolean leadingZero = val == '0';
            if (!leadingZero) {
                buf[pos++] = val;
            }
            val = HEX_DIGITS[high & 0xF];
            if (!(leadingZero = leadingZero && val == '0')) {
                buf[pos++] = val;
            }
            val = HEX_DIGITS[low >> 4 & 0xF];
            if (!leadingZero || val != '0') {
                buf[pos++] = val;
            }
            buf[pos++] = HEX_DIGITS[low & 0xF];
        }
        return new String(buf, 0, pos);
    }

    @Nullable
    private static byte[] textToNumericFormatV6(String ipString) {
        int partsLo;
        int partsHi;
        String[] parts = ipString.split(":", 10);
        if (parts.length < 3 || parts.length > 9) {
            return null;
        }
        int skipIndex = -1;
        for (int i = 1; i < parts.length - 1; ++i) {
            if (parts[i].length() != 0) continue;
            if (skipIndex >= 0) {
                return null;
            }
            skipIndex = i;
        }
        if (skipIndex >= 0) {
            partsHi = skipIndex;
            partsLo = parts.length - skipIndex - 1;
            if (parts[0].length() == 0 && --partsHi != 0) {
                return null;
            }
            if (parts[parts.length - 1].length() == 0 && --partsLo != 0) {
                return null;
            }
        } else {
            partsHi = parts.length;
            partsLo = 0;
        }
        int partsSkipped = 8 - (partsHi + partsLo);
        if (!(skipIndex < 0 ? partsSkipped == 0 : partsSkipped >= 1)) {
            return null;
        }
        ByteBuffer rawBytes = ByteBuffer.allocate(16);
        try {
            int i;
            for (i = 0; i < partsHi; ++i) {
                rawBytes.putShort(Endpoint.parseHextet(parts[i]));
            }
            for (i = 0; i < partsSkipped; ++i) {
                rawBytes.putShort((short)0);
            }
            for (i = partsLo; i > 0; --i) {
                rawBytes.putShort(Endpoint.parseHextet(parts[parts.length - i]));
            }
        }
        catch (NumberFormatException ex) {
            return null;
        }
        return rawBytes.array();
    }

    private static short parseHextet(String ipPart) {
        int hextet = Integer.parseInt(ipPart, 16);
        if (hextet > 65535) {
            throw new NumberFormatException();
        }
        return (short)hextet;
    }

    private static boolean isValidIpV4Address(String ip, int from, int toExcluded) {
        int i;
        int len = toExcluded - from;
        return len <= 15 && len >= 7 && (i = ip.indexOf(46, from + 1)) > 0 && Endpoint.isValidIpV4Word(ip, from, i) && (i = ip.indexOf(46, from = i + 2)) > 0 && Endpoint.isValidIpV4Word(ip, from - 1, i) && (i = ip.indexOf(46, from = i + 2)) > 0 && Endpoint.isValidIpV4Word(ip, from - 1, i) && Endpoint.isValidIpV4Word(ip, i + 1, toExcluded);
    }

    private static boolean isValidIpV4Word(CharSequence word, int from, int toExclusive) {
        char c0;
        int len = toExclusive - from;
        if (len < 1 || len > 3 || (c0 = word.charAt(from)) < '0') {
            return false;
        }
        if (len == 3) {
            char c2;
            char c1 = word.charAt(from + 1);
            return c1 >= '0' && (c2 = word.charAt(from + 2)) >= '0' && (c0 <= '1' && c1 <= '9' && c2 <= '9' || c0 == '2' && c1 <= '5' && (c2 <= '5' || c1 < '5' && c2 <= '9'));
        }
        return c0 <= '9' && (len == 1 || Endpoint.isValidNumericChar(word.charAt(from + 1)));
    }

    private static boolean isValidNumericChar(char c) {
        return c >= '0' && c <= '9';
    }

    static enum IpFamily {
        Unknown,
        IPv4,
        IPv4Embedded,
        IPv6;

    }

    public static abstract class Builder {
        public abstract Builder serviceName(@Nullable String var1);

        public Builder ip(@Nullable InetAddress addr) {
            this.parseIp(addr);
            return this;
        }

        public final boolean parseIp(@Nullable InetAddress addr) {
            if (addr == null) {
                return false;
            }
            if (addr instanceof Inet4Address) {
                this.ipv4(addr.getHostAddress());
            } else if (addr instanceof Inet6Address) {
                byte[] addressBytes = addr.getAddress();
                String ipv4 = Endpoint.parseEmbeddedIPv4(addressBytes);
                if (ipv4 != null) {
                    this.ipv4(ipv4);
                } else {
                    this.ipv6(Endpoint.writeIpV6(addressBytes));
                }
            } else {
                return false;
            }
            return true;
        }

        public Builder ip(@Nullable String ipString) {
            this.parseIp(ipString);
            return this;
        }

        public final boolean parseIp(@Nullable String ipString) {
            if (ipString == null || ipString.isEmpty()) {
                return false;
            }
            IpFamily format = Endpoint.detectFamily(ipString);
            if (format == IpFamily.IPv4) {
                this.ipv4(ipString);
            } else if (format == IpFamily.IPv4Embedded) {
                this.ipv4(ipString.substring(ipString.lastIndexOf(58) + 1));
            } else if (format == IpFamily.IPv6) {
                byte[] addressBytes = Endpoint.textToNumericFormatV6(ipString);
                if (addressBytes == null) {
                    return false;
                }
                this.ipv6(Endpoint.writeIpV6(addressBytes));
            } else {
                return false;
            }
            return true;
        }

        abstract Builder ipv4(@Nullable String var1);

        abstract Builder ipv6(@Nullable String var1);

        public abstract Builder port(@Nullable Integer var1);

        @Nullable
        abstract String serviceName();

        @Nullable
        abstract Integer port();

        abstract Endpoint autoBuild();

        public final Endpoint build() {
            Integer port;
            String serviceName = this.serviceName();
            if (serviceName != null) {
                if (serviceName.isEmpty()) {
                    this.serviceName(null);
                } else {
                    this.serviceName(serviceName.toLowerCase(Locale.ROOT));
                }
            }
            if ((port = this.port()) != null) {
                if (port < 0 || port > 65535) {
                    throw new IllegalArgumentException("invalid port " + port);
                }
                if (port == 0) {
                    this.port(null);
                }
            }
            return this.autoBuild();
        }

        Builder() {
        }
    }
}

