/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal.v2.codec;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import zipkin.internal.gson.stream.JsonReader;
import zipkin.internal.gson.stream.JsonToken;
import zipkin.internal.gson.stream.MalformedJsonException;
import zipkin.internal.v2.Endpoint;
import zipkin.internal.v2.Span;
import zipkin.internal.v2.codec.BytesDecoder;
import zipkin.internal.v2.codec.BytesEncoder;
import zipkin.internal.v2.codec.Encoding;
import zipkin.internal.v2.codec.SpanBytesCodec$$Lambda$1;
import zipkin.internal.v2.codec.SpanBytesEncoder;
import zipkin.internal.v2.internal.JsonCodec;
import zipkin.internal.v2.internal.V2SpanWriter;

public enum SpanBytesCodec implements BytesEncoder<Span>,
BytesDecoder<Span>
{
    JSON_V2{

        @Override
        public Encoding encoding() {
            return Encoding.JSON;
        }

        @Override
        public int sizeInBytes(Span input) {
            return SpanBytesEncoder.JSON_V2.sizeInBytes(input);
        }

        @Override
        public byte[] encode(Span input) {
            return SpanBytesEncoder.JSON_V2.encode(input);
        }

        @Override
        public byte[] encodeList(List<Span> input) {
            return SpanBytesEncoder.JSON_V2.encodeList(input);
        }

        @Override
        public Span decode(byte[] span) {
            return JsonCodec.read(new SpanReader(), span);
        }

        @Override
        public List<Span> decodeList(byte[] spans) {
            return JsonCodec.readList(new SpanReader(), spans);
        }

        @Override
        public byte[] encodeNestedList(List<List<Span>> traces) {
            return JsonCodec.writeNestedList(new V2SpanWriter(), traces);
        }

        @Override
        public List<List<Span>> decodeNestedList(byte[] traces) {
            return JsonCodec.readList(new SpanListReader(), traces);
        }
    };

    static final JsonCodec.JsonReaderAdapter<Endpoint> ENDPOINT_READER;

    public abstract byte[] encodeNestedList(List<List<Span>> var1);

    public abstract List<List<Span>> decodeNestedList(byte[] var1);

    static /* synthetic */ Endpoint lambda$static$0(JsonReader reader) throws IOException {
        Endpoint.Builder result2 = Endpoint.newBuilder();
        reader.beginObject();
        boolean readField = false;
        while (reader.hasNext()) {
            String nextName = reader.nextName();
            if (reader.peek() == JsonToken.NULL) {
                reader.skipValue();
                continue;
            }
            if (nextName.equals("serviceName")) {
                result2.serviceName(reader.nextString());
                readField = true;
                continue;
            }
            if (nextName.equals("ipv4") || nextName.equals("ipv6")) {
                result2.parseIp(reader.nextString());
                readField = true;
                continue;
            }
            if (nextName.equals("port")) {
                result2.port(reader.nextInt());
                readField = true;
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        if (!readField) {
            throw new MalformedJsonException("Empty endpoint at " + reader.getPath());
        }
        return result2.build();
    }

    static {
        ENDPOINT_READER = SpanBytesCodec$$Lambda$1.lambdaFactory$();
    }

    static final class SpanListReader
    implements JsonCodec.JsonReaderAdapter<List<Span>> {
        SpanReader spanReader;

        SpanListReader() {
        }

        @Override
        public List<Span> fromJson(JsonReader reader) throws IOException {
            reader.beginArray();
            if (!reader.hasNext()) {
                reader.endArray();
                return Collections.emptyList();
            }
            LinkedList<Span> result2 = new LinkedList<Span>();
            if (this.spanReader == null) {
                this.spanReader = new SpanReader();
            }
            while (reader.hasNext()) {
                result2.add(this.spanReader.fromJson(reader));
            }
            reader.endArray();
            return result2;
        }

        public String toString() {
            return "List<Span>";
        }
    }

    static final class SpanReader
    implements JsonCodec.JsonReaderAdapter<Span> {
        Span.Builder builder;

        SpanReader() {
        }

        @Override
        public Span fromJson(JsonReader reader) throws IOException {
            if (this.builder == null) {
                this.builder = Span.newBuilder();
            } else {
                this.builder.clear();
            }
            reader.beginObject();
            while (reader.hasNext()) {
                String nextName = reader.nextName();
                if (nextName.equals("traceId")) {
                    this.builder.traceId(reader.nextString());
                    continue;
                }
                if (nextName.equals("id")) {
                    this.builder.id(reader.nextString());
                    continue;
                }
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    continue;
                }
                if (nextName.equals("parentId")) {
                    this.builder.parentId(reader.nextString());
                    continue;
                }
                if (nextName.equals("kind")) {
                    this.builder.kind(Span.Kind.valueOf(reader.nextString()));
                    continue;
                }
                if (nextName.equals("name")) {
                    this.builder.name(reader.nextString());
                    continue;
                }
                if (nextName.equals("timestamp")) {
                    this.builder.timestamp(reader.nextLong());
                    continue;
                }
                if (nextName.equals("duration")) {
                    this.builder.duration(reader.nextLong());
                    continue;
                }
                if (nextName.equals("localEndpoint")) {
                    this.builder.localEndpoint(ENDPOINT_READER.fromJson(reader));
                    continue;
                }
                if (nextName.equals("remoteEndpoint")) {
                    this.builder.remoteEndpoint(ENDPOINT_READER.fromJson(reader));
                    continue;
                }
                if (nextName.equals("annotations")) {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        reader.beginObject();
                        Long timestamp = null;
                        String value = null;
                        while (reader.hasNext()) {
                            nextName = reader.nextName();
                            if (nextName.equals("timestamp")) {
                                timestamp = reader.nextLong();
                                continue;
                            }
                            if (nextName.equals("value")) {
                                value = reader.nextString();
                                continue;
                            }
                            reader.skipValue();
                        }
                        if (timestamp == null || value == null) {
                            throw new MalformedJsonException("Incomplete annotation at " + reader.getPath());
                        }
                        reader.endObject();
                        this.builder.addAnnotation(timestamp, value);
                    }
                    reader.endArray();
                    continue;
                }
                if (nextName.equals("tags")) {
                    reader.beginObject();
                    while (reader.hasNext()) {
                        String key = reader.nextName();
                        if (reader.peek() == JsonToken.NULL) {
                            throw new MalformedJsonException("No value at " + reader.getPath());
                        }
                        this.builder.putTag(key, reader.nextString());
                    }
                    reader.endObject();
                    continue;
                }
                if (nextName.equals("debug")) {
                    if (!reader.nextBoolean()) continue;
                    this.builder.debug(true);
                    continue;
                }
                if (nextName.equals("shared")) {
                    if (!reader.nextBoolean()) continue;
                    this.builder.shared(true);
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            return this.builder.build();
        }

        public String toString() {
            return "Span";
        }
    }
}

