/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal.v2.codec;

import java.util.List;
import javax.annotation.concurrent.Immutable;
import zipkin.internal.v2.Span;
import zipkin.internal.v2.codec.BytesEncoder;
import zipkin.internal.v2.codec.Encoding;
import zipkin.internal.v2.internal.Buffer;
import zipkin.internal.v2.internal.JsonCodec;
import zipkin.internal.v2.internal.V1SpanWriter;
import zipkin.internal.v2.internal.V2SpanWriter;

@Immutable
public enum SpanBytesEncoder implements BytesEncoder<Span>
{
    JSON_V1{
        final Buffer.Writer<Span> writer = new V1SpanWriter();

        @Override
        public Encoding encoding() {
            return Encoding.JSON;
        }

        @Override
        public int sizeInBytes(Span input) {
            return this.writer.sizeInBytes(input);
        }

        @Override
        public byte[] encode(Span span) {
            return JsonCodec.write(this.writer, span);
        }

        @Override
        public byte[] encodeList(List<Span> spans) {
            return JsonCodec.writeList(this.writer, spans);
        }
    }
    ,
    JSON_V2{
        final Buffer.Writer<Span> writer = new V2SpanWriter();

        @Override
        public Encoding encoding() {
            return Encoding.JSON;
        }

        @Override
        public int sizeInBytes(Span input) {
            return this.writer.sizeInBytes(input);
        }

        @Override
        public byte[] encode(Span span) {
            return JsonCodec.write(this.writer, span);
        }

        @Override
        public byte[] encodeList(List<Span> spans) {
            return JsonCodec.writeList(this.writer, spans);
        }
    };

}

