/*
 * Decompiled with CFR 0.152.
 */
package zipkin.reporter;

import java.io.Flushable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import zipkin.Component;
import zipkin.Span;
import zipkin.reporter.AsyncReporter$Builder$$Lambda$1;
import zipkin.reporter.BufferNextMessage;
import zipkin.reporter.ByteBoundedQueue;
import zipkin.reporter.Callback;
import zipkin.reporter.Encoder;
import zipkin.reporter.Reporter;
import zipkin.reporter.ReporterMetrics;
import zipkin.reporter.Sender;

public abstract class AsyncReporter<S>
implements Reporter<S>,
Flushable,
Component {
    public static AsyncReporter<Span> create(Sender sender) {
        return new Builder(sender).build();
    }

    public static Builder builder(Sender sender) {
        return new Builder(sender);
    }

    @Override
    public abstract void flush();

    @Override
    public abstract void close();

    static final class BoundedAsyncReporter<S>
    extends AsyncReporter<S> {
        static final Logger logger = Logger.getLogger(BoundedAsyncReporter.class.getName());
        final AtomicBoolean closed = new AtomicBoolean(false);
        final Encoder<S> encoder;
        final ByteBoundedQueue pending;
        final Sender sender;
        final int messageMaxBytes;
        final long messageTimeoutNanos;
        final long closeTimeoutNanos;
        final CountDownLatch close;
        final ReporterMetrics metrics;

        BoundedAsyncReporter(Builder builder, Encoder<S> encoder) {
            this.pending = new ByteBoundedQueue(builder.queuedMaxSpans, builder.queuedMaxBytes);
            this.sender = builder.sender;
            this.messageMaxBytes = builder.messageMaxBytes;
            this.messageTimeoutNanos = builder.messageTimeoutNanos;
            this.closeTimeoutNanos = builder.closeTimeoutNanos;
            this.close = new CountDownLatch(builder.messageTimeoutNanos > 0L ? 1 : 0);
            this.metrics = builder.metrics;
            this.encoder = encoder;
        }

        @Override
        public void report(S span) {
            if (span == null) {
                throw new NullPointerException("span == null");
            }
            this.metrics.incrementSpans(1);
            byte[] next = this.encoder.encode(span);
            int messageSizeOfNextSpan = this.sender.messageSizeInBytes(Collections.singletonList(next));
            this.metrics.incrementSpanBytes(next.length);
            if (this.closed.get() || messageSizeOfNextSpan > this.messageMaxBytes || !this.pending.offer(next)) {
                this.metrics.incrementSpansDropped(1);
            }
        }

        @Override
        public final void flush() {
            this.flush(new BufferNextMessage(this.sender, this.messageMaxBytes, 0L));
        }

        void flush(BufferNextMessage bundler) {
            block4: {
                if (this.closed.get()) {
                    throw new IllegalStateException("closed");
                }
                this.pending.drainTo(bundler, bundler.remainingNanos());
                this.metrics.updateQueuedSpans(this.pending.count);
                this.metrics.updateQueuedBytes(this.pending.sizeInBytes);
                if (!bundler.isReady() && !this.closed.get()) {
                    return;
                }
                this.metrics.incrementMessages();
                this.metrics.incrementMessageBytes(bundler.sizeInBytes());
                List<byte[]> nextMessage = bundler.drain();
                Callback failureCallback = this.sendSpansCallback(nextMessage.size());
                try {
                    this.sender.sendSpans(nextMessage, failureCallback);
                }
                catch (RuntimeException e) {
                    failureCallback.onError(e);
                    if (!(e instanceof IllegalStateException)) break block4;
                    throw e;
                }
            }
        }

        @Override
        public Component.CheckResult check() {
            return this.sender.check();
        }

        @Override
        public void close() {
            if (!this.closed.compareAndSet(false, true)) {
                return;
            }
            try {
                if (!this.close.await(this.closeTimeoutNanos, TimeUnit.NANOSECONDS)) {
                    logger.warning("Timed out waiting for in-flight spans to send");
                }
            }
            catch (InterruptedException e) {
                logger.warning("Interrupted waiting for in-flight spans to send");
                Thread.currentThread().interrupt();
            }
            int count = this.pending.clear();
            if (count > 0) {
                this.metrics.incrementSpansDropped(count);
                logger.warning("Dropped " + count + " spans due to AsyncReporter.close()");
            }
        }

        Callback sendSpansCallback(final int count) {
            return new Callback(){

                @Override
                public void onComplete() {
                }

                @Override
                public void onError(Throwable t) {
                    BoundedAsyncReporter.this.metrics.incrementMessagesDropped(t);
                    BoundedAsyncReporter.this.metrics.incrementSpansDropped(count);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, String.format("Dropped %s spans due to %s(%s)", count, t.getClass().getSimpleName(), t.getMessage() == null ? "" : t.getMessage()), t);
                    }
                }
            };
        }

        public String toString() {
            return "AsyncReporter(" + this.sender + ")";
        }
    }

    public static final class Builder {
        final Sender sender;
        ReporterMetrics metrics = ReporterMetrics.NOOP_METRICS;
        int messageMaxBytes;
        long messageTimeoutNanos = TimeUnit.SECONDS.toNanos(1L);
        long closeTimeoutNanos = TimeUnit.SECONDS.toNanos(1L);
        int queuedMaxSpans = 10000;
        int queuedMaxBytes = Builder.onePercentOfMemory();

        static int onePercentOfMemory() {
            long result2 = (long)((double)Runtime.getRuntime().totalMemory() * 0.01);
            return (int)Math.max(Math.min(Integer.MAX_VALUE, result2), Integer.MIN_VALUE);
        }

        Builder(Sender sender) {
            if (sender == null) {
                throw new NullPointerException("sender == null");
            }
            this.sender = sender;
            this.messageMaxBytes = sender.messageMaxBytes();
        }

        public Builder metrics(ReporterMetrics metrics) {
            if (metrics == null) {
                throw new NullPointerException("metrics == null");
            }
            this.metrics = metrics;
            return this;
        }

        public Builder messageMaxBytes(int messageMaxBytes) {
            if (messageMaxBytes < 0) {
                throw new IllegalArgumentException("messageMaxBytes < 0: " + messageMaxBytes);
            }
            this.messageMaxBytes = Math.min(messageMaxBytes, this.sender.messageMaxBytes());
            return this;
        }

        public Builder messageTimeout(long timeout, TimeUnit unit) {
            if (timeout < 0L) {
                throw new IllegalArgumentException("messageTimeout < 0: " + timeout);
            }
            if (unit == null) {
                throw new NullPointerException("unit == null");
            }
            this.messageTimeoutNanos = unit.toNanos(timeout);
            return this;
        }

        public Builder closeTimeout(long timeout, TimeUnit unit) {
            if (timeout < 0L) {
                throw new IllegalArgumentException("closeTimeout < 0: " + timeout);
            }
            if (unit == null) {
                throw new NullPointerException("unit == null");
            }
            this.closeTimeoutNanos = unit.toNanos(timeout);
            return this;
        }

        public Builder queuedMaxSpans(int queuedMaxSpans) {
            this.queuedMaxSpans = queuedMaxSpans;
            return this;
        }

        public Builder queuedMaxBytes(int queuedMaxBytes) {
            this.queuedMaxBytes = queuedMaxBytes;
            return this;
        }

        public AsyncReporter<Span> build() {
            switch (this.sender.encoding()) {
                case JSON: {
                    return this.build(Encoder.JSON);
                }
                case THRIFT: {
                    return this.build(Encoder.THRIFT);
                }
            }
            throw new UnsupportedOperationException(this.sender.encoding().name());
        }

        public <S> AsyncReporter<S> build(Encoder<S> encoder) {
            if (encoder == null) {
                throw new NullPointerException("encoder == null");
            }
            if (encoder.encoding() != this.sender.encoding()) {
                throw new IllegalArgumentException(String.format("Encoder doesn't match Sender: %s %s", new Object[]{encoder.encoding(), this.sender.encoding()}));
            }
            BoundedAsyncReporter<S> result2 = new BoundedAsyncReporter<S>(this, encoder);
            if (this.messageTimeoutNanos > 0L) {
                BufferNextMessage consumer = new BufferNextMessage(this.sender, this.messageMaxBytes, this.messageTimeoutNanos);
                Thread flushThread = new Thread(AsyncReporter$Builder$$Lambda$1.lambdaFactory$(result2, consumer), "AsyncReporter(" + this.sender + ")");
                flushThread.setDaemon(true);
                flushThread.start();
            }
            return result2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static /* synthetic */ void lambda$build$0(BoundedAsyncReporter result2, BufferNextMessage consumer) {
            try {
                while (!result2.closed.get()) {
                    result2.flush(consumer);
                }
            }
            finally {
                for (byte[] next : consumer.drain()) {
                    result2.pending.offer(next);
                }
                result2.close.countDown();
            }
        }
    }
}

