/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import zipkin.DependencyLink;
import zipkin.Span;
import zipkin.internal.ApplyTimestampAndDuration;
import zipkin.internal.CorrectForClockSkew;
import zipkin.internal.DependencyLinker;
import zipkin.internal.GroupByTraceId;
import zipkin.internal.MergeById;
import zipkin.internal.Pair;
import zipkin.internal.Util;
import zipkin.storage.InMemorySpanStore$$Lambda$1;
import zipkin.storage.InMemorySpanStore$$Lambda$4;
import zipkin.storage.InMemorySpanStore$$Lambda$5;
import zipkin.storage.InMemorySpanStore$ServiceNameToTraceIds$$Lambda$1;
import zipkin.storage.InMemoryStorage;
import zipkin.storage.QueryRequest;
import zipkin.storage.SpanStore;
import zipkin.storage.StorageAdapters;

public final class InMemorySpanStore
implements SpanStore {
    private final SortedMultimap<Pair<Long>, Span> spansByTraceIdTimeStamp = new LinkedListSortedMultimap<Pair<Long>, Span>(VALUE_2_DESCENDING);
    private final SortedMultimap<Long, Pair<Long>> traceIdToTraceIdTimeStamps = new LinkedHashSetSortedMultimap<Long, Pair<Long>>(InMemorySpanStore$$Lambda$1.lambdaFactory$());
    private final ServiceNameToTraceIds serviceToTraceIds = new ServiceNameToTraceIds();
    private final SortedMultimap<String, String> serviceToSpanNames = new LinkedHashSetSortedMultimap<String, String>(InMemorySpanStore$$Lambda$4.lambdaFactory$());
    private final boolean strictTraceId;
    final int maxSpanCount;
    volatile int acceptedSpanCount;
    final StorageAdapters.SpanConsumer spanConsumer = new StorageAdapters.SpanConsumer(){

        @Override
        public void accept(List<Span> spans) {
            if (spans.isEmpty()) {
                return;
            }
            if (spans.size() > InMemorySpanStore.this.maxSpanCount) {
                spans = spans.subList(0, InMemorySpanStore.this.maxSpanCount);
            }
            InMemorySpanStore.this.addSpans(spans);
        }

        public String toString() {
            return "InMemorySpanConsumer";
        }
    };
    static final Comparator<Pair<Long>> VALUE_2_DESCENDING = InMemorySpanStore$$Lambda$5.lambdaFactory$();

    public InMemorySpanStore() {
        this(new InMemoryStorage.Builder());
    }

    InMemorySpanStore(InMemoryStorage.Builder builder) {
        this.strictTraceId = builder.strictTraceId;
        this.maxSpanCount = builder.maxSpanCount;
    }

    @Deprecated
    public synchronized List<Long> traceIds() {
        return Util.sortedList(this.traceIdToTraceIdTimeStamps.keySet());
    }

    synchronized void clear() {
        this.acceptedSpanCount = 0;
        this.traceIdToTraceIdTimeStamps.clear();
        this.spansByTraceIdTimeStamp.clear();
        this.serviceToTraceIds.clear();
        this.serviceToSpanNames.clear();
    }

    synchronized void addSpans(List<Span> spans) {
        int delta = spans.size();
        int spansToRecover = this.spansByTraceIdTimeStamp.size() + delta - this.maxSpanCount;
        this.evictToRecoverSpans(spansToRecover);
        for (Span span : spans) {
            Long timestamp = ApplyTimestampAndDuration.guessTimestamp(span);
            Pair<Long> traceIdTimeStamp = Pair.create(span.traceId, timestamp == null ? Long.MIN_VALUE : timestamp);
            String spanName = span.name;
            this.spansByTraceIdTimeStamp.put(traceIdTimeStamp, span);
            this.traceIdToTraceIdTimeStamps.put(span.traceId, traceIdTimeStamp);
            ++this.acceptedSpanCount;
            for (String serviceName : span.serviceNames()) {
                this.serviceToTraceIds.put(serviceName, span.traceId);
                this.serviceToSpanNames.put(serviceName, spanName);
            }
        }
    }

    int evictToRecoverSpans(int spansToRecover) {
        int spansEvicted = 0;
        while (spansToRecover > 0) {
            int spansInOldestTrace = this.deleteOldestTrace();
            spansToRecover -= spansInOldestTrace;
            spansEvicted += spansInOldestTrace;
        }
        return spansEvicted;
    }

    private int deleteOldestTrace() {
        int spansEvicted = 0;
        long traceId = (Long)((Pair)this.spansByTraceIdTimeStamp.delegate.lastKey())._1;
        Collection<Pair<Long>> traceIdTimeStamps = this.traceIdToTraceIdTimeStamps.remove(traceId);
        for (Pair<Long> traceIdTimeStamp : traceIdTimeStamps) {
            Collection<Span> spans = this.spansByTraceIdTimeStamp.remove(traceIdTimeStamp);
            spansEvicted += spans.size();
        }
        for (String orphanedService : this.serviceToTraceIds.removeServiceIfTraceId(traceId)) {
            this.serviceToSpanNames.remove(orphanedService);
        }
        return spansEvicted;
    }

    public synchronized List<List<Span>> getRawTraces() {
        ArrayList<List<Span>> result2 = new ArrayList<List<Span>>();
        for (long traceId : this.traceIdToTraceIdTimeStamps.keySet()) {
            Collection<Span> sameTraceId = this.spansByTraceId(traceId);
            for (List<Span> next : GroupByTraceId.apply(sameTraceId, this.strictTraceId, false)) {
                result2.add(next);
            }
        }
        Collections.sort(result2, GroupByTraceId.TRACE_DESCENDING);
        return result2;
    }

    @Override
    public List<List<Span>> getTraces(QueryRequest request) {
        return this.getTraces(request, this.strictTraceId);
    }

    synchronized List<List<Span>> getTraces(QueryRequest request, boolean strictTraceId) {
        Set<Long> traceIdsInTimerange = this.traceIdsDescendingByTimestamp(request);
        if (traceIdsInTimerange.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<List<Span>> result2 = new ArrayList<List<Span>>();
        Iterator<Long> traceId = traceIdsInTimerange.iterator();
        while (traceId.hasNext() && result2.size() < request.limit) {
            Collection<Span> sameTraceId = this.spansByTraceId(traceId.next());
            for (List<Span> next : GroupByTraceId.apply(sameTraceId, strictTraceId, true)) {
                if (!request.test(next)) continue;
                result2.add(next);
            }
        }
        Collections.sort(result2, GroupByTraceId.TRACE_DESCENDING);
        return result2;
    }

    Set<Long> traceIdsDescendingByTimestamp(QueryRequest request) {
        Collection<Pair<Long>> traceIdTimestamps = request.serviceName != null ? this.traceIdTimestampsByServiceName(request.serviceName) : this.spansByTraceIdTimeStamp.keySet();
        long endTs = request.endTs * 1000L;
        long startTs = endTs - request.lookback * 1000L;
        if (traceIdTimestamps == null || traceIdTimestamps.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<Long> result2 = new LinkedHashSet<Long>();
        for (Pair<Long> traceIdTimestamp : traceIdTimestamps) {
            if ((Long)traceIdTimestamp._2 < startTs && (Long)traceIdTimestamp._2 > endTs) continue;
            result2.add((Long)traceIdTimestamp._1);
        }
        return result2;
    }

    @Override
    public synchronized List<Span> getTrace(long traceId) {
        return this.getTrace(0L, traceId);
    }

    @Override
    public synchronized List<Span> getTrace(long traceIdHigh, long traceIdLow) {
        List<Span> result2 = this.getRawTrace(traceIdHigh, traceIdLow);
        if (result2 == null) {
            return null;
        }
        return CorrectForClockSkew.apply(MergeById.apply(result2));
    }

    @Override
    public synchronized List<Span> getRawTrace(long traceId) {
        return this.getRawTrace(0L, traceId);
    }

    @Override
    public synchronized List<Span> getRawTrace(long traceIdHigh, long traceId) {
        List spans = (List)this.spansByTraceId(traceId);
        if (spans == null || spans.isEmpty()) {
            return null;
        }
        if (!this.strictTraceId) {
            return Util.sortedList(spans);
        }
        ArrayList<Span> filtered2 = new ArrayList<Span>(spans);
        Iterator iterator = filtered2.iterator();
        while (iterator.hasNext()) {
            if (((Span)iterator.next()).traceIdHigh == traceIdHigh) continue;
            iterator.remove();
        }
        return filtered2.isEmpty() ? null : filtered2;
    }

    @Override
    public synchronized List<String> getServiceNames() {
        return Util.sortedList(this.serviceToTraceIds.keySet());
    }

    @Override
    public synchronized List<String> getSpanNames(String service) {
        if (service == null) {
            return Collections.emptyList();
        }
        service = service.toLowerCase();
        return Util.sortedList(this.serviceToSpanNames.get(service));
    }

    @Override
    public synchronized List<DependencyLink> getDependencies(long endTs, @Nullable Long lookback) {
        QueryRequest request = QueryRequest.builder().endTs(endTs).lookback(lookback).limit(Integer.MAX_VALUE).build();
        DependencyLinker linksBuilder = new DependencyLinker();
        for (Collection collection : this.getTraces(request, false)) {
            linksBuilder.putTrace(collection);
        }
        return linksBuilder.link();
    }

    private Collection<Span> spansByTraceId(long traceId) {
        ArrayList<Span> sameTraceId = new ArrayList<Span>();
        for (Pair<Long> traceIdTimestamp : this.traceIdToTraceIdTimeStamps.get(traceId)) {
            sameTraceId.addAll(this.spansByTraceIdTimeStamp.get(traceIdTimestamp));
        }
        return sameTraceId;
    }

    private Collection<Pair<Long>> traceIdTimestampsByServiceName(String serviceName) {
        ArrayList<Pair<Long>> traceIdTimestamps = new ArrayList<Pair<Long>>();
        Iterator iterator = this.serviceToTraceIds.get(serviceName).iterator();
        while (iterator.hasNext()) {
            long traceId = (Long)iterator.next();
            traceIdTimestamps.addAll(this.traceIdToTraceIdTimeStamps.get(traceId));
        }
        Collections.sort(traceIdTimestamps, VALUE_2_DESCENDING);
        return traceIdTimestamps;
    }

    static /* synthetic */ int lambda$static$0(Pair left, Pair right) {
        int result2 = ((Long)right._2).compareTo((Long)left._2);
        if (result2 != 0) {
            return result2;
        }
        return ((Long)right._1).compareTo((Long)left._1);
    }

    static abstract class SortedMultimap<K, V> {
        final TreeMap<K, Collection<V>> delegate;
        int size = 0;

        SortedMultimap(Comparator<K> comparator) {
            this.delegate = new TreeMap(comparator);
        }

        abstract Collection<V> valueContainer();

        Set<K> keySet() {
            return this.delegate.keySet();
        }

        int size() {
            return this.size;
        }

        void put(K key, V value) {
            Collection<V> valueContainer = this.delegate.get(key);
            if (valueContainer == null) {
                valueContainer = this.valueContainer();
                this.delegate.put(key, valueContainer);
            }
            if (valueContainer.add(value)) {
                ++this.size;
            }
        }

        Collection<V> remove(K key) {
            Collection<V> value = this.delegate.remove(key);
            if (value != null) {
                this.size -= value.size();
            }
            return value;
        }

        void clear() {
            this.delegate.clear();
            this.size = 0;
        }

        Collection<V> get(K key) {
            Collection<V> result2 = this.delegate.get(key);
            return result2 != null ? result2 : Collections.emptySet();
        }
    }

    static final class LinkedHashSetSortedMultimap<K, V>
    extends SortedMultimap<K, V> {
        LinkedHashSetSortedMultimap(Comparator<K> comparator) {
            super(comparator);
        }

        @Override
        Collection<V> valueContainer() {
            return new LinkedHashSet();
        }
    }

    static final class ServiceNameToTraceIds
    extends SortedMultimap<String, Long> {
        ServiceNameToTraceIds() {
            super(InMemorySpanStore$ServiceNameToTraceIds$$Lambda$1.lambdaFactory$());
        }

        @Override
        Set<Long> valueContainer() {
            return new LinkedHashSet<Long>();
        }

        Set<String> removeServiceIfTraceId(long traceId) {
            LinkedHashSet<String> result2 = new LinkedHashSet<String>();
            for (Map.Entry entry : this.delegate.entrySet()) {
                Collection traceIds = (Collection)entry.getValue();
                if (!traceIds.remove(traceId) || !traceIds.isEmpty()) continue;
                result2.add((String)entry.getKey());
            }
            this.delegate.keySet().removeAll(result2);
            return result2;
        }
    }

    static final class LinkedListSortedMultimap<K, V>
    extends SortedMultimap<K, V> {
        LinkedListSortedMultimap(Comparator<K> comparator) {
            super(comparator);
        }

        @Override
        Collection<V> valueContainer() {
            return new LinkedList();
        }
    }
}

