/*
 * Decompiled with CFR 0.152.
 */
package akka.routing;

import akka.actor.ActorSystemImpl;
import akka.actor.InternalActorRef;
import akka.actor.Props;
import akka.dispatch.Envelope;
import akka.dispatch.Envelope$;
import akka.dispatch.MessageDispatcher;
import akka.routing.OptimalSizeExploringResizer;
import akka.routing.Pool;
import akka.routing.ResizablePoolActor$Resize$;
import akka.routing.Resizer;
import akka.routing.RoutedActorCell;
import akka.routing.Routee;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005=a!\u0002\u000b\u0016\u0005]I\u0002\"\u0003\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011'\u0011%Q\u0003A!A!\u0002\u0013Yc\u0006C\u00051\u0001\t\u0005\t\u0015!\u00032i!Ia\u0007\u0001B\u0001B\u0003%q'\u0010\u0005\n\u007f\u0001\u0011\t\u0011)A\u0005c\u0001C\u0011B\u0011\u0001\u0003\u0002\u0003\u0006IaK\"\t\u0011\u0015\u0003!Q1A\u0005\u0002\u0019C\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\u0006\u0017\u0002!\t\u0001\u0014\u0005\b+\u0002\u0011\r\u0011\"\u0001W\u0011\u0019Q\u0006\u0001)A\u0005/\"91\f\u0001b\u0001\n\u0013a\u0006BB5\u0001A\u0003%Q\fC\u0004k\u0001\t\u0007I\u0011B6\t\r=\u0004\u0001\u0015!\u0003m\u0011\u0015\u0001\b\u0001\"\u0015r\u0011\u0015A\b\u0001\"\u0011z\u0011\u001dy\b\u0001\"\u0001\u0018\u0003\u0003Aa!!\u0004\u0001\t\u0013\t(!\u0005*fg&T\u0018M\u00197f!>|GnQ3mY*\u0011acF\u0001\be>,H/\u001b8h\u0015\u0005A\u0012\u0001B1lW\u0006\u001c\"\u0001\u0001\u000e\u0011\u0005maR\"A\u000b\n\u0005u)\"a\u0004*pkR,G-Q2u_J\u001cU\r\u001c7\u0002\u000f}\u001b\u0018p\u001d;f[\u000e\u0001\u0001CA\u0011%\u001b\u0005\u0011#BA\u0012\u0018\u0003\u0015\t7\r^8s\u0013\t)#EA\bBGR|'oU=ti\u0016l\u0017*\u001c9m\u0013\t9\u0003&\u0001\u0004tsN$X-\\\u0005\u0003S\t\u0012\u0011\"Q2u_J\u001cU\r\u001c7\u0002\t}\u0013XM\u001a\t\u0003C1J!!\f\u0012\u0003!%sG/\u001a:oC2\f5\r^8s%\u00164\u0017BA\u0018)\u0003\u0011\u0019X\r\u001c4\u0002\u0019}\u0013x.\u001e;feB\u0013x\u000e]:\u0011\u0005\u0005\u0012\u0014BA\u001a#\u0005\u0015\u0001&o\u001c9t\u0013\t)\u0004&A\u0003qe>\u00048/A\t`e>,H/\u001a:ESN\u0004\u0018\r^2iKJ\u0004\"\u0001O\u001e\u000e\u0003eR!AO\f\u0002\u0011\u0011L7\u000f]1uG\"L!\u0001P\u001d\u0003#5+7o]1hK\u0012K7\u000f]1uG\",'/\u0003\u0002?Q\u0005QA-[:qCR\u001c\u0007.\u001a:\u0002\u0019}\u0013x.\u001e;fKB\u0013x\u000e]:\n\u0005\u0005c\u0012a\u0003:pkR,W\r\u0015:paN\f1bX:va\u0016\u0014h/[:pe&\u0011A\tK\u0001\u0007a\u0006\u0014XM\u001c;\u0002\tA|w\u000e\\\u000b\u0002\u000fB\u00111\u0004S\u0005\u0003\u0013V\u0011A\u0001U8pY\u0006)\u0001o\\8mA\u00051A(\u001b8jiz\"\u0002\"\u0014(P!F\u00136\u000b\u0016\t\u00037\u0001AQAH\u0005A\u0002\u0001BQAK\u0005A\u0002-BQ\u0001M\u0005A\u0002EBQAN\u0005A\u0002]BQaP\u0005A\u0002EBQAQ\u0005A\u0002-BQ!R\u0005A\u0002\u001d\u000bqA]3tSj,'/F\u0001X!\tY\u0002,\u0003\u0002Z+\t9!+Z:ju\u0016\u0014\u0018\u0001\u0003:fg&TXM\u001d\u0011\u0002!I,7/\u001b>f\u0013:\u0004&o\\4sKN\u001cX#A/\u0011\u0005y;W\"A0\u000b\u0005\u0001\f\u0017AB1u_6L7M\u0003\u0002cG\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\u0011,\u0017\u0001B;uS2T\u0011AZ\u0001\u0005U\u00064\u0018-\u0003\u0002i?\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:\f\u0011C]3tSj,\u0017J\u001c)s_\u001e\u0014Xm]:!\u00035\u0011Xm]5{K\u000e{WO\u001c;feV\tA\u000e\u0005\u0002_[&\u0011an\u0018\u0002\u000b\u0003R|W.[2M_:<\u0017A\u0004:fg&TXmQ8v]R,'\u000fI\u0001\u000eaJ,7+\u001e9feN#\u0018M\u001d;\u0015\u0003I\u0004\"a\u001d<\u000e\u0003QT\u0011!^\u0001\u0006g\u000e\fG.Y\u0005\u0003oR\u0014A!\u00168ji\u0006Y1/\u001a8e\u001b\u0016\u001c8/Y4f)\t\u0011(\u0010C\u0003|#\u0001\u0007A0\u0001\u0005f]Z,Gn\u001c9f!\tAT0\u0003\u0002\u007fs\tAQI\u001c<fY>\u0004X-\u0001\u0004sKNL'0\u001a\u000b\u0004e\u0006\r\u0001bBA\u0003%\u0001\u0007\u0011qA\u0001\bS:LG/[1m!\r\u0019\u0018\u0011B\u0005\u0004\u0003\u0017!(a\u0002\"p_2,\u0017M\\\u0001\u0016iJL(+\u001a9peRlUm]:bO\u0016\u001cu.\u001e8u\u0001")
public final class ResizablePoolCell
extends RoutedActorCell {
    private final Pool pool;
    private final Resizer resizer;
    private final AtomicBoolean resizeInProgress;
    private final AtomicLong resizeCounter;

    public Pool pool() {
        return this.pool;
    }

    public Resizer resizer() {
        return this.resizer;
    }

    private AtomicBoolean resizeInProgress() {
        return this.resizeInProgress;
    }

    private AtomicLong resizeCounter() {
        return this.resizeCounter;
    }

    @Override
    public void preSuperStart() {
        block0: {
            if (!this.resizer().isTimeForResize(this.resizeCounter().getAndIncrement())) break block0;
            this.resize(true);
        }
    }

    @Override
    public void sendMessage(Envelope envelope) {
        if (!this.routerConfig().isManagementMessage(envelope.message()) && this.resizer().isTimeForResize(this.resizeCounter().getAndIncrement()) && this.resizeInProgress().compareAndSet(false, true)) {
            super.sendMessage(Envelope$.MODULE$.apply(ResizablePoolActor$Resize$.MODULE$, this.self(), this.system()));
        }
        super.sendMessage(envelope);
    }

    public void resize(boolean initial) {
        if (this.resizeInProgress().get() || initial) {
            try {
                this.tryReportMessageCount();
                int requestedCapacity = this.resizer().resize(this.router().routees());
                if (requestedCapacity > 0) {
                    Vector newRoutees = (Vector)package$.MODULE$.Vector().fill(requestedCapacity, (Function0<Routee> & Serializable & scala.Serializable)() -> this.pool().newRoutee(this.routeeProps(), this));
                    this.addRoutees(newRoutees);
                } else if (requestedCapacity < 0) {
                    IndexedSeq<Routee> currentRoutees = this.router().routees();
                    IndexedSeq abandon = (IndexedSeq)currentRoutees.drop(currentRoutees.length() + requestedCapacity);
                    this.removeRoutees(abandon, true);
                }
            }
            finally {
                this.resizeInProgress().set(false);
            }
        }
    }

    private void tryReportMessageCount() {
        Resizer resizer = this.resizer();
        if (resizer instanceof OptimalSizeExploringResizer) {
            OptimalSizeExploringResizer optimalSizeExploringResizer = (OptimalSizeExploringResizer)resizer;
            optimalSizeExploringResizer.reportMessageCount(this.router().routees(), this.resizeCounter().get());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public ResizablePoolCell(ActorSystemImpl _system, InternalActorRef _ref, Props _routerProps, MessageDispatcher _routerDispatcher, Props _routeeProps, InternalActorRef _supervisor, Pool pool) {
        this.pool = pool;
        super(_system, _ref, _routerProps, _routerDispatcher, _routeeProps, _supervisor);
        Predef$.MODULE$.require(pool.resizer().isDefined(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "RouterConfig must be a Pool with defined resizer");
        this.resizer = pool.resizer().get();
        this.resizeInProgress = new AtomicBoolean();
        this.resizeCounter = new AtomicLong();
    }
}

