/*
 * Decompiled with CFR 0.152.
 */
package akka.util;

import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.util.HashCode$;
import akka.util.ManifestInfo$;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015v!\u0002\u0016,\u0011\u0003\u0001d!\u0002\u001a,\u0011\u0003\u0019\u0004BB&\u0002\t\u0003\ti\u0006C\u0005\u0002`\u0005\u0011\r\u0011\"\u0003\u0002b!9\u00111M\u0001!\u0002\u0013Y\b\"CA3\u0003\t\u0007I\u0011BA1\u0011\u001d\t9'\u0001Q\u0001\nmD\u0011\"!\u001b\u0002\u0005\u0004%I!!\u0019\t\u000f\u0005-\u0014\u0001)A\u0005w\"I\u0011QN\u0001C\u0002\u0013%\u0011\u0011\r\u0005\b\u0003_\n\u0001\u0015!\u0003|\u0011%\t\t(\u0001b\u0001\n\u0013\t\t\u0007C\u0004\u0002t\u0005\u0001\u000b\u0011B>\t\u0013\u0005U\u0014A1A\u0005\n\u0005\u0005\u0004bBA<\u0003\u0001\u0006Ia\u001f\u0005\n\u0003s\n!\u0019!C\u0005\u0003wB\u0001\"a!\u0002A\u0003%\u0011Q\u0010\u0005\b\u0003\u000b\u000bA\u0011IAD\u0011\u001d\t))\u0001C!\u0003#Cq!a'\u0002\t\u0003\ni\nC\u0004\u0002 \u0006!\t%!)\u0007\t\u0001\f!!\u0019\u0005\tYV\u0011)\u0019!C\u0001[\"Aa.\u0006B\u0001B\u0003%1\fC\u0003L+\u0011\u0005q\u000e\u0003\u0006r+A\u0005\t1!Q\u0001\nIDq!`\u000bC\u0002\u0013%a\u0010\u0003\u0004\u0000+\u0001\u0006I!\u001e\u0005\t\u0003\u0003)\"\u0019!C\u0005[\"9\u00111A\u000b!\u0002\u0013Y\u0006bBA\u0003+\u0011\u0005\u0013q\u0001\u0005\b\u0003\u001b)B\u0011IA\b\u0011\u001d\t\t#\u0006C!\u0003GAq!!\n\u0016\t\u0003\n9C\u0002\u00033W\t\t\u0005\u0002C##\u0005\u000b\u0007I\u0011\u0001$\t\u0011)\u0013#\u0011!Q\u0001\n\u001dCQa\u0013\u0012\u0005\u00021CqA\u0014\u0012C\u0002\u0013\u0005q\nC\u0004\u0002*\t\u0002\u000b\u0011\u0002)\t\u000f\u0005-\"\u0005\"\u0001\u0002.!9\u00111\u0006\u0012\u0005\u0002\u0005-\u0013\u0001D'b]&4Wm\u001d;J]\u001a|'B\u0001\u0017.\u0003\u0011)H/\u001b7\u000b\u00039\nA!Y6lC\u000e\u0001\u0001CA\u0019\u0002\u001b\u0005Y#\u0001D'b]&4Wm\u001d;J]\u001a|7#B\u00015u\u0005]\u0003CA\u001b9\u001b\u00051$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2$AB!osJ+g\rE\u0002<}\u0001k\u0011\u0001\u0010\u0006\u0003{5\nQ!Y2u_JL!a\u0010\u001f\u0003\u0017\u0015CH/\u001a8tS>t\u0017\n\u001a\t\u0003c\t\u001a2A\t\u001bC!\tY4)\u0003\u0002Ey\tIQ\t\u001f;f]NLwN\\\u0001\u0007gf\u001cH/Z7\u0016\u0003\u001d\u0003\"a\u000f%\n\u0005%c$aE#yi\u0016tG-\u001a3BGR|'oU=ti\u0016l\u0017aB:zgR,W\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0001k\u0005\"B#&\u0001\u00049\u0015\u0001\u0003<feNLwN\\:\u0016\u0003A\u0003B!\u0015-\\=:\u0011!K\u0016\t\u0003'Zj\u0011\u0001\u0016\u0006\u0003+>\na\u0001\u0010:p_Rt\u0014BA,7\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011L\u0017\u0002\u0004\u001b\u0006\u0004(BA,7!\t\tF,\u0003\u0002^5\n11\u000b\u001e:j]\u001e\u0004\"aX\u000b\u000f\u0005E\u0002!a\u0002,feNLwN\\\n\u0004+Q\u0012\u0007cA2iU6\tAM\u0003\u0002fM\u0006!A.\u00198h\u0015\u00059\u0017\u0001\u00026bm\u0006L!!\u001b3\u0003\u0015\r{W\u000e]1sC\ndW\r\u0005\u0002l+5\t\u0011!A\u0004wKJ\u001c\u0018n\u001c8\u0016\u0003m\u000b\u0001B^3sg&|g\u000e\t\u000b\u0003UBDQ\u0001\u001c\rA\u0002m\u000b1\u0001\u001f\u00132!\u0011)4/^>\n\u0005Q4$A\u0002+va2,'\u0007E\u00026mbL!a\u001e\u001c\u0003\u000b\u0005\u0013(/Y=\u0011\u0005UJ\u0018B\u0001>7\u0005\rIe\u000e\u001e\t\u0003GrL!!\u00183\u0002\u000f9,XNY3sgV\tQ/\u0001\u0005ok6\u0014WM]:!\u0003\u0011\u0011Xm\u001d;\u0002\u000bI,7\u000f\u001e\u0011\u0002\u0013\r|W\u000e]1sKR{Gc\u0001=\u0002\n!1\u00111\u0002\u0010A\u0002)\fQa\u001c;iKJ\fa!Z9vC2\u001cH\u0003BA\t\u0003/\u00012!NA\n\u0013\r\t)B\u000e\u0002\b\u0005>|G.Z1o\u0011\u001d\tIb\ba\u0001\u00037\t\u0011a\u001c\t\u0004k\u0005u\u0011bAA\u0010m\t\u0019\u0011I\\=\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012\u0001_\u0001\ti>\u001cFO]5oOR\t1,A\u0005wKJ\u001c\u0018n\u001c8tA\u0005\u00012\r[3dWN\u000bW.\u001a,feNLwN\u001c\u000b\t\u0003#\ty#a\r\u0002H!1\u0011\u0011\u0007\u0015A\u0002m\u000b1\u0002\u001d:pIV\u001cGOT1nK\"9\u0011Q\u0007\u0015A\u0002\u0005]\u0012\u0001\u00043fa\u0016tG-\u001a8dS\u0016\u001c\b#BA\u001d\u0003\u0007ZVBAA\u001e\u0015\u0011\ti$a\u0010\u0002\u0013%lW.\u001e;bE2,'bAA!m\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0015\u00131\b\u0002\u0004'\u0016\f\bbBA%Q\u0001\u0007\u0011\u0011C\u0001\u000bY><w+\u0019:oS:<GCCA\t\u0003\u001b\ny%!\u0015\u0002T!1\u0011\u0011G\u0015A\u0002mCq!!\u000e*\u0001\u0004\t9\u0004C\u0004\u0002J%\u0002\r!!\u0005\t\u000f\u0005U\u0013\u00061\u0001\u0002\u0012\u0005qA\u000f\u001b:po\u0016C8-\u001a9uS>t\u0007cA\u001e\u0002Z%\u0019\u00111\f\u001f\u0003'\u0015CH/\u001a8tS>t\u0017\n\u001a)s_ZLG-\u001a:\u0015\u0003A\n\u0011\"S7qYRKG\u000f\\3\u0016\u0003m\f!\"S7qYRKG\u000f\\3!\u0003-IU\u000e\u001d7WKJ\u001c\u0018n\u001c8\u0002\u0019%k\u0007\u000f\u001c,feNLwN\u001c\u0011\u0002\u0015%k\u0007\u000f\u001c,f]\u0012|'/A\u0006J[Bdg+\u001a8e_J\u0004\u0013A\u0003\"v]\u0012dWMT1nK\u0006Y!)\u001e8eY\u0016t\u0015-\\3!\u00035\u0011UO\u001c3mKZ+'o]5p]\u0006q!)\u001e8eY\u00164VM]:j_:\u0004\u0013\u0001\u0004\"v]\u0012dWMV3oI>\u0014\u0018!\u0004\"v]\u0012dWMV3oI>\u0014\b%\u0001\u0007l]><hNV3oI>\u00148/\u0006\u0002\u0002~A)\u0011\u0011HA@w&!\u0011\u0011QA\u001e\u0005\r\u0019V\r^\u0001\u000eW:|wO\u001c,f]\u0012|'o\u001d\u0011\u0002\u0007\u001d,G\u000fF\u0002A\u0003\u0013Ca!R\tA\u0002\u0005-\u0005cA\u001e\u0002\u000e&\u0019\u0011q\u0012\u001f\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\u001c\u000b\u0004\u0001\u0006M\u0005BB#\u0013\u0001\u0004\t)\nE\u0002<\u0003/K1!!'=\u0005i\u0019E.Y:tS\u000e\f5\r^8s'f\u001cH/Z7Qe>4\u0018\u000eZ3s\u0003\u0019awn\\6vaR\tq,A\bde\u0016\fG/Z#yi\u0016t7/[8o)\r\u0001\u00151\u0015\u0005\u0006\u000bR\u0001\ra\u0012")
public final class ManifestInfo
implements Extension {
    private final ExtendedActorSystem system;
    private final Map<String, Version> versions;

    public static ManifestInfo createExtension(ExtendedActorSystem extendedActorSystem) {
        return ManifestInfo$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ManifestInfo$ lookup() {
        return ManifestInfo$.MODULE$.lookup();
    }

    public static ManifestInfo get(ClassicActorSystemProvider classicActorSystemProvider) {
        return ManifestInfo$.MODULE$.get(classicActorSystemProvider);
    }

    public static ManifestInfo get(ActorSystem actorSystem) {
        return ManifestInfo$.MODULE$.get(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return ManifestInfo$.MODULE$.apply(classicActorSystemProvider);
    }

    public static Extension apply(ActorSystem actorSystem) {
        return ManifestInfo$.MODULE$.apply(actorSystem);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public Map<String, Version> versions() {
        return this.versions;
    }

    public boolean checkSameVersion(String productName, Seq<String> dependencies, boolean logWarning) {
        return this.checkSameVersion(productName, dependencies, logWarning, this.system().settings().FailMixedVersions());
    }

    public boolean checkSameVersion(String productName, Seq<String> dependencies, boolean logWarning, boolean throwException) {
        boolean bl;
        Map filteredVersions = this.versions().filterKeys(dependencies.toSet());
        Set values = filteredVersions.values().toSet();
        if (values.size() > 1) {
            String conflictingVersions = values.mkString(", ");
            String fullInfo = ((TraversableOnce)filteredVersions.map((Function1<Tuple2, String> & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String k = (String)tuple2._1();
                Version v = (Version)tuple2._2();
                String string2 = new StringBuilder(1).append(k).append(":").append(v).toString();
                return string2;
            }, Iterable$.MODULE$.canBuildFrom())).mkString(", ");
            Version highestVersion = (Version)values.max(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
            String message = new StringBuilder(347).append("Detected possible incompatible versions on the classpath. ").append("Please note that a given ").append(productName).append(" version MUST be the same across all modules of ").append(productName).append(" ").append("that you are using, e.g. if you use [").append(highestVersion).append("] all other modules that are released together MUST be of the ").append("same version. Make sure you're using a compatible set of libraries. ").append("Possibly conflicting versions [").append(conflictingVersions).append("] in libraries [").append(fullInfo).append("]").toString();
            if (logWarning) {
                Logging$.MODULE$.apply(this.system(), this.getClass(), LogSource$.MODULE$.fromAnyClass()).warning(message);
            }
            if (throwException) {
                throw new IllegalStateException(message);
            }
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private final void liftedTree2$1(ObjectRef manifests$1) {
        try {
            Enumeration<URL> resources = this.system().dynamicAccess().classLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                try (InputStream ios = resources.nextElement().openStream();){
                    Manifest manifest = new Manifest(ios);
                    Attributes attributes = manifest.getMainAttributes();
                    String string2 = attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$ImplTitle()));
                    String string3 = string2 == null ? attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$BundleName())) : string2;
                    String title = string3;
                    String string4 = attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$ImplVersion()));
                    String string5 = string4 == null ? attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$BundleVersion())) : string4;
                    String version = string5;
                    String string6 = attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$ImplVendor()));
                    String string7 = string6 == null ? attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$BundleVendor())) : string6;
                    String vendor = string7;
                    if (title == null || version == null || vendor == null || !ManifestInfo$.MODULE$.akka$util$ManifestInfo$$knownVendors().apply(vendor)) continue;
                    manifests$1.elem = ((Map)manifests$1.elem).updated(title, new Version(version));
                }
            }
        }
        catch (IOException ioe) {
            Logging$.MODULE$.apply(this.system(), this.getClass(), LogSource$.MODULE$.fromAnyClass()).warning("Could not read manifest information. {}", ioe);
        }
    }

    public ManifestInfo(ExtendedActorSystem system) {
        this.system = system;
        ObjectRef<GenMap> manifests = ObjectRef.create(Predef$.MODULE$.Map().empty());
        this.liftedTree2$1(manifests);
        this.versions = (Map)manifests.elem;
    }

    public static final class Version
    implements Comparable<Version> {
        private final String version;
        private final /* synthetic */ Tuple2 x$1;
        private final int[] numbers;
        private final String rest;

        public String version() {
            return this.version;
        }

        private int[] numbers() {
            return this.numbers;
        }

        private String rest() {
            return this.rest;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(Version other) {
            void var2_2;
            block0: {
                int diff = 0;
                diff = this.numbers()[0] - other.numbers()[0];
                if (diff != 0 || (diff = this.numbers()[1] - other.numbers()[1]) != 0 || (diff = this.numbers()[2] - other.numbers()[2]) != 0) break block0;
                diff = this.rest().compareTo(other.rest());
            }
            return (int)var2_2;
        }

        public boolean equals(Object o) {
            Version version;
            Object object = o;
            boolean bl = object instanceof Version ? this.compareTo(version = (Version)object) == 0 : false;
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        public int hashCode() {
            void var1_1;
            int result2 = HashCode$.MODULE$.SEED();
            result2 = HashCode$.MODULE$.hash(result2, this.numbers()[0]);
            result2 = HashCode$.MODULE$.hash(result2, this.numbers()[1]);
            result2 = HashCode$.MODULE$.hash(result2, this.numbers()[2]);
            result2 = HashCode$.MODULE$.hash(result2, this.rest());
            return (int)var1_1;
        }

        public String toString() {
            return this.version();
        }

        private static final void liftedTree1$1(int[] numbers$1, IntRef numbersPos$1, String[] segments$1, IntRef segmentPos$1) {
            try {
                numbers$1[numbersPos$1.elem] = new StringOps(Predef$.MODULE$.augmentString(segments$1[segmentPos$1.elem])).toInt();
                ++segmentPos$1.elem;
            }
            catch (NumberFormatException numberFormatException) {
                numbers$1[numbersPos$1.elem] = Integer.MAX_VALUE;
            }
        }

        public Version(String version) {
            int[] nArray;
            String rest;
            block6: {
                Tuple2<int[], String> tuple2;
                block5: {
                    this.version = version;
                    int[] numbers = new int[3];
                    String[] segments = version.split("[.-]");
                    IntRef segmentPos = IntRef.create(0);
                    IntRef numbersPos = IntRef.create(0);
                    while (numbersPos.elem < 3) {
                        if (segmentPos.elem < segments.length) {
                            Version.liftedTree1$1(numbers, numbersPos, segments, segmentPos);
                        }
                        ++numbersPos.elem;
                    }
                    String rest2 = segmentPos.elem >= segments.length ? "" : String.join((CharSequence)"-", Arrays.asList(Arrays.copyOfRange((Object[])segments, segmentPos.elem, segments.length)));
                    tuple2 = new Tuple2<int[], String>(numbers, rest2);
                    if (tuple2 == null) break block5;
                    int[] numbers2 = tuple2._1();
                    rest = tuple2._2();
                    if (numbers2 == null) break block5;
                    nArray = numbers2;
                    if (rest != null) break block6;
                }
                throw new MatchError(tuple2);
            }
            String string2 = rest;
            Tuple2<int[], String> tuple2 = new Tuple2<int[], String>(nArray, string2);
            this.x$1 = tuple2;
            this.numbers = (int[])this.x$1._1();
            this.rest = (String)this.x$1._2();
        }
    }
}

