/*
 * Decompiled with CFR 0.152.
 */
package brave.internal.recorder;

import brave.Span;
import brave.internal.zipkin.v2.Span;
import brave.propagation.TraceContext;
import javax.annotation.Nullable;
import zipkin.Endpoint;

final class MutableSpan {
    final Span.Builder span;
    boolean finished;
    long timestamp;

    MutableSpan(TraceContext context, Endpoint localEndpoint) {
        this.span = Span.builder().traceIdHigh(context.traceIdHigh()).traceId(context.traceId()).parentId(context.parentId()).id(context.spanId()).debug(context.debug()).shared(context.shared()).localEndpoint(localEndpoint);
        this.finished = false;
    }

    synchronized MutableSpan start(long timestamp) {
        this.timestamp = timestamp;
        this.span.timestamp(this.timestamp);
        return this;
    }

    synchronized MutableSpan name(String name) {
        this.span.name(name);
        return this;
    }

    synchronized MutableSpan kind(Span.Kind kind) {
        try {
            this.span.kind(Span.Kind.valueOf(kind.name()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this;
    }

    synchronized MutableSpan annotate(long timestamp, String value) {
        this.span.addAnnotation(timestamp, value);
        return this;
    }

    synchronized MutableSpan tag(String key, String value) {
        this.span.putTag(key, value);
        return this;
    }

    synchronized MutableSpan remoteEndpoint(Endpoint remoteEndpoint) {
        this.span.remoteEndpoint(remoteEndpoint);
        return this;
    }

    synchronized MutableSpan finish(@Nullable Long finishTimestamp) {
        if (this.finished) {
            return this;
        }
        this.finished = true;
        if (this.timestamp != 0L && finishTimestamp != null) {
            this.span.duration(Math.max(finishTimestamp - this.timestamp, 1L));
        }
        return this;
    }

    synchronized Span toSpan() {
        return this.span.build();
    }
}

