/*
 * Decompiled with CFR 0.152.
 */
package brave.internal.zipkin;

import brave.internal.zipkin.Util;
import brave.internal.zipkin.v2.Span;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.Endpoint;
import zipkin.Span;

public final class V2SpanConverter {
    public static List<Span> fromSpan(zipkin.Span source) {
        Builders builders = new Builders(source);
        builders.processAnnotations(source);
        builders.processBinaryAnnotations(source);
        return builders.build();
    }

    static boolean closeEnough(Endpoint left, Endpoint right) {
        return left.serviceName.equals(right.serviceName);
    }

    static Span.Builder newBuilder(zipkin.Span source) {
        return Span.builder().traceIdHigh(source.traceIdHigh).traceId(source.traceId).parentId(source.parentId).id(source.id).name(source.name).debug(source.debug);
    }

    public static zipkin.Span toSpan(Span in) {
        long duration;
        Span.Builder result2 = zipkin.Span.builder().traceIdHigh(in.traceIdHigh()).traceId(in.traceId()).parentId(in.parentId()).id(in.id()).debug(in.debug()).name(in.name() == null ? "" : in.name());
        long timestamp = in.timestamp() == null ? 0L : in.timestamp();
        long l = duration = in.duration() == null ? 0L : in.duration();
        if (timestamp != 0L) {
            result2.timestamp(timestamp);
            if (duration != 0L) {
                result2.duration(duration);
            }
        }
        Span.Kind kind = in.kind();
        Annotation cs = null;
        Annotation sr = null;
        Annotation ss = null;
        Annotation cr = null;
        Annotation ms = null;
        Annotation mr = null;
        Annotation ws = null;
        Annotation wr = null;
        String remoteEndpointType = null;
        boolean wroteEndpoint = false;
        int length = in.annotations().size();
        for (int i = 0; i < length; ++i) {
            Annotation a = in.annotations().get(i);
            if (in.localEndpoint() != null) {
                a = a.toBuilder().endpoint(in.localEndpoint()).build();
            }
            if (a.value.length() == 2) {
                if (a.value.equals("cs")) {
                    kind = Span.Kind.CLIENT;
                    cs = a;
                    remoteEndpointType = "sa";
                    continue;
                }
                if (a.value.equals("sr")) {
                    kind = Span.Kind.SERVER;
                    sr = a;
                    remoteEndpointType = "ca";
                    continue;
                }
                if (a.value.equals("ss")) {
                    kind = Span.Kind.SERVER;
                    ss = a;
                    continue;
                }
                if (a.value.equals("cr")) {
                    kind = Span.Kind.CLIENT;
                    cr = a;
                    continue;
                }
                if (a.value.equals("ms")) {
                    kind = Span.Kind.PRODUCER;
                    ms = a;
                    continue;
                }
                if (a.value.equals("mr")) {
                    kind = Span.Kind.CONSUMER;
                    mr = a;
                    continue;
                }
                if (a.value.equals("ws")) {
                    ws = a;
                    continue;
                }
                if (a.value.equals("wr")) {
                    wr = a;
                    continue;
                }
                wroteEndpoint = true;
                result2.addAnnotation(a);
                continue;
            }
            wroteEndpoint = true;
            result2.addAnnotation(a);
        }
        if (kind != null) {
            switch (kind) {
                case CLIENT: {
                    remoteEndpointType = "sa";
                    if (timestamp != 0L) {
                        cs = Annotation.create(timestamp, "cs", in.localEndpoint());
                    }
                    if (duration == 0L) break;
                    cr = Annotation.create(timestamp + duration, "cr", in.localEndpoint());
                    break;
                }
                case SERVER: {
                    remoteEndpointType = "ca";
                    if (timestamp != 0L) {
                        sr = Annotation.create(timestamp, "sr", in.localEndpoint());
                    }
                    if (duration == 0L) break;
                    ss = Annotation.create(timestamp + duration, "ss", in.localEndpoint());
                    break;
                }
                case PRODUCER: {
                    remoteEndpointType = "ma";
                    if (timestamp != 0L) {
                        ms = Annotation.create(timestamp, "ms", in.localEndpoint());
                    }
                    if (duration == 0L) break;
                    ws = Annotation.create(timestamp + duration, "ws", in.localEndpoint());
                    break;
                }
                case CONSUMER: {
                    remoteEndpointType = "ma";
                    if (timestamp != 0L && duration != 0L) {
                        wr = Annotation.create(timestamp, "wr", in.localEndpoint());
                        mr = Annotation.create(timestamp + duration, "mr", in.localEndpoint());
                        break;
                    }
                    if (timestamp == 0L) break;
                    mr = Annotation.create(timestamp, "mr", in.localEndpoint());
                    break;
                }
                default: {
                    throw new AssertionError((Object)"update kind mapping");
                }
            }
        }
        for (Map.Entry<String, String> tag2 : in.tags().entrySet()) {
            wroteEndpoint = true;
            result2.addBinaryAnnotation(BinaryAnnotation.create(tag2.getKey(), tag2.getValue(), in.localEndpoint()));
        }
        if (cs != null || sr != null || ss != null || cr != null || ws != null || wr != null || ms != null || mr != null) {
            if (cs != null) {
                result2.addAnnotation(cs);
            }
            if (sr != null) {
                result2.addAnnotation(sr);
            }
            if (ss != null) {
                result2.addAnnotation(ss);
            }
            if (cr != null) {
                result2.addAnnotation(cr);
            }
            if (ws != null) {
                result2.addAnnotation(ws);
            }
            if (wr != null) {
                result2.addAnnotation(wr);
            }
            if (ms != null) {
                result2.addAnnotation(ms);
            }
            if (mr != null) {
                result2.addAnnotation(mr);
            }
            wroteEndpoint = true;
        } else if (in.localEndpoint() != null && in.remoteEndpoint() != null) {
            result2.addBinaryAnnotation(BinaryAnnotation.address("ca", in.localEndpoint()));
            wroteEndpoint = true;
            remoteEndpointType = "sa";
        }
        if (remoteEndpointType != null && in.remoteEndpoint() != null) {
            result2.addBinaryAnnotation(BinaryAnnotation.address(remoteEndpointType, in.remoteEndpoint()));
        }
        if (Boolean.TRUE.equals(in.shared()) && sr != null) {
            result2.timestamp(null).duration(null);
        }
        if (in.localEndpoint() != null && !wroteEndpoint) {
            result2.addBinaryAnnotation(BinaryAnnotation.create("lc", "", in.localEndpoint()));
        }
        return result2.build();
    }

    static final class Builders {
        final List<Span.Builder> spans = new ArrayList<Span.Builder>();
        Annotation cs = null;
        Annotation sr = null;
        Annotation ss = null;
        Annotation cr = null;
        Annotation ms = null;
        Annotation mr = null;
        Annotation ws = null;
        Annotation wr = null;

        Builders(zipkin.Span source) {
            this.spans.add(V2SpanConverter.newBuilder(source));
        }

        void processAnnotations(zipkin.Span source) {
            int length = source.annotations.size();
            for (int i = 0; i < length; ++i) {
                Annotation a = source.annotations.get(i);
                Span.Builder currentSpan = this.forEndpoint(source, a.endpoint);
                if (a.value.length() == 2 && a.endpoint != null) {
                    if (a.value.equals("cs")) {
                        currentSpan.kind(Span.Kind.CLIENT);
                        this.cs = a;
                        continue;
                    }
                    if (a.value.equals("sr")) {
                        currentSpan.kind(Span.Kind.SERVER);
                        this.sr = a;
                        continue;
                    }
                    if (a.value.equals("ss")) {
                        currentSpan.kind(Span.Kind.SERVER);
                        this.ss = a;
                        continue;
                    }
                    if (a.value.equals("cr")) {
                        currentSpan.kind(Span.Kind.CLIENT);
                        this.cr = a;
                        continue;
                    }
                    if (a.value.equals("ms")) {
                        currentSpan.kind(Span.Kind.PRODUCER);
                        this.ms = a;
                        continue;
                    }
                    if (a.value.equals("mr")) {
                        currentSpan.kind(Span.Kind.CONSUMER);
                        this.mr = a;
                        continue;
                    }
                    if (a.value.equals("ws")) {
                        this.ws = a;
                        continue;
                    }
                    if (a.value.equals("wr")) {
                        this.wr = a;
                        continue;
                    }
                    currentSpan.addAnnotation(a.timestamp, a.value);
                    continue;
                }
                currentSpan.addAnnotation(a.timestamp, a.value);
            }
            if (this.cs != null && this.sr != null) {
                Span.Builder server;
                this.maybeTimestampDuration(source, this.cs, this.cr);
                Span.Builder client = this.forEndpoint(source, this.cs.endpoint);
                if (V2SpanConverter.closeEnough(this.cs.endpoint, this.sr.endpoint)) {
                    client.kind(Span.Kind.CLIENT);
                    server = this.newSpanBuilder(source, this.sr.endpoint).kind(Span.Kind.SERVER);
                } else {
                    server = this.forEndpoint(source, this.sr.endpoint);
                }
                server.shared(true).timestamp(this.sr.timestamp);
                if (this.ss != null) {
                    server.duration(this.ss.timestamp - this.sr.timestamp);
                }
                if (this.cr == null && source.duration == null) {
                    client.duration(null);
                }
            } else if (this.cs != null && this.cr != null) {
                this.maybeTimestampDuration(source, this.cs, this.cr);
            } else if (this.sr != null && this.ss != null) {
                this.maybeTimestampDuration(source, this.sr, this.ss);
            } else {
                for (Span.Builder next : this.spans) {
                    if (Span.Kind.CLIENT.equals((Object)next.kind())) {
                        if (this.cs == null) continue;
                        next.timestamp(this.cs.timestamp);
                        continue;
                    }
                    if (!Span.Kind.SERVER.equals((Object)next.kind()) || this.sr == null) continue;
                    next.timestamp(this.sr.timestamp);
                }
                if (source.timestamp != null) {
                    this.spans.get(0).timestamp(source.timestamp).duration(source.duration);
                }
            }
            if (this.cs == null && this.sr != null && source.timestamp == null) {
                this.forEndpoint(source, this.sr.endpoint).shared(true);
            }
            if (this.ms != null && this.mr != null) {
                Span.Builder consumer;
                Span.Builder producer = this.forEndpoint(source, this.ms.endpoint);
                if (V2SpanConverter.closeEnough(this.ms.endpoint, this.mr.endpoint)) {
                    producer.kind(Span.Kind.PRODUCER);
                    consumer = this.newSpanBuilder(source, this.mr.endpoint).kind(Span.Kind.CONSUMER);
                } else {
                    consumer = this.forEndpoint(source, this.mr.endpoint);
                }
                consumer.shared(true);
                if (this.wr != null) {
                    consumer.timestamp(this.wr.timestamp).duration(this.mr.timestamp - this.wr.timestamp);
                } else {
                    consumer.timestamp(this.mr.timestamp);
                }
                producer.timestamp(this.ms.timestamp).duration(this.ws != null ? Long.valueOf(this.ws.timestamp - this.ms.timestamp) : null);
            } else if (this.ms != null) {
                this.maybeTimestampDuration(source, this.ms, this.ws);
            } else if (this.mr != null) {
                if (this.wr != null) {
                    this.maybeTimestampDuration(source, this.wr, this.mr);
                } else {
                    this.maybeTimestampDuration(source, this.mr, null);
                }
            } else {
                if (this.ws != null) {
                    this.forEndpoint(source, this.ws.endpoint).addAnnotation(this.ws.timestamp, this.ws.value);
                }
                if (this.wr != null) {
                    this.forEndpoint(source, this.wr.endpoint).addAnnotation(this.wr.timestamp, this.wr.value);
                }
            }
        }

        void maybeTimestampDuration(zipkin.Span source, Annotation begin, @Nullable Annotation end) {
            Span.Builder span2 = this.forEndpoint(source, begin.endpoint);
            if (source.timestamp != null && source.duration != null) {
                span2.timestamp(source.timestamp).duration(source.duration);
            } else {
                span2.timestamp(begin.timestamp);
                if (end != null) {
                    span2.duration(end.timestamp - begin.timestamp);
                }
            }
        }

        void processBinaryAnnotations(zipkin.Span source) {
            Endpoint ca = null;
            Endpoint sa = null;
            Endpoint ma = null;
            int length = source.binaryAnnotations.size();
            block9: for (int i = 0; i < length; ++i) {
                BinaryAnnotation b = source.binaryAnnotations.get(i);
                if (b.type == BinaryAnnotation.Type.BOOL) {
                    if ("ca".equals(b.key)) {
                        ca = b.endpoint;
                        continue;
                    }
                    if ("sa".equals(b.key)) {
                        sa = b.endpoint;
                        continue;
                    }
                    if ("ma".equals(b.key)) {
                        ma = b.endpoint;
                        continue;
                    }
                    this.forEndpoint(source, b.endpoint).putTag(b.key, b.value[0] == 1 ? "true" : "false");
                    continue;
                }
                Span.Builder currentSpan = this.forEndpoint(source, b.endpoint);
                switch (b.type) {
                    case BOOL: {
                        continue block9;
                    }
                    case STRING: {
                        if ("lc".equals(b.key) && b.value.length == 0) continue block9;
                        currentSpan.putTag(b.key, new String(b.value, Util.UTF_8));
                        continue block9;
                    }
                    case BYTES: {
                        currentSpan.putTag(b.key, Util.writeBase64Url(b.value));
                        continue block9;
                    }
                    case I16: {
                        currentSpan.putTag(b.key, Short.toString(ByteBuffer.wrap(b.value).getShort()));
                        continue block9;
                    }
                    case I32: {
                        currentSpan.putTag(b.key, Integer.toString(ByteBuffer.wrap(b.value).getInt()));
                        continue block9;
                    }
                    case I64: {
                        currentSpan.putTag(b.key, Long.toString(ByteBuffer.wrap(b.value).getLong()));
                        continue block9;
                    }
                    case DOUBLE: {
                        double wrapped = Double.longBitsToDouble(ByteBuffer.wrap(b.value).getLong());
                        currentSpan.putTag(b.key, Double.toString(wrapped));
                    }
                }
            }
            if (this.cs != null && sa != null && !V2SpanConverter.closeEnough(sa, this.cs.endpoint)) {
                this.forEndpoint(source, this.cs.endpoint).remoteEndpoint(sa);
            }
            if (this.sr != null && ca != null && !V2SpanConverter.closeEnough(ca, this.sr.endpoint)) {
                this.forEndpoint(source, this.sr.endpoint).remoteEndpoint(ca);
            }
            if (this.ms != null && ma != null && !V2SpanConverter.closeEnough(ma, this.ms.endpoint)) {
                this.forEndpoint(source, this.ms.endpoint).remoteEndpoint(ma);
            }
            if (this.mr != null && ma != null && !V2SpanConverter.closeEnough(ma, this.mr.endpoint)) {
                this.forEndpoint(source, this.mr.endpoint).remoteEndpoint(ma);
            }
            if (this.cs == null && this.sr == null && ca != null && sa != null) {
                this.forEndpoint(source, ca).remoteEndpoint(sa);
            }
        }

        Span.Builder forEndpoint(zipkin.Span source, @Nullable Endpoint e) {
            if (e == null) {
                return this.spans.get(0);
            }
            int length = this.spans.size();
            for (int i = 0; i < length; ++i) {
                Span.Builder next = this.spans.get(i);
                Endpoint nextLocalEndpoint = next.localEndpoint();
                if (nextLocalEndpoint == null) {
                    next.localEndpoint(e);
                    return next;
                }
                if (!V2SpanConverter.closeEnough(nextLocalEndpoint, e)) continue;
                return next;
            }
            return this.newSpanBuilder(source, e);
        }

        Span.Builder newSpanBuilder(zipkin.Span source, Endpoint e) {
            Span.Builder result2 = V2SpanConverter.newBuilder(source).localEndpoint(e);
            this.spans.add(result2);
            return result2;
        }

        List<Span> build() {
            int length = this.spans.size();
            if (length == 1) {
                return Collections.singletonList(this.spans.get(0).build());
            }
            ArrayList<Span> result2 = new ArrayList<Span>(length);
            for (int i = 0; i < length; ++i) {
                result2.add(this.spans.get(i).build());
            }
            return result2;
        }
    }
}

