/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.internal.HexCodec;
import brave.propagation.Propagation;
import brave.propagation.SamplingFlags;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class B3Propagation<K>
implements Propagation<K> {
    static final String TRACE_ID_NAME = "X-B3-TraceId";
    static final String SPAN_ID_NAME = "X-B3-SpanId";
    static final String PARENT_SPAN_ID_NAME = "X-B3-ParentSpanId";
    static final String SAMPLED_NAME = "X-B3-Sampled";
    static final String FLAGS_NAME = "X-B3-Flags";
    final K traceIdKey;
    final K spanIdKey;
    final K parentSpanIdKey;
    final K sampledKey;
    final K debugKey;
    final List<K> fields;

    public static <K> B3Propagation<K> create(Propagation.KeyFactory<K> keyFactory) {
        return new B3Propagation<K>(keyFactory);
    }

    B3Propagation(Propagation.KeyFactory<K> keyFactory) {
        this.traceIdKey = keyFactory.create(TRACE_ID_NAME);
        this.spanIdKey = keyFactory.create(SPAN_ID_NAME);
        this.parentSpanIdKey = keyFactory.create(PARENT_SPAN_ID_NAME);
        this.sampledKey = keyFactory.create(SAMPLED_NAME);
        this.debugKey = keyFactory.create(FLAGS_NAME);
        this.fields = Collections.unmodifiableList(Arrays.asList(this.traceIdKey, this.spanIdKey, this.parentSpanIdKey, this.sampledKey, this.debugKey));
    }

    @Override
    public List<K> keys() {
        return this.fields;
    }

    @Override
    public <C> TraceContext.Injector<C> injector(Propagation.Setter<C, K> setter2) {
        if (setter2 == null) {
            throw new NullPointerException("setter == null");
        }
        return new B3Injector<C, K>(this, setter2);
    }

    @Override
    public <C> TraceContext.Extractor<C> extractor(Propagation.Getter<C, K> getter2) {
        if (getter2 == null) {
            throw new NullPointerException("getter == null");
        }
        return new B3Extractor<C, K>(this, getter2);
    }

    static final class B3Extractor<C, K>
    implements TraceContext.Extractor<C> {
        final B3Propagation<K> propagation;
        final Propagation.Getter<C, K> getter;

        B3Extractor(B3Propagation<K> propagation, Propagation.Getter<C, K> getter2) {
            this.propagation = propagation;
            this.getter = getter2;
        }

        @Override
        public TraceContextOrSamplingFlags extract(C carrier) {
            String parentSpanIdString;
            if (carrier == null) {
                throw new NullPointerException("carrier == null");
            }
            String sampledString = this.getter.get(carrier, this.propagation.sampledKey);
            Boolean sampled = sampledString != null ? Boolean.valueOf(sampledString.equals("1") || sampledString.equalsIgnoreCase("true")) : null;
            boolean debug = "1".equals(this.getter.get(carrier, this.propagation.debugKey));
            String traceIdString = this.getter.get(carrier, this.propagation.traceIdKey);
            if (traceIdString == null) {
                return TraceContextOrSamplingFlags.create(new SamplingFlags.Builder().sampled(sampled).debug(debug).build());
            }
            TraceContext.Builder result2 = TraceContext.newBuilder().sampled(sampled).debug(debug);
            result2.traceIdHigh(traceIdString.length() == 32 ? HexCodec.lowerHexToUnsignedLong(traceIdString, 0) : 0L);
            result2.traceId(HexCodec.lowerHexToUnsignedLong(traceIdString));
            String spanIdString = this.getter.get(carrier, this.propagation.spanIdKey);
            if (spanIdString != null) {
                result2.spanId(HexCodec.lowerHexToUnsignedLong(spanIdString));
            }
            if ((parentSpanIdString = this.getter.get(carrier, this.propagation.parentSpanIdKey)) != null) {
                result2.parentId(HexCodec.lowerHexToUnsignedLong(parentSpanIdString));
            }
            return TraceContextOrSamplingFlags.create(result2);
        }
    }

    static final class B3Injector<C, K>
    implements TraceContext.Injector<C> {
        final B3Propagation<K> propagation;
        final Propagation.Setter<C, K> setter;

        B3Injector(B3Propagation<K> propagation, Propagation.Setter<C, K> setter2) {
            this.propagation = propagation;
            this.setter = setter2;
        }

        @Override
        public void inject(TraceContext traceContext, C carrier) {
            this.setter.put(carrier, this.propagation.traceIdKey, traceContext.traceIdString());
            this.setter.put(carrier, this.propagation.spanIdKey, HexCodec.toLowerHex(traceContext.spanId()));
            if (traceContext.parentId() != null) {
                this.setter.put(carrier, this.propagation.parentSpanIdKey, HexCodec.toLowerHex(traceContext.parentId()));
            }
            if (traceContext.sampled() != null) {
                this.setter.put(carrier, this.propagation.sampledKey, traceContext.sampled() != false ? "1" : "0");
            }
            if (traceContext.debug()) {
                this.setter.put(carrier, this.propagation.debugKey, "1");
            }
        }
    }
}

