/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.internal.HexCodec;
import brave.propagation.AutoValue_TraceContext;
import brave.propagation.SamplingFlags;
import brave.propagation.TraceContextOrSamplingFlags;
import com.google.auto.value.AutoValue;
import javax.annotation.Nullable;

@AutoValue
public abstract class TraceContext
extends SamplingFlags {
    public static Builder newBuilder() {
        return new AutoValue_TraceContext.Builder().traceIdHigh(0L).debug(false).shared(false);
    }

    public abstract long traceIdHigh();

    public abstract long traceId();

    @Nullable
    public abstract Long parentId();

    @Override
    @Nullable
    public abstract Boolean sampled();

    public abstract long spanId();

    public abstract boolean shared();

    public abstract Builder toBuilder();

    public String traceIdString() {
        if (this.traceIdHigh() != 0L) {
            char[] result2 = new char[32];
            HexCodec.writeHexLong(result2, 0, this.traceIdHigh());
            HexCodec.writeHexLong(result2, 16, this.traceId());
            return new String(result2);
        }
        char[] result3 = new char[16];
        HexCodec.writeHexLong(result3, 0, this.traceId());
        return new String(result3);
    }

    public String toString() {
        boolean traceHi = this.traceIdHigh() != 0L;
        char[] result2 = new char[(traceHi ? 3 : 2) * 16 + 1];
        int pos = 0;
        if (traceHi) {
            HexCodec.writeHexLong(result2, pos, this.traceIdHigh());
            pos += 16;
        }
        HexCodec.writeHexLong(result2, pos, this.traceId());
        pos += 16;
        result2[pos++] = 47;
        HexCodec.writeHexLong(result2, pos, this.spanId());
        return new String(result2);
    }

    TraceContext() {
    }

    public static abstract class Builder {
        public abstract Builder traceIdHigh(long var1);

        public abstract Builder traceId(long var1);

        public abstract Builder parentId(@Nullable Long var1);

        public abstract Builder spanId(long var1);

        public abstract Builder sampled(Boolean var1);

        public abstract Builder debug(boolean var1);

        public abstract Builder shared(boolean var1);

        public abstract TraceContext build();

        abstract Boolean sampled();

        abstract boolean debug();

        Builder() {
        }
    }

    public static interface Extractor<C> {
        public TraceContextOrSamplingFlags extract(C var1);
    }

    public static interface Injector<C> {
        public void inject(TraceContext var1, C var2);
    }
}

