/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool;

import com.daml.ledger.api.testtool.Cli$;
import com.daml.ledger.api.testtool.Config;
import com.daml.ledger.api.testtool.Tests$;
import com.daml.ledger.api.testtool.infrastructure.LedgerSessionConfiguration;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSuiteRunner;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSummary;
import com.daml.ledger.api.testtool.infrastructure.Reporter;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.math.Ordering$String$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class LedgerApiTestTool$ {
    public static LedgerApiTestTool$ MODULE$;
    private final Logger logger;
    private final String identifierSuffix;
    private final String uncaughtExceptionErrorMessage;

    static {
        new LedgerApiTestTool$();
    }

    private int exitCode(Vector<LedgerTestSummary> summaries, boolean expectFailure) {
        return summaries.exists((Function1<LedgerTestSummary, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(LedgerApiTestTool$.$anonfun$exitCode$1(x$1))) == expectFailure ? 0 : 1;
    }

    private void printAvailableTests() {
        Predef$.MODULE$.println("Tests marked with * are run by default.\n");
        ((IterableLike)((TraversableLike)Tests$.MODULE$.default().keySet().toSeq().sorted(Ordering$String$.MODULE$)).map((Function1<String, String> & Serializable & scala.Serializable)x$2 -> new StringBuilder(2).append((String)x$2).append(" *").toString(), Seq$.MODULE$.canBuildFrom())).foreach((Function1<String, Object> & Serializable & scala.Serializable)x$3 -> {
            Predef$.MODULE$.println(x$3);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)Tests$.MODULE$.optional().keySet().toSeq().sorted(Ordering$String$.MODULE$)).foreach((Function1<String, Object> & Serializable & scala.Serializable)x$4 -> {
            Predef$.MODULE$.println(x$4);
            return BoxedUnit.UNIT;
        });
    }

    private void extractResources(Seq<String> resources) {
        Path pwd = Paths.get(".", new String[0]).toAbsolutePath();
        Predef$.MODULE$.println(new StringBuilder(63).append("Extracting all DAML resources necessary to run the tests into ").append(pwd).append(".").toString());
        resources.foreach((Function1<String, Object> & Serializable & scala.Serializable)resource -> {
            LedgerApiTestTool$.$anonfun$extractResources$1(resource);
            return BoxedUnit.UNIT;
        });
    }

    public void main(String[] args) {
        Config config = (Config)Cli$.MODULE$.parse(args).getOrElse((Function0<Nothing$> & Serializable & scala.Serializable)() -> package$.MODULE$.exit(1));
        if (config.listTests()) {
            this.printAvailableTests();
            throw package$.MODULE$.exit(0);
        }
        if (config.extract()) {
            this.extractResources(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/ledger/test-common/SemanticTests.dar", "/ledger/test-common/Test-stable.dar", "/ledger/test-common/Test-dev.dar"}));
            throw package$.MODULE$.exit(0);
        }
        if (config.participants().isEmpty()) {
            Predef$.MODULE$.println("No participant to test, exiting.");
            throw package$.MODULE$.exit(0);
        }
        Set missingTests = (Set)config.included().$plus$plus(config.excluded()).filterNot((Function1<String, Object> & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean(LedgerApiTestTool$.$anonfun$main$2(key)));
        if (missingTests.nonEmpty()) {
            Predef$.MODULE$.println("The following tests could not be found:");
            missingTests.foreach((Function1<String, Object> & Serializable & scala.Serializable)testName -> {
                Predef$.MODULE$.println(new StringBuilder(4).append("  - ").append(testName).toString());
                return BoxedUnit.UNIT;
            });
            throw package$.MODULE$.exit(2);
        }
        Set included = config.allTests() ? Tests$.MODULE$.all().keySet() : (config.included().isEmpty() ? Tests$.MODULE$.default().keySet() : config.included());
        Map testsToRun = Tests$.MODULE$.all().filterKeys((Function1)included.$minus$minus(config.excluded()));
        if (testsToRun.isEmpty()) {
            Predef$.MODULE$.println("No tests to run.");
            throw package$.MODULE$.exit(0);
        }
        Thread.currentThread().setUncaughtExceptionHandler((x$5, exception) -> {
            LedgerApiTestTool$.MODULE$.logger.error(LedgerApiTestTool$.MODULE$.uncaughtExceptionErrorMessage, exception);
            throw package$.MODULE$.exit(1);
        });
        LedgerTestSuiteRunner runner = new LedgerTestSuiteRunner(new LedgerSessionConfiguration(config.participants(), config.shuffleParticipants(), config.tlsConfig(), config.commandSubmissionTtlScaleFactor(), config.loadScaleFactor(), config.waitForParties()), testsToRun.values().toVector(), this.identifierSuffix, config.timeoutScaleFactor(), config.concurrentTestRuns());
        runner.verifyRequirementsAndRun((Function1<Try<Vector<LedgerTestSummary>>, BoxedUnit>)(Function1<Try, Object> & Serializable & scala.Serializable)x0$1 -> {
            LedgerApiTestTool$.$anonfun$main$5(config, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$exitCode$1(LedgerTestSummary x$1) {
        return x$1.result().failure();
    }

    public static final /* synthetic */ void $anonfun$extractResources$1(String resource) {
        InputStream is = MODULE$.getClass().getResourceAsStream(resource);
        if (is == null) {
            throw package$.MODULE$.error(new StringBuilder(28).append("Could not find ").append(resource).append(" in classpath").toString());
        }
        File targetFile = new File(new File(resource).getName());
        Files.copy(is, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        Predef$.MODULE$.println(new StringBuilder(14).append("Extracted ").append(resource).append(" to ").append(targetFile).toString());
    }

    public static final /* synthetic */ boolean $anonfun$main$2(String key) {
        return Tests$.MODULE$.all().contains(key);
    }

    public static final /* synthetic */ void $anonfun$main$5(Config config$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Vector summaries = (Vector)success.value();
            new Reporter.ColorizedPrintStreamReporter(System.out, config$1.verbose()).report((Vector<LedgerTestSummary>)summaries);
            throw package$.MODULE$.exit(MODULE$.exitCode(summaries, config$1.mustFail()));
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            LedgerApiTestTool$.MODULE$.logger.error(e.getMessage(), e);
            throw package$.MODULE$.exit(1);
        }
        throw new MatchError(try_);
    }

    private LedgerApiTestTool$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(new StringOps(Predef$.MODULE$.augmentString(this.getClass().getName())).stripSuffix("$"));
        long arg$macro$1 = System.nanoTime();
        this.identifierSuffix = new StringOps("%x").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(arg$macro$1)}));
        this.uncaughtExceptionErrorMessage = "UNEXPECTED UNCAUGHT EXCEPTION ON MAIN THREAD, GATHER THE STACKTRACE AND OPEN A _DETAILED_ TICKET DESCRIBING THE ISSUE HERE: https://github.com/digital-asset/daml/issues/new";
    }
}

