/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.tests;

import com.daml.ledger.api.testtool.infrastructure.Allocation;
import com.daml.ledger.api.testtool.infrastructure.Allocation$;
import com.daml.ledger.api.testtool.infrastructure.Allocation$NoParties$;
import com.daml.ledger.api.testtool.infrastructure.Assertions$;
import com.daml.ledger.api.testtool.infrastructure.LedgerSession;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSuite;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext;
import com.digitalasset.ledger.api.v1.admin.config_management_service.GetTimeModelResponse;
import com.digitalasset.ledger.api.v1.admin.config_management_service.SetTimeModelResponse;
import com.digitalasset.ledger.api.v1.admin.config_management_service.TimeModel;
import com.google.protobuf.duration.Duration;
import io.grpc.Status;
import java.io.Serializable;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\t2A!\u0001\u0002\u0003\u001f\t\u00012i\u001c8gS\u001el\u0015M\\1hK6,g\u000e\u001e\u0006\u0003\u0007\u0011\tQ\u0001^3tiNT!!\u0002\u0004\u0002\u0011Q,7\u000f\u001e;p_2T!a\u0002\u0005\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\n\u0015\u00051A.\u001a3hKJT!a\u0003\u0007\u0002\t\u0011\fW\u000e\u001c\u0006\u0002\u001b\u0005\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0003'\u0011\ta\"\u001b8ge\u0006\u001cHO];diV\u0014X-\u0003\u0002\u0016%\tyA*\u001a3hKJ$Vm\u001d;Tk&$X\rC\u0005\u0018\u0001\t\u0005\t\u0015!\u0003\u00197\u000591/Z:tS>t\u0007CA\t\u001a\u0013\tQ\"CA\u0007MK\u0012<WM]*fgNLwN\\\u0005\u0003/QAQ!\b\u0001\u0005\u0002y\ta\u0001P5oSRtDCA\u0010\"!\t\u0001\u0003!D\u0001\u0003\u0011\u00159B\u00041\u0001\u0019\u0001")
public final class ConfigManagement
extends LedgerTestSuite {
    public static final /* synthetic */ void $anonfun$new$12(TimeModel newTimeModel$1, GetTimeModelResponse response1$1, GetTimeModelResponse response2$1, GetTimeModelResponse response3$1, Throwable expiredMRTFailure) {
        Predef$.MODULE$.assert(response1$1.configurationGeneration() < response2$1.configurationGeneration(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Expected configuration generation to have increased after setting time model");
        Predef$.MODULE$.assert(response2$1.configurationGeneration() < response3$1.configurationGeneration(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Expected configuration generation to have increased after setting time model the second time");
        Predef$.MODULE$.assert(response2$1.timeModel().equals(new Some<TimeModel>(newTimeModel$1)), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Setting the new time model failed");
        Predef$.MODULE$.assert(response3$1.timeModel().equals(response1$1.timeModel()), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Restoring the original time model failed");
        Assertions$.MODULE$.assertGrpcError(expiredMRTFailure, Status.Code.ABORTED, "");
    }

    public ConfigManagement(LedgerSession session) {
        super(session);
        this.test("CMSetAndGetTimeModel", "It should be able to get, set and restore the time model", Allocation$.MODULE$.allocate(Allocation$NoParties$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$1 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$1;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(0) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            TimeModel newTimeModel = new TimeModel(new Some<Duration>(new Duration(0L, 1)), new Some<Duration>(new Duration(60L, 0)), new Some<Duration>(new Duration(120L, 0)));
            Future future = ledger.getTimeModel().map((Function1<GetTimeModelResponse, Tuple2> & Serializable & scala.Serializable)response1 -> {
                Predef$.MODULE$.assert(response1.timeModel().isDefined(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Expected time model to be defined");
                TimeModel oldTimeModel = response1.timeModel().get();
                return new Tuple2<GetTimeModelResponse, TimeModel>((GetTimeModelResponse)response1, oldTimeModel);
            }, this.ec()).flatMap((Function1<Tuple2, Future> & Serializable & scala.Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                GetTimeModelResponse response1 = (GetTimeModelResponse)tuple2._1();
                TimeModel oldTimeModel = (TimeModel)tuple2._2();
                Future future = ledger.time().flatMap((Function1<Instant, Future> & Serializable & scala.Serializable)t1 -> ledger.setTimeModel(t1.plusSeconds(30L), response1.configurationGeneration(), newTimeModel).flatMap((Function1<SetTimeModelResponse, Future> & Serializable & scala.Serializable)_ -> ledger.getTimeModel().flatMap((Function1<GetTimeModelResponse, Future> & Serializable & scala.Serializable)response2 -> ledger.time().flatMap((Function1<Instant, Future> & Serializable & scala.Serializable)t2 -> ledger.setTimeModel(t2.plusSeconds(30L), response2.configurationGeneration(), oldTimeModel).flatMap((Function1<SetTimeModelResponse, Future> & Serializable & scala.Serializable)_ -> ledger.getTimeModel().flatMap((Function1<GetTimeModelResponse, Future> & Serializable & scala.Serializable)response3 -> ledger.time().flatMap((Function1<Instant, Future> & Serializable & scala.Serializable)t3 -> ledger.setTimeModel(t3.minusSeconds(10L), response3.configurationGeneration(), oldTimeModel).failed().map((Function1<Throwable, Object> & Serializable & scala.Serializable)expiredMRTFailure -> {
                    ConfigManagement.$anonfun$new$12(newTimeModel, response1, response2, response3, expiredMRTFailure);
                    return BoxedUnit.UNIT;
                }, this.ec()), this.ec()), this.ec()), this.ec()), this.ec()), this.ec()), this.ec()), this.ec());
                return future;
            }, this.ec());
            return future;
        });
    }
}

