/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.tests;

import com.daml.ledger.api.testtool.infrastructure.Allocation;
import com.daml.ledger.api.testtool.infrastructure.Allocation$;
import com.daml.ledger.api.testtool.infrastructure.Allocation$NoParties$;
import com.daml.ledger.api.testtool.infrastructure.Allocation$SingleParty$;
import com.daml.ledger.api.testtool.infrastructure.Assertions$;
import com.daml.ledger.api.testtool.infrastructure.LedgerSession;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSuite;
import com.daml.ledger.api.testtool.infrastructure.ProtobufConverters$;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext;
import com.digitalasset.ledger.api.v1.command_submission_service.SubmitRequest;
import com.digitalasset.ledger.api.v1.command_submission_service.SubmitRequest$;
import com.digitalasset.ledger.api.v1.commands.Command;
import com.digitalasset.ledger.api.v1.commands.Commands;
import com.digitalasset.ledger.api.v1.commands.Commands$;
import com.digitalasset.ledger.api.v1.ledger_configuration_service.LedgerConfiguration;
import com.digitalasset.ledger.test_stable.Test.Dummy;
import com.google.protobuf.duration.Duration;
import com.google.protobuf.timestamp.Timestamp;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Predef$DummyImplicit$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scalapb.lenses.Lens;
import scalapb.lenses.Updatable;

@ScalaSignature(bytes="\u0006\u0001e3A!\u0001\u0002\u0001\u001f\tQB*\u001a3hKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]N+'O^5dK*\u00111\u0001B\u0001\u0006i\u0016\u001cHo\u001d\u0006\u0003\u000b\u0019\t\u0001\u0002^3tiR|w\u000e\u001c\u0006\u0003\u000f!\t1!\u00199j\u0015\tI!\"\u0001\u0004mK\u0012<WM\u001d\u0006\u0003\u00171\tA\u0001Z1nY*\tQ\"A\u0002d_6\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011\u0003F\u0007\u0002%)\u00111\u0003B\u0001\u000fS:4'/Y:ueV\u001cG/\u001e:f\u0013\t)\"CA\bMK\u0012<WM\u001d+fgR\u001cV/\u001b;f\u0011%9\u0002A!A!\u0002\u0013A2$A\u0004tKN\u001c\u0018n\u001c8\u0011\u0005EI\u0012B\u0001\u000e\u0013\u00055aU\rZ4feN+7o]5p]&\u0011q\u0003\u0006\u0005\u0006;\u0001!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005}\t\u0003C\u0001\u0011\u0001\u001b\u0005\u0011\u0001\"B\f\u001d\u0001\u0004A\u0002\"B\u0012\u0001\t\u0013!\u0013AB:fiR#H\u000eF\u0002&cM\u0002\"AJ\u0018\u000e\u0003\u001dR!\u0001K\u0015\u00025\r|W.\\1oI~\u001bXOY7jgNLwN\\0tKJ4\u0018nY3\u000b\u0005)Z\u0013A\u0001<2\u0015\t9AF\u0003\u0002\n[)\u0011a\u0006D\u0001\rI&<\u0017\u000e^1mCN\u001cX\r^\u0005\u0003a\u001d\u0012QbU;c[&$(+Z9vKN$\b\"\u0002\u001a#\u0001\u0004)\u0013a\u0002:fcV,7\u000f\u001e\u0005\u0006i\t\u0002\r!N\u0001\u0004iRd\u0007C\u0001\u001c<\u001b\u00059$B\u0001\u001d:\u0003\u0011!\u0018.\\3\u000b\u0003i\nAA[1wC&\u0011Ah\u000e\u0002\t\tV\u0014\u0018\r^5p]\")a\b\u0001C\u0005\u007f\u0005AqN^3sM2|w\u000f\u0006\u0002A\u001bR\u0011\u0011i\u0013\t\u0003\u0005&k\u0011a\u0011\u0006\u0003\t\u0016\u000b\u0011\u0002^5nKN$\u0018-\u001c9\u000b\u0005\u0019;\u0015\u0001\u00039s_R|'-\u001e4\u000b\u0005!c\u0011AB4p_\u001edW-\u0003\u0002K\u0007\nIA+[7fgR\fW\u000e\u001d\u0005\u0006\u0019v\u0002\r!Q\u0001\u0002i\")A'\u0010a\u0001\u001dB\u0011qJU\u0007\u0002!*\u0011\u0011+R\u0001\tIV\u0014\u0018\r^5p]&\u0011A\b\u0015\u0005\u0006)\u0002!I!V\u0001\nk:$WM\u001d4m_^$\"A\u0016-\u0015\u0005\u0005;\u0006\"\u0002'T\u0001\u0004\t\u0005\"\u0002\u001bT\u0001\u0004q\u0005")
public class LedgerConfigurationService
extends LedgerTestSuite {
    private SubmitRequest setTtl(SubmitRequest request, java.time.Duration ttl) {
        return (SubmitRequest)request.update(Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1<Lens, Function1> & Serializable & scala.Serializable)x$1 -> SubmitRequest$.MODULE$.SubmitRequestLens(x$1).commands().modify((Function1<Commands, Commands> & Serializable & scala.Serializable)commands -> {
            Option<Timestamp> x$15 = commands.ledgerEffectiveTime().map((Function1<Timestamp, Timestamp> & Serializable & scala.Serializable)x$2 -> ProtobufConverters$.MODULE$.JavaInstantConverter(ProtobufConverters$.MODULE$.ProtobufTimestampConverter((Timestamp)x$2).asJava().plus(ttl)).asProtobuf());
            String x$16 = commands.copy$default$1();
            String x$17 = commands.copy$default$2();
            String x$18 = commands.copy$default$3();
            String x$19 = commands.copy$default$4();
            String x$20 = commands.copy$default$5();
            Option<Timestamp> x$21 = commands.copy$default$6();
            Seq<Command> x$22 = commands.copy$default$8();
            return commands.copy(x$16, x$17, x$18, x$19, x$20, x$21, x$15, x$22);
        })}));
    }

    private Timestamp overflow(Duration ttl, Timestamp t) {
        return ProtobufConverters$.MODULE$.JavaInstantConverter(ProtobufConverters$.MODULE$.ProtobufTimestampConverter(t).asJava().plus(ProtobufConverters$.MODULE$.ProtobufDurationConverter(ttl).asJava()).plusSeconds(1L)).asProtobuf();
    }

    private Timestamp underflow(Duration ttl, Timestamp t) {
        return ProtobufConverters$.MODULE$.JavaInstantConverter(ProtobufConverters$.MODULE$.ProtobufTimestampConverter(t).asJava().minus(ProtobufConverters$.MODULE$.ProtobufDurationConverter(ttl).asJava()).minusSeconds(1L)).asProtobuf();
    }

    public static final /* synthetic */ void $anonfun$new$2(LedgerConfiguration config) {
        Predef$.MODULE$.assert(config.minTtl().isDefined(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "The minTTL field of the configuration is empty");
        Predef$.MODULE$.assert(config.maxTtl().isDefined(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "The maxTTL field of the configuration is empty");
    }

    public static final /* synthetic */ boolean $anonfun$new$8(LedgerConfiguration check$ifrefutable$1) {
        Option<Duration> option2;
        LedgerConfiguration ledgerConfiguration = check$ifrefutable$1;
        boolean bl = ledgerConfiguration != null && (option2 = ledgerConfiguration.minTtl()) instanceof Some;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$new$11(BoxedUnit _) {
    }

    public static final /* synthetic */ boolean $anonfun$new$13(LedgerConfiguration check$ifrefutable$2) {
        Option<Duration> option2;
        LedgerConfiguration ledgerConfiguration = check$ifrefutable$2;
        boolean bl = ledgerConfiguration != null && (option2 = ledgerConfiguration.minTtl()) instanceof Some;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$new$18(LedgerConfiguration check$ifrefutable$3) {
        Option<Duration> option2;
        LedgerConfiguration ledgerConfiguration = check$ifrefutable$3;
        boolean bl = ledgerConfiguration != null && (option2 = ledgerConfiguration.maxTtl()) instanceof Some;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$new$21(BoxedUnit _) {
    }

    public static final /* synthetic */ boolean $anonfun$new$23(LedgerConfiguration check$ifrefutable$4) {
        Option<Duration> option2;
        LedgerConfiguration ledgerConfiguration = check$ifrefutable$4;
        boolean bl = ledgerConfiguration != null && (option2 = ledgerConfiguration.maxTtl()) instanceof Some;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$new$29(BoxedUnit _) {
    }

    public static final /* synthetic */ boolean $anonfun$new$31(LedgerConfiguration check$ifrefutable$5) {
        Option<Duration> option2;
        LedgerConfiguration ledgerConfiguration = check$ifrefutable$5;
        boolean bl = ledgerConfiguration != null && (option2 = ledgerConfiguration.maxTtl()) instanceof Some;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$new$41(LedgerConfiguration check$ifrefutable$6) {
        Option<Duration> option2;
        LedgerConfiguration ledgerConfiguration = check$ifrefutable$6;
        boolean bl = ledgerConfiguration != null && (option2 = ledgerConfiguration.maxTtl()) instanceof Some;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$new$49(Throwable failure) {
        Throwable throwable2 = failure;
        boolean bl = throwable2 instanceof StatusRuntimeException ? true : throwable2 instanceof StatusException;
        if (!bl) {
            throw Assertions$.MODULE$.fail("Submission should have failed with gRPC exception");
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public LedgerConfigurationService(LedgerSession session) {
        super(session);
        this.test("ConfigSucceeds", "Return a valid configuration for a valid request", Allocation$.MODULE$.allocate(Allocation$NoParties$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$1 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$1;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(0) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Future future = ledger.configuration(ledger.configuration$default$1()).map((Function1<LedgerConfiguration, Object> & Serializable & scala.Serializable)config -> {
                LedgerConfigurationService.$anonfun$new$2(config);
                return BoxedUnit.UNIT;
            }, this.ec());
            return future;
        });
        this.test("ConfigLedgerId", "Return NOT_FOUND to invalid ledger identifier", Allocation$.MODULE$.allocate(Allocation$NoParties$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$2 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$2;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(0) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            String invalidLedgerId = "THIS_IS_AN_INVALID_LEDGER_ID";
            Future future = ledger.configuration(new Some<String>(invalidLedgerId)).failed().map((Function1<Throwable, Object> & Serializable & scala.Serializable)failure -> {
                Assertions$.MODULE$.assertGrpcError(failure, Status.Code.NOT_FOUND, new StringBuilder(23).append("Ledger ID '").append(invalidLedgerId).append("' not found.").toString());
                return BoxedUnit.UNIT;
            }, this.ec());
            return future;
        });
        this.test("ConfigJustMinTtl", "LET+minTTL should be an acceptable MRT", Allocation$.MODULE$.allocate(Allocation$SingleParty$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$3 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$3;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(1) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Object party = participant.parties().apply(false);
            Future future = ledger.configuration(ledger.configuration$default$1()).withFilter((Function1<LedgerConfiguration, Object> & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(LedgerConfigurationService.$anonfun$new$8(check$ifrefutable$1)), this.ec()).flatMap((Function1<LedgerConfiguration, Future> & Serializable & scala.Serializable)x$3 -> {
                Option<Duration> option2;
                LedgerConfiguration ledgerConfiguration = x$3;
                if (ledgerConfiguration == null || !((option2 = ledgerConfiguration.minTtl()) instanceof Some)) {
                    throw new MatchError(ledgerConfiguration);
                }
                Some some = (Some)option2;
                Duration minTtl = (Duration)some.value();
                Future future = ledger.submitRequest(party, Predef$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(Predef$DummyImplicit$.MODULE$.dummyImplicit()).command()})).flatMap((Function1<SubmitRequest, Future> & Serializable & scala.Serializable)request -> ledger.submit(this.setTtl((SubmitRequest)request, ProtobufConverters$.MODULE$.ProtobufDurationConverter(minTtl).asJava())).map((Function1<BoxedUnit, Object> & Serializable & scala.Serializable)_ -> {
                    LedgerConfigurationService.$anonfun$new$11(_);
                    return BoxedUnit.UNIT;
                }, this.ec()), this.ec());
                return future;
            }, this.ec());
            return future;
        });
        this.test("ConfigUnderflowMinTtl", "LET+minTTL-1 should NOT be an acceptable MRT", Allocation$.MODULE$.allocate(Allocation$SingleParty$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$4 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$4;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(1) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Object party = participant.parties().apply(false);
            Future future = ledger.configuration(ledger.configuration$default$1()).withFilter((Function1<LedgerConfiguration, Object> & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean(LedgerConfigurationService.$anonfun$new$13(check$ifrefutable$2)), this.ec()).flatMap((Function1<LedgerConfiguration, Future> & Serializable & scala.Serializable)x$4 -> {
                Option<Duration> option2;
                LedgerConfiguration ledgerConfiguration = x$4;
                if (ledgerConfiguration == null || !((option2 = ledgerConfiguration.minTtl()) instanceof Some)) {
                    throw new MatchError(ledgerConfiguration);
                }
                Some some = (Some)option2;
                Duration minTtl = (Duration)some.value();
                Future future = ledger.submitRequest(party, Predef$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(Predef$DummyImplicit$.MODULE$.dummyImplicit()).command()})).flatMap((Function1<SubmitRequest, Future> & Serializable & scala.Serializable)request -> ledger.submit(this.setTtl((SubmitRequest)request, ProtobufConverters$.MODULE$.ProtobufDurationConverter(minTtl).asJava().minusSeconds(1L))).failed().map((Function1<Throwable, Object> & Serializable & scala.Serializable)failure -> {
                    Assertions$.MODULE$.assertGrpcError(failure, Status.Code.INVALID_ARGUMENT, "out of bounds");
                    return BoxedUnit.UNIT;
                }, this.ec()), this.ec());
                return future;
            }, this.ec());
            return future;
        });
        this.test("ConfigJustMaxTtl", "LET+maxTTL should be an acceptable MRT", Allocation$.MODULE$.allocate(Allocation$SingleParty$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$5 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$5;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(1) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Object party = participant.parties().apply(false);
            Future future = ledger.configuration(ledger.configuration$default$1()).withFilter((Function1<LedgerConfiguration, Object> & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean(LedgerConfigurationService.$anonfun$new$18(check$ifrefutable$3)), this.ec()).flatMap((Function1<LedgerConfiguration, Future> & Serializable & scala.Serializable)x$5 -> {
                Option<Duration> option2;
                LedgerConfiguration ledgerConfiguration = x$5;
                if (ledgerConfiguration == null || !((option2 = ledgerConfiguration.maxTtl()) instanceof Some)) {
                    throw new MatchError(ledgerConfiguration);
                }
                Some some = (Some)option2;
                Duration maxTtl = (Duration)some.value();
                Future future = ledger.submitRequest(party, Predef$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(Predef$DummyImplicit$.MODULE$.dummyImplicit()).command()})).flatMap((Function1<SubmitRequest, Future> & Serializable & scala.Serializable)request -> ledger.submit(this.setTtl((SubmitRequest)request, ProtobufConverters$.MODULE$.ProtobufDurationConverter(maxTtl).asJava().minusSeconds(1L))).map((Function1<BoxedUnit, Object> & Serializable & scala.Serializable)_ -> {
                    LedgerConfigurationService.$anonfun$new$21(_);
                    return BoxedUnit.UNIT;
                }, this.ec()), this.ec());
                return future;
            }, this.ec());
            return future;
        });
        this.test("ConfigOverflowMaxTtl", "LET+maxTTL+1 should NOT be an acceptable MRT", Allocation$.MODULE$.allocate(Allocation$SingleParty$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$6 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$6;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(1) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Object party = participant.parties().apply(false);
            Future future = ledger.configuration(ledger.configuration$default$1()).withFilter((Function1<LedgerConfiguration, Object> & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean(LedgerConfigurationService.$anonfun$new$23(check$ifrefutable$4)), this.ec()).flatMap((Function1<LedgerConfiguration, Future> & Serializable & scala.Serializable)x$6 -> {
                Option<Duration> option2;
                LedgerConfiguration ledgerConfiguration = x$6;
                if (ledgerConfiguration == null || !((option2 = ledgerConfiguration.maxTtl()) instanceof Some)) {
                    throw new MatchError(ledgerConfiguration);
                }
                Some some = (Some)option2;
                Duration maxTtl = (Duration)some.value();
                Future future = ledger.submitRequest(party, Predef$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(Predef$DummyImplicit$.MODULE$.dummyImplicit()).command()})).flatMap((Function1<SubmitRequest, Future> & Serializable & scala.Serializable)request -> ledger.submit(this.setTtl((SubmitRequest)request, ProtobufConverters$.MODULE$.ProtobufDurationConverter(maxTtl).asJava().plusSeconds(1L))).failed().map((Function1<Throwable, Object> & Serializable & scala.Serializable)failure -> {
                    Assertions$.MODULE$.assertGrpcError(failure, Status.Code.INVALID_ARGUMENT, "out of bounds");
                    return BoxedUnit.UNIT;
                }, this.ec()), this.ec());
                return future;
            }, this.ec());
            return future;
        });
        this.test("CSLSuccessIfLetRight", "Submission returns OK if LET is within the accepted interval", Allocation$.MODULE$.allocate(Allocation$SingleParty$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$7 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$7;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(1) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Object party = participant.parties().apply(false);
            Future future = ledger.submitRequest(party, Predef$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(Predef$DummyImplicit$.MODULE$.dummyImplicit()).command()})).flatMap((Function1<SubmitRequest, Future> & Serializable & scala.Serializable)request -> ledger.submit((SubmitRequest)request).map((Function1<BoxedUnit, Object> & Serializable & scala.Serializable)_ -> {
                LedgerConfigurationService.$anonfun$new$29(_);
                return BoxedUnit.UNIT;
            }, this.ec()), this.ec());
            return future;
        });
        this.test("CSLAbortIfLetHigh", "Submission returns ABORTED if LET is too high", Allocation$.MODULE$.allocate(Allocation$SingleParty$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$8 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$8;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(1) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Object party = participant.parties().apply(false);
            Future future = ledger.configuration(ledger.configuration$default$1()).withFilter((Function1<LedgerConfiguration, Object> & Serializable & scala.Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean(LedgerConfigurationService.$anonfun$new$31(check$ifrefutable$5)), this.ec()).flatMap((Function1<LedgerConfiguration, Future> & Serializable & scala.Serializable)x$10 -> {
                Option<Duration> option2;
                LedgerConfiguration ledgerConfiguration = x$10;
                if (ledgerConfiguration == null || !((option2 = ledgerConfiguration.maxTtl()) instanceof Some)) {
                    throw new MatchError(ledgerConfiguration);
                }
                Some some = (Some)option2;
                Duration maxTtl = (Duration)some.value();
                Future future = ledger.submitRequest(party, Predef$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(Predef$DummyImplicit$.MODULE$.dummyImplicit()).command()})).map((Function1<SubmitRequest, Tuple2> & Serializable & scala.Serializable)request -> {
                    SubmitRequest invalidRequest = (SubmitRequest)((Updatable)request.update(Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1<Lens, Function1> & Serializable & scala.Serializable)x$7 -> Commands$.MODULE$.CommandsLens(SubmitRequest$.MODULE$.SubmitRequestLens(x$7).commands()).ledgerEffectiveTime().modify((Function1<Timestamp, Timestamp> & Serializable & scala.Serializable)t -> this.overflow(maxTtl, (Timestamp)t))}))).update(Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1<Lens, Function1> & Serializable & scala.Serializable)x$8 -> Commands$.MODULE$.CommandsLens(SubmitRequest$.MODULE$.SubmitRequestLens(x$8).commands()).maximumRecordTime().modify((Function1<Timestamp, Timestamp> & Serializable & scala.Serializable)t -> this.overflow(maxTtl, (Timestamp)t))}));
                    return new Tuple2<SubmitRequest, SubmitRequest>((SubmitRequest)request, invalidRequest);
                }, this.ec()).flatMap((Function1<Tuple2, Future> & Serializable & scala.Serializable)x$9 -> {
                    Tuple2 tuple2 = x$9;
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    SubmitRequest invalidRequest = (SubmitRequest)tuple2._2();
                    Future future = ledger.submit(invalidRequest).failed().map((Function1<Throwable, Object> & Serializable & scala.Serializable)failure -> {
                        Assertions$.MODULE$.assertGrpcError(failure, Status.Code.ABORTED, "TRANSACTION_OUT_OF_TIME_WINDOW: ");
                        return BoxedUnit.UNIT;
                    }, this.ec());
                    return future;
                }, this.ec());
                return future;
            }, this.ec());
            return future;
        });
        this.test("CSLAbortIfLetLow", "Submission returns ABORTED if LET is too low", Allocation$.MODULE$.allocate(Allocation$SingleParty$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$9 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$9;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(1) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Object party = participant.parties().apply(false);
            Future future = ledger.configuration(ledger.configuration$default$1()).withFilter((Function1<LedgerConfiguration, Object> & Serializable & scala.Serializable)check$ifrefutable$6 -> BoxesRunTime.boxToBoolean(LedgerConfigurationService.$anonfun$new$41(check$ifrefutable$6)), this.ec()).flatMap((Function1<LedgerConfiguration, Future> & Serializable & scala.Serializable)x$14 -> {
                Option<Duration> option2;
                LedgerConfiguration ledgerConfiguration = x$14;
                if (ledgerConfiguration == null || !((option2 = ledgerConfiguration.maxTtl()) instanceof Some)) {
                    throw new MatchError(ledgerConfiguration);
                }
                Some some = (Some)option2;
                Duration maxTtl = (Duration)some.value();
                Future future = ledger.submitRequest(party, Predef$.MODULE$.wrapRefArray((Object[])new Command[]{new Dummy(party).create(Predef$DummyImplicit$.MODULE$.dummyImplicit()).command()})).map((Function1<SubmitRequest, Tuple2> & Serializable & scala.Serializable)request -> {
                    SubmitRequest invalidRequest = (SubmitRequest)((Updatable)request.update(Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1<Lens, Function1> & Serializable & scala.Serializable)x$11 -> Commands$.MODULE$.CommandsLens(SubmitRequest$.MODULE$.SubmitRequestLens(x$11).commands()).ledgerEffectiveTime().modify((Function1<Timestamp, Timestamp> & Serializable & scala.Serializable)t -> this.underflow(maxTtl, (Timestamp)t))}))).update(Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1<Lens, Function1> & Serializable & scala.Serializable)x$12 -> Commands$.MODULE$.CommandsLens(SubmitRequest$.MODULE$.SubmitRequestLens(x$12).commands()).maximumRecordTime().modify((Function1<Timestamp, Timestamp> & Serializable & scala.Serializable)t -> this.underflow(maxTtl, (Timestamp)t))}));
                    return new Tuple2<SubmitRequest, SubmitRequest>((SubmitRequest)request, invalidRequest);
                }, this.ec()).flatMap((Function1<Tuple2, Future> & Serializable & scala.Serializable)x$13 -> {
                    Tuple2 tuple2 = x$13;
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    SubmitRequest invalidRequest = (SubmitRequest)tuple2._2();
                    Future future = ledger.submit(invalidRequest).failed().map((Function1<Throwable, Object> & Serializable & scala.Serializable)failure -> {
                        LedgerConfigurationService.$anonfun$new$49(failure);
                        return BoxedUnit.UNIT;
                    }, this.ec());
                    return future;
                }, this.ec());
                return future;
            }, this.ec());
            return future;
        });
    }
}

