/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.tests;

import com.daml.ledger.api.testtool.infrastructure.Allocation;
import com.daml.ledger.api.testtool.infrastructure.Allocation$;
import com.daml.ledger.api.testtool.infrastructure.Allocation$NoParties$;
import com.daml.ledger.api.testtool.infrastructure.Assertions$;
import com.daml.ledger.api.testtool.infrastructure.LedgerSession;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSuite;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext;
import com.digitalasset.ledger.api.v1.package_service.GetPackageResponse;
import com.digitalasset.ledger.api.v1.package_service.PackageStatus;
import io.grpc.Status;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u000112A!\u0001\u0002\u0003\u001f\tA\u0001+Y2lC\u001e,7O\u0003\u0002\u0004\t\u0005)A/Z:ug*\u0011QAB\u0001\ti\u0016\u001cH\u000f^8pY*\u0011q\u0001C\u0001\u0004CBL'BA\u0005\u000b\u0003\u0019aW\rZ4fe*\u00111\u0002D\u0001\u0005I\u0006lGNC\u0001\u000e\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012)5\t!C\u0003\u0002\u0014\t\u0005q\u0011N\u001c4sCN$(/^2ukJ,\u0017BA\u000b\u0013\u0005=aU\rZ4feR+7\u000f^*vSR,\u0007\"C\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u001c\u0003\u001d\u0019Xm]:j_:\u0004\"!E\r\n\u0005i\u0011\"!\u0004'fI\u001e,'oU3tg&|g.\u0003\u0002\u0018)!)Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\"aH\u0011\u0011\u0005\u0001\u0002Q\"\u0001\u0002\t\u000b]a\u0002\u0019\u0001\r\t\r\r\u0002\u0001\u0015!\u0003%\u0003A)hn\u001b8po:\u0004\u0016mY6bO\u0016LE\r\u0005\u0002&U5\taE\u0003\u0002(Q\u0005!A.\u00198h\u0015\u0005I\u0013\u0001\u00026bm\u0006L!a\u000b\u0014\u0003\rM#(/\u001b8h\u0001")
public final class Packages
extends LedgerTestSuite {
    private final String unknownPackageId;

    public static final /* synthetic */ void $anonfun$new$8(String somePackageId$1, GetPackageResponse somePackage) {
        Predef$.MODULE$.assert(somePackage.hash().length() > 0, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Package ").append(somePackageId$1).append(" has an empty hash.").toString());
        String string2 = somePackage.hash();
        String string3 = somePackageId$1;
        Predef$.MODULE$.assert(!(string2 != null ? !string2.equals(string3) : string3 != null), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Package ").append(somePackageId$1).append(" has hash ").append(somePackage.hash()).append(", expected hash to be equal to the package ID.").toString());
        Predef$.MODULE$.assert(somePackage.archivePayload().size() >= 0, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Package ").append(somePackageId$1).append(" has zero size.").toString());
    }

    public Packages(LedgerSession session) {
        super(session);
        this.unknownPackageId = " ";
        this.test("PackagesList", "Listing packages should return a result", Allocation$.MODULE$.allocate(Allocation$NoParties$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$1 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$1;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(0) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Future future = ledger.listPackages().map((Function1<Seq, Object> & Serializable & scala.Serializable)knownPackages -> {
                Predef$.MODULE$.assert(knownPackages.size() >= 3, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(75).append("List of packages was expected to contain at least 3 packages, got ").append(knownPackages.size()).append(" instead.").toString());
                return BoxedUnit.UNIT;
            }, this.ec());
            return future;
        });
        this.test("PackagesGet", "Getting package content should return a valid result", Allocation$.MODULE$.allocate(Allocation$NoParties$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$2 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$2;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(0) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Future future = ledger.listPackages().map((Function1<Seq, String> & Serializable & scala.Serializable)x$1 -> (String)x$1.headOption().getOrElse((Function0<Nothing$> & Serializable & scala.Serializable)() -> Assertions$.MODULE$.fail("No package found")), this.ec()).flatMap((Function1<String, Future> & Serializable & scala.Serializable)somePackageId -> ledger.getPackage((String)somePackageId).map((Function1<GetPackageResponse, Object> & Serializable & scala.Serializable)somePackage -> {
                Packages.$anonfun$new$8(somePackageId, somePackage);
                return BoxedUnit.UNIT;
            }, this.ec()), this.ec());
            return future;
        });
        this.test("PackagesGetUnknown", "Getting package content for an unknown package should fail", Allocation$.MODULE$.allocate(Allocation$NoParties$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$3 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$3;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(0) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Future future = ledger.getPackage($this.unknownPackageId).failed().map((Function1<Throwable, Object> & Serializable & scala.Serializable)failure -> {
                Assertions$.MODULE$.assertGrpcError(failure, Status.Code.NOT_FOUND, "");
                return BoxedUnit.UNIT;
            }, this.ec());
            return future;
        });
        this.test("PackagesStatus", "Getting package status should return a valid result", Allocation$.MODULE$.allocate(Allocation$NoParties$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$4 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$4;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(0) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Future future = ledger.listPackages().map((Function1<Seq, String> & Serializable & scala.Serializable)x$2 -> (String)x$2.headOption().getOrElse((Function0<Nothing$> & Serializable & scala.Serializable)() -> Assertions$.MODULE$.fail("No package found")), this.ec()).flatMap((Function1<String, Future> & Serializable & scala.Serializable)somePackageId -> ledger.getPackageStatus((String)somePackageId).map((Function1<PackageStatus, Object> & Serializable & scala.Serializable)status -> {
                Predef$.MODULE$.assert(status.isRegistered(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Package ").append(somePackageId$2).append(" is not registered.").toString());
                return BoxedUnit.UNIT;
            }, this.ec()), this.ec());
            return future;
        });
        this.test("PackagesStatusUnknown", "Getting package status for an unknown package should fail", Allocation$.MODULE$.allocate(Allocation$NoParties$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$5 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$5;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(0) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Future future = ledger.getPackageStatus($this.unknownPackageId).map((Function1<PackageStatus, Object> & Serializable & scala.Serializable)status -> {
                Predef$.MODULE$.assert(status.isUnknown(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Package ").append($this.unknownPackageId).append(" is not unknown.").toString());
                return BoxedUnit.UNIT;
            }, this.ec());
            return future;
        });
    }
}

