/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.testtool.tests;

import com.daml.ledger.api.testtool.infrastructure.Allocation;
import com.daml.ledger.api.testtool.infrastructure.Allocation$;
import com.daml.ledger.api.testtool.infrastructure.Allocation$NoParties$;
import com.daml.ledger.api.testtool.infrastructure.LedgerSession;
import com.daml.ledger.api.testtool.infrastructure.LedgerTestSuite;
import com.daml.ledger.api.testtool.infrastructure.participant.ParticipantTestContext;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;
import scalaz.Tag$;

@ScalaSignature(bytes="\u0006\u0001M2A!\u0001\u0002\u0003\u001f\ty\u0001+\u0019:us6\u000bg.Y4f[\u0016tGO\u0003\u0002\u0004\t\u0005)A/Z:ug*\u0011QAB\u0001\ti\u0016\u001cH\u000f^8pY*\u0011q\u0001C\u0001\u0004CBL'BA\u0005\u000b\u0003\u0019aW\rZ4fe*\u00111\u0002D\u0001\u0005I\u0006lGNC\u0001\u000e\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012)5\t!C\u0003\u0002\u0014\t\u0005q\u0011N\u001c4sCN$(/^2ukJ,\u0017BA\u000b\u0013\u0005=aU\rZ4feR+7\u000f^*vSR,\u0007\"C\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u001c\u0003\u001d\u0019Xm]:j_:\u0004\"!E\r\n\u0005i\u0011\"!\u0004'fI\u001e,'oU3tg&|g.\u0003\u0002\u0018)!)Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\"aH\u0011\u0011\u0005\u0001\u0002Q\"\u0001\u0002\t\u000b]a\u0002\u0019\u0001\r\t\u000f\r\u0002!\u0019!C\u0005I\u0005\u0011\u0002/T!mY>\u001c\u0017\r^3XSRD\u0007*\u001b8u+\u0005)\u0003C\u0001\u0014,\u001b\u00059#B\u0001\u0015*\u0003\u0011a\u0017M\\4\u000b\u0003)\nAA[1wC&\u0011Af\n\u0002\u0007'R\u0014\u0018N\\4\t\r9\u0002\u0001\u0015!\u0003&\u0003M\u0001X*\u00117m_\u000e\fG/Z,ji\"D\u0015N\u001c;!\u0011\u001d\u0001\u0004A1A\u0005\n\u0011\nA\u0004]'BY2|7-\u0019;f/&$\bn\\;u\t&\u001c\b\u000f\\1z\u001d\u0006lW\r\u0003\u00043\u0001\u0001\u0006I!J\u0001\u001ea6\u000bE\u000e\\8dCR,w+\u001b;i_V$H)[:qY\u0006Lh*Y7fA\u0001")
public final class PartyManagement
extends LedgerTestSuite {
    private final String pMAllocateWithHint;
    private final String pMAllocateWithoutDisplayName;

    private String pMAllocateWithHint() {
        return this.pMAllocateWithHint;
    }

    private String pMAllocateWithoutDisplayName() {
        return this.pMAllocateWithoutDisplayName;
    }

    public static final /* synthetic */ void $anonfun$new$15(Object p1$1, Object p2) {
        Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString((String)Tag$.MODULE$.unwrap(p1$1))).nonEmpty(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "The first allocated party identifier is an empty string");
        Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString((String)Tag$.MODULE$.unwrap(p2))).nonEmpty(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "The second allocated party identifier is an empty string");
        Predef$.MODULE$.assert(!BoxesRunTime.equals(p1$1, p2), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "The two parties have the same party identifier");
    }

    public static final /* synthetic */ boolean $anonfun$new$23(Tuple2 x$2) {
        return x$2._2$mcI$sp() > 1;
    }

    public static final /* synthetic */ void $anonfun$new$20(Vector parties) {
        Map nonUniqueNames = (Map)parties.groupBy((Function1<Object, String> & Serializable & scala.Serializable)a -> (String)Tag$.MODULE$.unwrap(a)).mapValues((Function1<Vector, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger(x$1.size())).filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(PartyManagement.$anonfun$new$23(x$2)));
        Predef$.MODULE$.assert(nonUniqueNames.isEmpty(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(34).append("There are non-unique party names: ").append(((TraversableOnce)nonUniqueNames.map((Function1<Tuple2, String> & Serializable & scala.Serializable)x0$7 -> {
            Tuple2 tuple2 = x0$7;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String name = (String)tuple2._1();
            int count = tuple2._2$mcI$sp();
            String string2 = new StringBuilder(3).append(name).append(" (").append(count).append(")").toString();
            return string2;
        }, Iterable$.MODULE$.canBuildFrom())).mkString(", ")).toString());
    }

    public PartyManagement(LedgerSession session) {
        super(session);
        this.test("PMNonEmptyParticipantID", "Asking for the participant identifier should return a non-empty string", Allocation$.MODULE$.allocate(Allocation$NoParties$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$1 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$1;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(0) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Future future = ledger.participantId().map((Function1<String, Object> & Serializable & scala.Serializable)participantId -> {
                Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString(participantId)).nonEmpty(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "The ledger returned an empty participant identifier");
                return BoxedUnit.UNIT;
            }, this.ec());
            return future;
        });
        this.pMAllocateWithHint = "PMAllocateWithHint";
        this.test(this.pMAllocateWithHint(), "It should be possible to provide a hint when allocating a party", Allocation$.MODULE$.allocate(Allocation$NoParties$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$2 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$2;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(0) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Future future = ledger.allocateParty(new Some<String>(new StringBuilder(1).append(this.pMAllocateWithHint()).append("_").append(((Stream)Random$.MODULE$.alphanumeric().take(10)).mkString()).toString()), new Some<String>("Bob Ross")).map((Function1<Object, Object> & Serializable & scala.Serializable)party -> {
                Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString((String)Tag$.MODULE$.unwrap(party))).nonEmpty(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "The allocated party identifier is an empty string");
                return BoxedUnit.UNIT;
            }, this.ec());
            return future;
        });
        this.test("PMAllocateWithoutHint", "It should be possible to not provide a hint when allocating a party", Allocation$.MODULE$.allocate(Allocation$NoParties$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$3 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$3;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(0) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Future future = ledger.allocateParty(None$.MODULE$, new Some<String>("Jebediah Kerman")).map((Function1<Object, Object> & Serializable & scala.Serializable)party -> {
                Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString((String)Tag$.MODULE$.unwrap(party))).nonEmpty(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "The allocated party identifier is an empty string");
                return BoxedUnit.UNIT;
            }, this.ec());
            return future;
        });
        this.pMAllocateWithoutDisplayName = "PMAllocateWithoutDisplayName";
        this.test(this.pMAllocateWithoutDisplayName(), "It should be possible to not provide a display name when allocating a party", Allocation$.MODULE$.allocate(Allocation$NoParties$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$4 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$4;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(0) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Future future = ledger.allocateParty(new Some<String>(new StringBuilder(1).append(this.pMAllocateWithoutDisplayName()).append("_").append(((Stream)Random$.MODULE$.alphanumeric().take(10)).mkString()).toString()), None$.MODULE$).map((Function1<Object, Object> & Serializable & scala.Serializable)party -> {
                Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString((String)Tag$.MODULE$.unwrap(party))).nonEmpty(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "The allocated party identifier is an empty string");
                return BoxedUnit.UNIT;
            }, this.ec());
            return future;
        });
        this.test("PMAllocateDuplicateDisplayName", "It should be possible to allocate parties with the same display names", Allocation$.MODULE$.allocate(Allocation$NoParties$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$5 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$5;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(0) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Future future = ledger.allocateParty(None$.MODULE$, new Some<String>("Ononym McOmonymface")).flatMap((Function1<Object, Future> & Serializable & scala.Serializable)p1 -> ledger.allocateParty(None$.MODULE$, new Some<String>("Ononym McOmonymface")).map((Function1<Object, Object> & Serializable & scala.Serializable)p2 -> {
                PartyManagement.$anonfun$new$15(p1, p2);
                return BoxedUnit.UNIT;
            }, this.ec()), this.ec());
            return future;
        });
        this.test("PMAllocateOneHundred", "It should create unique party names when allocating many parties", Allocation$.MODULE$.allocate(Allocation$NoParties$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new Allocation.PartyCount[0])), this.test$default$4(), (Function1<Allocation.Participants, Future<BoxedUnit>>)(Function1<Allocation.Participants, Future> & Serializable & scala.Serializable)x0$6 -> {
            Allocation.Participant participant;
            Allocation.Participants participants = x0$6;
            if (participants == null || participants.participants() == null || participants.participants().lengthCompare(1) != 0 || (participant = (Allocation.Participant)participants.participants().apply(false)) == null || participant.parties() == null || participant.parties().lengthCompare(0) != 0) {
                throw new MatchError(participants);
            }
            ParticipantTestContext ledger = participant.ledger();
            Future future = ledger.allocateParties(100).map((Function1<Vector, Object> & Serializable & scala.Serializable)parties -> {
                PartyManagement.$anonfun$new$20(parties);
                return BoxedUnit.UNIT;
            }, this.ec());
            return future;
        });
    }
}

