/*
 * Decompiled with CFR 0.152.
 */
package com.digitalasset.daml.lf.crypto;

import com.digitalasset.daml.lf.crypto.Hash;
import com.digitalasset.daml.lf.crypto.Hash$Purpose$;
import com.digitalasset.daml.lf.transaction.Node;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.SecureRandom;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.Ordering$Byte$;
import scala.math.Ordering$String$;
import scala.math.PartialOrdering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.control.NonFatal$;

public final class Hash$ {
    public static Hash$ MODULE$;
    private final byte com$digitalasset$daml$lf$crypto$Hash$$version;
    private final int com$digitalasset$daml$lf$crypto$Hash$$underlyingHashLength;
    private final Function0<Hash> secureRandom;
    private final Ordering<Hash> HashOrdering;
    private final String com$digitalasset$daml$lf$crypto$Hash$$hMacAlgorithm;

    static {
        new Hash$();
    }

    public byte com$digitalasset$daml$lf$crypto$Hash$$version() {
        return this.com$digitalasset$daml$lf$crypto$Hash$$version;
    }

    public int com$digitalasset$daml$lf$crypto$Hash$$underlyingHashLength() {
        return this.com$digitalasset$daml$lf$crypto$Hash$$underlyingHashLength;
    }

    public Function0<Hash> secureRandom() {
        return this.secureRandom;
    }

    public Ordering<Hash> HashOrdering() {
        return this.HashOrdering;
    }

    public Hash.Builder builder(Hash.Purpose purpose) {
        return new Hash.Builder(purpose){
            private final MessageDigest md;

            private MessageDigest md() {
                return this.md;
            }

            public void update(byte[] a) {
                this.md().update(a);
            }

            public void doFinal(byte[] buf, int offset) {
                Predef$.MODULE$.assert(this.md().digest(buf, offset, Hash$.MODULE$.com$digitalasset$daml$lf$crypto$Hash$$underlyingHashLength()) == Hash$.MODULE$.com$digitalasset$daml$lf$crypto$Hash$$underlyingHashLength());
            }
            {
                this.md = MessageDigest.getInstance("SHA-256");
                this.md().update(Hash$.MODULE$.com$digitalasset$daml$lf$crypto$Hash$$version());
                this.md().update(purpose$1.id());
            }
        };
    }

    public String com$digitalasset$daml$lf$crypto$Hash$$hMacAlgorithm() {
        return this.com$digitalasset$daml$lf$crypto$Hash$$hMacAlgorithm;
    }

    public Hash.Builder hMacBuilder(Hash key) {
        return new Hash.Builder(key){
            private final Mac mac;

            private Mac mac() {
                return this.mac;
            }

            public void update(byte[] a) {
                this.mac().update(a);
            }

            public void doFinal(byte[] buf, int offset) {
                this.mac().doFinal(buf, offset);
            }
            {
                this.mac = Mac.getInstance(Hash$.MODULE$.com$digitalasset$daml$lf$crypto$Hash$$hMacAlgorithm());
                this.mac().init(new SecretKeySpec(key$1.com$digitalasset$daml$lf$crypto$Hash$$bytes(), Hash$.MODULE$.com$digitalasset$daml$lf$crypto$Hash$$hMacAlgorithm()));
            }
        };
    }

    public Either<String, Hash> fromString(String s2) {
        Either either2;
        try {
            byte[] bytes = (byte[])new StringOps(Predef$.MODULE$.augmentString(s2)).sliding(2, 2).map((Function1<String, Object> & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToByte(Hash$.$anonfun$fromString$1(x$8))).toArray(ClassTag$.MODULE$.Byte());
            either2 = package$.MODULE$.Either().cond(bytes.length == this.com$digitalasset$daml$lf$crypto$Hash$$underlyingHashLength(), (Function0<Hash> & Serializable & scala.Serializable)() -> new Hash(bytes), (Function0<String> & Serializable & scala.Serializable)() -> Hash$.error$1(s2));
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            Option<Throwable> option2 = NonFatal$.MODULE$.unapply(throwable3);
            if (option2.isEmpty()) {
                throw throwable2;
            }
            Left<String, Hash> left = package$.MODULE$.Left().apply(Hash$.error$1(s2));
            either2 = left;
        }
        return either2;
    }

    public Hash assertFromString(String s2) {
        return com.digitalasset.daml.lf.data.package$.MODULE$.assertRight(this.fromString(s2));
    }

    public Hash hashPrivateKey(String s2) {
        return this.builder(Hash$Purpose$.MODULE$.PrivateKey()).add(s2).build();
    }

    public Hash hashContractKey(Node.GlobalKey key) {
        return this.builder(Hash$Purpose$.MODULE$.ContractKey()).addIdentifier(key.templateId()).addTypedValue(key.key().value()).build();
    }

    public Hash deriveTransactionSeed(Hash nonce, String participantId, String applicationId, String commandId, String submitter) {
        return this.hMacBuilder(nonce).add(participantId).add(applicationId).add(commandId).add(submitter).build();
    }

    public Hash deriveNodeDiscriminator(Hash parentDiscriminator, int childIdx) {
        return this.hMacBuilder(parentDiscriminator).add(childIdx).build();
    }

    public Hash deriveContractDiscriminator(Hash nodeDiscriminator, Set<String> parties) {
        return this.hMacBuilder(nodeDiscriminator).iterateOver(((IterableLike)parties.toSeq().sorted(Ordering$String$.MODULE$)).iterator(), parties.size(), (Function2<Hash.Builder, String, Hash.Builder> & Serializable & scala.Serializable)(x$9, x$10) -> x$9.add((String)x$10)).build();
    }

    public static final /* synthetic */ int com$digitalasset$daml$lf$crypto$Hash$$$anonfun$HashOrdering$1(Hash hash1, Hash hash2) {
        return Predef$.MODULE$.implicitly(Ordering$.MODULE$.Iterable(Ordering$Byte$.MODULE$)).compare(Predef$.MODULE$.wrapByteArray(hash1.com$digitalasset$daml$lf$crypto$Hash$$bytes()), Predef$.MODULE$.wrapByteArray(hash2.com$digitalasset$daml$lf$crypto$Hash$$bytes()));
    }

    private static final String error$1(String s$1) {
        return new StringBuilder(18).append("Cannot parse hash ").append(s$1).toString();
    }

    public static final /* synthetic */ byte $anonfun$fromString$1(String x$8) {
        return (byte)Integer.parseInt(x$8, 16);
    }

    private Hash$() {
        MODULE$ = this;
        this.com$digitalasset$daml$lf$crypto$Hash$$version = (byte)0;
        this.com$digitalasset$daml$lf$crypto$Hash$$underlyingHashLength = 32;
        SecureRandom random = new SecureRandom();
        this.secureRandom = (Function0<Hash> & Serializable & scala.Serializable)() -> {
            byte[] a = (byte[])Array$.MODULE$.ofDim(MODULE$.com$digitalasset$daml$lf$crypto$Hash$$underlyingHashLength(), ClassTag$.MODULE$.Byte());
            random.nextBytes(a);
            return new Hash(a);
        };
        this.HashOrdering = new Ordering<Hash>(){
            public static final long serialVersionUID = 0L;

            public Some tryCompare(Object x, Object y) {
                return Ordering.tryCompare$(this, x, y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.lteq$(this, x, y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.gteq$(this, x, y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.lt$(this, x, y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.gt$(this, x, y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.equiv$(this, x, y);
            }

            public Object max(Object x, Object y) {
                return Ordering.max$(this, x, y);
            }

            public Object min(Object x, Object y) {
                return Ordering.min$(this, x, y);
            }

            public Ordering<Hash> reverse() {
                return Ordering.reverse$(this);
            }

            public <U> Ordering<U> on(Function1<U, Hash> f) {
                return Ordering.on$(this, f);
            }

            public Ordering.Ops mkOrderingOps(Object lhs) {
                return Ordering.mkOrderingOps$(this, lhs);
            }

            public final int compare(Hash x, Hash y) {
                return Hash$.com$digitalasset$daml$lf$crypto$Hash$$$anonfun$HashOrdering$1(x, y);
            }
            {
                PartialOrdering.$init$(this);
                Ordering.$init$(this);
            }
        };
        this.com$digitalasset$daml$lf$crypto$Hash$$hMacAlgorithm = "HmacSHA256";
    }
}

