/*
 * Decompiled with CFR 0.152.
 */
package com.digitalasset.daml.lf.engine;

import com.digitalasset.daml.lf.command.Commands;
import com.digitalasset.daml.lf.command.CreateAndExerciseCommand;
import com.digitalasset.daml.lf.command.CreateCommand;
import com.digitalasset.daml.lf.command.ExerciseByKeyCommand;
import com.digitalasset.daml.lf.command.ExerciseCommand;
import com.digitalasset.daml.lf.data.BackStack;
import com.digitalasset.daml.lf.data.BackStack$;
import com.digitalasset.daml.lf.data.ImmArray;
import com.digitalasset.daml.lf.data.ImmArray$;
import com.digitalasset.daml.lf.data.ImmArrayCons$;
import com.digitalasset.daml.lf.data.Ref;
import com.digitalasset.daml.lf.engine.Error;
import com.digitalasset.daml.lf.engine.Error$;
import com.digitalasset.daml.lf.engine.MutableCompiledPackages;
import com.digitalasset.daml.lf.engine.Result;
import com.digitalasset.daml.lf.engine.Result$;
import com.digitalasset.daml.lf.engine.ResultDone;
import com.digitalasset.daml.lf.engine.ResultError;
import com.digitalasset.daml.lf.engine.ResultNeedContract;
import com.digitalasset.daml.lf.engine.ResultNeedKey;
import com.digitalasset.daml.lf.engine.ResultNeedPackage;
import com.digitalasset.daml.lf.engine.ValueTranslator;
import com.digitalasset.daml.lf.language.Ast;
import com.digitalasset.daml.lf.speedy.Command;
import com.digitalasset.daml.lf.speedy.SValue;
import com.digitalasset.daml.lf.transaction.Node;
import com.digitalasset.daml.lf.value.Value;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd!B\u0001\u0003\u0001\ta!aE\"p[6\fg\u000e\u001a)sKB\u0014xnY3tg>\u0014(BA\u0002\u0005\u0003\u0019)gnZ5oK*\u0011QAB\u0001\u0003Y\u001aT!a\u0002\u0005\u0002\t\u0011\fW\u000e\u001c\u0006\u0003\u0013)\tA\u0002Z5hSR\fG.Y:tKRT\u0011aC\u0001\u0004G>l7C\u0001\u0001\u000e!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fM\"AA\u0003\u0001B\u0001B\u0003%a#\u0001\td_6\u0004\u0018\u000e\\3e!\u0006\u001c7.Y4fg\u000e\u0001\u0001CA\f\u0019\u001b\u0005\u0011\u0011BA\r\u0003\u0005]iU\u000f^1cY\u0016\u001cu.\u001c9jY\u0016$\u0007+Y2lC\u001e,7\u000fC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0003;y\u0001\"a\u0006\u0001\t\u000bQQ\u0002\u0019\u0001\f\t\u000f\u0001\u0002!\u0019!C\u0005C\u0005ya/\u00197vKR\u0013\u0018M\\:mCR|'/F\u0001#!\t92%\u0003\u0002%\u0005\tya+\u00197vKR\u0013\u0018M\\:mCR|'\u000f\u0003\u0004'\u0001\u0001\u0006IAI\u0001\u0011m\u0006dW/\u001a+sC:\u001cH.\u0019;pe\u0002Ba\u0001\u000b\u0001\u0005\u0002\tI\u0013A\u0004;sC:\u001cH.\u0019;f-\u0006dW/\u001a\u000b\u0004UMZ\u0005cA\f,[%\u0011AF\u0001\u0002\u0007%\u0016\u001cX\u000f\u001c;\u0011\u00059\nT\"A\u0018\u000b\u0005A\"\u0011AB:qK\u0016$\u00170\u0003\u00023_\t11KV1mk\u0016DQ\u0001N\u0014A\u0002U\n1\u0001^=1!\t1\u0004J\u0004\u00028\u000b:\u0011\u0001h\u0011\b\u0003s\ts!AO!\u000f\u0005m\u0002eB\u0001\u001f@\u001b\u0005i$B\u0001 \u0016\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!\u0001\u0012\u0003\u0002\u00111\fgnZ;bO\u0016L!AR$\u0002\u0007\u0005\u001bHO\u0003\u0002E\t%\u0011\u0011J\u0013\u0002\u0005)f\u0004XM\u0003\u0002G\u000f\")Aj\na\u0001\u001b\u0006\u0011a\u000f\r\t\u0004\u001dF\u001bV\"A(\u000b\u0005A#\u0011!\u0002<bYV,\u0017B\u0001*P\u0005\u00151\u0016\r\\;f!\t!vK\u0004\u0002O+&\u0011akT\u0001\u0006-\u0006dW/Z\u0005\u00031f\u0013!#\u00112t_2,H/Z\"p]R\u0014\u0018m\u0019;JI*\u0011ak\u0014\u0005\u00077\u0002!\tA\u0001/\u0002!A\u0014X\r\u001d:pG\u0016\u001c8o\u0011:fCR,GcA/ecB\u0019qc\u000b0\u0011\t9yV'Y\u0005\u0003A>\u0011a\u0001V;qY\u0016\u0014\u0004C\u0001\u0018c\u0013\t\u0019wFA\u0004D_6l\u0017M\u001c3\t\u000b\u0015T\u0006\u0019\u00014\u0002\u0015Q,W\u000e\u001d7bi\u0016LE\r\u0005\u0002h]:\u0011\u0001n\u001b\b\u0003q%L!A\u001b\u0003\u0002\t\u0011\fG/Y\u0005\u0003Y6\f1AU3g\u0015\tQG!\u0003\u0002pa\nQ\u0011\nZ3oi&4\u0017.\u001a:\u000b\u00051l\u0007\"\u0002:[\u0001\u0004i\u0015\u0001C1sOVlWM\u001c;\t\rQ\u0004A\u0011\u0001\u0002v\u0003=\u0001(/\u001a9s_\u000e,7o\u001d$fi\u000eDGcA/wo\")Qm\u001da\u0001M\")\u0001p\u001da\u0001'\u0006!1m\\5e\u0011\u0019Q\b\u0001\"\u0001\u0003w\u0006\u0011\u0002O]3qe>\u001cWm]:Fq\u0016\u00148-[:f)\u001diF0`A\u0003\u0003\u001fAQ!Z=A\u0002\u0019DQA`=A\u0002}\f!bY8oiJ\f7\r^%e!\r!\u0016\u0011A\u0005\u0004\u0003\u0007I&AC\"p]R\u0014\u0018m\u0019;JI\"9\u0011qA=A\u0002\u0005%\u0011\u0001C2i_&\u001cW-\u00133\u0011\u0007\u001d\fY!C\u0002\u0002\u000eA\u0014!b\u00115pS\u000e,g*Y7f\u0011\u0015\u0011\u0018\u00101\u0001N\u0011!\t\u0019\u0002\u0001C\u0001\u0005\u0005U\u0011a\u00069sKB\u0014xnY3tg\u0016CXM]2jg\u0016\u0014\u0015pS3z)%i\u0016qCA\r\u0003;\ty\u0002\u0003\u0004f\u0003#\u0001\rA\u001a\u0005\b\u00037\t\t\u00021\u0001N\u0003-\u0019wN\u001c;sC\u000e$8*Z=\t\u0011\u0005\u001d\u0011\u0011\u0003a\u0001\u0003\u0013AaA]A\t\u0001\u0004i\u0005\u0002CA\u0012\u0001\u0011\u0005!!!\n\u00027A\u0014X\r\u001d:pG\u0016\u001c8o\u0011:fCR,\u0017I\u001c3Fq\u0016\u00148-[:f)%i\u0016qEA\u0018\u0003g\t)\u0004C\u0004f\u0003C\u0001\r!!\u000b\u0011\u0007\u001d\fY#C\u0002\u0002.A\u0014\u0001BV1mk\u0016\u0014VM\u001a\u0005\b\u0003c\t\t\u00031\u0001N\u00039\u0019'/Z1uK\u0006\u0013x-^7f]RD\u0001\"a\u0002\u0002\"\u0001\u0007\u0011\u0011\u0002\u0005\b\u0003o\t\t\u00031\u0001N\u00039\u0019\u0007n\\5dK\u0006\u0013x-^7f]RD\u0001\"a\u000f\u0001\t\u0003\u0011\u0011QH\u0001\u0012aJ,\u0007O]8dKN\u001c8i\\7nC:$GcA/\u0002@!A\u0011\u0011IA\u001d\u0001\u0004\t\u0019%A\u0002d[\u0012\u0004B!!\u0012\u0002L5\u0011\u0011q\t\u0006\u0004\u0003\u0013\"\u0011aB2p[6\fg\u000eZ\u0005\u0004G\u0006\u001d\u0003\u0002CA(\u0001\u0011\u0005!!!\u0015\u0002%A\u0014X\r\u001d:pG\u0016\u001c8oQ8n[\u0006tGm\u001d\u000b\u0005\u0003'\ni\u0006\u0005\u0003\u0018W\u0005U\u0003#BA,\u00033rV\"A7\n\u0007\u0005mSN\u0001\u0005J[6\f%O]1z\u0011!\ty&!\u0014A\u0002\u0005\u0005\u0014!B2nIN\u0004\u0004\u0003BA#\u0003GJA!!\u001a\u0002H\tA1i\\7nC:$7\u000f")
public class CommandPreprocessor {
    private final MutableCompiledPackages compiledPackages;
    private final ValueTranslator valueTranslator;

    private ValueTranslator valueTranslator() {
        return this.valueTranslator;
    }

    public Result<SValue> translateValue(Ast.Type ty0, Value<Value.AbsoluteContractId> v0) {
        Result<SValue> result2;
        Result<SValue> result3 = this.valueTranslator().translateValue(ty0, v0);
        if (result3 instanceof ResultNeedPackage) {
            ResultNeedPackage resultNeedPackage = (ResultNeedPackage)result3;
            String pkgId = resultNeedPackage.packageId();
            Function1 resume = resultNeedPackage.resume();
            result2 = new ResultNeedPackage<SValue>(pkgId, (Function1<Option, Result> & Serializable & scala.Serializable)x0$1 -> {
                Result<Nothing$> result2;
                Option option2 = x0$1;
                if (None$.MODULE$.equals(option2)) {
                    result2 = new ResultError(Error$.MODULE$.apply(new StringBuilder(22).append("Couldn't find package ").append(pkgId).toString()));
                } else if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    Ast.Package pkg = (Ast.Package)some.value();
                    result2 = $this.compiledPackages.addPackage(pkgId, pkg).flatMap((Function1<BoxedUnit, Result> & Serializable & scala.Serializable)x$1 -> (Result)resume.apply(new Some<Ast.Package>(pkg)));
                } else {
                    throw new MatchError(option2);
                }
                return result2;
            });
        } else {
            result2 = result3;
        }
        return result2;
    }

    public Result<Tuple2<Ast.Type, Command>> preprocessCreate(Ref.Identifier templateId, Value<Value.AbsoluteContractId> argument) {
        return Result$.MODULE$.needDataType(this.compiledPackages, templateId, (Function1<Ast.DDataType, Result> & Serializable & scala.Serializable)dataType -> {
            Result<Nothing$> result2;
            if (dataType.params().length() > 0) {
                result2 = new ResultError(Error$.MODULE$.apply(new StringBuilder(91).append("Unexpected type parameters ").append(dataType.params()).append(" for template ").append(templateId).append(". Template datatypes should never have parameters.").toString()));
            } else {
                Ast.TTyCon typ = new Ast.TTyCon(templateId);
                result2 = this.translateValue(typ, argument).map((Function1<SValue, Tuple2> & Serializable & scala.Serializable)x$2 -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(typ), new Command.Create(templateId, (SValue)x$2)));
            }
            return result2;
        });
    }

    public Result<Tuple2<Ast.Type, Command>> preprocessFetch(Ref.Identifier templateId, Value.AbsoluteContractId coid) {
        return Result$.MODULE$.needDataType(this.compiledPackages, templateId, (Function1<Ast.DDataType, Result> & Serializable & scala.Serializable)dataType -> {
            Result<Nothing$> result2;
            if (dataType.params().length() > 0) {
                result2 = new ResultError(Error$.MODULE$.apply(new StringBuilder(91).append("Unexpected type parameters ").append(dataType.params()).append(" for template ").append(templateId).append(". Template datatypes should never have parameters.").toString()));
            } else {
                Ast.TTyCon typ = new Ast.TTyCon(templateId);
                result2 = new ResultDone<Tuple2<Ast.TTyCon, Command.Fetch>>(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(typ), new Command.Fetch(templateId, new SValue.SContractId(coid))));
            }
            return result2;
        });
    }

    public Result<Tuple2<Ast.Type, Command>> preprocessExercise(Ref.Identifier templateId, Value.ContractId contractId, String choiceId, Value<Value.AbsoluteContractId> argument) {
        return Result$.MODULE$.needTemplate(this.compiledPackages, templateId, (Function1<Ast.Template, Result> & Serializable & scala.Serializable)template -> {
            ResultError resultError;
            Option option2 = template.choices().get(choiceId);
            if (None$.MODULE$.equals(option2)) {
                Seq choicesNames = template.choices().toList().map((Function1<Tuple2, String> & Serializable & scala.Serializable)x$3 -> (String)x$3._1(), List$.MODULE$.canBuildFrom());
                resultError = new ResultError(Error$.MODULE$.apply(new StringBuilder(66).append("Couldn't find requested choice ").append(choiceId).append(" for template ").append(templateId).append(". Available choices: ").append(choicesNames).toString()));
            } else if (option2 instanceof Some) {
                Some some = (Some)option2;
                Ast.TemplateChoice choice2 = (Ast.TemplateChoice)some.value();
                Ast.Type choiceTyp = choice2.argBinder()._2();
                resultError = this.translateValue(choiceTyp, argument).map((Function1<SValue, Tuple2> & Serializable & scala.Serializable)x$4 -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(choiceTyp), new Command.Exercise(templateId, new SValue.SContractId(contractId), choiceId, (SValue)x$4)));
            } else {
                throw new MatchError(option2);
            }
            return resultError;
        });
    }

    public Result<Tuple2<Ast.Type, Command>> preprocessExerciseByKey(Ref.Identifier templateId, Value<Value.AbsoluteContractId> contractKey, String choiceId, Value<Value.AbsoluteContractId> argument) {
        return Result$.MODULE$.needTemplate(this.compiledPackages, templateId, (Function1<Ast.Template, Result> & Serializable & scala.Serializable)template -> {
            Option<Ast.TemplateKey> option2;
            void var6_12;
            Option option3;
            Tuple2 tuple2 = new Tuple2(template.choices().get(choiceId), template.key());
            if (tuple2 != null && None$.MODULE$.equals(option3 = tuple2._1())) {
                Seq choicesNames = template.choices().toList().map((Function1<Tuple2, String> & Serializable & scala.Serializable)x$5 -> (String)x$5._1(), List$.MODULE$.canBuildFrom());
                ResultError resultError = new ResultError(Error$.MODULE$.apply(new StringBuilder(66).append("Couldn't find requested choice ").append(choiceId).append(" for template ").append(templateId).append(". Available choices: ").append(choicesNames).toString()));
                return var6_12;
            } else if (tuple2 != null && None$.MODULE$.equals(option2 = tuple2._2())) {
                ResultError resultError = new ResultError(Error$.MODULE$.apply(new StringBuilder(62).append("Impossible to exercise by key, no key is defined for template ").append(templateId).toString()));
                return var6_12;
            } else {
                Ast.Type choiceType;
                if (tuple2 == null) throw new MatchError(tuple2);
                Option option4 = tuple2._1();
                Option<Ast.TemplateKey> option5 = tuple2._2();
                if (!(option4 instanceof Some)) throw new MatchError(tuple2);
                Some some = (Some)option4;
                Ast.TemplateChoice choice2 = (Ast.TemplateChoice)some.value();
                if (!(option5 instanceof Some)) throw new MatchError(tuple2);
                Some some2 = (Some)option5;
                Ast.TemplateKey ck = (Ast.TemplateKey)some2.value();
                Tuple2<Option<String>, Ast.Type> tuple22 = choice2.argBinder();
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                Ast.Type type = choiceType = tuple22._2();
                Ast.Type choiceType2 = type;
                Result result2 = this.translateValue(choiceType2, argument).flatMap((Function1<SValue, Result> & Serializable & scala.Serializable)arg -> this.translateValue(ck.typ(), contractKey).map((Function1<SValue, Tuple2> & Serializable & scala.Serializable)key -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(choiceType2), new Command.ExerciseByKey(templateId, (SValue)key, choiceId, (SValue)arg))));
            }
            return var6_12;
        });
    }

    public Result<Tuple2<Ast.Type, Command>> preprocessCreateAndExercise(Ref.Identifier templateId, Value<Value.AbsoluteContractId> createArgument, String choiceId, Value<Value.AbsoluteContractId> choiceArgument) {
        return Result$.MODULE$.needDataType(this.compiledPackages, templateId, (Function1<Ast.DDataType, Result> & Serializable & scala.Serializable)dataType -> {
            Result<Nothing$> result2;
            if (dataType.params().length() > 0) {
                result2 = new ResultError(Error$.MODULE$.apply(new StringBuilder(91).append("Unexpected type parameters ").append(dataType.params()).append(" for template ").append(templateId).append(". Template datatypes should never have parameters.").toString()));
            } else {
                Ast.TTyCon typ = new Ast.TTyCon(templateId);
                result2 = this.translateValue(typ, createArgument).flatMap((Function1<SValue, Result> & Serializable & scala.Serializable)createValue -> Result$.MODULE$.needTemplate($this.compiledPackages, templateId, (Function1<Ast.Template, Result> & Serializable & scala.Serializable)template -> {
                    ResultError resultError;
                    Option option2 = template.choices().get(choiceId);
                    if (None$.MODULE$.equals(option2)) {
                        Seq choicesNames = template.choices().toList().map((Function1<Tuple2, String> & Serializable & scala.Serializable)x$6 -> (String)x$6._1(), List$.MODULE$.canBuildFrom());
                        resultError = new ResultError(Error$.MODULE$.apply(new StringBuilder(66).append("Couldn't find requested choice ").append(choiceId).append(" for template ").append(templateId).append(". Available choices: ").append(choicesNames).toString()));
                    } else if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        Ast.TemplateChoice choice2 = (Ast.TemplateChoice)some.value();
                        Ast.Type choiceTyp = choice2.argBinder()._2();
                        resultError = this.translateValue(choiceTyp, choiceArgument).map((Function1<SValue, Tuple2> & Serializable & scala.Serializable)x$7 -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(choiceTyp), new Command.CreateAndExercise(templateId, (SValue)createValue, choiceId, (SValue)x$7)));
                    } else {
                        throw new MatchError(option2);
                    }
                    return resultError;
                }));
            }
            return result2;
        });
    }

    public Result<Tuple2<Ast.Type, Command>> preprocessCommand(com.digitalasset.daml.lf.command.Command cmd) {
        Result<Tuple2<Ast.Type, Command>> result2;
        com.digitalasset.daml.lf.command.Command command = cmd;
        if (command instanceof CreateCommand) {
            CreateCommand createCommand = (CreateCommand)command;
            Ref.Identifier templateId = createCommand.templateId();
            Value<Value.AbsoluteContractId> argument = createCommand.argument();
            result2 = this.preprocessCreate(templateId, argument);
        } else if (command instanceof ExerciseCommand) {
            ExerciseCommand exerciseCommand = (ExerciseCommand)command;
            Ref.Identifier templateId = exerciseCommand.templateId();
            String contractId = exerciseCommand.contractId();
            String choiceId = exerciseCommand.choiceId();
            Value<Value.AbsoluteContractId> argument = exerciseCommand.argument();
            result2 = this.preprocessExercise(templateId, new Value.AbsoluteContractId(contractId), choiceId, argument);
        } else if (command instanceof ExerciseByKeyCommand) {
            ExerciseByKeyCommand exerciseByKeyCommand = (ExerciseByKeyCommand)command;
            Ref.Identifier templateId = exerciseByKeyCommand.templateId();
            Value<Value.AbsoluteContractId> contractKey = exerciseByKeyCommand.contractKey();
            String choiceId = exerciseByKeyCommand.choiceId();
            Value<Value.AbsoluteContractId> argument = exerciseByKeyCommand.argument();
            result2 = this.preprocessExerciseByKey(templateId, contractKey, choiceId, argument);
        } else if (command instanceof CreateAndExerciseCommand) {
            CreateAndExerciseCommand createAndExerciseCommand = (CreateAndExerciseCommand)command;
            Ref.Identifier templateId = createAndExerciseCommand.templateId();
            Value<Value.AbsoluteContractId> createArgument = createAndExerciseCommand.createArgument();
            String choiceId = createAndExerciseCommand.choiceId();
            Value<Value.AbsoluteContractId> choiceArgument = createAndExerciseCommand.choiceArgument();
            result2 = this.preprocessCreateAndExercise(templateId, createArgument, choiceId, choiceArgument);
        } else {
            throw new MatchError(command);
        }
        return result2;
    }

    public Result<ImmArray<Tuple2<Ast.Type, Command>>> preprocessCommands(Commands cmds0) {
        return this.go$1(BackStack$.MODULE$.empty(), cmds0.commands());
    }

    private final Result go$1(BackStack processed, ImmArray toProcess) {
        Result result2;
        block10: {
            ImmArray immArray;
            block11: {
                Result<Nothing$> result3;
                Result<Tuple2<Ast.Type, Command>> result4;
                ImmArray cmds;
                while (true) {
                    Option option2;
                    if (!(option2 = ImmArray$.MODULE$.unapplySeq(immArray = toProcess)).isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(0) == 0) {
                        result2 = new ResultDone(processed.toImmArray());
                        break block10;
                    }
                    Option option3 = ImmArrayCons$.MODULE$.unapply(immArray);
                    if (option3.isEmpty()) break block11;
                    com.digitalasset.daml.lf.command.Command cmd = (com.digitalasset.daml.lf.command.Command)option3.get()._1();
                    cmds = option3.get()._2();
                    result4 = this.preprocessCommand(cmd);
                    if (!(result4 instanceof ResultDone)) break;
                    ResultDone resultDone = (ResultDone)result4;
                    Tuple2 processedCommand = (Tuple2)resultDone.result();
                    toProcess = cmds;
                    processed = processed.$colon$plus(processedCommand);
                }
                if (result4 instanceof ResultError) {
                    ResultError resultError = (ResultError)result4;
                    Error err = resultError.err();
                    result3 = new ResultError(err);
                } else if (result4 instanceof ResultNeedContract) {
                    ResultNeedContract resultNeedContract = (ResultNeedContract)result4;
                    Value.AbsoluteContractId acoid = resultNeedContract.acoid();
                    Function1 resume = resultNeedContract.resume();
                    result3 = new ResultNeedContract(acoid, (Function1<Option, Result> & Serializable & scala.Serializable)contract -> ((Result)resume.apply((Option<Value.ContractInst<Value.VersionedValue<Value.AbsoluteContractId>>>)contract)).flatMap((Function1<Tuple2, Result> & Serializable & scala.Serializable)processedCommand -> this.goResume$1(processed.$colon$plus(processedCommand), cmds)));
                } else if (result4 instanceof ResultNeedPackage) {
                    ResultNeedPackage resultNeedPackage = (ResultNeedPackage)result4;
                    String pkgId = resultNeedPackage.packageId();
                    Function1 resume = resultNeedPackage.resume();
                    result3 = new ResultNeedPackage(pkgId, (Function1<Option, Result> & Serializable & scala.Serializable)pkg -> ((Result)resume.apply((Option<Ast.Package>)pkg)).flatMap((Function1<Tuple2, Result> & Serializable & scala.Serializable)processedCommand -> this.goResume$1(processed.$colon$plus(processedCommand), cmds)));
                } else if (result4 instanceof ResultNeedKey) {
                    ResultNeedKey resultNeedKey = (ResultNeedKey)result4;
                    Node.GlobalKey key = resultNeedKey.key();
                    Function1 resume = resultNeedKey.resume();
                    result3 = new ResultNeedKey(key, (Function1<Option, Result> & Serializable & scala.Serializable)contract -> ((Result)resume.apply((Option<Value.AbsoluteContractId>)contract)).flatMap((Function1<Tuple2, Result> & Serializable & scala.Serializable)processedCommand -> this.goResume$1(processed.$colon$plus(processedCommand), cmds)));
                } else {
                    throw new MatchError(result4);
                }
                result2 = result3;
                break block10;
            }
            throw new MatchError(immArray);
        }
        return result2;
    }

    private final Result goResume$1(BackStack processed, ImmArray toProcess) {
        return this.go$1(processed, toProcess);
    }

    public CommandPreprocessor(MutableCompiledPackages compiledPackages) {
        this.compiledPackages = compiledPackages;
        this.valueTranslator = new ValueTranslator(compiledPackages);
    }
}

