/*
 * Decompiled with CFR 0.152.
 */
package com.digitalasset.daml.lf.speedy;

import com.digitalasset.daml.lf.data.FrontStack;
import com.digitalasset.daml.lf.data.ImmArray;
import com.digitalasset.daml.lf.data.Ref;
import com.digitalasset.daml.lf.data.SortedLookupList;
import com.digitalasset.daml.lf.data.Time;
import com.digitalasset.daml.lf.speedy.SError;
import com.digitalasset.daml.lf.transaction.Node;
import com.digitalasset.daml.lf.transaction.Transaction;
import com.digitalasset.daml.lf.types.Ledger;
import com.digitalasset.daml.lf.value.Value;
import com.digitalasset.daml.lf.value.Value$ValueUnit$;
import java.io.Serializable;
import java.math.BigDecimal;
import org.typelevel.paiges.Doc;
import org.typelevel.paiges.Doc$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcZ$sp;
import scala.util.Try$;

public final class Pretty$ {
    public static Pretty$ MODULE$;

    static {
        new Pretty$();
    }

    public Doc prettyError(SError.SError err, Transaction.PartialTransaction ptx) {
        Doc doc;
        Doc doc2 = Doc$.MODULE$.text("Error:");
        SError.SError sError = err;
        if (sError instanceof SError.SErrorDamlException) {
            SError.SErrorDamlException sErrorDamlException = (SError.SErrorDamlException)((Object)sError);
            doc = this.prettyDamlException(sErrorDamlException, ptx);
        } else if (sError instanceof SError.SErrorCrash) {
            SError.SErrorCrash sErrorCrash = (SError.SErrorCrash)sError;
            String reason = sErrorCrash.reason();
            doc = Doc$.MODULE$.text(new StringBuilder(7).append("CRASH: ").append(reason).toString());
        } else if (sError instanceof SError.SErrorScenario) {
            SError.SErrorScenario sErrorScenario = (SError.SErrorScenario)((Object)sError);
            doc = this.prettyScenarioError(sErrorScenario);
        } else {
            throw new MatchError((Object)sError);
        }
        return doc2.$amp(doc);
    }

    public Doc prettyParty(String p) {
        return Doc$.MODULE$.char('\'').$plus(Doc$.MODULE$.text(p)).$plus(Doc$.MODULE$.char('\''));
    }

    public Doc prettyDamlException(SError.SErrorDamlException ex, Transaction.PartialTransaction ptx) {
        Doc doc;
        SError.SErrorDamlException sErrorDamlException = ex;
        if (sErrorDamlException instanceof SError.DamlEArithmeticError) {
            SError.DamlEArithmeticError damlEArithmeticError = (SError.DamlEArithmeticError)sErrorDamlException;
            String message = damlEArithmeticError.message();
            doc = Doc$.MODULE$.text(message);
        } else if (sErrorDamlException instanceof SError.DamlEUserError) {
            SError.DamlEUserError damlEUserError = (SError.DamlEUserError)sErrorDamlException;
            String message = damlEUserError.message();
            doc = Doc$.MODULE$.text(new StringBuilder(12).append("User abort: ").append(message).toString());
        } else if (sErrorDamlException instanceof SError.DamlETransactionError) {
            SError.DamlETransactionError damlETransactionError = (SError.DamlETransactionError)sErrorDamlException;
            String reason = damlETransactionError.reason();
            doc = Doc$.MODULE$.text(new StringBuilder(19).append("Transaction error: ").append(reason).toString());
        } else if (sErrorDamlException instanceof SError.DamlEMatchError) {
            SError.DamlEMatchError damlEMatchError = (SError.DamlEMatchError)sErrorDamlException;
            String reason = damlEMatchError.reason();
            doc = Doc$.MODULE$.text(reason);
        } else if (sErrorDamlException instanceof SError.DamlETemplatePreconditionViolated) {
            SError.DamlETemplatePreconditionViolated damlETemplatePreconditionViolated = (SError.DamlETemplatePreconditionViolated)sErrorDamlException;
            Ref.Identifier tid = damlETemplatePreconditionViolated.templateId();
            Value.VersionedValue<Value.ContractId> arg = damlETemplatePreconditionViolated.arg();
            doc = Doc$.MODULE$.text("Update failed due to precondition violation when creating").$amp(this.prettyTypeConName(tid)).$amp(Doc$.MODULE$.text("with")).$amp(this.prettyVersionedValue(true, arg));
        } else if (sErrorDamlException instanceof SError.DamlELocalContractNotActive) {
            Doc doc2;
            SError.DamlELocalContractNotActive damlELocalContractNotActive = (SError.DamlELocalContractNotActive)sErrorDamlException;
            Value.ContractId coid = damlELocalContractNotActive.coid();
            Ref.Identifier tid = damlELocalContractNotActive.templateId();
            Value.NodeId consumedBy = damlELocalContractNotActive.consumedBy();
            Doc doc3 = Doc$.MODULE$.text("Update failed due to fetch of an inactive contract").$amp(this.prettyContractId(coid));
            Doc doc4 = Doc$.MODULE$.char('(').$plus(this.prettyTypeConName(tid)).$plus(Doc$.MODULE$.text(").").$div(Doc$.MODULE$.text(new StringBuilder(52).append("The contract had been consumed in sub-transaction #").append(consumedBy).append(":").toString())));
            Option<Node.GenNode<Value.NodeId, Value.ContractId, Value.VersionedValue<Value.ContractId>>> option2 = ptx.nodes().get(consumedBy);
            if (None$.MODULE$.equals(option2)) {
                doc2 = Doc$.MODULE$.line().$plus(Doc$.MODULE$.text("Recursive exercise of ")).$plus(this.prettyTypeConName(tid)).nested(4);
            } else if (option2 instanceof Some) {
                Some some = (Some)option2;
                Node.GenNode node = (Node.GenNode)some.value();
                doc2 = Doc$.MODULE$.line().$plus(this.prettyTransactionNode(node)).nested(4);
            } else {
                throw new MatchError(option2);
            }
            doc = doc3.$amp(doc4.$plus(doc2));
        } else if (sErrorDamlException instanceof SError.DamlEWronglyTypedContract) {
            SError.DamlEWronglyTypedContract damlEWronglyTypedContract = (SError.DamlEWronglyTypedContract)sErrorDamlException;
            Value.ContractId coid = damlEWronglyTypedContract.coid();
            Ref.Identifier expected = damlEWronglyTypedContract.expected();
            Ref.Identifier actual = damlEWronglyTypedContract.actual();
            doc = Doc$.MODULE$.text("Update failed due to wrongly typed contract id").$amp(this.prettyContractId(coid).$div(Doc$.MODULE$.text("Expected contract of type"))).$amp(this.prettyTypeConName(expected)).$amp(Doc$.MODULE$.text("but got")).$amp(this.prettyTypeConName(actual));
        } else if (sErrorDamlException instanceof SError.DamlESubmitterNotInMaintainers) {
            SError.DamlESubmitterNotInMaintainers damlESubmitterNotInMaintainers = (SError.DamlESubmitterNotInMaintainers)sErrorDamlException;
            Ref.Identifier templateId = damlESubmitterNotInMaintainers.templateId();
            String submitter = damlESubmitterNotInMaintainers.submitter();
            Set<String> maintainers = damlESubmitterNotInMaintainers.maintainers();
            doc = Doc$.MODULE$.text("Expected the submitter").$amp(this.prettyParty(submitter)).$amp(Doc$.MODULE$.text("to be in maintainers")).$amp(Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), maintainers.map((Function1<String, Doc> & Serializable & scala.Serializable)p -> MODULE$.prettyParty((String)p), Set$.MODULE$.canBuildFrom()))).$amp(Doc$.MODULE$.text("when looking up template of maintainer")).$amp(this.prettyTypeConName(templateId));
        } else {
            throw new MatchError(sErrorDamlException);
        }
        return doc;
    }

    public Doc prettyTransactionNode(Node.GenNode<Value.NodeId, Value.ContractId, Value.VersionedValue<Value.ContractId>> node) {
        Doc doc;
        Node.GenNode<Value.NodeId, Value.ContractId, Value.VersionedValue<Value.ContractId>> genNode = node;
        if (genNode instanceof Node.NodeCreate) {
            Node.NodeCreate nodeCreate = (Node.NodeCreate)genNode;
            String string2 = "create";
            doc = this.prettyContractInst(nodeCreate.coinst()).$amp$colon(string2);
        } else if (genNode instanceof Node.NodeFetch) {
            Node.NodeFetch nodeFetch = (Node.NodeFetch)genNode;
            String string3 = "fetch";
            doc = this.prettyContractId((Value.ContractId)nodeFetch.coid()).$amp$colon(string3);
        } else if (genNode instanceof Node.NodeExercises) {
            Node.NodeExercises nodeExercises = (Node.NodeExercises)genNode;
            doc = Doc$.MODULE$.intercalate(Doc$.MODULE$.text(", "), nodeExercises.actingParties().map((Function1<String, Doc> & Serializable & scala.Serializable)p -> Doc$.MODULE$.text((String)p), Set$.MODULE$.canBuildFrom())).$amp(Doc$.MODULE$.text("exercises")).$amp(Doc$.MODULE$.text(nodeExercises.choiceId()).$plus(Doc$.MODULE$.char(':')).$plus(this.prettyIdentifier(nodeExercises.templateId()))).$amp(Doc$.MODULE$.text("on")).$amp(this.prettyContractId((Value.ContractId)nodeExercises.targetCoid()).$div(Doc$.MODULE$.text("with"))).$amp(this.prettyVersionedValue(false, (Value.VersionedValue)nodeExercises.chosenValue()));
        } else if (genNode instanceof Node.NodeLookupByKey) {
            Doc doc2;
            Node.NodeLookupByKey nodeLookupByKey = (Node.NodeLookupByKey)genNode;
            Doc doc3 = Doc$.MODULE$.text("lookup by key").$amp(this.prettyIdentifier(nodeLookupByKey.templateId()).$div(Doc$.MODULE$.text("key")));
            Doc doc4 = this.prettyKeyWithMaintainers(nodeLookupByKey.key());
            Option option2 = nodeLookupByKey.result();
            if (None$.MODULE$.equals(option2)) {
                doc2 = Doc$.MODULE$.text("not found");
            } else if (option2 instanceof Some) {
                Some some = (Some)option2;
                Value.ContractId coid = (Value.ContractId)some.value();
                doc2 = Doc$.MODULE$.text("found").$amp(this.prettyContractId(coid));
            } else {
                throw new MatchError(option2);
            }
            doc = doc3.$amp(doc4.$div(doc2));
        } else {
            throw new MatchError(genNode);
        }
        return doc;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Doc prettyScenarioError(SError.SErrorScenario serr) {
        Ledger.CommitError commitError;
        Doc doc;
        Doc doc2 = Doc$.MODULE$.text("Scenario failed");
        boolean bl = false;
        SError.ScenarioErrorCommitError scenarioErrorCommitError = null;
        SError.SErrorScenario sErrorScenario = serr;
        if (sErrorScenario instanceof SError.ScenarioErrorContractNotEffective) {
            SError.ScenarioErrorContractNotEffective scenarioErrorContractNotEffective = (SError.ScenarioErrorContractNotEffective)sErrorScenario;
            Value.AbsoluteContractId coid = scenarioErrorContractNotEffective.coid();
            Ref.Identifier tid = scenarioErrorContractNotEffective.templateId();
            Time.Timestamp effectiveAt = scenarioErrorContractNotEffective.effectiveAt();
            doc = Doc$.MODULE$.text("due to a fetch of an inactive contract").$amp(this.prettyContractId(coid)).$amp(Doc$.MODULE$.char('(').$plus(this.prettyIdentifier(tid)).$plus(Doc$.MODULE$.text(")."))).$amp(Doc$.MODULE$.text(new StringBuilder(26).append("that becomes effective at ").append(effectiveAt).toString()));
            return doc2.$amp(doc);
        }
        if (sErrorScenario instanceof SError.ScenarioErrorContractNotActive) {
            SError.ScenarioErrorContractNotActive scenarioErrorContractNotActive = (SError.ScenarioErrorContractNotActive)sErrorScenario;
            Value.AbsoluteContractId coid = scenarioErrorContractNotActive.coid();
            Ref.Identifier tid = scenarioErrorContractNotActive.templateId();
            String consumedBy = scenarioErrorContractNotActive.consumedBy();
            doc = Doc$.MODULE$.text("due to a fetch of a consumed contract").$amp(this.prettyContractId(coid)).$amp(Doc$.MODULE$.char('(').$plus(this.prettyIdentifier(tid)).$plus(Doc$.MODULE$.text(").").$div(Doc$.MODULE$.text("The contract had been consumed in transaction")))).$amp(this.prettyLedgerNodeId(consumedBy));
            return doc2.$amp(doc);
        }
        if (sErrorScenario instanceof SError.ScenarioErrorContractNotVisible) {
            SError.ScenarioErrorContractNotVisible scenarioErrorContractNotVisible = (SError.ScenarioErrorContractNotVisible)sErrorScenario;
            Value.AbsoluteContractId coid = scenarioErrorContractNotVisible.coid();
            Ref.Identifier tid = scenarioErrorContractNotVisible.templateId();
            String committer = scenarioErrorContractNotVisible.committer();
            Set<String> observers = scenarioErrorContractNotVisible.observers();
            doc = Doc$.MODULE$.text("due to the failure to fetch the contract").$amp(this.prettyContractId(coid)).$amp(Doc$.MODULE$.char('(').$plus(this.prettyIdentifier(tid)).$plus(Doc$.MODULE$.text(").").$div(Doc$.MODULE$.text("The contract had not been disclosed to the committer")))).$amp(this.prettyParty(committer).$plus(Doc$.MODULE$.char('.').$div(Doc$.MODULE$.text("The contract had been disclosed to:")))).$amp(Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), observers.map((Function1<String, Doc> & Serializable & scala.Serializable)p -> MODULE$.prettyParty((String)p), Set$.MODULE$.canBuildFrom())).$plus(Doc$.MODULE$.char('.')));
            return doc2.$amp(doc);
        }
        if (sErrorScenario instanceof SError.ScenarioErrorCommitError) {
            bl = true;
            scenarioErrorCommitError = (SError.ScenarioErrorCommitError)sErrorScenario;
            Ledger.CommitError commitError2 = scenarioErrorCommitError.commitError();
            if (commitError2 instanceof Ledger.CommitError.FailedAuthorizations) {
                Ledger.CommitError.FailedAuthorizations failedAuthorizations = (Ledger.CommitError.FailedAuthorizations)commitError2;
                Map<Value.NodeId, Ledger.FailedAuthorization> fas = failedAuthorizations.errors();
                doc = Doc$.MODULE$.text("due to failed authorizations:").$div(this.prettyFailedAuthorizations(fas)).nested(4);
                return doc2.$amp(doc);
            }
        }
        if (bl && (commitError = scenarioErrorCommitError.commitError()) instanceof Ledger.CommitError.UniqueKeyViolation) {
            Ledger.CommitError.UniqueKeyViolation uniqueKeyViolation = (Ledger.CommitError.UniqueKeyViolation)commitError;
            Ledger.UniqueKeyViolation gk = uniqueKeyViolation.error();
            doc = Doc$.MODULE$.text("due to unique key violation for key:").$amp(this.prettyVersionedValue(false, gk.gk().key())).$amp(Doc$.MODULE$.text("for template")).$amp(this.prettyIdentifier(gk.gk().templateId()));
            return doc2.$amp(doc);
        }
        if (sErrorScenario instanceof SError.ScenarioErrorMustFailSucceeded) {
            doc = Doc$.MODULE$.text("due to a mustfailAt that succeeded.");
            return doc2.$amp(doc);
        }
        if (!(sErrorScenario instanceof SError.ScenarioErrorInvalidPartyName)) throw new MatchError(sErrorScenario);
        SError.ScenarioErrorInvalidPartyName scenarioErrorInvalidPartyName = (SError.ScenarioErrorInvalidPartyName)sErrorScenario;
        String msg = scenarioErrorInvalidPartyName.msg();
        doc = Doc$.MODULE$.text(new StringBuilder(15).append("Invalid party: ").append(msg).toString());
        return doc2.$amp(doc);
    }

    public Doc prettyFailedAuthorizations(Map<Value.NodeId, Ledger.FailedAuthorization> fas) {
        return Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), fas.toSeq().map((Function1<Tuple2, Doc> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Value.NodeId nodeId = (Value.NodeId)tuple2._1();
                Ledger.FailedAuthorization failedAuthorization = (Ledger.FailedAuthorization)tuple2._2();
                if (failedAuthorization instanceof Ledger.FACreateMissingAuthorization) {
                    Ledger.FACreateMissingAuthorization fACreateMissingAuthorization = (Ledger.FACreateMissingAuthorization)failedAuthorization;
                    Set<String> authorizing = fACreateMissingAuthorization.authorizingParties();
                    Set<String> required = fACreateMissingAuthorization.requiredParties();
                    return Doc$.MODULE$.str(nodeId).$amp(Doc$.MODULE$.text(": missing authorization for create, authorizing parties:")).$amp(Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), authorizing.map((Function1<String, Doc> & Serializable & scala.Serializable)p -> MODULE$.prettyParty((String)p), Set$.MODULE$.canBuildFrom())).$plus(Doc$.MODULE$.text(", at least all of the following parties need to authorize:"))).$amp(Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), required.map((Function1<String, Doc> & Serializable & scala.Serializable)p -> MODULE$.prettyParty((String)p), Set$.MODULE$.canBuildFrom())));
                }
            }
            if (tuple2 != null) {
                Value.NodeId nodeId = (Value.NodeId)tuple2._1();
                Ledger.FailedAuthorization failedAuthorization = (Ledger.FailedAuthorization)tuple2._2();
                if (failedAuthorization instanceof Ledger.FAMaintainersNotSubsetOfSignatories) {
                    Ledger.FAMaintainersNotSubsetOfSignatories fAMaintainersNotSubsetOfSignatories = (Ledger.FAMaintainersNotSubsetOfSignatories)failedAuthorization;
                    Set<String> signatories = fAMaintainersNotSubsetOfSignatories.signatories();
                    Set<String> maintainers = fAMaintainersNotSubsetOfSignatories.maintainers();
                    return Doc$.MODULE$.str(nodeId).$amp(Doc$.MODULE$.text(": all the maintainers:")).$amp(Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), maintainers.map((Function1<String, Doc> & Serializable & scala.Serializable)p -> MODULE$.prettyParty((String)p), Set$.MODULE$.canBuildFrom())).$plus(Doc$.MODULE$.text(", need to be signatories:"))).$amp(Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), signatories.map((Function1<String, Doc> & Serializable & scala.Serializable)p -> MODULE$.prettyParty((String)p), Set$.MODULE$.canBuildFrom())));
                }
            }
            if (tuple2 != null) {
                Value.NodeId nodeId = (Value.NodeId)tuple2._1();
                Ledger.FailedAuthorization failedAuthorization = (Ledger.FailedAuthorization)tuple2._2();
                if (failedAuthorization instanceof Ledger.FAFetchMissingAuthorization) {
                    Ledger.FAFetchMissingAuthorization fAFetchMissingAuthorization = (Ledger.FAFetchMissingAuthorization)failedAuthorization;
                    Set<String> authorizing = fAFetchMissingAuthorization.stakeholders();
                    Set<String> stakeholders = fAFetchMissingAuthorization.authorizingParties();
                    return Doc$.MODULE$.str(nodeId).$amp(Doc$.MODULE$.text(": missing authorization for fetch, authorizing parties:")).$amp(Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), authorizing.map((Function1<String, Doc> & Serializable & scala.Serializable)p -> MODULE$.prettyParty((String)p), Set$.MODULE$.canBuildFrom())).$plus(Doc$.MODULE$.text(", at least one of the following parties need to authorize:"))).$amp(Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), stakeholders.map((Function1<String, Doc> & Serializable & scala.Serializable)p -> MODULE$.prettyParty((String)p), Set$.MODULE$.canBuildFrom())));
                }
            }
            if (tuple2 != null) {
                Value.NodeId nodeId = (Value.NodeId)tuple2._1();
                Ledger.FailedAuthorization failedAuthorization = (Ledger.FailedAuthorization)tuple2._2();
                if (failedAuthorization instanceof Ledger.FAExerciseMissingAuthorization) {
                    Ledger.FAExerciseMissingAuthorization fAExerciseMissingAuthorization = (Ledger.FAExerciseMissingAuthorization)failedAuthorization;
                    Set<String> authorizing = fAExerciseMissingAuthorization.authorizingParties();
                    Set<String> required = fAExerciseMissingAuthorization.requiredParties();
                    return Doc$.MODULE$.str(nodeId).$amp(Doc$.MODULE$.text(": missing authorization for exercise, authorizing parties:")).$amp(Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), authorizing.map((Function1<String, Doc> & Serializable & scala.Serializable)p -> MODULE$.prettyParty((String)p), Set$.MODULE$.canBuildFrom())).$plus(Doc$.MODULE$.text(", exactly the following parties need to authorize::"))).$amp(Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), required.map((Function1<String, Doc> & Serializable & scala.Serializable)p -> MODULE$.prettyParty((String)p), Set$.MODULE$.canBuildFrom())));
                }
            }
            if (tuple2 != null) {
                Value.NodeId nodeId = (Value.NodeId)tuple2._1();
                Ledger.FailedAuthorization failedAuthorization = (Ledger.FailedAuthorization)tuple2._2();
                if (failedAuthorization instanceof Ledger.FAActorMismatch) {
                    Ledger.FAActorMismatch fAActorMismatch = (Ledger.FAActorMismatch)failedAuthorization;
                    Set<String> ctrls = fAActorMismatch.controllers();
                    Set<String> actors = fAActorMismatch.givenActors();
                    return Doc$.MODULE$.str(nodeId).$plus(Doc$.MODULE$.text(": actor mismatch, controllers:")).$amp(Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), ctrls.map((Function1<String, Doc> & Serializable & scala.Serializable)p -> MODULE$.prettyParty((String)p), Set$.MODULE$.canBuildFrom()))).$amp(Doc$.MODULE$.text(", given actors:")).$amp(Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), actors.map((Function1<String, Doc> & Serializable & scala.Serializable)p -> MODULE$.prettyParty((String)p), Set$.MODULE$.canBuildFrom())));
                }
            }
            if (tuple2 != null) {
                Value.NodeId nodeId = (Value.NodeId)tuple2._1();
                Ledger.FailedAuthorization failedAuthorization = (Ledger.FailedAuthorization)tuple2._2();
                if (failedAuthorization instanceof Ledger.FANoSignatories) {
                    Ledger.FANoSignatories fANoSignatories = (Ledger.FANoSignatories)failedAuthorization;
                    Ref.Identifier templateId = fANoSignatories.templateId();
                    return Doc$.MODULE$.str(nodeId).$plus(Doc$.MODULE$.text(new StringBuilder(22).append(": ").append(templateId).append(" missing signatories").toString()));
                }
            }
            if (tuple2 != null) {
                Value.NodeId nodeId = (Value.NodeId)tuple2._1();
                Ledger.FailedAuthorization failedAuthorization = (Ledger.FailedAuthorization)tuple2._2();
                if (failedAuthorization instanceof Ledger.FANoControllers) {
                    Ledger.FANoControllers fANoControllers = (Ledger.FANoControllers)failedAuthorization;
                    Ref.Identifier templateId = fANoControllers.templateId();
                    String choiceId = fANoControllers.choiceid();
                    return Doc$.MODULE$.str(nodeId).$plus(Doc$.MODULE$.text(new StringBuilder(23).append(": ").append(templateId).append(" ").append(choiceId).append(" missing controllers").toString()));
                }
            }
            if (tuple2 == null) throw new MatchError(tuple2);
            Value.NodeId nodeId = (Value.NodeId)tuple2._1();
            Ledger.FailedAuthorization failedAuthorization = (Ledger.FailedAuthorization)tuple2._2();
            if (!(failedAuthorization instanceof Ledger.FALookupByKeyMissingAuthorization)) throw new MatchError(tuple2);
            Ledger.FALookupByKeyMissingAuthorization fALookupByKeyMissingAuthorization = (Ledger.FALookupByKeyMissingAuthorization)failedAuthorization;
            Set<String> maintainers = fALookupByKeyMissingAuthorization.maintainers();
            Set<String> authorizingParties = fALookupByKeyMissingAuthorization.authorizingParties();
            return Doc$.MODULE$.str(nodeId).$plus(Doc$.MODULE$.text(": missing authorization for lookup by key, authorizing parties:")).$amp(Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), authorizingParties.map((Function1<String, Doc> & Serializable & scala.Serializable)p -> MODULE$.prettyParty((String)p), Set$.MODULE$.canBuildFrom())).$plus(Doc$.MODULE$.text(" are not a superset of maintainers:"))).$amp(Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), maintainers.map((Function1<String, Doc> & Serializable & scala.Serializable)p -> MODULE$.prettyParty((String)p), Set$.MODULE$.canBuildFrom())));
        }, Seq$.MODULE$.canBuildFrom()));
    }

    public Doc prettyValueRef(Ref.Identifier ref) {
        return Doc$.MODULE$.text(new StringBuilder(1).append(ref.qualifiedName().toString()).append("@").append(ref.packageId()).toString());
    }

    public Doc prettyLedger(Ledger.Ledger l) {
        return Doc$.MODULE$.text("transactions:").$div(this.prettyTransactions(l)).$div(Doc$.MODULE$.line()).$plus(Doc$.MODULE$.text("active contracts:").$div(this.prettyActiveContracts(l.ledgerData())).nested(3));
    }

    public Doc prettyTransactions(Ledger.Ledger l) {
        return Doc$.MODULE$.intercalate(Doc$.MODULE$.line().$plus(Doc$.MODULE$.line()), l.scenarioSteps().values().map((Function1<Ledger.ScenarioStep, Doc> & Serializable & scala.Serializable)step -> MODULE$.prettyScenarioStep(l, (Ledger.ScenarioStep)step), Iterable$.MODULE$.canBuildFrom()));
    }

    public Doc prettyLoc(Option<Ref.Location> optLoc) {
        return (Doc)optLoc.map((Function1<Ref.Location, Doc> & Serializable & scala.Serializable)l -> Doc$.MODULE$.text(new StringBuilder(2).append("[").append(l.module().toString()).append(":").toString()).$plus(Doc$.MODULE$.str(BoxesRunTime.boxToInteger(l.start()._1$mcI$sp() + 1))).$plus(Doc$.MODULE$.text("]"))).getOrElse((Function0<Doc> & Serializable & scala.Serializable)() -> Doc$.MODULE$.text("[unknown source]"));
    }

    public Doc prettyScenarioStep(Ledger.Ledger l, Ledger.ScenarioStep step) {
        Doc doc;
        Ledger.ScenarioStep scenarioStep = step;
        if (scenarioStep instanceof Ledger.Commit) {
            Ledger.Commit commit = (Ledger.Commit)scenarioStep;
            Ledger.ScenarioTransactionId txid = commit.txId();
            Ledger.RichTransaction rtx = commit.richTransaction();
            Option<Ref.Location> optLoc = commit.optLocation();
            Doc children = Doc$.MODULE$.intercalate(Doc$.MODULE$.line().$plus(Doc$.MODULE$.line()), rtx.roots().toList().map((Function1<String, Doc> & Serializable & scala.Serializable)nodeId -> MODULE$.prettyNodeInfo(l, (String)nodeId), List$.MODULE$.canBuildFrom()));
            doc = Doc$.MODULE$.text("TX").$amp(Doc$.MODULE$.char('#').$plus(Doc$.MODULE$.str(txid.id()))).$amp(Doc$.MODULE$.str(rtx.effectiveAt())).$amp(this.prettyLoc(optLoc).$div(children));
        } else if (scenarioStep instanceof Ledger.PassTime) {
            Ledger.PassTime passTime = (Ledger.PassTime)scenarioStep;
            long dt = passTime.dtMicros();
            String string2 = "pass";
            doc = Doc$.MODULE$.str(BoxesRunTime.boxToLong(dt)).$amp$colon(string2);
        } else if (scenarioStep instanceof Ledger.AssertMustFail) {
            Ledger.AssertMustFail assertMustFail = (Ledger.AssertMustFail)scenarioStep;
            doc = Doc$.MODULE$.text("mustFailAt").$amp(this.prettyParty(assertMustFail.actor())).$amp(this.prettyLoc(assertMustFail.optLocation()));
        } else {
            throw new MatchError(scenarioStep);
        }
        return doc;
    }

    public Doc prettyKeyWithMaintainers(Node.KeyWithMaintainers<Value.VersionedValue<Value.ContractId>> key) {
        return this.prettyVersionedValue(false, key.key());
    }

    public Doc prettyNodeInfo(Ledger.Ledger l, String nodeId2) {
        Doc doc;
        Doc doc2;
        Ledger.LedgerNodeInfo ni = (Ledger.LedgerNodeInfo)l.ledgerData().nodeInfos().apply(nodeId2);
        Node.GenNode<String, Value.AbsoluteContractId, Value.VersionedValue<Value.AbsoluteContractId>> genNode = ni.node();
        if (genNode instanceof Node.NodeCreate) {
            Doc doc3;
            Node.NodeCreate nodeCreate = (Node.NodeCreate)genNode;
            String string2 = "create";
            Doc d = this.prettyContractInst(nodeCreate.coinst()).$amp$colon(string2);
            Option option2 = nodeCreate.key();
            if (None$.MODULE$.equals(option2)) {
                doc3 = d;
            } else if (option2 instanceof Some) {
                Some some = (Some)option2;
                Node.KeyWithMaintainers key = (Node.KeyWithMaintainers)some.value();
                doc3 = d.$div(Doc$.MODULE$.text("key")).$amp(this.prettyKeyWithMaintainers(key));
            } else {
                throw new MatchError(option2);
            }
            doc2 = doc3;
        } else if (genNode instanceof Node.NodeFetch) {
            Node.NodeFetch nodeFetch = (Node.NodeFetch)genNode;
            String string3 = "ensure active";
            doc2 = this.prettyContractId((Value.ContractId)nodeFetch.coid()).$amp$colon(string3);
        } else if (genNode instanceof Node.NodeExercises) {
            Node.NodeExercises nodeExercises = (Node.NodeExercises)genNode;
            Doc children = nodeExercises.children().nonEmpty() ? Doc$.MODULE$.text("children:").$div(Doc$.MODULE$.stack(nodeExercises.children().toList().map((Function1<String, Doc> & Serializable & scala.Serializable)nodeId -> MODULE$.prettyNodeInfo(l, (String)nodeId), List$.MODULE$.canBuildFrom()))) : Doc$.MODULE$.text("");
            doc2 = Doc$.MODULE$.intercalate(Doc$.MODULE$.text(", "), nodeExercises.actingParties().map((Function1<String, Doc> & Serializable & scala.Serializable)p -> Doc$.MODULE$.text((String)p), Set$.MODULE$.canBuildFrom())).$amp(Doc$.MODULE$.text("exercises")).$amp(Doc$.MODULE$.text(nodeExercises.choiceId()).$plus(Doc$.MODULE$.char(':')).$plus(this.prettyIdentifier(nodeExercises.templateId()))).$amp(Doc$.MODULE$.text("on")).$amp(this.prettyContractId((Value.ContractId)nodeExercises.targetCoid()).$div(Doc$.MODULE$.text("    ").$plus(Doc$.MODULE$.text("with")).$amp(this.prettyVersionedValue(false, (Value.VersionedValue)nodeExercises.chosenValue()).$div(children)).nested(4)));
        } else if (genNode instanceof Node.NodeLookupByKey) {
            Doc doc4;
            Node.NodeLookupByKey nodeLookupByKey = (Node.NodeLookupByKey)genNode;
            Doc doc5 = Doc$.MODULE$.text("lookup by key").$amp(this.prettyIdentifier(nodeLookupByKey.templateId()).$div(Doc$.MODULE$.text("key")));
            Doc doc6 = this.prettyKeyWithMaintainers(nodeLookupByKey.key());
            Option option3 = nodeLookupByKey.result();
            if (None$.MODULE$.equals(option3)) {
                doc4 = Doc$.MODULE$.text("not found");
            } else if (option3 instanceof Some) {
                Some some = (Some)option3;
                Value.AbsoluteContractId coid = (Value.AbsoluteContractId)some.value();
                doc4 = Doc$.MODULE$.text("found").$amp(this.prettyContractId(coid));
            } else {
                throw new MatchError(option3);
            }
            doc2 = doc5.$amp(doc6.$div(doc4));
        } else {
            throw new MatchError(genNode);
        }
        Doc ppNode = doc2;
        Doc ppDisclosedTo = ni.observingSince().nonEmpty() ? Pretty$.meta$1(Doc$.MODULE$.text("known to (since):").$amp(Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), ((TraversableLike)ni.observingSince().toSeq().sortWith((Function2<Tuple2, Tuple2, Object> & Serializable & scala.Serializable)(x0$2, x1$1) -> BoxesRunTime.boxToBoolean(Pretty$.$anonfun$prettyNodeInfo$3(x0$2, x1$1)))).map((Function1<Tuple2, Doc> & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String p = (String)tuple2._1();
            Ledger.ScenarioTransactionId txid = (Ledger.ScenarioTransactionId)tuple2._2();
            Doc doc = Doc$.MODULE$.text(p).$amp(Doc$.MODULE$.text("(#").$plus(Doc$.MODULE$.str(txid.id())).$plus(Doc$.MODULE$.char(')')));
            return doc;
        }, Seq$.MODULE$.canBuildFrom())))) : Doc$.MODULE$.text("");
        Doc ppReferencedBy = ni.referencedBy().nonEmpty() ? Pretty$.meta$1(Doc$.MODULE$.text("referenced by").$amp(Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), ni.referencedBy().toSeq().map((Function1<String, Doc> & Serializable & scala.Serializable)n -> MODULE$.prettyLedgerNodeId((String)n), Seq$.MODULE$.canBuildFrom())))) : Doc$.MODULE$.text("");
        Option<String> option4 = ni.consumedBy();
        if (None$.MODULE$.equals(option4)) {
            doc = Doc$.MODULE$.text("");
        } else if (option4 instanceof Some) {
            Some some = (Some)option4;
            String nid = (String)some.value();
            String string4 = "archived by";
            doc = Pretty$.meta$1(this.prettyLedgerNodeId(nid).$amp$colon(string4));
        } else {
            throw new MatchError(option4);
        }
        Doc ppArchivedBy = doc;
        return this.prettyLedgerNodeId(nodeId2).$div(Doc$.MODULE$.stack((Iterable)((TraversableLike)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Doc[]{ppArchivedBy, ppReferencedBy, ppDisclosedTo, Pretty$.arrowRight$1(ppNode)}))).filter((Function1<Doc, Object> & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean(x$7.nonEmpty()))));
    }

    public Doc prettyLedgerNodeId(String n) {
        return Doc$.MODULE$.text(n);
    }

    public Doc prettyContractInst(Value.ContractInst<Value.VersionedValue<Value.ContractId>> coinst) {
        return this.prettyIdentifier(coinst.template()).$div(Doc$.MODULE$.text("with:")).$amp(this.prettyVersionedValue(false, coinst.arg())).nested(4);
    }

    public Doc prettyTypeConName(Ref.Identifier tycon) {
        return Doc$.MODULE$.text(tycon.qualifiedName().toString()).$plus(Doc$.MODULE$.char('@')).$plus(this.prettyPackageId(tycon.packageId()));
    }

    public Doc prettyContractId(Value.ContractId coid) {
        Doc doc;
        Value.ContractId contractId = coid;
        if (contractId instanceof Value.AbsoluteContractId) {
            Value.AbsoluteContractId absoluteContractId = (Value.AbsoluteContractId)contractId;
            String acoid = absoluteContractId.coid();
            doc = Doc$.MODULE$.text(acoid);
        } else if (contractId instanceof Value.RelativeContractId) {
            Value.RelativeContractId relativeContractId = (Value.RelativeContractId)contractId;
            Value.NodeId rcoid = relativeContractId.txnid();
            doc = Doc$.MODULE$.str(rcoid);
        } else {
            throw new MatchError(contractId);
        }
        return doc;
    }

    public Doc prettyActiveContracts(Ledger.LedgerData c) {
        return Doc$.MODULE$.fill(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), ((List)c.activeContracts().toList().sortWith((Function2<Value.AbsoluteContractId, Value.AbsoluteContractId, Object> & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean(Pretty$.ltNodeId$1(a, b)))).map((Function1<Value.ContractId, Doc> & Serializable & scala.Serializable)coid -> MODULE$.prettyContractId((Value.ContractId)coid), List$.MODULE$.canBuildFrom()));
    }

    public Doc prettyPackageId(String pkgId) {
        return Doc$.MODULE$.text((String)new StringOps(Predef$.MODULE$.augmentString(pkgId)).take(8));
    }

    public Doc prettyIdentifier(Ref.Identifier id2) {
        return Doc$.MODULE$.text(id2.qualifiedName().toString()).$plus(Doc$.MODULE$.char('@')).$plus(this.prettyPackageId(id2.packageId()));
    }

    public Doc prettyVersionedValue(boolean verbose, Value.VersionedValue<Value.ContractId> v) {
        return this.prettyValue(verbose, v.value()).$amp(Doc$.MODULE$.text("value-version: ").$plus(Doc$.MODULE$.text(v.version().protoValue())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Doc prettyValue(boolean verbose, Value<Value.ContractId> v) {
        Option option2;
        Value.ContractId contractId;
        boolean bl = false;
        Value.ValueContractId valueContractId = null;
        boolean bl2 = false;
        Value.ValueOptional valueOptional = null;
        Value<Value.ContractId> value = v;
        if (value instanceof Value.ValueInt64) {
            Value.ValueInt64 valueInt64 = (Value.ValueInt64)value;
            long i = valueInt64.value();
            return Doc$.MODULE$.str(BoxesRunTime.boxToLong(i));
        }
        if (value instanceof Value.ValueNumeric) {
            Value.ValueNumeric valueNumeric = (Value.ValueNumeric)value;
            BigDecimal d = valueNumeric.value();
            return Doc$.MODULE$.str(d);
        }
        if (value instanceof Value.ValueRecord) {
            Doc doc;
            Value.ValueRecord valueRecord = (Value.ValueRecord)value;
            Option<Ref.Identifier> mbId = valueRecord.tycon();
            ImmArray fs = valueRecord.fields();
            Option<Ref.Identifier> option3 = mbId;
            if (None$.MODULE$.equals(option3)) {
                doc = Doc$.MODULE$.text("");
                return doc.$plus(Doc$.MODULE$.char('{')).$amp(Doc$.MODULE$.fill(Doc$.MODULE$.text(", "), fs.toList().map((Function1<Tuple2, Doc> & Serializable & scala.Serializable)x0$4 -> {
                    Tuple2 tuple2 = x0$4;
                    if (tuple2 != null) {
                        Option option2 = (Option)tuple2._1();
                        Value v = (Value)tuple2._2();
                        if (option2 instanceof Some) {
                            Some some = (Some)option2;
                            String k = (String)some.value();
                            return Doc$.MODULE$.text(k).$amp(Doc$.MODULE$.char('=')).$amp(MODULE$.prettyValue(true, v));
                        }
                    }
                    if (tuple2 == null) throw new MatchError(tuple2);
                    Option option3 = (Option)tuple2._1();
                    Value v = (Value)tuple2._2();
                    if (!None$.MODULE$.equals(option3)) throw new MatchError(tuple2);
                    return Doc$.MODULE$.text("<no-label>").$amp(Doc$.MODULE$.char('=')).$amp(MODULE$.prettyValue(true, v));
                }, List$.MODULE$.canBuildFrom()))).$amp(Doc$.MODULE$.char('}'));
            } else {
                if (!(option3 instanceof Some)) throw new MatchError(option3);
                Some some = (Some)option3;
                Ref.Identifier id2 = (Ref.Identifier)some.value();
                doc = verbose ? this.prettyIdentifier(id2) : Doc$.MODULE$.text("");
            }
            return doc.$plus(Doc$.MODULE$.char('{')).$amp(Doc$.MODULE$.fill(Doc$.MODULE$.text(", "), fs.toList().map((Function1<Tuple2, Doc> & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 != null) {
                    Option option2 = (Option)tuple2._1();
                    Value v = (Value)tuple2._2();
                    if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        String k = (String)some.value();
                        return Doc$.MODULE$.text(k).$amp(Doc$.MODULE$.char('=')).$amp(MODULE$.prettyValue(true, v));
                    }
                }
                if (tuple2 == null) throw new MatchError(tuple2);
                Option option3 = (Option)tuple2._1();
                Value v = (Value)tuple2._2();
                if (!None$.MODULE$.equals(option3)) throw new MatchError(tuple2);
                return Doc$.MODULE$.text("<no-label>").$amp(Doc$.MODULE$.char('=')).$amp(MODULE$.prettyValue(true, v));
            }, List$.MODULE$.canBuildFrom()))).$amp(Doc$.MODULE$.char('}'));
        }
        if (value instanceof Value.ValueStruct) {
            Value.ValueStruct valueStruct = (Value.ValueStruct)value;
            ImmArray fs = valueStruct.fields();
            return Doc$.MODULE$.char('{').$amp(Doc$.MODULE$.fill(Doc$.MODULE$.text(", "), fs.toList().map((Function1<Tuple2, Doc> & Serializable & scala.Serializable)x0$5 -> {
                Tuple2 tuple2 = x0$5;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String k = (String)tuple2._1();
                Value v = (Value)tuple2._2();
                Doc doc = Doc$.MODULE$.text(k).$amp(Doc$.MODULE$.char('=')).$amp(MODULE$.prettyValue(true, v));
                return doc;
            }, List$.MODULE$.canBuildFrom()))).$amp(Doc$.MODULE$.char('}'));
        }
        if (value instanceof Value.ValueVariant) {
            Doc doc;
            Value.ValueVariant valueVariant = (Value.ValueVariant)value;
            Option<Ref.Identifier> mbId = valueVariant.tycon();
            String variant = valueVariant.variant();
            Value<Value.ContractId> value2 = valueVariant.value();
            Option<Ref.Identifier> option4 = mbId;
            if (None$.MODULE$.equals(option4)) {
                doc = Doc$.MODULE$.text("");
            } else {
                if (!(option4 instanceof Some)) throw new MatchError(option4);
                Some some = (Some)option4;
                Ref.Identifier id3 = (Ref.Identifier)some.value();
                doc = verbose ? this.prettyIdentifier(id3).$plus(Doc$.MODULE$.char(':')) : Doc$.MODULE$.text("");
            }
            Value<Value.ContractId> value3 = value2;
            Doc doc2 = Value$ValueUnit$.MODULE$.equals(value3) ? Doc$.MODULE$.text(variant) : Doc$.MODULE$.text(variant).$plus(Doc$.MODULE$.char('(')).$plus(this.prettyValue(true, value2)).$plus(Doc$.MODULE$.char(')'));
            return doc.$plus(doc2);
        }
        if (value instanceof Value.ValueEnum) {
            Doc doc;
            Value.ValueEnum valueEnum = (Value.ValueEnum)value;
            Option<Ref.Identifier> mbId = valueEnum.tycon();
            String constructor = valueEnum.value();
            Option<Ref.Identifier> option5 = mbId;
            if (None$.MODULE$.equals(option5)) {
                doc = Doc$.MODULE$.text("");
                return doc.$plus(Doc$.MODULE$.text(constructor));
            } else {
                if (!(option5 instanceof Some)) throw new MatchError(option5);
                Some some = (Some)option5;
                Ref.Identifier id4 = (Ref.Identifier)some.value();
                doc = verbose ? this.prettyIdentifier(id4).$plus(Doc$.MODULE$.char(':')) : Doc$.MODULE$.text("");
            }
            return doc.$plus(Doc$.MODULE$.text(constructor));
        }
        if (value instanceof Value.ValueText) {
            Value.ValueText valueText = (Value.ValueText)value;
            String t = valueText.value();
            return Doc$.MODULE$.char('\"').$plus(Doc$.MODULE$.text(t)).$plus(Doc$.MODULE$.char('\"'));
        }
        if (value instanceof Value.ValueContractId) {
            bl = true;
            valueContractId = (Value.ValueContractId)value;
            Value.ContractId contractId2 = (Value.ContractId)valueContractId.value();
            if (contractId2 instanceof Value.AbsoluteContractId) {
                Value.AbsoluteContractId absoluteContractId = (Value.AbsoluteContractId)contractId2;
                String acoid = absoluteContractId.coid();
                return Doc$.MODULE$.text(acoid);
            }
        }
        if (bl && (contractId = (Value.ContractId)valueContractId.value()) instanceof Value.RelativeContractId) {
            Value.RelativeContractId relativeContractId = (Value.RelativeContractId)contractId;
            Value.NodeId rcoid = relativeContractId.txnid();
            return Doc$.MODULE$.char('~').$plus(Doc$.MODULE$.text(rcoid.toString()));
        }
        if (Value$ValueUnit$.MODULE$.equals(value)) {
            return Doc$.MODULE$.text("<unit>");
        }
        if (value instanceof Value.ValueBool) {
            Value.ValueBool valueBool = (Value.ValueBool)value;
            boolean b = valueBool.value();
            return Doc$.MODULE$.str(BoxesRunTime.boxToBoolean(b));
        }
        if (value instanceof Value.ValueList) {
            Value.ValueList valueList = (Value.ValueList)value;
            FrontStack lst = valueList.values();
            return Doc$.MODULE$.char('[').$plus(Doc$.MODULE$.intercalate(Doc$.MODULE$.text(", "), lst.map((Function1<Value, Doc> & Serializable & scala.Serializable)x$8 -> MODULE$.prettyValue(true, (Value<Value.ContractId>)x$8)).toImmArray().toSeq())).$plus(Doc$.MODULE$.char(']'));
        }
        if (value instanceof Value.ValueTimestamp) {
            Value.ValueTimestamp valueTimestamp = (Value.ValueTimestamp)value;
            Time.Timestamp t = valueTimestamp.value();
            return Doc$.MODULE$.str(t);
        }
        if (value instanceof Value.ValueDate) {
            Value.ValueDate valueDate = (Value.ValueDate)value;
            Time.Date days = valueDate.value();
            return Doc$.MODULE$.str(days);
        }
        if (value instanceof Value.ValueParty) {
            Value.ValueParty valueParty = (Value.ValueParty)value;
            String p = valueParty.value();
            return Doc$.MODULE$.char('\'').$plus(Doc$.MODULE$.str(p)).$plus(Doc$.MODULE$.char('\''));
        }
        if (value instanceof Value.ValueOptional) {
            bl2 = true;
            valueOptional = (Value.ValueOptional)value;
            Option option6 = valueOptional.value();
            if (option6 instanceof Some) {
                Some some = (Some)option6;
                Value v1 = (Value)some.value();
                return Doc$.MODULE$.text("Option(").$plus(this.prettyValue(verbose, v1)).$plus(Doc$.MODULE$.char(')'));
            }
        }
        if (bl2 && None$.MODULE$.equals(option2 = valueOptional.value())) {
            return Doc$.MODULE$.text("None");
        }
        if (value instanceof Value.ValueTextMap) {
            Value.ValueTextMap valueTextMap = (Value.ValueTextMap)value;
            SortedLookupList map2 = valueTextMap.value();
            ImmArray list2 = map2.toImmArray().map((Function1<Tuple2, Doc> & Serializable & scala.Serializable)x0$6 -> {
                Tuple2 tuple2 = x0$6;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String k = (String)tuple2._1();
                Value v = (Value)tuple2._2();
                Doc doc = Doc$.MODULE$.text(k).$plus(Doc$.MODULE$.text(" -> ")).$plus(MODULE$.prettyValue(verbose, v));
                return doc;
            });
            return Doc$.MODULE$.text("TextMap(").$plus(Doc$.MODULE$.intercalate(Doc$.MODULE$.text(", "), list2.toSeq())).$plus(Doc$.MODULE$.text(")"));
        }
        if (!(value instanceof Value.ValueGenMap)) throw new MatchError(value);
        Value.ValueGenMap valueGenMap = (Value.ValueGenMap)value;
        ImmArray entries = valueGenMap.entries();
        ImmArray list3 = entries.map((Function1<Tuple2, Doc> & Serializable & scala.Serializable)x0$7 -> {
            Tuple2 tuple2 = x0$7;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Value k = (Value)tuple2._1();
            Value v = (Value)tuple2._2();
            Doc doc = MODULE$.prettyValue(verbose, k).$plus(Doc$.MODULE$.text(" -> ")).$plus(MODULE$.prettyValue(verbose, v));
            return doc;
        });
        return Doc$.MODULE$.text("GenMap(").$plus(Doc$.MODULE$.intercalate(Doc$.MODULE$.text(", "), list3.toSeq())).$plus(Doc$.MODULE$.text(")"));
    }

    private static final Doc arrowRight$1(Doc d) {
        return Doc$.MODULE$.text("\u2514\u2500>").$amp(d);
    }

    private static final Doc meta$1(Doc d) {
        return Doc$.MODULE$.text("\u2502  ").$amp(d);
    }

    public static final /* synthetic */ boolean $anonfun$prettyNodeInfo$3(Tuple2 x0$2, Tuple2 x1$1) {
        Ledger.ScenarioTransactionId id1;
        String p1;
        Tuple2 tuple2;
        block3: {
            Tuple2<Tuple2, Tuple2> tuple22;
            block2: {
                tuple22 = new Tuple2<Tuple2, Tuple2>(x0$2, x1$1);
                if (tuple22 == null) break block2;
                Tuple2 tuple23 = tuple22._1();
                tuple2 = tuple22._2();
                if (tuple23 == null) break block2;
                p1 = (String)tuple23._1();
                id1 = (Ledger.ScenarioTransactionId)tuple23._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError(tuple22);
        }
        String p2 = (String)tuple2._1();
        Ledger.ScenarioTransactionId id2 = (Ledger.ScenarioTransactionId)tuple2._2();
        boolean bl = id1.$less$eq(id2) && new StringOps(Predef$.MODULE$.augmentString(p1)).$less(p2);
        return bl;
    }

    private static final boolean ltNodeId$1(Value.AbsoluteContractId a, Value.AbsoluteContractId b) {
        String[] ap = new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(a.coid())).drop(1))).split(':');
        String[] bp = new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(b.coid())).drop(1))).split(':');
        return BoxesRunTime.unboxToBoolean(Try$.MODULE$.apply((JFunction0$mcZ$sp & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(ap[0])).toInt() < new StringOps(Predef$.MODULE$.augmentString(bp[0])).toInt() || new StringOps(Predef$.MODULE$.augmentString(ap[0])).toInt() == new StringOps(Predef$.MODULE$.augmentString(bp[0])).toInt() && new StringOps(Predef$.MODULE$.augmentString(ap[1])).toInt() < new StringOps(Predef$.MODULE$.augmentString(bp[1])).toInt()).getOrElse((JFunction0$mcZ$sp & scala.Serializable)() -> false));
    }

    private Pretty$() {
        MODULE$ = this;
    }
}

