/*
 * Decompiled with CFR 0.152.
 */
package com.digitalasset.daml.lf.speedy;

import com.digitalasset.daml.lf.data.FrontStack;
import com.digitalasset.daml.lf.data.Ref;
import com.digitalasset.daml.lf.data.Ref$;
import com.digitalasset.daml.lf.data.package$;
import com.digitalasset.daml.lf.language.Ast$;
import com.digitalasset.daml.lf.speedy.SError;
import com.digitalasset.daml.lf.speedy.SError$;
import com.digitalasset.daml.lf.speedy.SValue;
import com.digitalasset.daml.lf.speedy.SValue$SGenMap$Key$;
import com.digitalasset.daml.lf.speedy.SValue$SToken$;
import com.digitalasset.daml.lf.speedy.Speedy;
import com.digitalasset.daml.lf.transaction.Node;
import com.digitalasset.daml.lf.transaction.Transaction;
import com.digitalasset.daml.lf.transaction.Transaction$EndExerciseInRootContext$;
import com.digitalasset.daml.lf.value.Value;
import com.digitalasset.daml.lf.value.Value$;
import com.digitalasset.daml.lf.value.Value$ContractId$;
import com.digitalasset.daml.lf.value.ValueVersions$;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.TreeSet;
import scala.collection.immutable.TreeSet$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class SBuiltin$ {
    public static SBuiltin$ MODULE$;

    static {
        new SBuiltin$();
    }

    public long com$digitalasset$daml$lf$speedy$SBuiltin$$add(long x, long y) {
        long l;
        try {
            l = Math.addExact(x, y);
        }
        catch (ArithmeticException arithmeticException) {
            throw new SError.DamlEArithmeticError(new StringBuilder(32).append("Int64 overflow when adding ").append(y).append(" to ").append(x).append(".").toString());
        }
        return l;
    }

    public long com$digitalasset$daml$lf$speedy$SBuiltin$$div(long x, long y) {
        if (y == 0L) {
            throw new SError.DamlEArithmeticError(new StringBuilder(24).append("Attempt to divide ").append(x).append(" by 0.").toString());
        }
        if (x == Long.MIN_VALUE && y == -1L) {
            throw new SError.DamlEArithmeticError(new StringBuilder(34).append("Int64 overflow when dividing ").append(x).append(" by ").append(y).append(".").toString());
        }
        return x / y;
    }

    public long com$digitalasset$daml$lf$speedy$SBuiltin$$mult(long x, long y) {
        long l;
        try {
            l = Math.multiplyExact(x, y);
        }
        catch (ArithmeticException arithmeticException) {
            throw new SError.DamlEArithmeticError(new StringBuilder(37).append("Int64 overflow when multiplying ").append(x).append(" by ").append(y).append(".").toString());
        }
        return l;
    }

    public long com$digitalasset$daml$lf$speedy$SBuiltin$$sub(long x, long y) {
        long l;
        try {
            l = Math.subtractExact(x, y);
        }
        catch (ArithmeticException arithmeticException) {
            throw new SError.DamlEArithmeticError(new StringBuilder(39).append("Int64 overflow when subtracting ").append(y).append(" from ").append(x).append(".").toString());
        }
        return l;
    }

    public long com$digitalasset$daml$lf$speedy$SBuiltin$$mod(long x, long y) {
        if (y == 0L) {
            throw new SError.DamlEArithmeticError(new StringBuilder(29).append("Attempt to compute ").append(x).append(" modulo 0.").toString());
        }
        return x % y;
    }

    public long com$digitalasset$daml$lf$speedy$SBuiltin$$exp(long base, long exponent) {
        long l;
        if (exponent < 0L) {
            throw new SError.DamlEArithmeticError(new StringBuilder(44).append("Attempt to raise ").append(base).append(" to the negative exponent ").append(exponent).append(".").toString());
        }
        if (exponent == 0L) {
            l = 1L;
        } else {
            try {
                long x = base;
                long y = 1L;
                for (long n = exponent; n > 1L; n >>= 1) {
                    if (n % 2L == 1L) {
                        y = Math.multiplyExact(y, x);
                    }
                    x = Math.multiplyExact(x, x);
                }
                l = Math.multiplyExact(x, y);
            }
            catch (ArithmeticException arithmeticException) {
                throw new SError.DamlEArithmeticError(new StringBuilder(46).append("Int64 overflow when raising ").append(base).append(" to the exponent ").append(exponent).append(".").toString());
            }
        }
        return l;
    }

    public BigDecimal com$digitalasset$daml$lf$speedy$SBuiltin$$add(BigDecimal x, BigDecimal y) {
        return this.com$digitalasset$daml$lf$speedy$SBuiltin$$rightOrArithmeticError(new StringBuilder(37).append("(Numeric ").append(x.scale()).append(") overflow when adding ").append(package$.MODULE$.Numeric().toString(y)).append(" to ").append(package$.MODULE$.Numeric().toString(x)).append(".").toString(), package$.MODULE$.Numeric().add(x, y));
    }

    public BigDecimal com$digitalasset$daml$lf$speedy$SBuiltin$$subtract(BigDecimal x, BigDecimal y) {
        return this.com$digitalasset$daml$lf$speedy$SBuiltin$$rightOrArithmeticError(new StringBuilder(44).append("(Numeric ").append(x.scale()).append(") overflow when subtracting ").append(package$.MODULE$.Numeric().toString(y)).append(" from ").append(package$.MODULE$.Numeric().toString(x)).append(".").toString(), package$.MODULE$.Numeric().subtract(x, y));
    }

    public BigDecimal com$digitalasset$daml$lf$speedy$SBuiltin$$multiply(int scale, BigDecimal x, BigDecimal y) {
        return this.com$digitalasset$daml$lf$speedy$SBuiltin$$rightOrArithmeticError(new StringBuilder(42).append("(Numeric ").append(scale).append(") overflow when multiplying ").append(package$.MODULE$.Numeric().toString(x)).append(" by ").append(package$.MODULE$.Numeric().toString(y)).append(".").toString(), package$.MODULE$.Numeric().multiply(scale, x, y));
    }

    public BigDecimal com$digitalasset$daml$lf$speedy$SBuiltin$$divide(int scale, BigDecimal x, BigDecimal y) {
        if (y.signum() == 0) {
            throw new SError.DamlEArithmeticError(new StringBuilder(23).append("Attempt to divide ").append(package$.MODULE$.Numeric().toString(x)).append(" by ").append(package$.MODULE$.Numeric().toString(y)).append(".").toString());
        }
        return this.com$digitalasset$daml$lf$speedy$SBuiltin$$rightOrArithmeticError(new StringBuilder(39).append("(Numeric ").append(scale).append(") overflow when dividing ").append(package$.MODULE$.Numeric().toString(x)).append(" by ").append(package$.MODULE$.Numeric().toString(y)).append(".").toString(), package$.MODULE$.Numeric().divide(scale, x, y));
    }

    public SValue.SGenMap.Key com$digitalasset$daml$lf$speedy$SBuiltin$$buildKey(SValue v) throws SError.SErrorCrash {
        SValue.SGenMap.Key key;
        Either<String, SValue.SGenMap.Key> either2 = SValue$SGenMap$Key$.MODULE$.fromSValue(v);
        if (either2 instanceof Left) {
            Left left = (Left)either2;
            String msg = (String)left.value();
            throw new SError.SErrorCrash(msg);
        }
        if (!(either2 instanceof Right)) {
            throw new MatchError(either2);
        }
        Right right = (Right)either2;
        SValue.SGenMap.Key key2 = key = (SValue.SGenMap.Key)right.value();
        return key2;
    }

    public void com$digitalasset$daml$lf$speedy$SBuiltin$$checkAborted(Transaction.PartialTransaction ptx) {
        Transaction.TransactionError transactionError;
        boolean bl = false;
        Some some = null;
        Option<Transaction.TransactionError> option2 = ptx.aborted();
        if (option2 instanceof Some) {
            bl = true;
            some = (Some)option2;
            Transaction.TransactionError transactionError2 = (Transaction.TransactionError)some.value();
            if (transactionError2 instanceof Transaction.ContractNotActive) {
                Transaction.ContractNotActive contractNotActive = (Transaction.ContractNotActive)transactionError2;
                Value.ContractId coid = contractNotActive.coid();
                Ref.Identifier tid = contractNotActive.templateId();
                Value.NodeId consumedBy = contractNotActive.consumedBy();
                throw new SError.DamlELocalContractNotActive(coid, tid, consumedBy);
            }
        }
        if (bl && Transaction$EndExerciseInRootContext$.MODULE$.equals(transactionError = (Transaction.TransactionError)some.value())) {
            BoxedUnit boxedUnit = (BoxedUnit)SError$.MODULE$.crash("internal error: end exercise in root context");
        } else if (None$.MODULE$.equals(option2)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option2);
        }
    }

    public void com$digitalasset$daml$lf$speedy$SBuiltin$$checkToken(SValue v) {
        SValue sValue = v;
        if (SValue$SToken$.MODULE$.equals(sValue)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = (BoxedUnit)SError$.MODULE$.crash(new StringBuilder(19).append("value not a token: ").append(v).toString());
        }
    }

    public TreeSet<String> com$digitalasset$daml$lf$speedy$SBuiltin$$extractParties(SValue v) {
        TreeSet treeSet;
        SValue sValue = v;
        if (sValue instanceof SValue.SList) {
            SValue.SList sList = (SValue.SList)sValue;
            FrontStack<SValue> vs = sList.list();
            treeSet = (TreeSet)((TreeSet)TreeSet$.MODULE$.empty(Ref$.MODULE$.Party().ordering())).$plus$plus((GenTraversableOnce)vs.iterator().map((Function1<SValue, String> & Serializable & scala.Serializable)x0$4 -> {
                String string2;
                SValue sValue = x0$4;
                if (sValue instanceof SValue.SParty) {
                    String p;
                    SValue.SParty sParty = (SValue.SParty)sValue;
                    string2 = p = sParty.value();
                } else {
                    string2 = (String)SError$.MODULE$.crash(new StringBuilder(25).append("non-party value in list: ").append(sValue).toString());
                }
                return string2;
            }));
        } else if (sValue instanceof SValue.SParty) {
            SValue.SParty sParty = (SValue.SParty)sValue;
            String p = sParty.value();
            treeSet = (TreeSet)TreeSet$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{p}), Ref$.MODULE$.Party().ordering());
        } else {
            treeSet = (TreeSet)SError$.MODULE$.crash(new StringBuilder(38).append("value not a list of parties or party: ").append(v).toString());
        }
        return treeSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Node.KeyWithMaintainers<Value.VersionedValue<Nothing$>> com$digitalasset$daml$lf$speedy$SBuiltin$$extractKeyWithMaintainers(SValue v) {
        SValue sValue = v;
        if (!(sValue instanceof SValue.SStruct)) return (Node.KeyWithMaintainers)SError$.MODULE$.crash(new StringBuilder(30).append("Invalid key with maintainers: ").append(v).toString());
        SValue.SStruct sStruct = (SValue.SStruct)sValue;
        String[] flds = sStruct.fields();
        ArrayList<SValue> vals = sStruct.values();
        if (flds.length != 2) return (Node.KeyWithMaintainers)SError$.MODULE$.crash(new StringBuilder(30).append("Invalid key with maintainers: ").append(v).toString());
        String string2 = flds[0];
        String string3 = Ast$.MODULE$.keyFieldName();
        if (string2 == null) {
            if (string3 != null) {
                return (Node.KeyWithMaintainers)SError$.MODULE$.crash(new StringBuilder(30).append("Invalid key with maintainers: ").append(v).toString());
            }
        } else if (!string2.equals(string3)) return (Node.KeyWithMaintainers)SError$.MODULE$.crash(new StringBuilder(30).append("Invalid key with maintainers: ").append(v).toString());
        String string4 = flds[1];
        String string5 = Ast$.MODULE$.maintainersFieldName();
        if (string4 == null) {
            if (string5 == null) return (Node.KeyWithMaintainers)this.rightOrCrash(vals.get(0).toValue().ensureNoCid(Value$.MODULE$.noCidCheckerInstance(Value$ContractId$.MODULE$.noCidMapper())).left().map((Function1<Value.ContractId, String> & Serializable & scala.Serializable)coid -> new StringBuilder(31).append("Unexpected contract id in key: ").append(coid).toString()).flatMap((Function1<Value, Either> & Serializable & scala.Serializable)keyVal -> ValueVersions$.MODULE$.asVersionedValue(keyVal).map((Function1<Value.VersionedValue, Node.KeyWithMaintainers> & Serializable & scala.Serializable)versionedKeyVal -> new Node.KeyWithMaintainers<Value.VersionedValue>((Value.VersionedValue)versionedKeyVal, (Set<String>)MODULE$.com$digitalasset$daml$lf$speedy$SBuiltin$$extractParties((SValue)vals.get(1))))));
            return (Node.KeyWithMaintainers)SError$.MODULE$.crash(new StringBuilder(30).append("Invalid key with maintainers: ").append(v).toString());
        } else {
            if (!string4.equals(string5)) return (Node.KeyWithMaintainers)SError$.MODULE$.crash(new StringBuilder(30).append("Invalid key with maintainers: ").append(v).toString());
            return (Node.KeyWithMaintainers)this.rightOrCrash(vals.get(0).toValue().ensureNoCid(Value$.MODULE$.noCidCheckerInstance(Value$ContractId$.MODULE$.noCidMapper())).left().map((Function1<Value.ContractId, String> & Serializable & scala.Serializable)coid -> new StringBuilder(31).append("Unexpected contract id in key: ").append(coid).toString()).flatMap((Function1<Value, Either> & Serializable & scala.Serializable)keyVal -> ValueVersions$.MODULE$.asVersionedValue(keyVal).map((Function1<Value.VersionedValue, Node.KeyWithMaintainers> & Serializable & scala.Serializable)versionedKeyVal -> new Node.KeyWithMaintainers<Value.VersionedValue>((Value.VersionedValue)versionedKeyVal, (Set<String>)MODULE$.com$digitalasset$daml$lf$speedy$SBuiltin$$extractParties((SValue)vals.get(1))))));
        }
    }

    public void com$digitalasset$daml$lf$speedy$SBuiltin$$checkLookupMaintainers(Ref.Identifier templateId, Speedy.Machine machine, Set<String> maintainers) {
        if (!machine.validating()) {
            String submitter;
            String string2 = submitter = machine.committers().size() != 1 ? (String)SError$.MODULE$.crash(new StringBuilder(68).append("expecting exactly one committer since we're not validating, but got ").append(machine.committers()).toString()) : (String)machine.committers().toSeq().head();
            if (machine.checkSubmitterInMaintainers() && !maintainers.contains(submitter)) {
                throw new SError.DamlESubmitterNotInMaintainers(templateId, submitter, maintainers);
            }
        }
    }

    public <A> A com$digitalasset$daml$lf$speedy$SBuiltin$$rightOrArithmeticError(String message, Either<String, A> mb) {
        return (A)mb.fold((Function1<String, Nothing$> & Serializable & scala.Serializable)x$20 -> {
            throw new SError.DamlEArithmeticError(String.valueOf(message));
        }, (Function1<Object, Object> & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x));
    }

    private <A> A rightOrCrash(Either<String, A> either2) {
        return (A)either2.fold((Function1<String, Nothing$> & Serializable & scala.Serializable)reason -> (Nothing$)SError$.MODULE$.crash((String)reason), (Function1<Object, Object> & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x));
    }

    private SBuiltin$() {
        MODULE$ = this;
    }
}

