/*
 * Decompiled with CFR 0.152.
 */
package com.digitalasset.grpc.adapter;

import com.digitalasset.grpc.adapter.ExecutionSequencer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleThreadExecutionSequencer
implements ExecutionSequencer {
    private static final Logger logger = LoggerFactory.getLogger(SingleThreadExecutionSequencer.class);
    private final ExecutorService executor = Executors.newSingleThreadExecutor(runnable -> {
        Thread thread = new Thread(runnable);
        thread.setName(name);
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler((t, e) -> logger.error("Unhandled exception in SingleThreadExecutionSequencer.", e));
        return thread;
    });

    SingleThreadExecutionSequencer(String name) {
    }

    @Override
    public void sequence(Runnable runnable) {
        this.executor.execute(runnable);
    }

    @Override
    public void close() throws Exception {
        this.executor.shutdown();
        this.executor.awaitTermination(30L, TimeUnit.SECONDS);
    }
}

