/*
 * Decompiled with CFR 0.152.
 */
package com.digitalasset.grpc.adapter.client.rs;

import com.digitalasset.grpc.adapter.CallCounter;
import com.digitalasset.grpc.adapter.ExecutionSequencer;
import com.digitalasset.grpc.adapter.client.rs.BufferingSubscription;
import com.digitalasset.grpc.adapter.client.rs.UpstreamEventBuffer;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BufferingResponseObserver<Req, Resp>
implements ClientResponseObserver<Req, Resp> {
    private static final Logger logger = LoggerFactory.getLogger(BufferingResponseObserver.class);
    @Nonnull
    private BufferingSubscription<Resp> subscription;
    @Nonnull
    private final ExecutionSequencer es;
    @Nonnull
    private final String logPrefix = String.format("Call %d: ", CallCounter.getNewCallId());
    @Nonnull
    private final UpstreamEventBuffer<Resp> buffer = new UpstreamEventBuffer(this.logPrefix);
    @Nullable
    private ClientCallStreamObserver<Req> requestObserver;

    BufferingResponseObserver(@Nonnull Subscriber<? super Resp> subscriber, @Nonnull ExecutionSequencer es) {
        this.es = es;
        this.subscription = new BufferingSubscription<Resp>(this.buffer::flushOnFirstRequest, () -> this.requestObserver, this.es, subscriber, this.logPrefix);
        subscriber.onSubscribe(this.subscription);
        logger.trace("{}RS downstream subscription registered.", (Object)this.logPrefix);
    }

    @Override
    public void beforeStart(ClientCallStreamObserver<Req> ccso) {
        logger.trace("{}Starting call.", (Object)this.logPrefix);
        ccso.disableAutoInboundFlowControl();
        this.es.sequence(() -> {
            this.requestObserver = ccso;
        });
    }

    @Override
    public void onNext(Resp response) {
        logger.trace("{}gRPC upstream emitted response message {}.", (Object)this.logPrefix, (Object)response);
        this.es.sequence(() -> {
            this.subscription.onNextElement(this.requestObserver);
            if (!this.subscription.isCancelled()) {
                if (!this.subscription.isFirstRequestPending()) {
                    this.subscription.getSubscriber().onNext(response);
                } else {
                    boolean bufferingSucceeded = this.buffer.onNext(response);
                    if (!bufferingSucceeded) {
                        this.subscription.cancel();
                    }
                }
            }
        });
    }

    @Override
    public void onError(Throwable throwable2) {
        logger.trace("{}gRPC upstream emitted error.", (Object)this.logPrefix, (Object)throwable2);
        this.es.sequence(() -> {
            this.subscription.onStreamClosure();
            if (!this.subscription.isCancelled()) {
                if (this.buffer.hasNoElement()) {
                    this.subscription.getSubscriber().onError(throwable2);
                } else {
                    this.buffer.onError(throwable2);
                }
            }
        });
    }

    @Override
    public void onCompleted() {
        logger.trace("{}gRPC upstream completed.", (Object)this.logPrefix);
        this.es.sequence(() -> {
            this.subscription.onStreamClosure();
            if (!this.subscription.isCancelled()) {
                if (this.buffer.hasNoElement()) {
                    this.subscription.getSubscriber().onComplete();
                } else {
                    this.buffer.onComplete();
                }
            }
        });
    }
}

