/*
 * Decompiled with CFR 0.152.
 */
package com.digitalasset.grpc.adapter.client.rs;

import com.digitalasset.grpc.adapter.ExecutionSequencerFactory;
import com.digitalasset.grpc.adapter.client.rs.BufferingResponseObserver;
import io.grpc.stub.StreamObserver;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class ClientPublisher<Req, Resp>
implements Publisher<Resp> {
    @Nonnull
    private final Req request;
    @Nonnull
    private final BiConsumer<Req, StreamObserver<Resp>> clientStub;
    @Nonnull
    private final ExecutionSequencerFactory esf;

    public ClientPublisher(@Nonnull Req request, @Nonnull BiConsumer<Req, StreamObserver<Resp>> clientStub, @Nonnull ExecutionSequencerFactory esf) {
        this.request = request;
        this.clientStub = clientStub;
        this.esf = esf;
    }

    @Override
    public void subscribe(Subscriber<? super Resp> subscriber) {
        if (subscriber == null) {
            throw new NullPointerException("RS downstream called onSubscribe with null subscriber.");
        }
        this.clientStub.accept(this.request, new BufferingResponseObserver(subscriber, this.esf.getExecutionSequencer()));
    }
}

