/*
 * Decompiled with CFR 0.152.
 */
package com.digitalasset.grpc.adapter.client.rs;

import io.grpc.stub.ClientCallStreamObserver;
import java.math.BigInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DownstreamEventBuffer {
    private static Logger logger = LoggerFactory.getLogger(DownstreamEventBuffer.class);
    private static final BigInteger LONG_MAX_AS_BIGINT = BigInteger.valueOf(Long.MAX_VALUE);
    private static final long INT_MAX_AS_LONG = Integer.MAX_VALUE;
    @Nonnull
    private final String logPrefix;
    private long demand = 0L;
    private DownstreamState downstreamState = DownstreamState.FLOW_CONTROLLED;
    private final Consumer<ClientCallStreamObserver> propagateCancellation;
    private final BiConsumer<ClientCallStreamObserver, Integer> propagateDemand;

    DownstreamEventBuffer(@Nonnull Consumer<ClientCallStreamObserver> propagateCancellation, @Nonnull BiConsumer<ClientCallStreamObserver, Integer> propagateDemand, @Nonnull String logPrefix) {
        this.propagateCancellation = propagateCancellation;
        this.propagateDemand = propagateDemand;
        this.logPrefix = logPrefix;
    }

    void bufferDemand(@Nonnegative long newDemand) {
        switch (this.downstreamState) {
            case FLOW_CONTROLLED: {
                boolean reachedLongMaxValue;
                boolean bl = reachedLongMaxValue = this.demand >= Long.MAX_VALUE - newDemand;
                if (reachedLongMaxValue) {
                    logger.trace("{}Switched to unbounded downstreamState as new demand of {} total buffered demand reached Long.MAX_VALUE.", (Object)this.logPrefix, (Object)newDemand);
                    if (this.downstreamState.equals((Object)DownstreamState.FLOW_CONTROLLED)) {
                        this.downstreamState = DownstreamState.UNBOUNDED;
                    }
                    this.demand = 0L;
                    break;
                }
                this.demand += newDemand;
                logger.trace("{}Demand of {} buffered. Total buffered is {}.", this.logPrefix, newDemand, this.demand);
                break;
            }
            case UNBOUNDED: {
                break;
            }
            case CANCELLATION_BUFFERED: {
                break;
            }
        }
    }

    private int getIntegerChunk() {
        long chunk = this.demand < Integer.MAX_VALUE ? this.demand : Integer.MAX_VALUE;
        this.demand -= chunk;
        return (int)chunk;
    }

    void bufferCancellation() {
        if (!this.downstreamState.equals((Object)DownstreamState.CANCELLATION_FLUSHED)) {
            this.downstreamState = DownstreamState.CANCELLATION_BUFFERED;
        }
        logger.trace("{}Cancellation buffered.", (Object)this.logPrefix);
    }

    int propagateCancellationOrDemand(@Nonnull ClientCallStreamObserver requestObserver) {
        switch (this.downstreamState) {
            case FLOW_CONTROLLED: {
                int demandToPropagate = this.getIntegerChunk();
                if (demandToPropagate != 0) {
                    logger.trace("{}Flushing demand for {} elements. Remaining demand in buffer: {}", this.logPrefix, demandToPropagate, this.demand);
                    this.propagateDemand.accept(requestObserver, demandToPropagate);
                }
                return demandToPropagate;
            }
            case UNBOUNDED: {
                logger.trace("{}Flushing demand for Integer.MAX_VALUE elements in unbounded mode.", (Object)this.logPrefix);
                this.propagateDemand.accept(requestObserver, Integer.MAX_VALUE);
                return Integer.MAX_VALUE;
            }
            case CANCELLATION_BUFFERED: {
                logger.trace("{}Flushing buffered cancellation.", (Object)this.logPrefix);
                this.propagateCancellation.accept(requestObserver);
                this.downstreamState = DownstreamState.CANCELLATION_FLUSHED;
                return 0;
            }
        }
        return 0;
    }

    static enum DownstreamState {
        FLOW_CONTROLLED,
        UNBOUNDED,
        CANCELLATION_BUFFERED,
        CANCELLATION_FLUSHED;

    }
}

